/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.Base64Util;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.BlobDeleteType;
import com.azure.storage.blob.implementation.models.BlobExpiryOptions;
import com.azure.storage.blob.implementation.models.BlobTags;
import com.azure.storage.blob.implementation.models.BlobsAbortCopyFromURLResponse;
import com.azure.storage.blob.implementation.models.BlobsAcquireLeaseResponse;
import com.azure.storage.blob.implementation.models.BlobsBreakLeaseResponse;
import com.azure.storage.blob.implementation.models.BlobsChangeLeaseResponse;
import com.azure.storage.blob.implementation.models.BlobsCopyFromURLResponse;
import com.azure.storage.blob.implementation.models.BlobsCreateSnapshotResponse;
import com.azure.storage.blob.implementation.models.BlobsDeleteImmutabilityPolicyResponse;
import com.azure.storage.blob.implementation.models.BlobsDeleteResponse;
import com.azure.storage.blob.implementation.models.BlobsGetAccountInfoResponse;
import com.azure.storage.blob.implementation.models.BlobsGetPropertiesResponse;
import com.azure.storage.blob.implementation.models.BlobsGetTagsResponse;
import com.azure.storage.blob.implementation.models.BlobsReleaseLeaseResponse;
import com.azure.storage.blob.implementation.models.BlobsRenewLeaseResponse;
import com.azure.storage.blob.implementation.models.BlobsSetExpiryResponse;
import com.azure.storage.blob.implementation.models.BlobsSetHttpHeadersResponse;
import com.azure.storage.blob.implementation.models.BlobsSetImmutabilityPolicyResponse;
import com.azure.storage.blob.implementation.models.BlobsSetLegalHoldResponse;
import com.azure.storage.blob.implementation.models.BlobsSetMetadataResponse;
import com.azure.storage.blob.implementation.models.BlobsSetTagsResponse;
import com.azure.storage.blob.implementation.models.BlobsSetTierResponse;
import com.azure.storage.blob.implementation.models.BlobsStartCopyFromURLResponse;
import com.azure.storage.blob.implementation.models.BlobsUndeleteResponse;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.models.QueryRequest;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobCopySourceTagsMode;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicyMode;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.EncryptionAlgorithmType;
import com.azure.storage.blob.models.RehydratePriority;
import java.time.OffsetDateTime;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class BlobsImpl {
    private final BlobsService service;
    private final AzureBlobStorageImpl client;

    BlobsImpl(AzureBlobStorageImpl client) {
        this.service = (BlobsService)RestProxy.create(BlobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> downloadWithResponseAsync(String containerName, String blob, String snapshot, String versionId, Integer timeout, String range, String leaseId, Boolean rangeGetContentMD5, Boolean rangeGetContentCRC64, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, Context context) {
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.download(this.client.getUrl(), containerName, blob, snapshot, versionId, timeout, range, leaseId, rangeGetContentMD5, rangeGetContentCRC64, encryptionKey, encryptionKeySha256, encryptionAlgorithm, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsGetPropertiesResponse> getPropertiesWithResponseAsync(String containerName, String blob, String snapshot, String versionId, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, Context context) {
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getProperties(this.client.getUrl(), containerName, blob, snapshot, versionId, timeout, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsDeleteResponse> deleteWithResponseAsync(String containerName, String blob, String snapshot, String versionId, Integer timeout, String leaseId, DeleteSnapshotsOptionType deleteSnapshots, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, BlobDeleteType blobDeleteType, Context context) {
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(this.client.getUrl(), containerName, blob, snapshot, versionId, timeout, leaseId, deleteSnapshots, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobDeleteType, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsUndeleteResponse> undeleteWithResponseAsync(String containerName, String blob, Integer timeout, String requestId, Context context) {
        String comp = "undelete";
        String accept = "application/xml";
        return this.service.undelete(this.client.getUrl(), containerName, blob, "undelete", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsSetExpiryResponse> setExpiryWithResponseAsync(String containerName, String blob, BlobExpiryOptions expiryOptions, Integer timeout, String requestId, String expiresOn, Context context) {
        String comp = "expiry";
        String accept = "application/xml";
        return this.service.setExpiry(this.client.getUrl(), containerName, blob, "expiry", timeout, this.client.getVersion(), requestId, expiryOptions, expiresOn, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsSetHttpHeadersResponse> setHttpHeadersWithResponseAsync(String containerName, String blob, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, BlobHttpHeaders blobHttpHeaders, Context context) {
        String comp = "properties";
        String accept = "application/xml";
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString((byte[])contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setHttpHeaders(this.client.getUrl(), containerName, blob, "properties", timeout, cacheControl, contentType, contentMd5Converted, contentEncoding, contentLanguage, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, contentDisposition, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsSetImmutabilityPolicyResponse> setImmutabilityPolicyWithResponseAsync(String containerName, String blob, Integer timeout, String requestId, OffsetDateTime ifUnmodifiedSince, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Context context) {
        String comp = "immutabilityPolicies";
        String accept = "application/xml";
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return this.service.setImmutabilityPolicy(this.client.getUrl(), containerName, blob, "immutabilityPolicies", timeout, this.client.getVersion(), requestId, ifUnmodifiedSinceConverted, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsDeleteImmutabilityPolicyResponse> deleteImmutabilityPolicyWithResponseAsync(String containerName, String blob, Integer timeout, String requestId, Context context) {
        String comp = "immutabilityPolicies";
        String accept = "application/xml";
        return this.service.deleteImmutabilityPolicy(this.client.getUrl(), containerName, blob, "immutabilityPolicies", timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsSetLegalHoldResponse> setLegalHoldWithResponseAsync(String containerName, String blob, boolean legalHold, Integer timeout, String requestId, Context context) {
        String comp = "legalhold";
        String accept = "application/xml";
        return this.service.setLegalHold(this.client.getUrl(), containerName, blob, "legalhold", timeout, this.client.getVersion(), requestId, legalHold, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsSetMetadataResponse> setMetadataWithResponseAsync(String containerName, String blob, Integer timeout, Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setMetadata(this.client.getUrl(), containerName, blob, "metadata", timeout, metadata, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsAcquireLeaseResponse> acquireLeaseWithResponseAsync(String containerName, String blob, Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        String comp = "lease";
        String action = "acquire";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.acquireLease(this.client.getUrl(), containerName, blob, "lease", "acquire", timeout, duration, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsReleaseLeaseResponse> releaseLeaseWithResponseAsync(String containerName, String blob, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        String comp = "lease";
        String action = "release";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.releaseLease(this.client.getUrl(), containerName, blob, "lease", "release", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsRenewLeaseResponse> renewLeaseWithResponseAsync(String containerName, String blob, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        String comp = "lease";
        String action = "renew";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.renewLease(this.client.getUrl(), containerName, blob, "lease", "renew", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsChangeLeaseResponse> changeLeaseWithResponseAsync(String containerName, String blob, String leaseId, String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        String comp = "lease";
        String action = "change";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.changeLease(this.client.getUrl(), containerName, blob, "lease", "change", timeout, leaseId, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsBreakLeaseResponse> breakLeaseWithResponseAsync(String containerName, String blob, Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        String comp = "lease";
        String action = "break";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.breakLease(this.client.getUrl(), containerName, blob, "lease", "break", timeout, breakPeriod, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsCreateSnapshotResponse> createSnapshotWithResponseAsync(String containerName, String blob, Integer timeout, Map<String, String> metadata, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String comp = "snapshot";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.createSnapshot(this.client.getUrl(), containerName, blob, "snapshot", timeout, metadata, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, leaseId, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsStartCopyFromURLResponse> startCopyFromURLWithResponseAsync(String containerName, String blob, String copySource, Integer timeout, Map<String, String> metadata, AccessTier tier, RehydratePriority rehydratePriority, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String sourceIfTags, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String leaseId, String requestId, String blobTagsString, Boolean sealBlob, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, Context context) {
        String accept = "application/xml";
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return this.service.startCopyFromURL(this.client.getUrl(), containerName, blob, timeout, metadata, tier, rehydratePriority, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfTags, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, copySource, leaseId, this.client.getVersion(), requestId, blobTagsString, sealBlob, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsCopyFromURLResponse> copyFromURLWithResponseAsync(String containerName, String blob, String copySource, Integer timeout, Map<String, String> metadata, AccessTier tier, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String leaseId, String requestId, byte[] sourceContentMD5, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, String copySourceAuthorization, BlobCopySourceTagsMode copySourceTags, EncryptionScope encryptionScopeParam, Context context) {
        String xMsRequiresSync = "true";
        String accept = "application/xml";
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        String sourceContentMD5Converted = Base64Util.encodeToString((byte[])sourceContentMD5);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return this.service.copyFromURL(this.client.getUrl(), containerName, blob, "true", timeout, metadata, tier, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, copySource, leaseId, this.client.getVersion(), requestId, sourceContentMD5Converted, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, copySourceAuthorization, encryptionScope, copySourceTags, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsAbortCopyFromURLResponse> abortCopyFromURLWithResponseAsync(String containerName, String blob, String copyId, Integer timeout, String leaseId, String requestId, Context context) {
        String comp = "copy";
        String copyActionAbortConstant = "abort";
        String accept = "application/xml";
        return this.service.abortCopyFromURL(this.client.getUrl(), containerName, blob, "copy", "abort", copyId, timeout, leaseId, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsSetTierResponse> setTierWithResponseAsync(String containerName, String blob, AccessTier tier, String snapshot, String versionId, Integer timeout, RehydratePriority rehydratePriority, String requestId, String leaseId, String ifTags, Context context) {
        String comp = "tier";
        String accept = "application/xml";
        return this.service.setTier(this.client.getUrl(), containerName, blob, "tier", snapshot, versionId, timeout, tier, rehydratePriority, this.client.getVersion(), requestId, leaseId, ifTags, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsGetAccountInfoResponse> getAccountInfoWithResponseAsync(String containerName, String blob, Context context) {
        String restype = "account";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getAccountInfo(this.client.getUrl(), containerName, blob, "account", "properties", this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> queryWithResponseAsync(String containerName, String blob, String snapshot, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, QueryRequest queryRequest, CpkInfo cpkInfo, Context context) {
        String comp = "query";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.query(this.client.getUrl(), containerName, blob, "query", snapshot, timeout, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, queryRequest, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsGetTagsResponse> getTagsWithResponseAsync(String containerName, String blob, Integer timeout, String requestId, String snapshot, String versionId, String ifTags, String leaseId, Context context) {
        String comp = "tags";
        String accept = "application/xml";
        return this.service.getTags(this.client.getUrl(), containerName, blob, "tags", timeout, this.client.getVersion(), requestId, snapshot, versionId, ifTags, leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobsSetTagsResponse> setTagsWithResponseAsync(String containerName, String blob, Integer timeout, String versionId, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, String requestId, String ifTags, String leaseId, BlobTags tags, Context context) {
        String comp = "tags";
        String accept = "application/xml";
        String transactionalContentMD5Converted = Base64Util.encodeToString((byte[])transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString((byte[])transactionalContentCrc64);
        return this.service.setTags(this.client.getUrl(), containerName, blob, "tags", this.client.getVersion(), timeout, versionId, transactionalContentMD5Converted, transactionalContentCrc64Converted, requestId, ifTags, leaseId, tags, "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageBlob")
    public static interface BlobsService {
        @Get(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<StreamResponse> download(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="snapshot") String var4, @QueryParam(value="versionid") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-range") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var9, @HeaderParam(value="x-ms-range-get-content-crc64") Boolean var10, @HeaderParam(value="x-ms-encryption-key") String var11, @HeaderParam(value="x-ms-encryption-key-sha256") String var12, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var13, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var15, @HeaderParam(value="If-Match") String var16, @HeaderParam(value="If-None-Match") String var17, @HeaderParam(value="x-ms-if-tags") String var18, @HeaderParam(value="x-ms-version") String var19, @HeaderParam(value="x-ms-client-request-id") String var20, @HeaderParam(value="Accept") String var21, Context var22);

        @Head(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="snapshot") String var4, @QueryParam(value="versionid") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-encryption-key") String var8, @HeaderParam(value="x-ms-encryption-key-sha256") String var9, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Match") String var13, @HeaderParam(value="If-None-Match") String var14, @HeaderParam(value="x-ms-if-tags") String var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="x-ms-client-request-id") String var17, @HeaderParam(value="Accept") String var18, Context var19);

        @Delete(value="/{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsDeleteResponse> delete(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="snapshot") String var4, @QueryParam(value="versionid") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-delete-snapshots") DeleteSnapshotsOptionType var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, @HeaderParam(value="x-ms-if-tags") String var13, @HeaderParam(value="x-ms-version") String var14, @HeaderParam(value="x-ms-client-request-id") String var15, @QueryParam(value="deletetype") BlobDeleteType var16, @HeaderParam(value="Accept") String var17, Context var18);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsUndeleteResponse> undelete(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsSetExpiryResponse> setExpiry(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-expiry-option") BlobExpiryOptions var8, @HeaderParam(value="x-ms-expiry-time") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsSetHttpHeadersResponse> setHttpHeaders(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-blob-cache-control") String var6, @HeaderParam(value="x-ms-blob-content-type") String var7, @HeaderParam(value="x-ms-blob-content-md5") String var8, @HeaderParam(value="x-ms-blob-content-encoding") String var9, @HeaderParam(value="x-ms-blob-content-language") String var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Match") String var14, @HeaderParam(value="If-None-Match") String var15, @HeaderParam(value="x-ms-if-tags") String var16, @HeaderParam(value="x-ms-blob-content-disposition") String var17, @HeaderParam(value="x-ms-version") String var18, @HeaderParam(value="x-ms-client-request-id") String var19, @HeaderParam(value="Accept") String var20, Context var21);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsSetImmutabilityPolicyResponse> setImmutabilityPolicy(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="x-ms-immutability-policy-until-date") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Delete(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsDeleteImmutabilityPolicyResponse> deleteImmutabilityPolicy(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsSetLegalHoldResponse> setLegalHold(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-legal-hold") boolean var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsSetMetadataResponse> setMetadata(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-encryption-key") String var8, @HeaderParam(value="x-ms-encryption-key-sha256") String var9, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var10, @HeaderParam(value="x-ms-encryption-scope") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Match") String var14, @HeaderParam(value="If-None-Match") String var15, @HeaderParam(value="x-ms-if-tags") String var16, @HeaderParam(value="x-ms-version") String var17, @HeaderParam(value="x-ms-client-request-id") String var18, @HeaderParam(value="Accept") String var19, Context var20);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsAcquireLeaseResponse> acquireLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, @HeaderParam(value="x-ms-if-tags") String var13, @HeaderParam(value="x-ms-version") String var14, @HeaderParam(value="x-ms-client-request-id") String var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsReleaseLeaseResponse> releaseLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="x-ms-if-tags") String var12, @HeaderParam(value="x-ms-version") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsRenewLeaseResponse> renewLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="x-ms-if-tags") String var12, @HeaderParam(value="x-ms-version") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsChangeLeaseResponse> changeLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, @HeaderParam(value="x-ms-if-tags") String var13, @HeaderParam(value="x-ms-version") String var14, @HeaderParam(value="x-ms-client-request-id") String var15, @HeaderParam(value="Accept") String var16, Context var17);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsBreakLeaseResponse> breakLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-break-period") Integer var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="x-ms-if-tags") String var12, @HeaderParam(value="x-ms-version") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsCreateSnapshotResponse> createSnapshot(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-encryption-key") String var7, @HeaderParam(value="x-ms-encryption-key-sha256") String var8, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var9, @HeaderParam(value="x-ms-encryption-scope") String var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Match") String var13, @HeaderParam(value="If-None-Match") String var14, @HeaderParam(value="x-ms-if-tags") String var15, @HeaderParam(value="x-ms-lease-id") String var16, @HeaderParam(value="x-ms-version") String var17, @HeaderParam(value="x-ms-client-request-id") String var18, @HeaderParam(value="Accept") String var19, Context var20);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsStartCopyFromURLResponse> startCopyFromURL(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-access-tier") AccessTier var6, @HeaderParam(value="x-ms-rehydrate-priority") RehydratePriority var7, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var8, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-source-if-match") String var10, @HeaderParam(value="x-ms-source-if-none-match") String var11, @HeaderParam(value="x-ms-source-if-tags") String var12, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Match") String var15, @HeaderParam(value="If-None-Match") String var16, @HeaderParam(value="x-ms-if-tags") String var17, @HeaderParam(value="x-ms-copy-source") String var18, @HeaderParam(value="x-ms-lease-id") String var19, @HeaderParam(value="x-ms-version") String var20, @HeaderParam(value="x-ms-client-request-id") String var21, @HeaderParam(value="x-ms-tags") String var22, @HeaderParam(value="x-ms-seal-blob") Boolean var23, @HeaderParam(value="x-ms-immutability-policy-until-date") DateTimeRfc1123 var24, @HeaderParam(value="x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode var25, @HeaderParam(value="x-ms-legal-hold") Boolean var26, @HeaderParam(value="Accept") String var27, Context var28);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsCopyFromURLResponse> copyFromURL(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @HeaderParam(value="x-ms-requires-sync") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-access-tier") AccessTier var7, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var8, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-source-if-match") String var10, @HeaderParam(value="x-ms-source-if-none-match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Match") String var14, @HeaderParam(value="If-None-Match") String var15, @HeaderParam(value="x-ms-if-tags") String var16, @HeaderParam(value="x-ms-copy-source") String var17, @HeaderParam(value="x-ms-lease-id") String var18, @HeaderParam(value="x-ms-version") String var19, @HeaderParam(value="x-ms-client-request-id") String var20, @HeaderParam(value="x-ms-source-content-md5") String var21, @HeaderParam(value="x-ms-tags") String var22, @HeaderParam(value="x-ms-immutability-policy-until-date") DateTimeRfc1123 var23, @HeaderParam(value="x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode var24, @HeaderParam(value="x-ms-legal-hold") Boolean var25, @HeaderParam(value="x-ms-copy-source-authorization") String var26, @HeaderParam(value="x-ms-encryption-scope") String var27, @HeaderParam(value="x-ms-copy-source-tag-option") BlobCopySourceTagsMode var28, @HeaderParam(value="Accept") String var29, Context var30);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsAbortCopyFromURLResponse> abortCopyFromURL(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-copy-action") String var5, @QueryParam(value="copyid") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsSetTierResponse> setTier(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="snapshot") String var5, @QueryParam(value="versionid") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-access-tier") AccessTier var8, @HeaderParam(value="x-ms-rehydrate-priority") RehydratePriority var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="x-ms-if-tags") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Get(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsGetAccountInfoResponse> getAccountInfo(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<StreamResponse> query(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="snapshot") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-encryption-key") String var8, @HeaderParam(value="x-ms-encryption-key-sha256") String var9, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Match") String var13, @HeaderParam(value="If-None-Match") String var14, @HeaderParam(value="x-ms-if-tags") String var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="x-ms-client-request-id") String var17, @BodyParam(value="application/xml") QueryRequest var18, @HeaderParam(value="Accept") String var19, Context var20);

        @Get(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsGetTagsResponse> getTags(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="snapshot") String var8, @QueryParam(value="versionid") String var9, @HeaderParam(value="x-ms-if-tags") String var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsSetTagsResponse> setTags(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-version") String var5, @QueryParam(value="timeout") Integer var6, @QueryParam(value="versionid") String var7, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-if-tags") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @BodyParam(value="application/xml") BlobTags var13, @HeaderParam(value="Accept") String var14, Context var15);
    }
}

