/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.SignedIdentifiersWrapper;
import com.azure.storage.blob.implementation.models.ContainersAcquireLeaseResponse;
import com.azure.storage.blob.implementation.models.ContainersBreakLeaseResponse;
import com.azure.storage.blob.implementation.models.ContainersChangeLeaseResponse;
import com.azure.storage.blob.implementation.models.ContainersCreateResponse;
import com.azure.storage.blob.implementation.models.ContainersDeleteResponse;
import com.azure.storage.blob.implementation.models.ContainersFilterBlobsResponse;
import com.azure.storage.blob.implementation.models.ContainersGetAccessPolicyResponse;
import com.azure.storage.blob.implementation.models.ContainersGetAccountInfoResponse;
import com.azure.storage.blob.implementation.models.ContainersGetPropertiesResponse;
import com.azure.storage.blob.implementation.models.ContainersListBlobFlatSegmentResponse;
import com.azure.storage.blob.implementation.models.ContainersListBlobHierarchySegmentResponse;
import com.azure.storage.blob.implementation.models.ContainersReleaseLeaseResponse;
import com.azure.storage.blob.implementation.models.ContainersRenameResponse;
import com.azure.storage.blob.implementation.models.ContainersRenewLeaseResponse;
import com.azure.storage.blob.implementation.models.ContainersRestoreResponse;
import com.azure.storage.blob.implementation.models.ContainersSetAccessPolicyResponse;
import com.azure.storage.blob.implementation.models.ContainersSetMetadataResponse;
import com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.azure.storage.blob.models.BlobSignedIdentifier;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ListBlobsIncludeItem;
import com.azure.storage.blob.models.PublicAccessType;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ContainersImpl {
    private final ContainersService service;
    private final AzureBlobStorageImpl client;

    ContainersImpl(AzureBlobStorageImpl client) {
        this.service = (ContainersService)RestProxy.create(ContainersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersCreateResponse> createWithResponseAsync(String containerName, Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId, BlobContainerEncryptionScope blobContainerEncryptionScope, Context context) {
        String restype = "container";
        String accept = "application/xml";
        String defaultEncryptionScopeInternal = null;
        if (blobContainerEncryptionScope != null) {
            defaultEncryptionScopeInternal = blobContainerEncryptionScope.getDefaultEncryptionScope();
        }
        String defaultEncryptionScope = defaultEncryptionScopeInternal;
        Boolean encryptionScopeOverridePreventedInternal = null;
        if (blobContainerEncryptionScope != null) {
            encryptionScopeOverridePreventedInternal = blobContainerEncryptionScope.isEncryptionScopeOverridePrevented();
        }
        Boolean encryptionScopeOverridePrevented = encryptionScopeOverridePreventedInternal;
        return this.service.create(this.client.getUrl(), containerName, "container", timeout, metadata, access, this.client.getVersion(), requestId, defaultEncryptionScope, encryptionScopeOverridePrevented, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersGetPropertiesResponse> getPropertiesWithResponseAsync(String containerName, Integer timeout, String leaseId, String requestId, Context context) {
        String restype = "container";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), containerName, "container", timeout, leaseId, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersDeleteResponse> deleteWithResponseAsync(String containerName, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String restype = "container";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(this.client.getUrl(), containerName, "container", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersSetMetadataResponse> setMetadataWithResponseAsync(String containerName, Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId, Context context) {
        String restype = "container";
        String comp = "metadata";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        return this.service.setMetadata(this.client.getUrl(), containerName, "container", "metadata", timeout, leaseId, metadata, ifModifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersGetAccessPolicyResponse> getAccessPolicyWithResponseAsync(String containerName, Integer timeout, String leaseId, String requestId, Context context) {
        String restype = "container";
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicy(this.client.getUrl(), containerName, "container", "acl", timeout, leaseId, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersSetAccessPolicyResponse> setAccessPolicyWithResponseAsync(String containerName, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, List<BlobSignedIdentifier> containerAcl, Context context) {
        String restype = "container";
        String comp = "acl";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        SignedIdentifiersWrapper containerAclConverted = new SignedIdentifiersWrapper(containerAcl);
        return this.service.setAccessPolicy(this.client.getUrl(), containerName, "container", "acl", timeout, leaseId, access, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, containerAclConverted, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersRestoreResponse> restoreWithResponseAsync(String containerName, Integer timeout, String requestId, String deletedContainerName, String deletedContainerVersion, Context context) {
        String restype = "container";
        String comp = "undelete";
        String accept = "application/xml";
        return this.service.restore(this.client.getUrl(), containerName, "container", "undelete", timeout, this.client.getVersion(), requestId, deletedContainerName, deletedContainerVersion, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersRenameResponse> renameWithResponseAsync(String containerName, String sourceContainerName, Integer timeout, String requestId, String sourceLeaseId, Context context) {
        String restype = "container";
        String comp = "rename";
        String accept = "application/xml";
        return this.service.rename(this.client.getUrl(), containerName, "container", "rename", timeout, this.client.getVersion(), requestId, sourceContainerName, sourceLeaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> submitBatchWithResponseAsync(String containerName, long contentLength, String multipartContentType, Flux<ByteBuffer> body, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "batch";
        String accept = "application/xml";
        return this.service.submitBatch(this.client.getUrl(), containerName, "container", "batch", contentLength, multipartContentType, timeout, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersFilterBlobsResponse> filterBlobsWithResponseAsync(String containerName, Integer timeout, String requestId, String where, String marker, Integer maxresults, Context context) {
        String restype = "container";
        String comp = "blobs";
        String accept = "application/xml";
        return this.service.filterBlobs(this.client.getUrl(), containerName, "container", "blobs", timeout, this.client.getVersion(), requestId, where, marker, maxresults, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersAcquireLeaseResponse> acquireLeaseWithResponseAsync(String containerName, Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "acquire";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.acquireLease(this.client.getUrl(), containerName, "lease", "container", "acquire", timeout, duration, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersReleaseLeaseResponse> releaseLeaseWithResponseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "release";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.releaseLease(this.client.getUrl(), containerName, "lease", "container", "release", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersRenewLeaseResponse> renewLeaseWithResponseAsync(String containerName, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "renew";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.renewLease(this.client.getUrl(), containerName, "lease", "container", "renew", timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersBreakLeaseResponse> breakLeaseWithResponseAsync(String containerName, Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "break";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.breakLease(this.client.getUrl(), containerName, "lease", "container", "break", timeout, breakPeriod, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersChangeLeaseResponse> changeLeaseWithResponseAsync(String containerName, String leaseId, String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String comp = "lease";
        String restype = "container";
        String action = "change";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.changeLease(this.client.getUrl(), containerName, "lease", "container", "change", timeout, leaseId, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersListBlobFlatSegmentResponse> listBlobFlatSegmentWithResponseAsync(String containerName, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(include, CollectionFormat.CSV);
        return this.service.listBlobFlatSegment(this.client.getUrl(), containerName, "container", "list", prefix, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersListBlobHierarchySegmentResponse> listBlobHierarchySegmentWithResponseAsync(String containerName, String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, Context context) {
        String restype = "container";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(include, CollectionFormat.CSV);
        return this.service.listBlobHierarchySegment(this.client.getUrl(), containerName, "container", "list", prefix, delimiter, marker, maxresults, includeConverted, timeout, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContainersGetAccountInfoResponse> getAccountInfoWithResponseAsync(String containerName, Context context) {
        String restype = "account";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.getAccountInfo(this.client.getUrl(), containerName, "account", "properties", this.client.getVersion(), "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageCont")
    public static interface ContainersService {
        @Put(value="/{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersCreateResponse> create(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @HeaderParam(value="x-ms-default-encryption-scope") String var9, @HeaderParam(value="x-ms-deny-encryption-scope-override") Boolean var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersDeleteResponse> delete(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersSetMetadataResponse> setMetadata(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersGetAccessPolicyResponse> getAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersSetAccessPolicyResponse> setAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @BodyParam(value="application/xml") SignedIdentifiersWrapper var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersRestoreResponse> restore(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-deleted-container-name") String var8, @HeaderParam(value="x-ms-deleted-container-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersRenameResponse> rename(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-source-container-name") String var8, @HeaderParam(value="x-ms-source-lease-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<StreamResponse> submitBatch(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="Content-Type") String var7, @QueryParam(value="timeout") Integer var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @BodyParam(value="application/xml") Flux<ByteBuffer> var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersFilterBlobsResponse> filterBlobs(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="where") String var8, @QueryParam(value="marker") String var9, @QueryParam(value="maxresults") Integer var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersAcquireLeaseResponse> acquireLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersReleaseLeaseResponse> releaseLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersRenewLeaseResponse> renewLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersBreakLeaseResponse> breakLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-break-period") Integer var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersChangeLeaseResponse> changeLease(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="restype") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersListBlobFlatSegmentResponse> listBlobFlatSegment(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="prefix") String var5, @QueryParam(value="marker") String var6, @QueryParam(value="maxresults") Integer var7, @QueryParam(value="include") String var8, @QueryParam(value="timeout") Integer var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersListBlobHierarchySegmentResponse> listBlobHierarchySegment(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="prefix") String var5, @QueryParam(value="delimiter") String var6, @QueryParam(value="marker") String var7, @QueryParam(value="maxresults") Integer var8, @QueryParam(value="include") String var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Get(value="/{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ContainersGetAccountInfoResponse> getAccountInfo(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

