// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.storage.blob.models.PageRange;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;

/** The PageListCollection model. */
@JacksonXmlRootElement(localName = "PageList")
@Fluent
public final class PageListCollection {
    /*
     * The value property.
     */
    @JsonProperty("PageRange")
    private List<PageRange> value = new ArrayList<>();

    /*
     * The nextMarker property.
     */
    @JsonProperty(value = "nextMarker")
    private String nextMarker;

    /**
     * Get the value property: The value property.
     *
     * @return the value value.
     */
    public List<PageRange> getValue() {
        return this.value;
    }

    /**
     * Set the value property: The value property.
     *
     * @param value the value value to set.
     * @return the PageListCollection object itself.
     */
    public PageListCollection setValue(List<PageRange> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextMarker property: The nextMarker property.
     *
     * @return the nextMarker value.
     */
    public String getNextMarker() {
        return this.nextMarker;
    }

    /**
     * Set the nextMarker property: The nextMarker property.
     *
     * @param nextMarker the nextMarker value to set.
     * @return the PageListCollection object itself.
     */
    public PageListCollection setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }
}
