/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.ArchiveStatus;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.azure.storage.blob.models.ObjectReplicationPolicy;
import com.azure.storage.blob.models.ObjectReplicationRule;
import com.azure.storage.blob.models.ObjectReplicationStatus;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BlobProperties {
    private final OffsetDateTime creationTime;
    private final OffsetDateTime lastModified;
    private final String eTag;
    private final long blobSize;
    private final String contentType;
    private final byte[] contentMd5;
    private final String contentEncoding;
    private final String contentDisposition;
    private final String contentLanguage;
    private final String cacheControl;
    private final Long blobSequenceNumber;
    private final BlobType blobType;
    private final LeaseStatusType leaseStatus;
    private final LeaseStateType leaseState;
    private final LeaseDurationType leaseDuration;
    private final String copyId;
    private final CopyStatusType copyStatus;
    private final String copySource;
    private final String copyProgress;
    private final OffsetDateTime copyCompletionTime;
    private final String copyStatusDescription;
    private final Boolean isServerEncrypted;
    private final Boolean isIncrementalCopy;
    private final String copyDestinationSnapshot;
    private final AccessTier accessTier;
    private final Boolean isAccessTierInferred;
    private final ArchiveStatus archiveStatus;
    private final String encryptionKeySha256;
    private final String encryptionScope;
    private final OffsetDateTime accessTierChangeTime;
    private final Map<String, String> metadata;
    private final Integer committedBlockCount;
    private final Long tagCount;
    private final String versionId;
    private final Boolean isCurrentVersion;
    private final List<ObjectReplicationPolicy> objectReplicationSourcePolicies;
    private final String objectReplicationDestinationPolicyId;

    public BlobProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, long blobSize, String contentType, byte[] contentMd5, String contentEncoding, String contentDisposition, String contentLanguage, String cacheControl, Long blobSequenceNumber, BlobType blobType, LeaseStatusType leaseStatus, LeaseStateType leaseState, LeaseDurationType leaseDuration, String copyId, CopyStatusType copyStatus, String copySource, String copyProgress, OffsetDateTime copyCompletionTime, String copyStatusDescription, Boolean isServerEncrypted, Boolean isIncrementalCopy, String copyDestinationSnapshot, AccessTier accessTier, Boolean isAccessTierInferred, ArchiveStatus archiveStatus, String encryptionKeySha256, OffsetDateTime accessTierChangeTime, Map<String, String> metadata, Integer committedBlockCount) {
        this(creationTime, lastModified, eTag, blobSize, contentType, contentMd5, contentEncoding, contentDisposition, contentLanguage, cacheControl, blobSequenceNumber, blobType, leaseStatus, leaseState, leaseDuration, copyId, copyStatus, copySource, copyProgress, copyCompletionTime, copyStatusDescription, isServerEncrypted, isIncrementalCopy, copyDestinationSnapshot, accessTier, isAccessTierInferred, archiveStatus, encryptionKeySha256, null, accessTierChangeTime, metadata, committedBlockCount, null, null, null, null, null);
    }

    public BlobProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, long blobSize, String contentType, byte[] contentMd5, String contentEncoding, String contentDisposition, String contentLanguage, String cacheControl, Long blobSequenceNumber, BlobType blobType, LeaseStatusType leaseStatus, LeaseStateType leaseState, LeaseDurationType leaseDuration, String copyId, CopyStatusType copyStatus, String copySource, String copyProgress, OffsetDateTime copyCompletionTime, String copyStatusDescription, Boolean isServerEncrypted, Boolean isIncrementalCopy, String copyDestinationSnapshot, AccessTier accessTier, Boolean isAccessTierInferred, ArchiveStatus archiveStatus, String encryptionKeySha256, String encryptionScope, OffsetDateTime accessTierChangeTime, Map<String, String> metadata, Integer committedBlockCount, String versionId, Boolean isCurrentVersion, Long tagCount, Map<String, String> objectReplicationStatus) {
        this.creationTime = creationTime;
        this.lastModified = lastModified;
        this.eTag = eTag;
        this.blobSize = blobSize;
        this.contentType = contentType;
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        this.contentEncoding = contentEncoding;
        this.contentDisposition = contentDisposition;
        this.contentLanguage = contentLanguage;
        this.cacheControl = cacheControl;
        this.blobSequenceNumber = blobSequenceNumber;
        this.blobType = blobType;
        this.leaseStatus = leaseStatus;
        this.leaseState = leaseState;
        this.leaseDuration = leaseDuration;
        this.copyId = copyId;
        this.copyStatus = copyStatus;
        this.copySource = copySource;
        this.copyProgress = copyProgress;
        this.copyCompletionTime = copyCompletionTime;
        this.copyStatusDescription = copyStatusDescription;
        this.isServerEncrypted = isServerEncrypted;
        this.isIncrementalCopy = isIncrementalCopy;
        this.copyDestinationSnapshot = copyDestinationSnapshot;
        this.accessTier = accessTier;
        this.isAccessTierInferred = isAccessTierInferred;
        this.archiveStatus = archiveStatus;
        this.encryptionKeySha256 = encryptionKeySha256;
        this.encryptionScope = encryptionScope;
        this.accessTierChangeTime = accessTierChangeTime;
        this.metadata = metadata;
        this.committedBlockCount = committedBlockCount;
        this.tagCount = tagCount;
        this.versionId = versionId;
        this.isCurrentVersion = isCurrentVersion;
        HashMap internalSourcePolicies = new HashMap();
        objectReplicationStatus = objectReplicationStatus == null ? new HashMap() : objectReplicationStatus;
        this.objectReplicationDestinationPolicyId = objectReplicationStatus.getOrDefault("policy-id", null);
        if (this.objectReplicationDestinationPolicyId == null) {
            for (Map.Entry entry : objectReplicationStatus.entrySet()) {
                String[] split = ((String)entry.getKey()).split("_");
                String policyId = split[0];
                String ruleId = split[1];
                ObjectReplicationRule rule = new ObjectReplicationRule(ruleId, ObjectReplicationStatus.fromString((String)entry.getValue()));
                if (!internalSourcePolicies.containsKey(policyId)) {
                    internalSourcePolicies.put(policyId, new ArrayList());
                }
                ((List)internalSourcePolicies.get(policyId)).add(rule);
            }
        }
        this.objectReplicationSourcePolicies = new ArrayList<ObjectReplicationPolicy>();
        for (Map.Entry entry : internalSourcePolicies.entrySet()) {
            this.objectReplicationSourcePolicies.add(new ObjectReplicationPolicy((String)entry.getKey(), (List)entry.getValue()));
        }
    }

    public BlobProperties(OffsetDateTime creationTime, OffsetDateTime lastModified, String eTag, long blobSize, String contentType, byte[] contentMd5, String contentEncoding, String contentDisposition, String contentLanguage, String cacheControl, Long blobSequenceNumber, BlobType blobType, LeaseStatusType leaseStatus, LeaseStateType leaseState, LeaseDurationType leaseDuration, String copyId, CopyStatusType copyStatus, String copySource, String copyProgress, OffsetDateTime copyCompletionTime, String copyStatusDescription, Boolean isServerEncrypted, Boolean isIncrementalCopy, String copyDestinationSnapshot, AccessTier accessTier, Boolean isAccessTierInferred, ArchiveStatus archiveStatus, String encryptionKeySha256, String encryptionScope, OffsetDateTime accessTierChangeTime, Map<String, String> metadata, Integer committedBlockCount, Long tagCount, String versionId, Boolean isCurrentVersion, List<ObjectReplicationPolicy> objectReplicationSourcePolicies, String objectReplicationDestinationPolicyId) {
        this.creationTime = creationTime;
        this.lastModified = lastModified;
        this.eTag = eTag;
        this.blobSize = blobSize;
        this.contentType = contentType;
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        this.contentEncoding = contentEncoding;
        this.contentDisposition = contentDisposition;
        this.contentLanguage = contentLanguage;
        this.cacheControl = cacheControl;
        this.blobSequenceNumber = blobSequenceNumber;
        this.blobType = blobType;
        this.leaseStatus = leaseStatus;
        this.leaseState = leaseState;
        this.leaseDuration = leaseDuration;
        this.copyId = copyId;
        this.copyStatus = copyStatus;
        this.copySource = copySource;
        this.copyProgress = copyProgress;
        this.copyCompletionTime = copyCompletionTime;
        this.copyStatusDescription = copyStatusDescription;
        this.isServerEncrypted = isServerEncrypted;
        this.isIncrementalCopy = isIncrementalCopy;
        this.copyDestinationSnapshot = copyDestinationSnapshot;
        this.accessTier = accessTier;
        this.isAccessTierInferred = isAccessTierInferred;
        this.archiveStatus = archiveStatus;
        this.encryptionKeySha256 = encryptionKeySha256;
        this.encryptionScope = encryptionScope;
        this.accessTierChangeTime = accessTierChangeTime;
        this.metadata = metadata;
        this.committedBlockCount = committedBlockCount;
        this.tagCount = tagCount;
        this.versionId = versionId;
        this.isCurrentVersion = isCurrentVersion;
        this.objectReplicationSourcePolicies = objectReplicationSourcePolicies;
        this.objectReplicationDestinationPolicyId = objectReplicationDestinationPolicyId;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public String getETag() {
        return this.eTag;
    }

    public long getBlobSize() {
        return this.blobSize;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone((byte[])this.contentMd5);
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public BlobType getBlobType() {
        return this.blobType;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public String getCopyProgress() {
        return this.copyProgress;
    }

    public OffsetDateTime getCopyCompletionTime() {
        return this.copyCompletionTime;
    }

    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public Boolean isIncrementalCopy() {
        return this.isIncrementalCopy;
    }

    public String getCopyDestinationSnapshot() {
        return this.copyDestinationSnapshot;
    }

    public AccessTier getAccessTier() {
        return this.accessTier;
    }

    public Boolean isAccessTierInferred() {
        return this.isAccessTierInferred;
    }

    public ArchiveStatus getArchiveStatus() {
        return this.archiveStatus;
    }

    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public OffsetDateTime getAccessTierChangeTime() {
        return this.accessTierChangeTime;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Integer getCommittedBlockCount() {
        return this.committedBlockCount;
    }

    public Long getTagCount() {
        return this.tagCount;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public Boolean isCurrentVersion() {
        return this.isCurrentVersion;
    }

    public List<ObjectReplicationPolicy> getObjectReplicationSourcePolicies() {
        return Collections.unmodifiableList(this.objectReplicationSourcePolicies);
    }

    public String getObjectReplicationDestinationPolicyId() {
        return this.objectReplicationDestinationPolicyId;
    }
}

