/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.sas;

import java.util.Locale;

public final class BlobContainerSasPermission {
    private boolean readPermission;
    private boolean addPermission;
    private boolean createPermission;
    private boolean writePermission;
    private boolean deletePermission;
    private boolean deleteVersionPermission;
    private boolean listPermission;

    public static BlobContainerSasPermission parse(String permString) {
        BlobContainerSasPermission permissions = new BlobContainerSasPermission();
        block9: for (int i = 0; i < permString.length(); ++i) {
            char c = permString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.readPermission = true;
                    continue block9;
                }
                case 'a': {
                    permissions.addPermission = true;
                    continue block9;
                }
                case 'c': {
                    permissions.createPermission = true;
                    continue block9;
                }
                case 'w': {
                    permissions.writePermission = true;
                    continue block9;
                }
                case 'd': {
                    permissions.deletePermission = true;
                    continue block9;
                }
                case 'x': {
                    permissions.deleteVersionPermission = true;
                    continue block9;
                }
                case 'l': {
                    permissions.listPermission = true;
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permString, Character.valueOf(c)));
                }
            }
        }
        return permissions;
    }

    public boolean hasReadPermission() {
        return this.readPermission;
    }

    public BlobContainerSasPermission setReadPermission(boolean hasReadPermission) {
        this.readPermission = hasReadPermission;
        return this;
    }

    public boolean hasAddPermission() {
        return this.addPermission;
    }

    public BlobContainerSasPermission setAddPermission(boolean hasAddPermission) {
        this.addPermission = hasAddPermission;
        return this;
    }

    public boolean hasCreatePermission() {
        return this.createPermission;
    }

    public BlobContainerSasPermission setCreatePermission(boolean hasCreatePermission) {
        this.createPermission = hasCreatePermission;
        return this;
    }

    public boolean hasWritePermission() {
        return this.writePermission;
    }

    public BlobContainerSasPermission setWritePermission(boolean hasWritePermission) {
        this.writePermission = hasWritePermission;
        return this;
    }

    public boolean hasDeletePermission() {
        return this.deletePermission;
    }

    public BlobContainerSasPermission setDeletePermission(boolean hasDeletePermission) {
        this.deletePermission = hasDeletePermission;
        return this;
    }

    public boolean hasDeleteVersionPermission() {
        return this.deleteVersionPermission;
    }

    public BlobContainerSasPermission setDeleteVersionPermission(boolean hasDeleteVersionPermission) {
        this.deleteVersionPermission = hasDeleteVersionPermission;
        return this;
    }

    public boolean hasListPermission() {
        return this.listPermission;
    }

    public BlobContainerSasPermission setListPermission(boolean hasListPermission) {
        this.listPermission = hasListPermission;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.readPermission) {
            builder.append('r');
        }
        if (this.addPermission) {
            builder.append('a');
        }
        if (this.createPermission) {
            builder.append('c');
        }
        if (this.writePermission) {
            builder.append('w');
        }
        if (this.deletePermission) {
            builder.append('d');
        }
        if (this.deleteVersionPermission) {
            builder.append('x');
        }
        if (this.listPermission) {
            builder.append('l');
        }
        return builder.toString();
    }
}

