/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.implementation.AzureBlobStorageBuilder;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.BlobAcquireLeaseHeaders;
import com.azure.storage.blob.implementation.models.BlobBreakLeaseHeaders;
import com.azure.storage.blob.implementation.models.BlobChangeLeaseHeaders;
import com.azure.storage.blob.implementation.models.BlobRenewLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainerAcquireLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainerBreakLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainerChangeLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainerRenewLeaseHeaders;
import reactor.core.publisher.Mono;

public final class BlobLeaseAsyncClient {
    private final ClientLogger logger = new ClientLogger(BlobLeaseAsyncClient.class);
    private final boolean isBlob;
    private final String leaseId;
    private final AzureBlobStorageImpl client;
    private final String accountName;

    BlobLeaseAsyncClient(HttpPipeline pipeline, String url, String leaseId, boolean isBlob, String accountName, String serviceVersion) {
        this.isBlob = isBlob;
        this.leaseId = leaseId;
        this.client = new AzureBlobStorageBuilder().pipeline(pipeline).url(url).version(serviceVersion).build();
        this.accountName = accountName;
    }

    public String getResourceUrl() {
        return this.client.getUrl();
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    public Mono<String> acquireLease(int duration) {
        try {
            return this.acquireLeaseWithResponse(duration, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> acquireLeaseWithResponse(int duration, RequestConditions modifiedRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.acquireLeaseWithResponse(duration, modifiedRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> acquireLeaseWithResponse(int duration, RequestConditions modifiedRequestConditions, Context context) {
        modifiedRequestConditions = modifiedRequestConditions == null ? new RequestConditions() : modifiedRequestConditions;
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isBlob) {
            return this.client.blobs().acquireLeaseWithRestResponseAsync(null, null, null, duration, this.leaseId, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), modifiedRequestConditions.getIfMatch(), modifiedRequestConditions.getIfNoneMatch(), null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobAcquireLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
        }
        return this.client.containers().acquireLeaseWithRestResponseAsync(null, null, duration, this.leaseId, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainerAcquireLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
    }

    public Mono<String> renewLease() {
        try {
            return this.renewLeaseWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> renewLeaseWithResponse(RequestConditions modifiedRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.renewLeaseWithResponse(modifiedRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> renewLeaseWithResponse(RequestConditions modifiedRequestConditions, Context context) {
        modifiedRequestConditions = modifiedRequestConditions == null ? new RequestConditions() : modifiedRequestConditions;
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isBlob) {
            return this.client.blobs().renewLeaseWithRestResponseAsync(null, null, this.leaseId, null, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), modifiedRequestConditions.getIfMatch(), modifiedRequestConditions.getIfNoneMatch(), null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobRenewLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
        }
        return this.client.containers().renewLeaseWithRestResponseAsync(null, this.leaseId, null, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainerRenewLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
    }

    public Mono<Void> releaseLease() {
        try {
            return this.releaseLeaseWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> releaseLeaseWithResponse(RequestConditions modifiedRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.releaseLeaseWithResponse(modifiedRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> releaseLeaseWithResponse(RequestConditions modifiedRequestConditions, Context context) {
        modifiedRequestConditions = modifiedRequestConditions == null ? new RequestConditions() : modifiedRequestConditions;
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isBlob) {
            return this.client.blobs().releaseLeaseWithRestResponseAsync(null, null, this.leaseId, null, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), modifiedRequestConditions.getIfMatch(), modifiedRequestConditions.getIfNoneMatch(), null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
        }
        return this.client.containers().releaseLeaseWithRestResponseAsync(null, this.leaseId, null, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Integer> breakLease() {
        try {
            return this.breakLeaseWithResponse(null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Integer>> breakLeaseWithResponse(Integer breakPeriodInSeconds, RequestConditions modifiedRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.breakLeaseWithResponse(breakPeriodInSeconds, modifiedRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Integer>> breakLeaseWithResponse(Integer breakPeriodInSeconds, RequestConditions modifiedRequestConditions, Context context) {
        modifiedRequestConditions = modifiedRequestConditions == null ? new RequestConditions() : modifiedRequestConditions;
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isBlob) {
            return this.client.blobs().breakLeaseWithRestResponseAsync(null, null, null, breakPeriodInSeconds, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), modifiedRequestConditions.getIfMatch(), modifiedRequestConditions.getIfNoneMatch(), null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobBreakLeaseHeaders)rb.getDeserializedHeaders()).getLeaseTime()));
        }
        return this.client.containers().breakLeaseWithRestResponseAsync(null, null, breakPeriodInSeconds, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainerBreakLeaseHeaders)rb.getDeserializedHeaders()).getLeaseTime()));
    }

    public Mono<String> changeLease(String proposedId) {
        try {
            return this.changeLeaseWithResponse(proposedId, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> changeLeaseWithResponse(String proposedId, RequestConditions modifiedRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.changeLeaseWithResponse(proposedId, modifiedRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> changeLeaseWithResponse(String proposedId, RequestConditions modifiedRequestConditions, Context context) {
        modifiedRequestConditions = modifiedRequestConditions == null ? new RequestConditions() : modifiedRequestConditions;
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isBlob) {
            return this.client.blobs().changeLeaseWithRestResponseAsync(null, null, this.leaseId, proposedId, null, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), modifiedRequestConditions.getIfMatch(), modifiedRequestConditions.getIfNoneMatch(), null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobChangeLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
        }
        return this.client.containers().changeLeaseWithRestResponseAsync(null, this.leaseId, proposedId, null, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainerChangeLeaseHeaders)rb.getDeserializedHeaders()).getLeaseId()));
    }

    public String getAccountName() {
        return this.accountName;
    }
}

