/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareFileClientBuilder;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.CopyFileSmbInfo;
import com.azure.storage.file.share.implementation.models.DestinationLeaseAccessConditions;
import com.azure.storage.file.share.implementation.models.DirectoriesCreateHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesCreateResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesForceCloseHandlesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesListFilesAndDirectoriesSegmentHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesListFilesAndDirectoriesSegmentResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesListHandlesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesSetMetadataHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesSetMetadataResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesSetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesSetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.ListFilesIncludeType;
import com.azure.storage.file.share.implementation.models.SourceLeaseAccessConditions;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.implementation.util.ShareSasImplUtil;
import com.azure.storage.file.share.models.CloseHandlesInfo;
import com.azure.storage.file.share.models.HandleItem;
import com.azure.storage.file.share.models.NtfsFileAttributes;
import com.azure.storage.file.share.models.ShareDirectoryInfo;
import com.azure.storage.file.share.models.ShareDirectoryProperties;
import com.azure.storage.file.share.models.ShareDirectorySetMetadataInfo;
import com.azure.storage.file.share.models.ShareErrorCode;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareFileItem;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.options.ShareFileRenameOptions;
import com.azure.storage.file.share.options.ShareListFilesAndDirectoriesOptions;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ShareFileClientBuilder.class, isAsync=true)
public class ShareDirectoryAsyncClient {
    private final ClientLogger logger = new ClientLogger(ShareDirectoryAsyncClient.class);
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String shareName;
    private final String directoryPath;
    private final String snapshot;
    private final String accountName;
    private final ShareServiceVersion serviceVersion;

    ShareDirectoryAsyncClient(AzureFileStorageImpl azureFileStorageClient, String shareName, String directoryPath, String snapshot, String accountName, ShareServiceVersion serviceVersion) {
        Objects.requireNonNull(shareName, "'shareName' cannot be null.");
        Objects.requireNonNull(directoryPath);
        this.shareName = shareName;
        this.directoryPath = directoryPath;
        this.snapshot = snapshot;
        this.azureFileStorageClient = azureFileStorageClient;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
    }

    ShareDirectoryAsyncClient(ShareDirectoryAsyncClient directoryAsyncClient) {
        this(directoryAsyncClient.azureFileStorageClient, directoryAsyncClient.shareName, Utility.urlEncode((String)directoryAsyncClient.directoryPath), directoryAsyncClient.snapshot, directoryAsyncClient.accountName, directoryAsyncClient.serviceVersion);
    }

    public String getDirectoryUrl() {
        StringBuilder directoryUrlString = new StringBuilder(this.azureFileStorageClient.getUrl()).append("/").append(this.shareName).append("/").append(this.directoryPath);
        if (this.snapshot != null) {
            directoryUrlString.append("?sharesnapshot=").append(this.snapshot);
        }
        return directoryUrlString.toString();
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public ShareFileAsyncClient getFileClient(String fileName) {
        String filePath = this.directoryPath + "/" + fileName;
        if (this.directoryPath.isEmpty()) {
            filePath = fileName;
        }
        return new ShareFileAsyncClient(this.azureFileStorageClient, this.shareName, filePath, null, this.accountName, this.serviceVersion);
    }

    public ShareDirectoryAsyncClient getSubdirectoryClient(String subdirectoryName) {
        StringBuilder directoryPathBuilder = new StringBuilder().append(this.directoryPath);
        if (!this.directoryPath.isEmpty() && !this.directoryPath.endsWith("/")) {
            directoryPathBuilder.append("/");
        }
        directoryPathBuilder.append(subdirectoryName);
        return new ShareDirectoryAsyncClient(this.azureFileStorageClient, this.shareName, directoryPathBuilder.toString(), this.snapshot, this.accountName, this.serviceVersion);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> exists() {
        return this.existsWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> existsWithResponse() {
        try {
            return FluxUtil.withContext(this::existsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> existsWithResponse(Context context) {
        return this.getPropertiesWithResponse(context).map(cp -> new SimpleResponse(cp, (Object)true)).onErrorResume(this::checkDoesNotExistStatusCode, t -> {
            HttpResponse response = ((ShareStorageException)((Object)((Object)t))).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
        });
    }

    private boolean checkDoesNotExistStatusCode(Throwable t) {
        return t instanceof ShareStorageException && ((ShareStorageException)((Object)t)).getStatusCode() == 404 && (((ShareStorageException)((Object)t)).getErrorCode() == ShareErrorCode.RESOURCE_NOT_FOUND || ((ShareStorageException)((Object)t)).getErrorCode() == ShareErrorCode.SHARE_NOT_FOUND);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareDirectoryInfo> create() {
        try {
            return this.createWithResponse(null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareDirectoryInfo>> createWithResponse(FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(smbProperties, filePermission, metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareDirectoryInfo>> createWithResponse(FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Context context) {
        FileSmbProperties properties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        this.validateFilePermissionAndKey(filePermission, properties.getFilePermissionKey());
        filePermission = properties.setFilePermission(filePermission, "Inherit");
        String filePermissionKey = properties.getFilePermissionKey();
        String fileAttributes = properties.setNtfsFileAttributes("None");
        String fileCreationTime = properties.setFileCreationTime("Now");
        String fileLastWriteTime = properties.setFileLastWriteTime("Now");
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getDirectories().createWithResponseAsync(this.shareName, this.directoryPath, fileAttributes, fileCreationTime, fileLastWriteTime, null, metadata, filePermission, filePermissionKey, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::createWithRestResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete() {
        try {
            return this.deleteWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse() {
        try {
            return FluxUtil.withContext(this::deleteWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getDirectories().deleteWithResponseAsync(this.shareName, this.directoryPath, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareDirectoryProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareDirectoryProperties>> getPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(this::getPropertiesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareDirectoryProperties>> getPropertiesWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getDirectories().getPropertiesWithResponseAsync(this.shareName, this.directoryPath, this.snapshot, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::getPropertiesResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareDirectoryInfo> setProperties(FileSmbProperties smbProperties, String filePermission) {
        try {
            return this.setPropertiesWithResponse(smbProperties, filePermission).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareDirectoryInfo>> setPropertiesWithResponse(FileSmbProperties smbProperties, String filePermission) {
        try {
            return FluxUtil.withContext(context -> this.setPropertiesWithResponse(smbProperties, filePermission, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareDirectoryInfo>> setPropertiesWithResponse(FileSmbProperties smbProperties, String filePermission, Context context) {
        FileSmbProperties properties = smbProperties == null ? new FileSmbProperties() : smbProperties;
        this.validateFilePermissionAndKey(filePermission, properties.getFilePermissionKey());
        filePermission = properties.setFilePermission(filePermission, "Preserve");
        String filePermissionKey = properties.getFilePermissionKey();
        String fileAttributes = properties.setNtfsFileAttributes("Preserve");
        String fileCreationTime = properties.setFileCreationTime("Preserve");
        String fileLastWriteTime = properties.setFileLastWriteTime("Preserve");
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getDirectories().setPropertiesWithResponseAsync(this.shareName, this.directoryPath, fileAttributes, fileCreationTime, fileLastWriteTime, null, filePermission, filePermissionKey, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::setPropertiesResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareDirectorySetMetadataInfo> setMetadata(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(metadata).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareDirectorySetMetadataInfo>> setMetadataWithResponse(Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.setMetadataWithResponse(metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareDirectorySetMetadataInfo>> setMetadataWithResponse(Map<String, String> metadata, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getDirectories().setMetadataWithResponseAsync(this.shareName, this.directoryPath, null, metadata, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(this::setMetadataResponse);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareFileItem> listFilesAndDirectories() {
        try {
            return this.listFilesAndDirectories(null, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareFileItem> listFilesAndDirectories(String prefix, Integer maxResultsPerPage) {
        try {
            return this.listFilesAndDirectoriesWithOptionalTimeout(new ShareListFilesAndDirectoriesOptions().setPrefix(prefix).setMaxResultsPerPage(maxResultsPerPage), null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareFileItem> listFilesAndDirectories(ShareListFilesAndDirectoriesOptions options) {
        try {
            return this.listFilesAndDirectoriesWithOptionalTimeout(options, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<ShareFileItem> listFilesAndDirectoriesWithOptionalTimeout(ShareListFilesAndDirectoriesOptions options, Duration timeout, Context context) {
        ShareListFilesAndDirectoriesOptions modifiedOptions = options == null ? new ShareListFilesAndDirectoriesOptions() : options;
        ArrayList<ListFilesIncludeType> includeTypes = new ArrayList<ListFilesIncludeType>();
        if (modifiedOptions.includeAttributes()) {
            includeTypes.add(ListFilesIncludeType.ATTRIBUTES);
        }
        if (modifiedOptions.includeETag()) {
            includeTypes.add(ListFilesIncludeType.ETAG);
        }
        if (modifiedOptions.includeTimestamps()) {
            includeTypes.add(ListFilesIncludeType.TIMESTAMPS);
        }
        if (modifiedOptions.includePermissionKey()) {
            includeTypes.add(ListFilesIncludeType.PERMISSION_KEY);
        }
        ArrayList<ListFilesIncludeType> finalIncludeTypes = includeTypes.size() == 0 ? null : includeTypes;
        BiFunction<String, Integer, Mono> retriever = (marker, pageSize) -> StorageImplUtils.applyOptionalTimeout(this.azureFileStorageClient.getDirectories().listFilesAndDirectoriesSegmentWithResponseAsync(this.shareName, this.directoryPath, modifiedOptions.getPrefix(), this.snapshot, (String)marker, pageSize == null ? modifiedOptions.getMaxResultsPerPage() : pageSize, null, (List<ListFilesIncludeType>)finalIncludeTypes, modifiedOptions.includeExtendedInfo(), context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), this.convertResponseAndGetNumOfResults((DirectoriesListFilesAndDirectoriesSegmentResponse)((Object)((Object)response))), response.getValue().getNextMarker(), (Object)((DirectoriesListFilesAndDirectoriesSegmentHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(pageSize -> (Mono)retriever.apply((String)null, (Integer)pageSize), retriever);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<HandleItem> listHandles(Integer maxResultPerPage, boolean recursive) {
        try {
            return this.listHandlesWithOptionalTimeout(maxResultPerPage, recursive, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<HandleItem> listHandlesWithOptionalTimeout(Integer maxResultPerPage, boolean recursive, Duration timeout, Context context) {
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.azureFileStorageClient.getDirectories().listHandlesWithResponseAsync(this.shareName, this.directoryPath, (String)marker, maxResultPerPage, null, this.snapshot, recursive, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), response.getValue().getHandleList(), response.getValue().getNextMarker(), (Object)((DirectoriesListHandlesHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CloseHandlesInfo> forceCloseHandle(String handleId) {
        try {
            return FluxUtil.withContext(context -> this.forceCloseHandleWithResponse(handleId, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CloseHandlesInfo>> forceCloseHandleWithResponse(String handleId) {
        try {
            return FluxUtil.withContext(context -> this.forceCloseHandleWithResponse(handleId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CloseHandlesInfo>> forceCloseHandleWithResponse(String handleId, Context context) {
        return this.azureFileStorageClient.getDirectories().forceCloseHandlesWithResponseAsync(this.shareName, this.directoryPath, handleId, null, null, this.snapshot, false, context).map(response -> new SimpleResponse((Response)response, (Object)new CloseHandlesInfo(((DirectoriesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesClosed(), ((DirectoriesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesFailed())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CloseHandlesInfo> forceCloseAllHandles(boolean recursive) {
        try {
            return FluxUtil.withContext(context -> this.forceCloseAllHandlesWithTimeout(recursive, null, (Context)context).reduce((Object)new CloseHandlesInfo(0, 0), (accu, next) -> new CloseHandlesInfo(accu.getClosedHandles() + next.getClosedHandles(), accu.getFailedHandles() + next.getFailedHandles())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PagedFlux<CloseHandlesInfo> forceCloseAllHandlesWithTimeout(boolean recursive, Duration timeout, Context context) {
        Function<String, Mono> retriever = marker -> StorageImplUtils.applyOptionalTimeout(this.azureFileStorageClient.getDirectories().forceCloseHandlesWithResponseAsync(this.shareName, this.directoryPath, "*", null, (String)marker, this.snapshot, recursive, context), (Duration)timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Collections.singletonList(new CloseHandlesInfo(((DirectoriesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesClosed(), ((DirectoriesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsNumberOfHandlesFailed())), ((DirectoriesForceCloseHandlesHeaders)response.getDeserializedHeaders()).getXMsMarker(), (Object)((DirectoriesForceCloseHandlesHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)retriever.apply(null), retriever);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareDirectoryAsyncClient> rename(String destinationPath) {
        try {
            return this.renameWithResponse(new ShareFileRenameOptions(destinationPath)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareDirectoryAsyncClient>> renameWithResponse(ShareFileRenameOptions options) {
        try {
            return FluxUtil.withContext(context -> this.renameWithResponse(options, (Context)context)).map(response -> new SimpleResponse(response, (Object)new ShareDirectoryAsyncClient((ShareDirectoryAsyncClient)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareDirectoryAsyncClient>> renameWithResponse(ShareFileRenameOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        context = context == null ? Context.NONE : context;
        ShareRequestConditions sourceRequestConditions = options.getSourceRequestConditions() == null ? new ShareRequestConditions() : options.getSourceRequestConditions();
        ShareRequestConditions destinationRequestConditions = options.getDestinationRequestConditions() == null ? new ShareRequestConditions() : options.getDestinationRequestConditions();
        SourceLeaseAccessConditions sourceConditions = new SourceLeaseAccessConditions().setSourceLeaseId(sourceRequestConditions.getLeaseId());
        DestinationLeaseAccessConditions destinationConditions = new DestinationLeaseAccessConditions().setDestinationLeaseId(destinationRequestConditions.getLeaseId());
        CopyFileSmbInfo smbInfo = null;
        String filePermissionKey = null;
        if (options.getSmbProperties() != null) {
            FileSmbProperties tempSmbProperties = options.getSmbProperties();
            filePermissionKey = tempSmbProperties.getFilePermissionKey();
            String fileAttributes = NtfsFileAttributes.toString(tempSmbProperties.getNtfsFileAttributes());
            String fileCreationTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileCreationTime());
            String fileLastWriteTime = FileSmbProperties.parseFileSMBDate(tempSmbProperties.getFileLastWriteTime());
            smbInfo = new CopyFileSmbInfo().setFileAttributes(fileAttributes).setFileCreationTime(fileCreationTime).setFileLastWriteTime(fileLastWriteTime).setIgnoreReadOnly(options.isIgnoreReadOnly());
        }
        ShareDirectoryAsyncClient destinationDirectoryClient = this.getDirectoryAsyncClient(options.getDestinationPath());
        String renameSource = this.getDirectoryUrl();
        return destinationDirectoryClient.azureFileStorageClient.getDirectories().renameWithResponseAsync(destinationDirectoryClient.getShareName(), destinationDirectoryClient.getDirectoryPath(), renameSource, null, options.getReplaceIfExists(), options.isIgnoreReadOnly(), options.getFilePermission(), filePermissionKey, options.getMetadata(), sourceConditions, destinationConditions, smbInfo, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)destinationDirectoryClient));
    }

    ShareDirectoryAsyncClient getDirectoryAsyncClient(String destinationPath) {
        if (CoreUtils.isNullOrEmpty((CharSequence)destinationPath)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'destinationPath' can not be set to null"));
        }
        return new ShareDirectoryAsyncClient(this.azureFileStorageClient, this.getShareName(), destinationPath, null, this.getAccountName(), this.getServiceVersion());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareDirectoryAsyncClient> createSubdirectory(String subdirectoryName) {
        try {
            return this.createSubdirectoryWithResponse(subdirectoryName, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareDirectoryAsyncClient>> createSubdirectoryWithResponse(String subdirectoryName, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata) {
        try {
            return FluxUtil.withContext(context -> this.createSubdirectoryWithResponse(subdirectoryName, smbProperties, filePermission, metadata, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareDirectoryAsyncClient>> createSubdirectoryWithResponse(String subdirectoryName, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Context context) {
        ShareDirectoryAsyncClient createSubClient = this.getSubdirectoryClient(subdirectoryName);
        return createSubClient.createWithResponse(smbProperties, filePermission, metadata, context).map(response -> new SimpleResponse(response, (Object)createSubClient));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSubdirectory(String subdirectoryName) {
        try {
            return this.deleteSubdirectoryWithResponse(subdirectoryName).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSubdirectoryWithResponse(String subdirectoryName) {
        try {
            return FluxUtil.withContext(context -> this.deleteSubdirectoryWithResponse(subdirectoryName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteSubdirectoryWithResponse(String subdirectoryName, Context context) {
        ShareDirectoryAsyncClient deleteSubClient = this.getSubdirectoryClient(subdirectoryName);
        return deleteSubClient.deleteWithResponse(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareFileAsyncClient> createFile(String fileName, long maxSize) {
        try {
            return this.createFileWithResponse(fileName, maxSize, null, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileAsyncClient>> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata) {
        return this.createFileWithResponse(fileName, maxSize, httpHeaders, smbProperties, filePermission, metadata, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareFileAsyncClient>> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.createFileWithResponse(fileName, maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareFileAsyncClient>> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Context context) {
        ShareFileAsyncClient shareFileAsyncClient = this.getFileClient(fileName);
        return shareFileAsyncClient.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, context).map(response -> new SimpleResponse(response, (Object)shareFileAsyncClient));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteFile(String fileName) {
        try {
            return this.deleteFileWithResponse(fileName).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteFileWithResponse(String fileName) {
        return this.deleteFileWithResponse(fileName, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteFileWithResponse(String fileName, ShareRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteFileWithResponse(fileName, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteFileWithResponse(String fileName, ShareRequestConditions requestConditions, Context context) {
        ShareFileAsyncClient shareFileAsyncClient = this.getFileClient(fileName);
        return shareFileAsyncClient.deleteWithResponse(requestConditions, context);
    }

    public String getShareSnapshotId() {
        return this.snapshot;
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureFileStorageClient.getHttpPipeline();
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return this.generateSas(shareServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Context context) {
        return new ShareSasImplUtil(shareServiceSasSignatureValues, this.getShareName(), this.getDirectoryPath()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), context);
    }

    private Response<ShareDirectoryInfo> createWithRestResponse(DirectoriesCreateResponse response) {
        String eTag = ((DirectoriesCreateHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime lastModified = ((DirectoriesCreateHeaders)response.getDeserializedHeaders()).getLastModified();
        FileSmbProperties smbProperties = new FileSmbProperties(response.getHeaders());
        ShareDirectoryInfo shareDirectoryInfo = new ShareDirectoryInfo(eTag, lastModified, smbProperties);
        return new SimpleResponse((Response)response, (Object)shareDirectoryInfo);
    }

    private Response<ShareDirectoryProperties> getPropertiesResponse(DirectoriesGetPropertiesResponse response) {
        Map<String, String> metadata = ((DirectoriesGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsMeta();
        String eTag = ((DirectoriesGetPropertiesHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime offsetDateTime = ((DirectoriesGetPropertiesHeaders)response.getDeserializedHeaders()).getLastModified();
        boolean isServerEncrypted = ((DirectoriesGetPropertiesHeaders)response.getDeserializedHeaders()).isXMsServerEncrypted();
        FileSmbProperties smbProperties = new FileSmbProperties(response.getHeaders());
        ShareDirectoryProperties shareDirectoryProperties = new ShareDirectoryProperties(metadata, eTag, offsetDateTime, isServerEncrypted, smbProperties);
        return new SimpleResponse((Response)response, (Object)shareDirectoryProperties);
    }

    private Response<ShareDirectoryInfo> setPropertiesResponse(DirectoriesSetPropertiesResponse response) {
        String eTag = ((DirectoriesSetPropertiesHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime lastModified = ((DirectoriesSetPropertiesHeaders)response.getDeserializedHeaders()).getLastModified();
        FileSmbProperties smbProperties = new FileSmbProperties(response.getHeaders());
        ShareDirectoryInfo shareDirectoryInfo = new ShareDirectoryInfo(eTag, lastModified, smbProperties);
        return new SimpleResponse((Response)response, (Object)shareDirectoryInfo);
    }

    private Response<ShareDirectorySetMetadataInfo> setMetadataResponse(DirectoriesSetMetadataResponse response) {
        String eTag = ((DirectoriesSetMetadataHeaders)response.getDeserializedHeaders()).getETag();
        boolean isServerEncrypted = ((DirectoriesSetMetadataHeaders)response.getDeserializedHeaders()).isXMsRequestServerEncrypted();
        ShareDirectorySetMetadataInfo shareDirectorySetMetadataInfo = new ShareDirectorySetMetadataInfo(eTag, isServerEncrypted);
        return new SimpleResponse((Response)response, (Object)shareDirectorySetMetadataInfo);
    }

    private List<ShareFileItem> convertResponseAndGetNumOfResults(DirectoriesListFilesAndDirectoriesSegmentResponse response) {
        TreeSet<ShareFileItem> shareFileItems = new TreeSet<ShareFileItem>(Comparator.comparing(ShareFileItem::getName));
        if (response.getValue().getSegment() != null) {
            response.getValue().getSegment().getDirectoryItems().forEach(directoryItem -> shareFileItems.add(new ShareFileItem(directoryItem.getName(), true, directoryItem.getFileId(), ModelHelper.transformFileProperty(directoryItem.getProperties()), NtfsFileAttributes.toAttributes(directoryItem.getAttributes()), directoryItem.getPermissionKey(), null)));
            response.getValue().getSegment().getFileItems().forEach(fileItem -> shareFileItems.add(new ShareFileItem(fileItem.getName(), false, fileItem.getFileId(), ModelHelper.transformFileProperty(fileItem.getProperties()), NtfsFileAttributes.toAttributes(fileItem.getAttributes()), fileItem.getPermissionKey(), fileItem.getProperties().getContentLength())));
        }
        return new ArrayList<ShareFileItem>(shareFileItems);
    }

    private void validateFilePermissionAndKey(String filePermission, String filePermissionKey) {
        if (filePermission != null && filePermissionKey != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("File permission and file permission key cannot both be set"));
        }
        if (filePermission != null) {
            StorageImplUtils.assertInBounds((String)"filePermission", (long)filePermission.getBytes(StandardCharsets.UTF_8).length, (long)0L, (long)8192L);
        }
    }
}

