/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="null")
public final class FilesRenameHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-file-permission-key")
    private String xMsFilePermissionKey;
    @JsonProperty(value="x-ms-file-id")
    private String xMsFileId;
    @JsonProperty(value="x-ms-file-creation-time")
    private OffsetDateTime xMsFileCreationTime;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-request-server-encrypted")
    private Boolean xMsRequestServerEncrypted;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="x-ms-file-attributes")
    private String xMsFileAttributes;
    @JsonProperty(value="x-ms-file-change-time")
    private OffsetDateTime xMsFileChangeTime;
    @JsonProperty(value="x-ms-file-parent-id")
    private String xMsFileParentId;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-file-last-write-time")
    private OffsetDateTime xMsFileLastWriteTime;

    public FilesRenameHeaders(HttpHeaders rawHeaders) {
        String date;
        String xMsRequestServerEncrypted;
        String lastModified;
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        this.xMsFilePermissionKey = rawHeaders.getValue("x-ms-file-permission-key");
        this.xMsFileId = rawHeaders.getValue("x-ms-file-id");
        String xMsFileCreationTime = rawHeaders.getValue("x-ms-file-creation-time");
        if (xMsFileCreationTime != null) {
            this.xMsFileCreationTime = OffsetDateTime.parse(xMsFileCreationTime);
        }
        if ((lastModified = rawHeaders.getValue("Last-Modified")) != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        if ((xMsRequestServerEncrypted = rawHeaders.getValue("x-ms-request-server-encrypted")) != null) {
            this.xMsRequestServerEncrypted = Boolean.parseBoolean(xMsRequestServerEncrypted);
        }
        if ((date = rawHeaders.getValue("Date")) != null) {
            this.date = new DateTimeRfc1123(date);
        }
        this.eTag = rawHeaders.getValue("ETag");
        this.xMsFileAttributes = rawHeaders.getValue("x-ms-file-attributes");
        String xMsFileChangeTime = rawHeaders.getValue("x-ms-file-change-time");
        if (xMsFileChangeTime != null) {
            this.xMsFileChangeTime = OffsetDateTime.parse(xMsFileChangeTime);
        }
        this.xMsFileParentId = rawHeaders.getValue("x-ms-file-parent-id");
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        String xMsFileLastWriteTime = rawHeaders.getValue("x-ms-file-last-write-time");
        if (xMsFileLastWriteTime != null) {
            this.xMsFileLastWriteTime = OffsetDateTime.parse(xMsFileLastWriteTime);
        }
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public FilesRenameHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsFilePermissionKey() {
        return this.xMsFilePermissionKey;
    }

    public FilesRenameHeaders setXMsFilePermissionKey(String xMsFilePermissionKey) {
        this.xMsFilePermissionKey = xMsFilePermissionKey;
        return this;
    }

    public String getXMsFileId() {
        return this.xMsFileId;
    }

    public FilesRenameHeaders setXMsFileId(String xMsFileId) {
        this.xMsFileId = xMsFileId;
        return this;
    }

    public OffsetDateTime getXMsFileCreationTime() {
        return this.xMsFileCreationTime;
    }

    public FilesRenameHeaders setXMsFileCreationTime(OffsetDateTime xMsFileCreationTime) {
        this.xMsFileCreationTime = xMsFileCreationTime;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public FilesRenameHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Boolean isXMsRequestServerEncrypted() {
        return this.xMsRequestServerEncrypted;
    }

    public FilesRenameHeaders setXMsRequestServerEncrypted(Boolean xMsRequestServerEncrypted) {
        this.xMsRequestServerEncrypted = xMsRequestServerEncrypted;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public FilesRenameHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public FilesRenameHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getXMsFileAttributes() {
        return this.xMsFileAttributes;
    }

    public FilesRenameHeaders setXMsFileAttributes(String xMsFileAttributes) {
        this.xMsFileAttributes = xMsFileAttributes;
        return this;
    }

    public OffsetDateTime getXMsFileChangeTime() {
        return this.xMsFileChangeTime;
    }

    public FilesRenameHeaders setXMsFileChangeTime(OffsetDateTime xMsFileChangeTime) {
        this.xMsFileChangeTime = xMsFileChangeTime;
        return this;
    }

    public String getXMsFileParentId() {
        return this.xMsFileParentId;
    }

    public FilesRenameHeaders setXMsFileParentId(String xMsFileParentId) {
        this.xMsFileParentId = xMsFileParentId;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public FilesRenameHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public OffsetDateTime getXMsFileLastWriteTime() {
        return this.xMsFileLastWriteTime;
    }

    public FilesRenameHeaders setXMsFileLastWriteTime(OffsetDateTime xMsFileLastWriteTime) {
        this.xMsFileLastWriteTime = xMsFileLastWriteTime;
        return this;
    }
}

