/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.file.share.implementation.models.FileProperty;
import com.azure.storage.file.share.implementation.models.StringEncoded;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class FileItem
implements XmlSerializable<FileItem> {
    private StringEncoded name;
    private String fileId;
    private FileProperty properties;
    private String attributes;
    private String permissionKey;

    public StringEncoded getName() {
        return this.name;
    }

    public FileItem setName(StringEncoded name) {
        this.name = name;
        return this;
    }

    public String getFileId() {
        return this.fileId;
    }

    public FileItem setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    public FileProperty getProperties() {
        return this.properties;
    }

    public FileItem setProperties(FileProperty properties) {
        this.properties = properties;
        return this;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public FileItem setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public String getPermissionKey() {
        return this.permissionKey;
    }

    public FileItem setPermissionKey(String permissionKey) {
        this.permissionKey = permissionKey;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "File" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml((XmlSerializable)this.name, "Name");
        xmlWriter.writeStringElement("FileId", this.fileId);
        xmlWriter.writeXml((XmlSerializable)this.properties, "Properties");
        xmlWriter.writeStringElement("Attributes", this.attributes);
        xmlWriter.writeStringElement("PermissionKey", this.permissionKey);
        return xmlWriter.writeEndElement();
    }

    public static FileItem fromXml(XmlReader xmlReader) throws XMLStreamException {
        return FileItem.fromXml(xmlReader, null);
    }

    public static FileItem fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "File" : rootElementName;
        return (FileItem)xmlReader.readObject(finalRootElementName, reader -> {
            FileItem deserializedFileItem = new FileItem();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedFileItem.name = StringEncoded.fromXml(reader, "Name");
                    continue;
                }
                if ("FileId".equals(elementName.getLocalPart())) {
                    deserializedFileItem.fileId = reader.getStringElement();
                    continue;
                }
                if ("Properties".equals(elementName.getLocalPart())) {
                    deserializedFileItem.properties = FileProperty.fromXml(reader, "Properties");
                    continue;
                }
                if ("Attributes".equals(elementName.getLocalPart())) {
                    deserializedFileItem.attributes = reader.getStringElement();
                    continue;
                }
                if ("PermissionKey".equals(elementName.getLocalPart())) {
                    deserializedFileItem.permissionKey = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedFileItem;
        });
    }
}

