/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.reactor;

import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.reactor.IOEventHandler;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.reactor.ProtocolIOSession;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.reactor.SocksProxyProtocolHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class SocksProxyProtocolHandlerFactory
implements IOEventHandlerFactory {
    private final InetSocketAddress targetAddress;
    private final String username;
    private final String password;
    private final IOEventHandlerFactory eventHandlerFactory;

    public SocksProxyProtocolHandlerFactory(SocketAddress targetAddress, String username, String password, IOEventHandlerFactory eventHandlerFactory) throws IOException {
        this.eventHandlerFactory = eventHandlerFactory;
        this.username = username;
        this.password = password;
        if (!(targetAddress instanceof InetSocketAddress)) {
            throw new IOException("Unsupported target address type for SOCKS proxy connection: " + targetAddress.getClass());
        }
        this.targetAddress = (InetSocketAddress)targetAddress;
    }

    @Override
    public IOEventHandler createHandler(ProtocolIOSession ioSession, Object attachment) {
        return new SocksProxyProtocolHandler(ioSession, attachment, this.targetAddress, this.username, this.password, this.eventHandlerFactory);
    }
}

