/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.util.concurrent.TimeUnit;
import org.awaitility.core.ConditionEvaluationListener;
import org.awaitility.core.EvaluatedCondition;
import org.awaitility.core.TemporalDuration;

public class ConditionEvaluationLogger
implements ConditionEvaluationListener<Object> {
    private final TimeUnit unit;

    public ConditionEvaluationLogger() {
        this(TimeUnit.MILLISECONDS);
    }

    public ConditionEvaluationLogger(TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("TimeUnit cannot be null");
        }
        this.unit = unit;
    }

    @Override
    public void conditionEvaluated(EvaluatedCondition<Object> condition) {
        String description = condition.getDescription();
        long elapsedTime = this.unit.convert(condition.getElapsedTimeInMS(), TimeUnit.MILLISECONDS);
        long remainingTime = this.unit.convert(condition.getRemainingTimeInMS(), TimeUnit.MILLISECONDS);
        String unitAsString = this.unit.toString().toLowerCase();
        if (condition.isSatisfied()) {
            System.out.printf("%s after %d %s (remaining time %d %s, last poll interval was %s)%n", description, elapsedTime, unitAsString, remainingTime, unitAsString, new TemporalDuration(condition.getPollInterval()).toString());
        } else {
            System.out.printf("%s (elapsed time %d %s, remaining time %d %s (last poll interval was %s))%n", description, elapsedTime, unitAsString, remainingTime, unitAsString, new TemporalDuration(condition.getPollInterval()).toString());
        }
    }

    public static ConditionEvaluationLogger conditionEvaluationLogger() {
        return new ConditionEvaluationLogger();
    }

    public static ConditionEvaluationLogger conditionEvaluationLogger(TimeUnit unit) {
        return new ConditionEvaluationLogger(unit);
    }
}

