// $ANTLR 3.5.2 com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g 2022-09-03 03:04:19

package com.bpodgursky.jbool_expressions.parsers;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class BooleanExprLexer extends Lexer {
	public static final int EOF=-1;
	public static final int AND=4;
	public static final int DOUBLE_QUOTED_NAME=5;
	public static final int FALSE=6;
	public static final int LPAREN=7;
	public static final int NAME=8;
	public static final int NOT=9;
	public static final int OR=10;
	public static final int QUOTED_NAME=11;
	public static final int RPAREN=12;
	public static final int TRUE=13;
	public static final int WS=14;

	// delegates
	// delegators
	public Lexer[] getDelegates() {
		return new Lexer[] {};
	}

	public BooleanExprLexer() {} 
	public BooleanExprLexer(CharStream input) {
		this(input, new RecognizerSharedState());
	}
	public BooleanExprLexer(CharStream input, RecognizerSharedState state) {
		super(input,state);
	}
	@Override public String getGrammarFileName() { return "com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g"; }

	// $ANTLR start "LPAREN"
	public final void mLPAREN() throws RecognitionException {
		try {
			int _type = LPAREN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:17:8: ( '(' )
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:17:10: '('
			{
			match('('); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LPAREN"

	// $ANTLR start "RPAREN"
	public final void mRPAREN() throws RecognitionException {
		try {
			int _type = RPAREN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:18:8: ( ')' )
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:18:10: ')'
			{
			match(')'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RPAREN"

	// $ANTLR start "AND"
	public final void mAND() throws RecognitionException {
		try {
			int _type = AND;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:19:5: ( '&' )
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:19:7: '&'
			{
			match('&'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "AND"

	// $ANTLR start "OR"
	public final void mOR() throws RecognitionException {
		try {
			int _type = OR;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:20:4: ( '|' )
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:20:6: '|'
			{
			match('|'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "OR"

	// $ANTLR start "NOT"
	public final void mNOT() throws RecognitionException {
		try {
			int _type = NOT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:21:5: ( '!' )
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:21:7: '!'
			{
			match('!'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NOT"

	// $ANTLR start "TRUE"
	public final void mTRUE() throws RecognitionException {
		try {
			int _type = TRUE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:22:6: ( 'true' )
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:22:8: 'true'
			{
			match("true"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TRUE"

	// $ANTLR start "FALSE"
	public final void mFALSE() throws RecognitionException {
		try {
			int _type = FALSE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:23:7: ( 'false' )
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:23:9: 'false'
			{
			match("false"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FALSE"

	// $ANTLR start "NAME"
	public final void mNAME() throws RecognitionException {
		try {
			int _type = NAME;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:24:6: ( ( 'A' .. 'Z' | 'a' .. 'z' | '_' | '0' .. '9' )+ )
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:24:8: ( 'A' .. 'Z' | 'a' .. 'z' | '_' | '0' .. '9' )+
			{
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:24:8: ( 'A' .. 'Z' | 'a' .. 'z' | '_' | '0' .. '9' )+
			int cnt1=0;
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( ((LA1_0 >= '0' && LA1_0 <= '9')||(LA1_0 >= 'A' && LA1_0 <= 'Z')||LA1_0=='_'||(LA1_0 >= 'a' && LA1_0 <= 'z')) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:
					{
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt1 >= 1 ) break loop1;
					EarlyExitException eee = new EarlyExitException(1, input);
					throw eee;
				}
				cnt1++;
			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NAME"

	// $ANTLR start "QUOTED_NAME"
	public final void mQUOTED_NAME() throws RecognitionException {
		try {
			int _type = QUOTED_NAME;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:25:13: ( '\\'' (~ ( '\\r' | '\\n' | '\\'' ) )+ '\\'' )
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:25:15: '\\'' (~ ( '\\r' | '\\n' | '\\'' ) )+ '\\''
			{
			match('\''); 
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:25:19: (~ ( '\\r' | '\\n' | '\\'' ) )+
			int cnt2=0;
			loop2:
			while (true) {
				int alt2=2;
				int LA2_0 = input.LA(1);
				if ( ((LA2_0 >= '\u0000' && LA2_0 <= '\t')||(LA2_0 >= '\u000B' && LA2_0 <= '\f')||(LA2_0 >= '\u000E' && LA2_0 <= '&')||(LA2_0 >= '(' && LA2_0 <= '\uFFFF')) ) {
					alt2=1;
				}

				switch (alt2) {
				case 1 :
					// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:
					{
					if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\t')||(input.LA(1) >= '\u000B' && input.LA(1) <= '\f')||(input.LA(1) >= '\u000E' && input.LA(1) <= '&')||(input.LA(1) >= '(' && input.LA(1) <= '\uFFFF') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt2 >= 1 ) break loop2;
					EarlyExitException eee = new EarlyExitException(2, input);
					throw eee;
				}
				cnt2++;
			}

			match('\''); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "QUOTED_NAME"

	// $ANTLR start "DOUBLE_QUOTED_NAME"
	public final void mDOUBLE_QUOTED_NAME() throws RecognitionException {
		try {
			int _type = DOUBLE_QUOTED_NAME;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:26:20: ( '\"' (~ ( '\\r' | '\\n' | '\"' ) )+ '\"' )
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:26:22: '\"' (~ ( '\\r' | '\\n' | '\"' ) )+ '\"'
			{
			match('\"'); 
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:26:25: (~ ( '\\r' | '\\n' | '\"' ) )+
			int cnt3=0;
			loop3:
			while (true) {
				int alt3=2;
				int LA3_0 = input.LA(1);
				if ( ((LA3_0 >= '\u0000' && LA3_0 <= '\t')||(LA3_0 >= '\u000B' && LA3_0 <= '\f')||(LA3_0 >= '\u000E' && LA3_0 <= '!')||(LA3_0 >= '#' && LA3_0 <= '\uFFFF')) ) {
					alt3=1;
				}

				switch (alt3) {
				case 1 :
					// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:
					{
					if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\t')||(input.LA(1) >= '\u000B' && input.LA(1) <= '\f')||(input.LA(1) >= '\u000E' && input.LA(1) <= '!')||(input.LA(1) >= '#' && input.LA(1) <= '\uFFFF') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt3 >= 1 ) break loop3;
					EarlyExitException eee = new EarlyExitException(3, input);
					throw eee;
				}
				cnt3++;
			}

			match('\"'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DOUBLE_QUOTED_NAME"

	// $ANTLR start "WS"
	public final void mWS() throws RecognitionException {
		try {
			int _type = WS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:27:4: ( ( ' ' | '\\t' | '\\r' | '\\n' )+ )
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:27:6: ( ' ' | '\\t' | '\\r' | '\\n' )+
			{
			// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:27:6: ( ' ' | '\\t' | '\\r' | '\\n' )+
			int cnt4=0;
			loop4:
			while (true) {
				int alt4=2;
				int LA4_0 = input.LA(1);
				if ( ((LA4_0 >= '\t' && LA4_0 <= '\n')||LA4_0=='\r'||LA4_0==' ') ) {
					alt4=1;
				}

				switch (alt4) {
				case 1 :
					// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:
					{
					if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n')||input.LA(1)=='\r'||input.LA(1)==' ' ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt4 >= 1 ) break loop4;
					EarlyExitException eee = new EarlyExitException(4, input);
					throw eee;
				}
				cnt4++;
			}

			 _channel = HIDDEN; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "WS"

	@Override
	public void mTokens() throws RecognitionException {
		// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:1:8: ( LPAREN | RPAREN | AND | OR | NOT | TRUE | FALSE | NAME | QUOTED_NAME | DOUBLE_QUOTED_NAME | WS )
		int alt5=11;
		switch ( input.LA(1) ) {
		case '(':
			{
			alt5=1;
			}
			break;
		case ')':
			{
			alt5=2;
			}
			break;
		case '&':
			{
			alt5=3;
			}
			break;
		case '|':
			{
			alt5=4;
			}
			break;
		case '!':
			{
			alt5=5;
			}
			break;
		case 't':
			{
			int LA5_6 = input.LA(2);
			if ( (LA5_6=='r') ) {
				int LA5_12 = input.LA(3);
				if ( (LA5_12=='u') ) {
					int LA5_14 = input.LA(4);
					if ( (LA5_14=='e') ) {
						int LA5_16 = input.LA(5);
						if ( ((LA5_16 >= '0' && LA5_16 <= '9')||(LA5_16 >= 'A' && LA5_16 <= 'Z')||LA5_16=='_'||(LA5_16 >= 'a' && LA5_16 <= 'z')) ) {
							alt5=8;
						}

						else {
							alt5=6;
						}

					}

					else {
						alt5=8;
					}

				}

				else {
					alt5=8;
				}

			}

			else {
				alt5=8;
			}

			}
			break;
		case 'f':
			{
			int LA5_7 = input.LA(2);
			if ( (LA5_7=='a') ) {
				int LA5_13 = input.LA(3);
				if ( (LA5_13=='l') ) {
					int LA5_15 = input.LA(4);
					if ( (LA5_15=='s') ) {
						int LA5_17 = input.LA(5);
						if ( (LA5_17=='e') ) {
							int LA5_19 = input.LA(6);
							if ( ((LA5_19 >= '0' && LA5_19 <= '9')||(LA5_19 >= 'A' && LA5_19 <= 'Z')||LA5_19=='_'||(LA5_19 >= 'a' && LA5_19 <= 'z')) ) {
								alt5=8;
							}

							else {
								alt5=7;
							}

						}

						else {
							alt5=8;
						}

					}

					else {
						alt5=8;
					}

				}

				else {
					alt5=8;
				}

			}

			else {
				alt5=8;
			}

			}
			break;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z':
			{
			alt5=8;
			}
			break;
		case '\'':
			{
			alt5=9;
			}
			break;
		case '\"':
			{
			alt5=10;
			}
			break;
		case '\t':
		case '\n':
		case '\r':
		case ' ':
			{
			alt5=11;
			}
			break;
		default:
			NoViableAltException nvae =
				new NoViableAltException("", 5, 0, input);
			throw nvae;
		}
		switch (alt5) {
			case 1 :
				// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:1:10: LPAREN
				{
				mLPAREN(); 

				}
				break;
			case 2 :
				// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:1:17: RPAREN
				{
				mRPAREN(); 

				}
				break;
			case 3 :
				// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:1:24: AND
				{
				mAND(); 

				}
				break;
			case 4 :
				// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:1:28: OR
				{
				mOR(); 

				}
				break;
			case 5 :
				// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:1:31: NOT
				{
				mNOT(); 

				}
				break;
			case 6 :
				// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:1:35: TRUE
				{
				mTRUE(); 

				}
				break;
			case 7 :
				// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:1:40: FALSE
				{
				mFALSE(); 

				}
				break;
			case 8 :
				// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:1:46: NAME
				{
				mNAME(); 

				}
				break;
			case 9 :
				// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:1:51: QUOTED_NAME
				{
				mQUOTED_NAME(); 

				}
				break;
			case 10 :
				// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:1:63: DOUBLE_QUOTED_NAME
				{
				mDOUBLE_QUOTED_NAME(); 

				}
				break;
			case 11 :
				// com/bpodgursky/jbool_expressions/parsers/BooleanExpr.g:1:82: WS
				{
				mWS(); 

				}
				break;

		}
	}



}
