/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.BinaryStreamUtils;
import com.clickhouse.client.data.ClickHouseDateTimeValue;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.JdbcParameterizedQuery;
import com.clickhouse.jdbc.JdbcTypeMapping;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.ClickHouseStatementImpl;
import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;

public class SqlBasedPreparedStatement
extends ClickHouseStatementImpl
implements PreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(SqlBasedPreparedStatement.class);
    private final Calendar defaultCalendar;
    private final ZoneId jvmZoneId;
    private final JdbcParameterizedQuery preparedQuery;
    private final ClickHouseValue[] templates;
    private final String[] values;
    private final List<String[]> batch;

    protected SqlBasedPreparedStatement(ClickHouseConnection connection, ClickHouseRequest<?> request, JdbcParameterizedQuery preparedQuery, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, request, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.defaultCalendar = connection.getDefaultCalendar();
        this.jvmZoneId = connection.getJvmTimeZone().toZoneId();
        this.preparedQuery = preparedQuery;
        this.templates = new ClickHouseValue[preparedQuery.getNamedParameters().size()];
        this.values = new String[this.templates.length];
        this.batch = new LinkedList<String[]>();
    }

    protected void ensureParams() throws SQLException {
        ArrayList<String> columns = new ArrayList<String>();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.values[i] != null) continue;
            columns.add(String.valueOf(i + 1));
        }
        if (!columns.isEmpty()) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing parameter(s): %s", (Object[])new Object[]{columns}));
        }
    }

    protected int toArrayIndex(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.templates.length) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Parameter index must between 1 and %d but we got %d", (Object[])new Object[]{this.templates.length, parameterIndex}));
        }
        return parameterIndex - 1;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.ensureParams();
        return this.executeQuery(this.preparedQuery.apply(this.values));
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.ensureParams();
        return this.executeUpdate(this.preparedQuery.apply(this.values));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setNull(parameterIndex, sqlType, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = x ? "1" : "0";
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = String.valueOf(x);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = ClickHouseValues.convertToQuotedString((Object)x);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = new String(x, StandardCharsets.UTF_8);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String s = null;
        if (x != null) {
            try {
                s = BinaryStreamUtils.readFixedString((ClickHouseInputStream)ClickHouseInputStream.of((InputStream)x), (int)length, (Charset)StandardCharsets.US_ASCII);
            }
            catch (Throwable e) {
                throw SqlExceptionUtils.clientError(e);
            }
        }
        this.setString(parameterIndex, s);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        String s = null;
        if (x != null) {
            try {
                s = BinaryStreamUtils.readFixedString((ClickHouseInputStream)ClickHouseInputStream.of((InputStream)x), (int)length, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable e) {
                throw SqlExceptionUtils.clientError(e);
            }
        }
        this.setString(parameterIndex, s);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureOpen();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.update(x);
            this.values[idx] = value.toSqlExpression();
        } else if (x instanceof ClickHouseValue) {
            this.templates[idx] = value = (ClickHouseValue)x;
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = ClickHouseValues.convertToSqlExpression((Object)x);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.ensureParams();
        return this.execute(this.preparedQuery.apply(this.values));
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("addBatch(String) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureOpen();
        int len = this.values.length;
        String[] newValues = new String[len];
        for (int i = 0; i < len; ++i) {
            String v = this.values[i];
            if (v == null) {
                throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing value for parameter #%d", (Object[])new Object[]{i + 1}));
            }
            newValues[i] = v;
        }
        this.batch.add(newValues);
        this.clearParameters();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureOpen();
        int len = this.batch.size();
        int[] results = new int[len];
        int counter = 0;
        for (String[] params : this.batch) {
            try {
                results[counter] = this.executeStatement(new ClickHouseSqlStatement(this.preparedQuery.apply(params)), null, null, null);
            }
            catch (Exception e) {
                results[counter] = -3;
                log.error((Object)"Failed to execute task %d of %d", new Object[]{counter + 1, len, e});
            }
            ++counter;
        }
        this.clearBatch();
        return results;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureOpen();
        this.batch.clear();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        String s = null;
        if (reader != null) {
            try {
                s = BinaryStreamUtils.readString((Reader)reader, (int)length);
            }
            catch (Throwable e) {
                throw SqlExceptionUtils.clientError(e);
            }
        }
        this.setString(parameterIndex, s);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (x != null) {
            this.setBinaryStream(parameterIndex, x.getBinaryStream());
        } else {
            this.setNull(parameterIndex, -2);
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet currentResult = this.getResultSet();
        return currentResult != null ? currentResult.getMetaData() : null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        if (x == null) {
            this.values[idx] = "NULL";
            return;
        }
        LocalDateTime dt = null;
        dt = cal != null ? x.toLocalDateTime().atZone(this.jvmZoneId).withZoneSameInstant(cal.getTimeZone().toZoneId()).toLocalDateTime() : x.toLocalDateTime();
        ClickHouseValue value = this.templates[idx];
        if (value == null) {
            value = ClickHouseDateTimeValue.ofNull((int)(dt.getNano() > 0 ? 9 : 0));
        }
        this.values[idx] = value.update(dt).toSqlExpression();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value != null) {
            value.resetToNullOrEmpty();
            this.values[idx] = value.toSqlExpression();
        } else {
            this.values[idx] = "NULL";
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setString(parameterIndex, String.valueOf(x));
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setRowId not implemented");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setNClob not implemented");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setClob not implemented");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setBlob not implemented");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setSQLXML not implemented");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        ClickHouseValue value = this.templates[idx];
        if (value == null) {
            this.templates[idx] = value = ClickHouseValues.newValue((ClickHouseColumn)JdbcTypeMapping.fromJdbcType(targetSqlType, scaleOrLength));
        }
        value.update(x);
        this.values[idx] = value.toSqlExpression();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setAsciiStream not implemented");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setBinaryStream not implemented");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ensureOpen();
        this.toArrayIndex(parameterIndex);
        throw SqlExceptionUtils.unsupportedError("setCharacterStream not implemented");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }
}

