/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClickHouseParameterizedQuery
implements Serializable {
    private static final long serialVersionUID = 8108887349618342152L;
    protected final ClickHouseConfig config;
    protected final String originalQuery;
    private final List<QueryPart> parts;
    private final Map<String, ClickHouseValue> names;
    private final String lastPart;

    public static String apply(String sql, Map<String, String> params) {
        StringBuilder builder = new StringBuilder();
        ClickHouseParameterizedQuery.apply(builder, sql, params);
        return builder.toString();
    }

    public static void apply(StringBuilder builder, String sql, Map<String, String> params) {
        int len;
        int n = len = sql == null ? 0 : sql.length();
        if (len < 2 || params == null || params.isEmpty()) {
            builder.append(sql);
            return;
        }
        for (int i = 0; i < len; ++i) {
            int endIndex;
            char ch = sql.charAt(i);
            if (ClickHouseUtils.isQuote(ch)) {
                endIndex = ClickHouseUtils.skipQuotedString(sql, i, len, ch);
                builder.append(sql.substring(i, endIndex));
                i = endIndex - 1;
                continue;
            }
            if (i + 1 < len) {
                endIndex = i + 1;
                char nextCh = sql.charAt(endIndex);
                if (ch == '-' && nextCh == ch) {
                    endIndex = ClickHouseUtils.skipSingleLineComment(sql, i + 2, len);
                    builder.append(sql.substring(i, endIndex));
                    i = endIndex - 1;
                    continue;
                }
                if (ch == '/' && nextCh == '*') {
                    endIndex = ClickHouseUtils.skipMultiLineComment(sql, i + 2, len);
                    builder.append(sql.substring(i, endIndex));
                    i = endIndex - 1;
                    continue;
                }
                if (ch == ':') {
                    if (nextCh == ch) {
                        builder.append(ch).append(ch);
                        ++i;
                        continue;
                    }
                    if (Character.isJavaIdentifierStart(nextCh)) {
                        StringBuilder sb = new StringBuilder().append(nextCh);
                        i += 2;
                        while (i < len) {
                            char c = sql.charAt(i);
                            if (c == '(') {
                                i = ClickHouseUtils.skipBrackets(sql, i, len, c) - 1;
                                break;
                            }
                            if (!Character.isJavaIdentifierPart(c)) {
                                --i;
                                break;
                            }
                            sb.append(c);
                            ++i;
                        }
                        builder.append(params.getOrDefault(sb.toString(), "NULL"));
                        continue;
                    }
                    builder.append(ch);
                    continue;
                }
                builder.append(ch);
                continue;
            }
            builder.append(ch);
        }
    }

    public static ClickHouseParameterizedQuery of(ClickHouseConfig config, String query) {
        return new ClickHouseParameterizedQuery(config, query);
    }

    protected ClickHouseParameterizedQuery(ClickHouseConfig config, String query) {
        this.config = ClickHouseChecker.nonNull(config, "Config");
        this.originalQuery = ClickHouseChecker.nonBlank(query, "query");
        this.parts = new LinkedList<QueryPart>();
        this.names = new LinkedHashMap<String, ClickHouseValue>();
        this.lastPart = this.parse();
    }

    protected void addPart(String part, int paramIndex, String paramType) {
        this.addPart(part, paramIndex, null, paramType);
    }

    protected void addPart(String part, int paramIndex, String paramName, String paramType) {
        if (paramName == null) {
            paramName = String.valueOf(paramIndex);
        }
        this.parts.add(new QueryPart(this.config, part, paramIndex, paramName, paramType, this.names));
    }

    protected List<QueryPart> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    protected String parse() {
        int paramIndex = 0;
        int partIndex = 0;
        int len = this.originalQuery.length();
        for (int i = 0; i < len; ++i) {
            char ch = this.originalQuery.charAt(i);
            if (ClickHouseUtils.isQuote(ch)) {
                i = ClickHouseUtils.skipQuotedString(this.originalQuery, i, len, ch) - 1;
                continue;
            }
            if (i + 1 >= len) continue;
            char nextCh = this.originalQuery.charAt(i + 1);
            if (ch == '-' && nextCh == ch) {
                i = ClickHouseUtils.skipSingleLineComment(this.originalQuery, i + 2, len) - 1;
                continue;
            }
            if (ch == '/' && nextCh == '*') {
                i = ClickHouseUtils.skipMultiLineComment(this.originalQuery, i + 2, len) - 1;
                continue;
            }
            if (ch != ':') continue;
            if (nextCh == ch) {
                ++i;
                continue;
            }
            if (!Character.isJavaIdentifierStart(nextCh)) continue;
            String part = partIndex != i ? this.originalQuery.substring(partIndex, i) : "";
            String paramName = null;
            String paramType = null;
            StringBuilder builder = new StringBuilder().append(nextCh);
            i += 2;
            while (i < len) {
                char c = this.originalQuery.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) {
                    if (c != '(') break;
                    int idx = ClickHouseUtils.skipBrackets(this.originalQuery, i, len, c);
                    paramType = this.originalQuery.substring(i + 1, idx - 1);
                    i = idx;
                    break;
                }
                builder.append(c);
                ++i;
            }
            partIndex = i--;
            if (builder.length() > 0 && !this.names.containsKey(paramName = builder.toString())) {
                ++paramIndex;
            }
            this.parts.add(new QueryPart(this.config, part, paramIndex, paramName, paramType, this.names));
        }
        return partIndex < len ? this.originalQuery.substring(partIndex, len) : null;
    }

    protected StringBuilder appendLastPartIfExists(StringBuilder builder) {
        if (this.lastPart != null) {
            builder.append(this.lastPart);
        }
        return builder;
    }

    protected String toSqlExpression(String paramName, Object value) {
        ClickHouseValue template = this.names.get(paramName);
        return template != null ? template.update(value).toSqlExpression() : ClickHouseValues.convertToSqlExpression(value);
    }

    public void apply(StringBuilder builder, Map<String, String> params) {
        if (!this.hasParameter()) {
            builder.append(this.originalQuery);
            return;
        }
        if (params == null) {
            params = Collections.emptyMap();
        }
        for (QueryPart p : this.parts) {
            builder.append(p.part);
            builder.append(params.getOrDefault(p.paramName, "NULL"));
        }
        this.appendLastPartIfExists(builder);
    }

    public void apply(StringBuilder builder, Collection<String> params) {
        if (params == null || params.isEmpty()) {
            this.apply(builder, Collections.emptyMap());
            return;
        }
        HashMap<String, String> map = null;
        Iterator<String> it = params.iterator();
        if (it.hasNext()) {
            map = new HashMap<String, String>();
            for (String n : this.names.keySet()) {
                String v = it.next();
                if (v != null) {
                    map.put(n, v);
                }
                if (it.hasNext()) continue;
                break;
            }
        }
        this.apply(builder, map);
    }

    public void apply(StringBuilder builder, Object param, Object ... more) {
        if (!this.hasParameter()) {
            builder.append(this.originalQuery);
            return;
        }
        int len = more == null ? 0 : more.length;
        HashMap<String, String> map = new HashMap<String, String>();
        int index = -1;
        for (Map.Entry<String, ClickHouseValue> e : this.names.entrySet()) {
            ClickHouseValue v = e.getValue();
            if (index < 0) {
                map.put(e.getKey(), v != null ? v.update(param).toSqlExpression() : ClickHouseValues.convertToSqlExpression(param));
            } else {
                if (index >= len) break;
                map.put(e.getKey(), v != null ? v.update(more[index]).toSqlExpression() : ClickHouseValues.convertToSqlExpression(more[index]));
            }
            ++index;
        }
        this.apply(builder, map);
    }

    public void apply(StringBuilder builder, Object[] values) {
        int len;
        int n = len = values == null ? 0 : values.length;
        if (len == 0) {
            this.apply(builder, Collections.emptyMap());
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int index = 0;
        for (Map.Entry<String, ClickHouseValue> e : this.names.entrySet()) {
            ClickHouseValue v = e.getValue();
            if (index >= len) break;
            map.put(e.getKey(), v != null ? v.update(values[index]).toSqlExpression() : ClickHouseValues.convertToSqlExpression(values[index]));
            ++index;
        }
        this.apply(builder, map);
    }

    public void apply(StringBuilder builder, String param, String ... more) {
        if (!this.hasParameter()) {
            builder.append(this.originalQuery);
            return;
        }
        int len = more == null ? 0 : more.length;
        HashMap<String, String> map = new HashMap<String, String>();
        int index = -1;
        for (String n : this.names.keySet()) {
            if (index < 0) {
                map.put(n, param);
            } else {
                if (index >= len) break;
                map.put(n, more[index]);
            }
            ++index;
        }
        this.apply(builder, map);
    }

    public void apply(StringBuilder builder, String[] values) {
        int len;
        int n = len = values == null ? 0 : values.length;
        if (len == 0) {
            this.apply(builder, Collections.emptyMap());
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int index = 0;
        for (String n2 : this.names.keySet()) {
            if (index >= len) break;
            map.put(n2, values[index]);
            ++index;
        }
        this.apply(builder, map);
    }

    public List<String> getParameters() {
        if (this.names.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(this.names.size());
        for (String n : this.names.keySet()) {
            list.add(n);
        }
        return Collections.unmodifiableList(list);
    }

    public String getOriginalQuery() {
        return this.originalQuery;
    }

    public List<String[]> getQueryParts() {
        ArrayList<String[]> queryParts = new ArrayList<String[]>(this.parts.size() + 1);
        for (QueryPart p : this.parts) {
            queryParts.add(new String[]{p.part, p.paramName});
        }
        if (this.lastPart != null) {
            queryParts.add(new String[]{this.lastPart, null});
        }
        return queryParts;
    }

    public ClickHouseValue[] getParameterTemplates() {
        int i = 0;
        ClickHouseValue[] templates = new ClickHouseValue[this.names.size()];
        for (ClickHouseValue v : this.names.values()) {
            templates[i++] = v;
        }
        return templates;
    }

    public boolean hasParameter() {
        return !this.names.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lastPart == null ? 0 : this.lastPart.hashCode());
        result = 31 * result + this.names.hashCode();
        result = 31 * result + this.originalQuery.hashCode();
        result = 31 * result + this.parts.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseParameterizedQuery other = (ClickHouseParameterizedQuery)obj;
        return Objects.equals(this.lastPart, other.lastPart) && this.names.equals(other.names) && this.originalQuery.equals(other.originalQuery) && this.parts.equals(other.parts);
    }

    protected static class QueryPart
    implements Serializable {
        public final String part;
        public final int paramIndex;
        public final String paramName;
        public final ClickHouseColumn paramType;

        protected QueryPart(ClickHouseConfig config, String part, int paramIndex, String paramName, String paramType, Map<String, ClickHouseValue> map) {
            this.part = part;
            this.paramIndex = paramIndex;
            String string = this.paramName = paramName != null ? paramName : String.valueOf(paramIndex);
            if (paramType != null) {
                this.paramType = ClickHouseColumn.of("", paramType);
                map.put(paramName, this.paramType.newValue(config));
            } else {
                this.paramType = null;
                map.putIfAbsent(paramName, null);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.paramIndex;
            result = 31 * result + (this.paramName == null ? 0 : this.paramName.hashCode());
            result = 31 * result + (this.paramType == null ? 0 : this.paramType.hashCode());
            result = 31 * result + (this.part == null ? 0 : this.part.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            QueryPart other = (QueryPart)obj;
            return this.paramIndex == other.paramIndex && Objects.equals(this.paramName, other.paramName) && Objects.equals(this.paramType, other.paramType) && Objects.equals(this.part, other.part);
        }
    }
}

