/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Button;
import com.codename1.ui.Display;
import com.codename1.ui.events.ActionListener;

class HeavyButton
extends Button {
    Object peer;

    HeavyButton(String label) {
        super(label);
        if (Display.impl.requiresHeavyButtonForCopyToClipboard()) {
            this.peer = Display.impl.createHeavyButton(this);
        }
    }

    public void addActionListener(ActionListener l) {
        super.addActionListener(l);
        if (this.peer != null) {
            Display.impl.addHeavyActionListener(this.peer, l);
        }
    }

    public void removeActionListener(ActionListener l) {
        super.removeActionListener(l);
        if (this.peer != null) {
            Display.impl.removeHeavyActionListener(this.peer, l);
        }
    }

    private void updateHeavyBounds() {
        if (this.peer != null) {
            Display.impl.updateHeavyButtonBounds(this.peer, this.getAbsoluteX(), this.getAbsoluteY(), this.getWidth(), this.getHeight());
        }
    }

    public void setWidth(int w) {
        super.setWidth(w);
        this.updateHeavyBounds();
    }

    public void setHeight(int h) {
        super.setHeight(h);
        this.updateHeavyBounds();
    }

    public void setX(int x) {
        super.setX(x);
        this.updateHeavyBounds();
    }

    public void setY(int y) {
        super.setY(y);
        this.updateHeavyBounds();
    }

    protected void initComponent() {
        super.initComponent();
        if (this.peer != null) {
            Display.impl.initHeavyButton(this.peer);
        }
    }

    protected void deinitialize() {
        if (this.peer != null) {
            Display.impl.deinitializeHeavyButton(this.peer);
        }
        super.deinitialize();
    }
}

