/*
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores
 * CA 94065 USA or visit www.oracle.com if you need additional information or
 * have any questions.
 */
package com.codename1.io.rest;

import java.io.InputStream;

/**
 * The http Response class
 *
 * @author Chen Fishbein
 */
public class Response<T> {
    private int responseCode;
    private T responseData;
    private String responseMessage;

    Response(int responseCode, T responseData, String responseMessage) {
        this.responseCode = responseCode;
        this.responseData = responseData;
        this.responseMessage = responseMessage;
    }
    
    /**
     * The http response data
     * 
     * @return the data
     */ 
    public T getResponseData() {
        return responseData;
    }
    
    /**
     * The http response code
     * 
     * @return the code
     */ 
    public int getResponseCode() {
        return responseCode;
    }
    
    /**
     * Returns the error message that accompanies the response
     * @return the response
     */
    public String getResponseErrorMessage() {
        return responseMessage;
    }
}
