/*
 * Copyright (c) 2012, Codename One and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Codename One designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *  
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please contact Codename One through http://www.codenameone.com/ if you 
 * need additional information or have any questions.
 */
package com.codename1.ui;


/**
 * Represents a virtual input device that may need to be closed/disposed, providing a way  Widgets that
 * require exclusive access to the user's input (but perhaps not all of the user interactions with the app)
 * need to provide a way for the form to dispose of it when a new input device needs to be displayed.
 * 
 * <p>Examples of virtual input devices include the virtual keyboard and the Picker.</p>
 * 
 * <p>VirtualInputDevices should implement the {@link #close() } method to safely dispose of itself.  Before displaying
 * the input device to the screen, it should call {@link Form#setCurrentInputDevice(com.codename1.ui.VirtualInputDevice) }
 * which will execute the {@link #close() } method of the the current input device.</p>
 * @author Steve Hannah
 * @see Form#setCurrentInputDevice(com.codename1.ui.VirtualInputDevice) 
 */
public interface VirtualInputDevice extends AutoCloseable {
    
}
