/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.layouts;

import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Form;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.plaf.Style;

public class BoxLayout
extends Layout {
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    public static final int X_AXIS_NO_GROW = 3;
    public static final int Y_AXIS_BOTTOM_LAST = 4;
    private int align = 0;
    private int axis;
    private Dimension dim = new Dimension(0, 0);

    public BoxLayout(int axis) {
        this.axis = axis;
    }

    public static BoxLayout y() {
        return new BoxLayout(2);
    }

    public static BoxLayout yLast() {
        return new BoxLayout(4);
    }

    public static BoxLayout yCenter() {
        BoxLayout out = new BoxLayout(2);
        out.setAlign(4);
        return out;
    }

    public static BoxLayout yBottom() {
        BoxLayout out = new BoxLayout(2);
        out.setAlign(2);
        return out;
    }

    public static BoxLayout x() {
        return new BoxLayout(1);
    }

    public static BoxLayout xCenter() {
        BoxLayout out = new BoxLayout(1);
        out.setAlign(4);
        return out;
    }

    public static BoxLayout xRight() {
        BoxLayout out = new BoxLayout(1);
        out.setAlign(3);
        return out;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public int getAlign() {
        return this.align;
    }

    public void layoutContainer(Container parent) {
        block40: {
            int dx;
            int i;
            Component lastCmp;
            int numOfcomponents;
            block41: {
                boolean rtl;
                block39: {
                    Style ps = parent.getStyle();
                    int width = parent.getLayoutWidth() - parent.getSideGap() - ps.getHorizontalPadding();
                    int height = parent.getLayoutHeight() - parent.getBottomGap() - ps.getVerticalPadding();
                    int x = ps.getPaddingLeft(parent.isRTL());
                    int y = ps.getPaddingTop();
                    numOfcomponents = parent.getComponentCount();
                    rtl = parent.isRTL();
                    if (rtl) {
                        x += parent.getSideGap();
                    }
                    int initX = x;
                    block16: for (int i2 = 0; i2 < numOfcomponents; ++i2) {
                        Component cmp = parent.getComponentAt(i2);
                        Style stl = cmp.getStyle();
                        switch (this.axis) {
                            case 2: 
                            case 4: {
                                int cmpBottom = height;
                                cmp.setWidth(width - stl.getHorizontalMargins());
                                int cmpH = cmp.getPreferredH();
                                if ((y += stl.getMarginTop()) - ps.getPaddingTop() >= cmpBottom && !parent.isScrollableY()) {
                                    cmpH = 0;
                                } else if (y + cmpH - ps.getPaddingTop() > cmpBottom && !parent.isScrollableY()) {
                                    cmpH = cmpBottom - y - stl.getMarginBottom();
                                }
                                cmp.setHeight(cmpH);
                                cmp.setX(x + stl.getMarginLeft(parent.isRTL()));
                                cmp.setY(y);
                                y += cmp.getHeight() + stl.getMarginBottom();
                                continue block16;
                            }
                            case 3: {
                                int cmpRight = width;
                                height = Math.min(this.getPreferredSize(parent).getHeight(), height);
                                int cmpW = cmp.getPreferredW();
                                if ((x += stl.getMarginLeftNoRTL()) >= cmpRight && !parent.isScrollableX()) {
                                    cmpW = 0;
                                } else if (x + cmpW - ps.getPaddingLeftNoRTL() > cmpRight) {
                                    cmpW = cmpRight - x - stl.getMarginRightNoRTL();
                                }
                                cmp.setWidth(cmpW);
                                cmp.setHeight(height - stl.getMarginTop() - stl.getMarginBottom());
                                if (rtl) {
                                    cmp.setX(width + initX - (x - initX) - cmpW);
                                } else {
                                    cmp.setX(x);
                                }
                                cmp.setY(y + stl.getMarginTop());
                                x += cmp.getWidth() + stl.getMarginRightNoRTL();
                                continue block16;
                            }
                            default: {
                                int cmpRight = width;
                                int cmpW = cmp.getPreferredW();
                                if ((x += stl.getMarginLeftNoRTL()) >= cmpRight && !parent.isScrollableX()) {
                                    cmpW = 0;
                                } else if (x + cmpW - ps.getPaddingLeftNoRTL() > cmpRight) {
                                    cmpW = cmpRight - x - stl.getMarginRightNoRTL();
                                }
                                cmp.setWidth(cmpW);
                                cmp.setHeight(height - stl.getVerticalMargins());
                                if (rtl) {
                                    cmp.setX(width + initX - (x - initX) - cmpW);
                                } else {
                                    cmp.setX(x);
                                }
                                cmp.setY(y + stl.getMarginTop());
                                x += cmp.getWidth() + stl.getMarginRightNoRTL();
                            }
                        }
                    }
                    if (this.axis == 4 && numOfcomponents > 0) {
                        Component cmp;
                        if (parent instanceof Form) {
                            parent = ((Form)parent).getContentPane();
                        }
                        if ((cmp = parent.getComponentAt(numOfcomponents - 1)).getY() + cmp.getHeight() < height) {
                            cmp.setY(height - cmp.getHeight());
                        }
                    }
                    if (this.axis != 2) break block39;
                    if (numOfcomponents <= 0) break block40;
                    int containerBottomInner = parent.getLayoutHeight() - parent.getStyle().getPaddingBottom();
                    lastCmp = parent.getComponentAt(numOfcomponents - 1);
                    int lastCmpBottomOuter = lastCmp.getY() + lastCmp.getHeight() + lastCmp.getStyle().getMarginBottom();
                    int dy = 0;
                    switch (this.align) {
                        case 4: {
                            dy = (containerBottomInner - lastCmpBottomOuter) / 2;
                            break;
                        }
                        case 2: {
                            dy = containerBottomInner - lastCmpBottomOuter;
                        }
                    }
                    if (dy > 0) {
                        for (i = 0; i < numOfcomponents; ++i) {
                            Component cmp = parent.getComponentAt(i);
                            cmp.setY(cmp.getY() + dy);
                        }
                    }
                    break block40;
                }
                if (this.axis != 1 || numOfcomponents <= 0) break block40;
                if (!rtl) break block41;
                int containerLeftInner = parent.getStyle().getPaddingLeftNoRTL();
                lastCmp = parent.getComponentAt(numOfcomponents - 1);
                int lastCmpLeftOuter = lastCmp.getX() - lastCmp.getStyle().getMarginLeftNoRTL();
                dx = 0;
                switch (this.align) {
                    case 4: {
                        dx = (lastCmpLeftOuter - containerLeftInner) / 2;
                        break;
                    }
                    case 3: {
                        dx = lastCmpLeftOuter - containerLeftInner;
                    }
                }
                if (dx <= 0) break block40;
                for (i = 0; i < numOfcomponents; ++i) {
                    Component cmp = parent.getComponentAt(i);
                    cmp.setX(cmp.getX() - dx);
                }
                break block40;
            }
            int containerRightInner = parent.getLayoutWidth() - parent.getStyle().getPaddingRightNoRTL();
            lastCmp = parent.getComponentAt(numOfcomponents - 1);
            int lastCmpRightOuter = lastCmp.getX() + lastCmp.getWidth() + lastCmp.getStyle().getMarginRightNoRTL();
            dx = 0;
            switch (this.align) {
                case 4: {
                    dx = (containerRightInner - lastCmpRightOuter) / 2;
                    break;
                }
                case 3: {
                    dx = containerRightInner - lastCmpRightOuter;
                }
            }
            if (dx > 0) {
                for (i = 0; i < numOfcomponents; ++i) {
                    Component cmp = parent.getComponentAt(i);
                    cmp.setX(cmp.getX() + dx);
                }
            }
        }
    }

    public Dimension getPreferredSize(Container parent) {
        int width = 0;
        int height = 0;
        int numOfcomponents = parent.getComponentCount();
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            Style stl = cmp.getStyle();
            if (this.axis == 2 || this.axis == 4) {
                int cmpH = cmp.getPreferredH() + stl.getVerticalMargins();
                height += cmpH;
                width = Math.max(width, cmp.getPreferredW() + stl.getHorizontalMargins());
                continue;
            }
            int cmpW = cmp.getPreferredW() + stl.getHorizontalMargins();
            width += cmpW;
            height = Math.max(height, cmp.getPreferredH() + stl.getVerticalMargins());
        }
        Style s = parent.getStyle();
        this.dim.setWidth(width + s.getHorizontalPadding());
        this.dim.setHeight(height + s.getVerticalPadding());
        return this.dim;
    }

    public int getAxis() {
        return this.axis;
    }

    public String toString() {
        if (this.axis == 1) {
            return "BoxLayout X";
        }
        return "BoxLayout Y";
    }

    public boolean equals(Object o) {
        return super.equals(o) && this.axis == ((BoxLayout)o).axis;
    }

    public static Container encloseY(Component ... cmps) {
        return Container.encloseIn((Layout)new BoxLayout(2), cmps);
    }

    public static Container encloseYCenter(Component ... cmps) {
        return Container.encloseIn((Layout)BoxLayout.yCenter(), cmps);
    }

    public static Container encloseYBottom(Component ... cmps) {
        return Container.encloseIn((Layout)BoxLayout.yBottom(), cmps);
    }

    public static Container encloseYBottomLast(Component ... cmps) {
        return Container.encloseIn((Layout)new BoxLayout(4), cmps);
    }

    public static Container encloseX(Component ... cmps) {
        return Container.encloseIn((Layout)new BoxLayout(1), cmps);
    }

    public static Container encloseXNoGrow(Component ... cmps) {
        return Container.encloseIn((Layout)new BoxLayout(3), cmps);
    }

    public static Container encloseXCenter(Component ... cmps) {
        return Container.encloseIn((Layout)BoxLayout.xCenter(), cmps);
    }

    public static Container encloseXRight(Component ... cmps) {
        return Container.encloseIn((Layout)BoxLayout.xRight(), cmps);
    }
}

