/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.html;

import com.codename1.ui.Button;
import com.codename1.ui.CheckBox;
import com.codename1.ui.ComboBox;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Label;
import com.codename1.ui.List;
import com.codename1.ui.RadioButton;
import com.codename1.ui.TextArea;
import com.codename1.ui.TextField;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.html.AsyncDocumentRequestHandler;
import com.codename1.ui.html.CSSElement;
import com.codename1.ui.html.CSSEngine;
import com.codename1.ui.html.CSSParser;
import com.codename1.ui.html.CellConstraint;
import com.codename1.ui.html.DefaultDocumentRequestHandler;
import com.codename1.ui.html.DocumentInfo;
import com.codename1.ui.html.DocumentRequestHandler;
import com.codename1.ui.html.HTMLCallback;
import com.codename1.ui.html.HTMLElement;
import com.codename1.ui.html.HTMLEventsListener;
import com.codename1.ui.html.HTMLFont;
import com.codename1.ui.html.HTMLForm;
import com.codename1.ui.html.HTMLImageMap;
import com.codename1.ui.html.HTMLInputFormat;
import com.codename1.ui.html.HTMLLink;
import com.codename1.ui.html.HTMLListItem;
import com.codename1.ui.html.HTMLParser;
import com.codename1.ui.html.HTMLTable;
import com.codename1.ui.html.HTMLTableModel;
import com.codename1.ui.html.HTMLUtils;
import com.codename1.ui.html.IOCallback;
import com.codename1.ui.html.ImageMapData;
import com.codename1.ui.html.MultiComboBox;
import com.codename1.ui.html.OptionItem;
import com.codename1.ui.html.ResourceThreadQueue;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.Style;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HTMLComponent
extends Container
implements ActionListener,
IOCallback {
    private boolean supressExceptions;
    static final boolean FIXED_WIDTH = false;
    static final boolean SUPPORT_INPUT_FORMAT = true;
    static final boolean SUPPORT_CSS = true;
    private static final boolean CLEAN_ON_PAGE_REQUEST = true;
    private static final boolean CJK_SUPPORT = true;
    static final boolean PROCESS_HTML_MP1_ONLY = false;
    private static final int INDENT_BLOCKQUOTE = 20;
    private static final int INDENT_DD = 20;
    private static int INDENT_OL = -1;
    private static int INDENT_UL = -1;
    private static final int MIN_MULTI_COMBOBOX_ITEMS = 4;
    private static final int MAX_MULTI_COMBOBOX_ITEMS = 6;
    private static final int DEFAULT_TEXTFIELD_SIZE = 12;
    private static final int DEFAULT_TEXTAREA_COLS = 20;
    private static final int DEFAULT_TEXTAREA_ROWS = 2;
    static final int JUSTIFY = 5;
    private static final int HR_THICKNESS = 3;
    private static final int MARQUEE_DELAY = 6000;
    private static final boolean MATCH_EXACT_FONTS_ONLY = false;
    private static final boolean MATCH_BITMAP_FONTS_ONLY = true;
    private static final boolean MATCH_SAME_FONT_FAMILY_ONLY = true;
    private static HTMLFont DEFAULT_FONT = null;
    private static final int COLOR_VISITED_LINKS = 0x990099;
    static Hashtable fonts = new Hashtable();
    private static final int INPUT_CHECKBOX = 0;
    private static final int INPUT_HIDDEN = 1;
    private static final int INPUT_PASSWORD = 2;
    private static final int INPUT_RADIO = 3;
    private static final int INPUT_RESET = 4;
    private static final int INPUT_SUBMIT = 5;
    private static final int INPUT_TEXT = 6;
    private static final int INPUT_IMAGE = 7;
    private static final int INPUT_BUTTON = 8;
    private static final int INPUT_EMAIL = 9;
    private static String[] INPUT_TYPE_STRINGS = new String[]{"checkbox", "hidden", "password", "radio", "reset", "submit", "text", "image", "button", "email"};
    private static Vector INPUT_TYPES = new Vector();
    static final String CLIENT_PROPERTY_QUOTE = "quote";
    static final String CLIENT_PROPERTY_IMG_BORDER = "imgBorder";
    private static final char[] ORDERED_LIST_TYPE_IDENTIFIERS = new char[]{'1', 'A', 'a', 'I', 'i'};
    boolean loadCSS = true;
    boolean eventsEnabled = false;
    HTMLParser parser;
    int contCount = 0;
    private Vector embeddedCSS;
    private Vector externalCSS;
    static final int DEFAULT_BGCOLOR = 0xFFFFFF;
    static final int DEFAULT_TEXT_COLOR = 0;
    private static final int DEFAULT_LINK_COLOR = 255;
    private int bgColor = 0xFFFFFF;
    private int textColor = 0;
    private int linkColor = 255;
    private DocumentRequestHandler handler;
    private RedirectThread redirectThread;
    private ResourceThreadQueue threadQueue;
    private HTMLCallback htmlCallback;
    private HTMLEventsListener eventsListener;
    private DocumentInfo docInfo;
    private HTMLElement document;
    private String pageURL;
    private int pageStatus = -3;
    private boolean pageError;
    private String title;
    private int displayWidth;
    private boolean cancelled;
    private boolean cancelledCaught;
    boolean showImages = true;
    private Style pageStyle;
    private String pageUIID;
    private Hashtable accessKeys = new Hashtable();
    private Hashtable anchors;
    private Hashtable inputFields;
    Component firstFocusable;
    HTMLFont defaultFont = DEFAULT_FONT;
    private String htmlBody;
    private Container mainContainer;
    private Container curContainer;
    private boolean autoFocus = true;
    private Container curLine;
    private int x;
    private int width;
    private int leftIndent;
    private boolean lastWasEmpty;
    private HTMLFont font;
    private String link;
    private HTMLLink mainLink;
    private char accesskey = '\u0000';
    private String anchor;
    private boolean linkVisited;
    private HTMLForm curForm;
    private TextArea curTextArea;
    private List curComboBox;
    private boolean optionTag;
    private boolean optionSelected;
    private String optionValue;
    private Hashtable textfieldsToForms;
    private int ulLevel;
    private int olIndex;
    private Vector olUpperLevelIndex;
    private int listType;
    private int listIndent;
    private Vector tables;
    private Vector tableCells;
    HTMLTableModel curTable;
    private Vector fieldsets;
    private int preTagCount = 0;
    private int quoteTagCount = 0;
    private String labelForID;
    private int underlineCount;
    private int strikethruCount;
    private int textDecoration;
    private Hashtable imageMapComponents;
    private Hashtable imageMapData;
    private ImageMapData curImageMap;
    private int superscript;
    private int maxSuperscript;
    Hashtable counters;
    private Vector containers = new Vector();
    Vector marqueeComponents = new Vector();
    private Motion marqueeMotion;
    static final String[] CSS_OL_TYPES;
    private static final String[] ROMAN_NUMERALS_ONES;
    private static final String[] ROMAN_NUMERALS_TENS;
    static final String[] CSS_UL_TYPES;

    public static void addFont(String fontKey, Font font) {
        if (fontKey != null) {
            fontKey = fontKey.toLowerCase();
        } else if (font.getCharset() != null) {
            throw new IllegalArgumentException("Font key must be non-null for bitmap fonts");
        }
        fonts.put(fontKey, new HTMLFont(fontKey, font));
    }

    public void setParser(HTMLParser parser) {
        this.parser.setParserCallback(null);
        this.parser.setHTMLComponent(null);
        this.parser = parser;
        parser.setHTMLComponent(this);
        parser.setParserCallback(this.htmlCallback);
    }

    public void addCharEntity(String symbol, int code) {
        this.parser.addCharEntity(symbol, code);
    }

    public static void addSpecialKey(String specialKeyName, int specialKeyCode) {
        CSSEngine.addSpecialKey(specialKeyName, specialKeyCode);
    }

    public void addCharEntitiesRange(String[] symbols, int startcode) {
        this.parser.addCharEntitiesRange(symbols, startcode);
    }

    public static void setMaxThreads(int threadsNum) {
        ResourceThreadQueue.setMaxThreads(threadsNum);
    }

    public static void setCSSSupportedMediaTypes(String[] supportedMediaTypes) {
        CSSParser.setCSSSupportedMediaTypes(supportedMediaTypes);
    }

    public HTMLComponent() {
        this(new DefaultDocumentRequestHandler());
    }

    public HTMLComponent(DocumentRequestHandler handler) {
        if (INDENT_OL < 0) {
            INDENT_OL = Font.getDefaultFont().stringWidth("8888. ");
        }
        if (INDENT_UL < 0) {
            INDENT_UL = Font.getDefaultFont().charWidth('W');
        }
        if (DEFAULT_FONT == null) {
            DEFAULT_FONT = new HTMLFont(null, Font.createSystemFont(0, 0, 0));
        }
        this.setLayout(new BoxLayout(2));
        this.handler = handler;
        this.threadQueue = new ResourceThreadQueue(this);
        this.setHandlesInput(true);
        this.setScrollableY(true);
        this.setScrollableX(false);
        this.setSmoothScrolling(true);
        HTMLFont italic = new HTMLFont(null, Font.createSystemFont(0, 2, 0));
        HTMLFont monospace = new HTMLFont(null, Font.createSystemFont(32, 0, 0));
        fonts.put(HTMLElement.TAG_NAMES[13], italic);
        fonts.put(HTMLElement.TAG_NAMES[26], new HTMLFont(null, Font.createSystemFont(0, 1, 0)));
        fonts.put(HTMLElement.TAG_NAMES[11], italic);
        fonts.put(HTMLElement.TAG_NAMES[10], monospace);
        fonts.put(HTMLElement.TAG_NAMES[24], monospace);
        fonts.put(HTMLElement.TAG_NAMES[20], monospace);
        fonts.put(HTMLElement.TAG_NAMES[27], italic);
        fonts.put(HTMLElement.TAG_NAMES[9], italic);
        fonts.put(HTMLElement.TAG_NAMES[22], monospace);
        fonts.put(HTMLElement.TAG_NAMES[14], new HTMLFont(null, Font.createSystemFont(0, 1, 16)));
        fonts.put(HTMLElement.TAG_NAMES[15], new HTMLFont(null, Font.createSystemFont(0, 2, 16)));
        fonts.put(HTMLElement.TAG_NAMES[16], new HTMLFont(null, Font.createSystemFont(0, 1, 0)));
        fonts.put(HTMLElement.TAG_NAMES[64], monospace);
        this.parser = new HTMLParser();
        this.parser.setHTMLComponent(this);
    }

    public DocumentRequestHandler getRequestHandler() {
        return this.handler;
    }

    public void setRequestHandler(DocumentRequestHandler handler) {
        this.handler = handler;
    }

    public DocumentInfo getDocumentInfo() {
        return this.docInfo;
    }

    public void setHTMLCallback(HTMLCallback callback) {
        this.htmlCallback = callback;
        this.parser.setParserCallback(this.htmlCallback);
        CSSParser.getInstance().setCSSParserCallback(this.htmlCallback);
    }

    public HTMLCallback getHTMLCallback() {
        return this.htmlCallback;
    }

    public void setDefaultFont(String fontKey, Font font) {
        if (fontKey != null) {
            fontKey = fontKey.toLowerCase();
        }
        this.defaultFont = new HTMLFont(fontKey, font);
        if (fontKey != null) {
            fonts.put(fontKey, this.defaultFont);
        }
    }

    public void setShowImages(boolean show) {
        this.showImages = show;
    }

    public void setIgnoreCSS(boolean ignore) {
        this.loadCSS = !ignore;
    }

    public void scrollPixels(int pixels, boolean animate) {
        int scrollToY = this.getScrollY() + pixels;
        this.scrollTo(scrollToY, animate);
    }

    public void scrollPages(int pages, boolean animate) {
        int scrollToY = this.getScrollY() + this.getHeight() * pages;
        this.scrollTo(scrollToY, animate);
    }

    public void scrollToElement(HTMLElement element, boolean animate) {
        if (!this.pageLoading()) {
            Component cmp;
            if (!this.document.contains(element)) {
                throw new IllegalArgumentException("The specified element is not contained in the current document.");
            }
            Vector v = element.getUi();
            if (v != null && v.size() > 0 && (cmp = (Component)v.firstElement()) != null) {
                int y = cmp.getY();
                for (Container parent = cmp.getParent(); parent != null && parent != this; parent = parent.getParent()) {
                    y += parent.getY();
                }
                this.scrollTo(y, animate);
            }
        } else {
            throw new IllegalStateException("Page is still loading");
        }
    }

    private void scrollTo(int y, boolean animate) {
        if (y < 0) {
            y = 0;
        } else if (y > this.getPreferredH() - this.getHeight()) {
            y = this.getPreferredH() - this.getHeight();
        }
        if (animate) {
            this.scrollRectToVisible(this.getX(), y, this.getWidth(), this.getHeight(), this);
        } else {
            this.setScrollY(y);
        }
    }

    public void setBodyText(String htmlText) {
        this.setBodyText(htmlText, null);
    }

    public boolean setBodyText(String htmlText, String encoding) {
        return this.setHTML(htmlText, encoding, null, false);
    }

    public boolean setHTML(String htmlText, String encoding, String title, boolean isFullHTML) {
        boolean success = true;
        InputStreamReader isr = this.getStream(htmlText, encoding, title, isFullHTML);
        if (isr == null) {
            isr = this.getStream("Encoding error loading string", null, title, isFullHTML);
            success = false;
        }
        final InputStreamReader isReader = isr;
        Display.getInstance().startThread(new Runnable(){

            public void run() {
                HTMLElement doc = HTMLComponent.this.parser.parseHTML(isReader);
                HTMLComponent.this.documentReady(null, doc);
            }
        }, "setHTML").start();
        return success;
    }

    private InputStreamReader getStream(String htmlText, String encoding) {
        return this.getStream(htmlText, encoding, null, false);
    }

    private InputStreamReader getStream(String htmlText, String encoding, String title, boolean isFullHTML) {
        if (!isFullHTML) {
            String titleStr = "";
            if (title != null) {
                titleStr = "<head><title>" + title + "</title></head>";
            }
            htmlText = "<html>" + titleStr + "<body>" + htmlText + "</body></html>";
        }
        ByteArrayInputStream bais = null;
        if (encoding != null) {
            try {
                bais = new ByteArrayInputStream(htmlText.getBytes(encoding));
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
        }
        if (bais == null) {
            bais = new ByteArrayInputStream(htmlText.getBytes());
        }
        InputStreamReader isr = null;
        if (encoding != null) {
            try {
                isr = new InputStreamReader((InputStream)bais, encoding);
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }
        if (isr == null) {
            isr = new InputStreamReader(bais);
        }
        return isr;
    }

    public void cancel() {
        this.cancelled = true;
        this.setPageStatus(-1);
        this.cancelRedirectsAndImages();
    }

    void addToExternalCSS(CSSElement cssElement) {
        if (this.externalCSS == null) {
            this.externalCSS = new Vector();
        }
        this.externalCSS.addElement(cssElement);
    }

    void addToEmebeddedCSS(CSSElement cssElement) {
        if (this.embeddedCSS == null) {
            this.embeddedCSS = new Vector();
        }
        this.embeddedCSS.addElement(cssElement);
    }

    public void setPage(String pageURL) {
        this.setPage(new DocumentInfo(pageURL));
    }

    public void setPageStyle(Style pageStyle) {
        this.pageStyle = pageStyle;
        if (this.mainContainer != null && pageStyle != null) {
            this.applyPageStyle();
        }
    }

    public void setPageUIID(String pageUIID) {
        this.pageUIID = pageUIID;
        if (this.mainContainer != null && pageUIID != null) {
            this.mainContainer.setUIID(pageUIID);
        }
    }

    private void applyPageStyle() {
        Style pageStyleCopy = new Style(this.pageStyle);
        this.mainContainer.setUnselectedStyle(pageStyleCopy);
        this.mainContainer.setSelectedStyle(pageStyleCopy);
    }

    private void cancelCurrent() {
        this.cancelRedirectsAndImages();
        if (this.pageStatus == 0 || this.pageStatus == 1 || this.pageStatus == 2) {
            this.cancel();
            int waitTime = 0;
            while (true) {
                if (this.pageStatus == -1 || waitTime >= 2500) break;
                System.out.println("Waiting for previous page to cancel " + System.currentTimeMillis());
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                waitTime += 50;
            }
        }
        this.cancelled = false;
        this.cancelledCaught = false;
        this.cleanup();
        this.removeAll();
        this.revalidate();
    }

    void setPage(final DocumentInfo docInfo) {
        this.cancelCurrent();
        this.docInfo = docInfo;
        this.pageURL = docInfo.getFullUrl();
        if (this.handler instanceof AsyncDocumentRequestHandler) {
            this.setPageStatus(0);
            ((AsyncDocumentRequestHandler)this.handler).resourceRequestedAsync(docInfo, this);
        } else {
            Display.getInstance().startThread(new Runnable(){

                public void run() {
                    HTMLComponent.this.setPageStatus(0);
                    InputStream is = HTMLComponent.this.handler.resourceRequested(docInfo);
                    HTMLComponent.this.streamReady(is, docInfo);
                }
            }, "setPage").start();
        }
    }

    public void streamReady(InputStream is, DocumentInfo docInfo) {
        InputStreamReader isr = null;
        try {
            if (is != null) {
                isr = new InputStreamReader(is, docInfo.getEncoding());
            }
        }
        catch (Exception uee) {
            boolean cont = true;
            if (this.htmlCallback != null) {
                cont = this.htmlCallback.parsingError(9, null, null, null, "Page encoding " + docInfo.getEncoding() + " failed: " + uee.getMessage());
            }
            if (cont) {
                try {
                    isr = new InputStreamReader(is);
                }
                catch (Exception e) {
                    this.htmlCallback.parsingError(9, null, null, null, "Page loading failed, probably due to wrong encoding. " + e.getMessage());
                    isr = this.getStream("Page loading failed, probably due to encoding mismatch.", null);
                    this.setPageStatus(-2);
                }
            }
            isr = this.getStream("Page encoding not supported", null);
            this.setPageStatus(-2);
        }
        if (this.cancelled) {
            isr = this.getStream("Page loading cancelled by user", null);
        }
        if (isr == null) {
            if (this.htmlCallback != null) {
                this.htmlCallback.parsingError(100, null, null, null, "Error connecting to stream");
            }
            this.setPageStatus(-2);
            isr = this.getStream("Error connecting to stream", null);
        } else {
            this.setPageStatus(1);
        }
        HTMLElement newDoc = null;
        try {
            newDoc = this.parser.parseHTML(isr);
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            this.setPageStatus(-2);
            isr = this.getStream("Parsing error " + iae.getMessage(), null);
            newDoc = this.parser.parseHTML(isr);
        }
        if (this.cancelled) {
            isr = this.getStream("Page loading cancelled by user", null);
            newDoc = this.parser.parseHTML(isr);
        }
        this.setPageStatus(2);
        this.documentReady(docInfo, newDoc);
    }

    public void setDOM(HTMLElement dom) {
        this.setDOM(dom, null);
    }

    public void setDOM(HTMLElement dom, String baseURL) {
        if (dom.getTagId() != 2) {
            throw new IllegalArgumentException("HTML root element must be 'html'");
        }
        this.cancelCurrent();
        this.docInfo = baseURL != null ? new DocumentInfo(baseURL) : null;
        this.documentReady(this.docInfo, dom);
    }

    private boolean pageLoading() {
        return this.pageStatus == 0 || this.pageStatus == 1 || this.pageStatus == 2;
    }

    public HTMLElement getDOM() {
        if (this.pageLoading()) {
            throw new IllegalStateException("Page is still loading");
        }
        return this.document;
    }

    public void refreshDOM() {
        this.documentReady(this.docInfo, this.document);
    }

    void documentReady(DocumentInfo docInfo, HTMLElement newDocument) {
        this.pageURL = null;
        if (docInfo != null) {
            this.pageURL = docInfo.getUrl();
        }
        this.cleanup();
        this.document = newDocument;
        if (this.supressExceptions) {
            try {
                this.rebuildPage();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        } else {
            this.rebuildPage();
        }
        if (!this.cancelled || this.cancelledCaught) {
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    int hash;
                    if (HTMLComponent.this.threadQueue.getCSSCount() == -1) {
                        HTMLComponent.this.displayPage();
                    }
                    if (HTMLComponent.this.threadQueue.getQueueSize() == 0) {
                        HTMLComponent.this.setPageStatus(4);
                    } else {
                        HTMLComponent.this.threadQueue.startRunning();
                    }
                    if (HTMLComponent.this.pageURL != null && (hash = HTMLComponent.this.pageURL.indexOf(35)) != -1 && HTMLComponent.this.pageURL.length() > hash + 1) {
                        String anchorName = HTMLComponent.this.pageURL.substring(hash + 1);
                        HTMLComponent.this.goToAnchor(anchorName);
                    }
                }
            });
        } else {
            this.cancelled = false;
            InputStreamReader isr = this.getStream("Page loading cancelled by user", null);
            HTMLElement newDoc = this.parser.parseHTML(isr);
            this.documentReady(docInfo, newDoc);
        }
    }

    void cssCompleted() {
        Display.getInstance().callSerially(new Runnable(){

            public void run() {
                HTMLComponent.this.displayPage();
            }
        });
    }

    public void setEventsEnabled(boolean enabled) {
        if (this.eventsEnabled != enabled) {
            this.eventsEnabled = enabled;
            if (!enabled) {
                this.eventsListener.deregisterAll();
                this.eventsListener = null;
            } else {
                this.eventsListener = new HTMLEventsListener(this);
            }
        }
    }

    public boolean isEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setAutoFocusOnFirstLink(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    void displayPage() {
        this.removeAll();
        this.addComponent(this.mainContainer);
        this.setScrollY(0);
        this.revalidate();
        this.repaint();
        if (this.getComponentForm() != null) {
            this.getComponentForm().revalidate();
            if (this.firstFocusable != null) {
                if (this.autoFocus) {
                    if (this.firstFocusable.getY() < this.getHeight()) {
                        this.getComponentForm().setFocused(this.firstFocusable);
                    } else {
                        this.getComponentForm().setFocused(this.mainContainer);
                    }
                }
            } else {
                this.mainContainer.setFocusable(true);
                this.getComponentForm().setFocused(this.mainContainer);
            }
            if (this.marqueeComponents.size() > 0) {
                this.getComponentForm().registerAnimated(this);
                int dir = this.getUIManager().getLookAndFeel().isRTL() ? 1 : -1;
                this.marqueeMotion = Motion.createLinearMotion(0, dir * this.getWidth(), 3000);
                this.marqueeMotion.start();
            }
        }
        this.setPageStatus(3);
        if (this.getComponentForm() != null) {
            this.getComponentForm().revalidate();
        }
    }

    public boolean animate() {
        boolean result = super.animate();
        if (this.marqueeMotion == null) {
            return result;
        }
        Enumeration e = this.marqueeComponents.elements();
        while (e.hasMoreElements()) {
            Component cmp = (Component)e.nextElement();
            cmp.setX(this.marqueeMotion.getValue());
        }
        if (this.marqueeMotion.isFinished()) {
            int dir = this.getUIManager().getLookAndFeel().isRTL() ? 1 : -1;
            this.marqueeMotion = Motion.createLinearMotion(dir * -this.getWidth(), dir * this.getWidth(), 6000);
            this.marqueeMotion.start();
        }
        return true;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPageURL() {
        return this.pageURL;
    }

    public int getPageStatus() {
        return this.pageStatus;
    }

    void setPageStatus(final int status) {
        if (!this.pageError || status == 0) {
            this.pageStatus = status;
            if (this.htmlCallback != null) {
                if (Display.getInstance().isEdt()) {
                    this.htmlCallback.pageStatusChanged(this, status, this.pageURL);
                } else {
                    Display.getInstance().callSerially(new Runnable(){

                        public void run() {
                            HTMLComponent.this.htmlCallback.pageStatusChanged(HTMLComponent.this, status, HTMLComponent.this.pageURL);
                        }
                    });
                }
            }
            this.pageError = status == -2 || status == -1;
            this.cancelledCaught = status == -1;
        }
    }

    HTMLFont getClosestHTMLFont(String family, int size, int style, int weight) {
        int FACTOR_FONT_FAMILY = 30;
        int FACTOR_FONT_SIZE = 5;
        int FACTOR_FONT_STYLE = 10;
        HTMLFont bestFit = null;
        int bestFitDistance = 10000;
        Enumeration e = fonts.elements();
        while (e.hasMoreElements()) {
            int curFontDistance = 0;
            HTMLFont hFont = (HTMLFont)e.nextElement();
            if (hFont.isSystemFont() || family != null && (hFont.getFamily() == null || !hFont.getFamily().equalsIgnoreCase(family))) continue;
            if (size > 0) {
                curFontDistance += Math.abs(size - hFont.getSizeInPixels()) * 5;
            }
            if (weight >= 0 && (weight & 1) != (hFont.getStyle() & 1)) {
                curFontDistance += 10;
            }
            if (style >= 0 && (style & 2) != (hFont.getStyle() & 2)) {
                curFontDistance += 10;
            }
            if (curFontDistance >= bestFitDistance) continue;
            bestFitDistance = curFontDistance;
            bestFit = hFont;
            if (curFontDistance != 0) continue;
            break;
        }
        if (bestFit == null) {
            return null;
        }
        return bestFit;
    }

    Font getClosestFont(String family, int size, int style, int weight) {
        HTMLFont f = this.getClosestHTMLFont(family, size, style, weight);
        if (f != null) {
            return f.getFont();
        }
        return null;
    }

    HTMLFont getHTMLFont(Font font) {
        Enumeration e = fonts.elements();
        while (e.hasMoreElements()) {
            HTMLFont hFont = (HTMLFont)e.nextElement();
            if (hFont.getFont() != font) continue;
            return hFont;
        }
        return null;
    }

    boolean isSmallCapsFontAvailable() {
        Enumeration e = fonts.elements();
        while (e.hasMoreElements()) {
            HTMLFont hFont = (HTMLFont)e.nextElement();
            if (hFont.getFamily() == null || !hFont.getFamily().equals("small-caps")) continue;
            return true;
        }
        return false;
    }

    private HTMLFont getCounterpartFont(int tag, HTMLFont font) {
        int attribute = -1;
        switch (tag) {
            case 55: {
                attribute = 0;
                break;
            }
            case 56: {
                attribute = 1;
                break;
            }
            case 57: {
                attribute = 2;
                break;
            }
            case 58: {
                attribute = 3;
            }
        }
        if (attribute == -1) {
            return font;
        }
        return this.getCounterpartFontByAttribute(attribute, font);
    }

    HTMLFont getCounterpartFontByAttribute(int attribute, HTMLFont font) {
        HTMLFont cFont = font.getCounterpartFont(attribute);
        if (cFont != null) {
            return cFont;
        }
        HTMLFont bestFit = null;
        Enumeration e = fonts.elements();
        while (e.hasMoreElements()) {
            HTMLFont hFont = (HTMLFont)e.nextElement();
            if (!hFont.isCounterpart(attribute, font)) continue;
            if (attribute == 2) {
                if (bestFit != null && bestFit.getSize() <= hFont.getSize()) continue;
                bestFit = hFont;
                continue;
            }
            if (attribute == 3) {
                if (bestFit != null && bestFit.getSize() >= hFont.getSize()) continue;
                bestFit = hFont;
                continue;
            }
            font.setCounterpartFont(attribute, hFont);
            return hFont;
        }
        if (bestFit == null) {
            bestFit = font;
        }
        font.setCounterpartFont(attribute, bestFit);
        return bestFit;
    }

    private void cleanElementUI(HTMLElement element) {
        element.clearAssociatedComponents();
        int children = element.getNumChildren();
        for (int i = 0; i < children; ++i) {
            HTMLElement child = (HTMLElement)element.getChildAt(i);
            this.cleanElementUI(child);
        }
    }

    private void cleanup() {
        if (this.document != null) {
            this.cleanElementUI(this.document);
        }
        if (this.eventsListener != null) {
            this.eventsListener.deregisterAll();
        }
        this.displayWidth = Display.getInstance().getDisplayWidth();
        this.leftIndent = 0;
        this.x = 0;
        this.containers = new Vector();
        this.marqueeComponents = new Vector();
        this.marqueeMotion = null;
        this.anchors = new Hashtable();
        this.anchor = null;
        this.accesskey = '\u0000';
        Enumeration e = this.accessKeys.keys();
        while (e.hasMoreElements()) {
            int keyCode = (Integer)e.nextElement();
            this.getComponentForm().removeKeyListener(keyCode, this);
        }
        this.accessKeys.clear();
        this.fieldsets = new Vector();
        this.curTable = null;
        this.tables = new Vector();
        this.tableCells = new Vector();
        this.ulLevel = 0;
        this.olIndex = Integer.MIN_VALUE;
        this.olUpperLevelIndex = new Vector();
        this.listType = 0;
        this.underlineCount = 0;
        this.strikethruCount = 0;
        this.textDecoration = 0;
        this.imageMapComponents = null;
        this.imageMapData = null;
        this.curImageMap = null;
        this.superscript = 0;
        this.maxSuperscript = 0;
        this.counters = null;
        this.font = this.defaultFont;
        this.labelForID = null;
        this.inputFields = new Hashtable();
        this.link = null;
        this.linkVisited = false;
        this.mainLink = null;
        this.firstFocusable = null;
        this.curForm = null;
        this.curTextArea = null;
        this.curComboBox = null;
        this.textfieldsToForms = new Hashtable();
        this.optionTag = false;
        this.optionSelected = false;
        this.preTagCount = 0;
        this.quoteTagCount = 0;
        this.mainContainer = new Container();
        if (this.pageUIID != null) {
            this.mainContainer.setUIID(this.pageUIID);
        }
        if (this.pageStyle != null) {
            this.applyPageStyle();
        }
        this.mainContainer.setScrollableX(false);
        this.mainContainer.setLayout(new BoxLayout(2));
        this.curContainer = this.mainContainer;
        this.curLine = new Container();
        this.lastWasEmpty = false;
        this.width = Display.getInstance().getDisplayWidth() - this.getStyle().getMargin(1) - this.getStyle().getPadding(1) - this.getStyle().getMargin(3) - this.getStyle().getPadding(3) - 10;
        this.textColor = 0;
    }

    private void handleLinkTag(HTMLElement linkTag) {
        String linkType = linkTag.getAttributeById(19);
        String media = linkTag.getAttributeById(51);
        String href = linkTag.getAttributeById(14);
        String charset = linkTag.getAttributeById(13);
        if (linkType != null && linkType.equalsIgnoreCase("text/css") && href != null && CSSParser.getInstance().mediaTypeMatches(media)) {
            if (this.docInfo != null) {
                this.threadQueue.addCSS(this.docInfo.convertURL(href), charset);
            } else if (DocumentInfo.isAbsoluteURL(href)) {
                this.threadQueue.addCSS(href, charset);
            } else if (this.htmlCallback != null) {
                this.htmlCallback.parsingError(103, linkTag.getTagName(), linkTag.getAttributeName(new Integer(14)), href, "Ignoring CSS file referred in a LINK tag (" + href + "), since page was set by setBody/setHTML/setDOM so there's no way to access relative URLs");
            }
        }
    }

    private void rebuildPage() {
        HTMLElement html = null;
        if (this.document.getTagId() == 2) {
            html = this.document;
        }
        HTMLElement body = null;
        HTMLElement head = null;
        String dir = null;
        if (html != null) {
            Vector noFrames;
            dir = html.getAttributeById(59);
            body = html.getFirstChildByTagId(0);
            if (body == null && (noFrames = html.getDescendantsByTagId(77)) != null && noFrames.size() > 0) {
                body = (HTMLElement)noFrames.elementAt(0);
            }
            head = html.getFirstChildByTagId(1);
        }
        this.title = null;
        if (head != null) {
            HTMLElement basefontTag;
            HTMLElement titleText;
            HTMLElement titleTag;
            String baseURL;
            HTMLElement baseTag = head.getFirstChildByTagId(51);
            if (baseTag != null && (baseURL = baseTag.getAttributeById(14)) != null && this.docInfo != null) {
                this.docInfo.setBaseURL(baseURL);
            }
            if ((titleTag = head.getFirstChildByTagId(3)) != null && titleTag.getNumChildren() > 0 && (titleText = (HTMLElement)titleTag.getChildAt(0)) != null) {
                this.title = titleText.getText();
            }
            if ((basefontTag = head.getFirstChildByTagId(65)) != null) {
                HTMLFont f;
                this.textColor = HTMLElement.getColor(basefontTag.getAttributeById(61), this.textColor);
                String family = basefontTag.getAttributeById(62);
                int size = HTMLComponent.getInt(basefontTag.getAttributeById(31));
                if ((family != null || size != 0) && (f = this.getClosestHTMLFont(family, size, 0, 0)) != null) {
                    this.font = f;
                }
            }
            if (this.loadCSS) {
                for (int i = 0; i < head.getNumChildren(); ++i) {
                    HTMLElement child = (HTMLElement)head.getChildAt(i);
                    if (child.getTagId() != 50) continue;
                    this.handleLinkTag(child);
                }
            }
        }
        if (this.htmlCallback != null) {
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    HTMLComponent.this.htmlCallback.titleUpdated(HTMLComponent.this, HTMLComponent.this.title);
                }
            });
        }
        if (body != null) {
            this.bgColor = HTMLElement.getColor(body.getAttributeById(7), -1);
            this.textColor = HTMLElement.getColor(body.getAttributeById(9), this.textColor);
            this.linkColor = HTMLElement.getColor(body.getAttributeById(8), 255);
            if (this.bgColor != -1) {
                this.mainContainer.getUnselectedStyle().setBgColor(this.bgColor);
                this.mainContainer.getUnselectedStyle().setBgTransparency(255);
                this.mainContainer.getSelectedStyle().setBgColor(this.bgColor);
                this.mainContainer.getSelectedStyle().setBgTransparency(255);
            } else if (this.pageStyle == null && this.pageUIID == null) {
                this.mainContainer.getUnselectedStyle().setBgColor(0xFFFFFF);
                this.mainContainer.getUnselectedStyle().setBgTransparency(255);
                this.mainContainer.getSelectedStyle().setBgColor(0xFFFFFF);
                this.mainContainer.getSelectedStyle().setBgTransparency(255);
            }
            this.processTag(body, 1);
            this.newLineIfNotEmpty(1);
            this.mainContainer.applyRTL(dir != null && dir.equalsIgnoreCase("rtl"));
            if (this.loadCSS) {
                body.setAssociatedComponents(this.mainContainer);
                if (this.threadQueue.getCSSCount() == -1) {
                    this.applyAllCSS();
                }
            }
        } else {
            System.out.println("no BODY tag was found in page.");
        }
        if (!this.cancelled) {
            this.checkRedirect(head);
        }
    }

    void applyAllCSS() {
        HTMLElement html = null;
        if (this.document.getTagId() == 2) {
            html = this.document;
        }
        HTMLElement body = null;
        if (html != null) {
            body = html.getFirstChildByTagId(0);
        }
        if (body != null) {
            CSSEngine.getInstance().applyCSS(body, this, this.externalCSS, this.embeddedCSS);
        }
    }

    private void checkRedirect(HTMLElement head) {
        String content;
        String httpequiv;
        HTMLElement meta;
        if (head != null && (meta = head.getFirstChildByTagId(49)) != null && (httpequiv = meta.getAttributeById(55)) != null && httpequiv.equalsIgnoreCase("refresh") && (content = meta.getAttributeById(54)) != null) {
            int seperator = content.indexOf(59);
            String redirectURL = null;
            if (seperator != -1) {
                String tempUrl = content.substring(seperator + 1);
                redirectURL = "";
                for (int i = 0; i < tempUrl.length(); ++i) {
                    char ch = tempUrl.charAt(i);
                    if (CSSParser.isWhiteSpace(ch)) continue;
                    redirectURL = redirectURL + ch;
                }
                if (redirectURL.startsWith("url=")) {
                    redirectURL = redirectURL.substring(4);
                }
                content = content.substring(0, seperator);
            }
            int redirectTime = -1;
            try {
                redirectTime = Integer.parseInt(content);
                this.redirectThread = new RedirectThread(this, redirectTime, redirectURL);
                Display.getInstance().startThread(this.redirectThread, "HTML checkRedirect").start();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    void cancelRedirectsAndImages() {
        if (this.redirectThread != null) {
            this.redirectThread.cancel();
            this.redirectThread = null;
        }
        this.threadQueue.discardQueue();
        this.embeddedCSS = null;
        this.externalCSS = null;
        if (this.getComponentForm() != null) {
            this.marqueeMotion = null;
            this.getComponentForm().deregisterAnimated(this);
        }
    }

    private void newLine(int align) {
        if (this.curLine.getComponentCount() == 0) {
            this.curLine.setPreferredH(this.font.getHeight());
        } else if (this.maxSuperscript != 0) {
            for (int i = 0; i < this.curLine.getComponentCount(); ++i) {
                Component cmp = this.curLine.getComponentAt(i);
                Style style = cmp.getStyle();
                style.setMargin(0, style.getMargin(0) + this.maxSuperscript - style.getMargin(2));
                style.setMargin(2, 0);
                if (!(cmp instanceof HTMLLink)) continue;
                style = cmp.getSelectedStyle();
                style.setMargin(0, style.getMargin(0) + this.maxSuperscript - style.getMargin(2));
                style.setMargin(2, 0);
                style = ((HTMLLink)cmp).getPressedStyle();
                style.setMargin(0, style.getMargin(0) + this.maxSuperscript - style.getMargin(2));
                style.setMargin(2, 0);
            }
            this.maxSuperscript = 0;
        }
        this.lastWasEmpty = this.curLine.getComponentCount() == 0;
        this.curContainer.addComponent(this.curLine);
        this.curLine = new Container();
        this.curLine.getStyle().setBgTransparency(0);
        FlowLayout fl = new FlowLayout(align);
        fl.setValign(2);
        fl.setValignByRow(true);
        this.curLine.setLayout(fl);
        this.curLine.setScrollableX(false);
        this.curLine.getStyle().setMargin(1, this.leftIndent);
        this.x = this.leftIndent;
    }

    private void newLineIfNotEmpty(int align) {
        if (this.curLine.getComponentCount() > 0) {
            this.newLine(align);
        }
    }

    private void newLineIfLastWasNotEmpty(int align) {
        if (!this.lastWasEmpty) {
            this.newLine(align);
        }
    }

    Vector showPreTagText(String text, int align) {
        Vector<Label> comps = new Vector<Label>();
        if (text == null || text.equals("")) {
            return comps;
        }
        String line = "";
        for (int c = 0; c < text.length(); ++c) {
            char ch = text.charAt(c);
            if (ch == '\n' || ch == '\r') {
                if (line.equals("")) continue;
                comps.addElement(this.addString(line, align));
                this.newLine(align);
                line = "";
                continue;
            }
            line = line + ch;
        }
        if (!line.equals("")) {
            comps.addElement(this.addString(line, align));
            this.newLine(align);
        }
        return comps;
    }

    Vector getWords(String text, int align, boolean returnComps) {
        Vector<Object> words = new Vector<Object>();
        String word = "";
        String leadSpace = "";
        for (int c = 0; c < text.length(); ++c) {
            char ch = text.charAt(c);
            if (ch >= '\u3400' && ch <= '\u9fff' || ch >= '\uf900' && ch <= '\ufaff') {
                word = word + ch;
                if (returnComps) {
                    words.addElement(this.addString(word, align));
                } else {
                    words.addElement(word);
                }
                word = "";
                continue;
            }
            if (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\n') {
                if (word.length() != 0) {
                    if (returnComps) {
                        words.addElement(this.addString(leadSpace + word + ' ', align));
                        leadSpace = "";
                    } else {
                        words.addElement(word);
                    }
                    word = "";
                    continue;
                }
                if (!words.isEmpty() || text.length() <= 1) continue;
                leadSpace = " ";
                continue;
            }
            if (!returnComps && this.font.stringWidth(word + ch) > this.width - this.leftIndent) {
                words.addElement(word);
                word = "" + ch;
                continue;
            }
            word = word + ch;
        }
        if (word.length() != 0 || leadSpace.length() != 0) {
            if (returnComps) {
                words.addElement(this.addString(leadSpace + word, align));
            } else if (word.length() != 0) {
                words.addElement(word);
            }
        }
        return words;
    }

    private Vector showText(String text, int align) {
        return this.getWords(text, align, true);
    }

    private Vector showTextFixedWidth(String text, int align) {
        Vector<Label> comps = new Vector<Label>();
        if (text == null || text.equals("")) {
            return comps;
        }
        int spaceW = this.width - this.x;
        Vector words = this.getWords(text, align, false);
        if (words.size() > 0) {
            int w = 0;
            String wordStr = "";
            if (CSSParser.isWhiteSpace(text.charAt(0)) && this.curLine.getComponentCount() != 0) {
                wordStr = " ";
            }
            while (w < words.size()) {
                String nextWord = (String)words.elementAt(w);
                String space = "";
                if (!wordStr.equals("") && !wordStr.equals(" ")) {
                    space = " ";
                }
                if (this.font.stringWidth(wordStr + space + nextWord) > spaceW - 2) {
                    comps.addElement(this.addString(wordStr, align));
                    this.newLineIfNotEmpty(align);
                    spaceW = this.width - this.x;
                    wordStr = nextWord;
                } else {
                    wordStr = wordStr + space + nextWord;
                }
                ++w;
            }
            if (CSSParser.isWhiteSpace(text.charAt(text.length() - 1))) {
                wordStr = wordStr + " ";
            }
            comps.addElement(this.addString(wordStr, align));
        }
        return comps;
    }

    private Label addString(String str, int align) {
        Label lbl = null;
        int color = this.textColor;
        if (this.curLine.getComponentCount() == 0 && str.startsWith(" ") && (str = str.substring(1)).length() == 0) {
            return null;
        }
        if (this.link != null) {
            lbl = new HTMLLink(str, this.link, this, this.mainLink, this.linkVisited);
            color = this.linkColor;
            if (this.linkVisited) {
                color = 0x990099;
            }
            lbl.getSelectedStyle().setFont(this.font.getFont());
            ((HTMLLink)lbl).getPressedStyle().setFont(this.font.getFont());
            if (this.mainLink == null) {
                this.mainLink = (HTMLLink)lbl;
            }
            if (this.accesskey != '\u0000') {
                this.addAccessKey(this.accesskey, lbl, false);
                this.accesskey = '\u0000';
            }
            lbl.getSelectedStyle().setMargin(0, 0, 0, 0);
            lbl.getSelectedStyle().setPadding(0, 0, 0, 0);
            ((HTMLLink)lbl).getPressedStyle().setMargin(0, 0, 0, 0);
            ((HTMLLink)lbl).getPressedStyle().setPadding(0, 0, 0, 0);
            lbl.getSelectedStyle().setTextDecoration(this.textDecoration);
            ((HTMLLink)lbl).getPressedStyle().setTextDecoration(this.textDecoration);
        } else if (this.labelForID != null) {
            lbl = new ForLabel(str, this, this.labelForID);
            if (this.accesskey != '\u0000') {
                this.addAccessKey(this.accesskey, lbl, false);
                this.accesskey = '\u0000';
            }
            this.labelForID = null;
        } else {
            lbl = new Label(str);
        }
        lbl.getStyle().setMargin(0, 0, 0, 0);
        lbl.getStyle().setPadding(0, 0, 0, 0);
        if (this.superscript > 0) {
            int margin = this.font.getHeight() * this.superscript / 2;
            lbl.getStyle().setMargin(2, margin);
            if (this.link != null) {
                lbl.getSelectedStyle().setMargin(2, margin);
                ((HTMLLink)lbl).getPressedStyle().setMargin(2, margin);
            }
            if (margin > this.maxSuperscript) {
                this.maxSuperscript = margin;
            }
        } else if (this.superscript < 0) {
            int margin = -this.font.getHeight() * this.superscript / 2;
            lbl.getStyle().setMargin(0, margin);
            if (this.link != null) {
                lbl.getSelectedStyle().setMargin(0, margin);
                ((HTMLLink)lbl).getPressedStyle().setMargin(0, margin);
            }
        }
        lbl.getUnselectedStyle().setFgColor(color);
        lbl.getSelectedStyle().setFgColor(color);
        lbl.getUnselectedStyle().setFont(this.font.getFont());
        lbl.getUnselectedStyle().setBgTransparency(0);
        lbl.setGap(0);
        lbl.setTickerEnabled(false);
        lbl.setEndsWith3Points(false);
        lbl.getUnselectedStyle().setTextDecoration(this.textDecoration);
        if (align != 5) {
            lbl.setAlignment(align);
        }
        this.curLine.addComponent(lbl);
        if (this.anchor != null) {
            this.anchors.put(this.anchor, lbl);
        }
        return lbl;
    }

    void addAccessKey(int accessKey, Component cmp, boolean override) {
        if (override && this.accessKeys.contains(cmp)) {
            Hashtable newAccessKeys = new Hashtable();
            Enumeration e = this.accessKeys.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Component c = (Component)this.accessKeys.get(key);
                if (c == cmp) continue;
                newAccessKeys.put(key, c);
            }
            this.accessKeys = newAccessKeys;
        }
        this.accessKeys.put(new Integer(accessKey), cmp);
        Form form = this.getComponentForm();
        if (form != null) {
            form.addKeyListener(accessKey, this);
        }
    }

    protected void initComponent() {
        super.initComponent();
        Enumeration e = this.accessKeys.keys();
        while (e.hasMoreElements()) {
            int keyCode = (Integer)e.nextElement();
            this.getComponentForm().addKeyListener(keyCode, this);
        }
    }

    protected void deinitialize() {
        super.deinitialize();
        Enumeration e = this.accessKeys.keys();
        while (e.hasMoreElements()) {
            int keyCode = (Integer)e.nextElement();
            this.getComponentForm().removeKeyListener(keyCode, this);
        }
    }

    private void handleImage(HTMLElement imgElement, int align, Command cmd) {
        String imageUrl = imgElement.getAttributeById(30);
        Label imgLabel = null;
        if (imageUrl != null) {
            String alignStr = imgElement.getAttributeById(6);
            int iWidth = HTMLComponent.calcSize(this.getWidth(), imgElement.getAttributeById(23), 0, false);
            int iHeight = HTMLComponent.calcSize(this.getHeight(), imgElement.getAttributeById(24), 0, false);
            int hspace = HTMLComponent.getInt(imgElement.getAttributeById(26));
            int vspace = HTMLComponent.getInt(imgElement.getAttributeById(27));
            int totalWidth = iWidth + hspace * 2;
            String altText = imgElement.getAttributeById(25);
            String imageMap = imgElement.getAttributeById(65);
            if (this.link != null) {
                imgLabel = new HTMLLink(altText, this.link, this, this.mainLink, false);
                if (this.mainLink == null) {
                    this.mainLink = (HTMLLink)imgLabel;
                }
                if (this.accesskey != '\u0000') {
                    this.addAccessKey(this.accesskey, imgLabel, false);
                }
                ((HTMLLink)imgLabel).isMap = imgElement.getAttributeById(73) != null;
            } else if (cmd != null) {
                imgLabel = new Button(cmd);
                if (altText != null && !altText.equals("")) {
                    imgLabel.setText(altText);
                }
                if (this.firstFocusable == null) {
                    this.firstFocusable = imgLabel;
                }
            } else if (imageMap != null) {
                imgLabel = new HTMLImageMap(this);
                if (this.imageMapComponents == null) {
                    this.imageMapComponents = new Hashtable();
                }
                if (imageMap.startsWith("#")) {
                    imageMap = imageMap.substring(1);
                }
                this.imageMapComponents.put(imageMap, imgLabel);
                if (this.imageMapData != null && this.imageMapData.containsKey(imageMap)) {
                    ImageMapData data;
                    ((HTMLImageMap)imgLabel).mapData = data = (ImageMapData)this.imageMapData.get(imageMap);
                }
            } else {
                imgLabel = new Label(altText);
            }
            if (iWidth != 0 || iHeight != 0) {
                imgLabel.setPreferredSize(new Dimension(iWidth += imgLabel.getStyle().getPadding(1) + imgLabel.getStyle().getPadding(3), iHeight += imgLabel.getStyle().getPadding(0) + imgLabel.getStyle().getPadding(2)));
            } else if (imgLabel.getText() == null || imgLabel.getText().equals("")) {
                imgLabel.setText(" ");
            }
            imgLabel.getSelectedStyle().setPadding(0, 0, 0, 0);
            imgLabel.getUnselectedStyle().setPadding(0, 0, 0, 0);
            imgLabel.getSelectedStyle().setFont(this.font.getFont());
            imgLabel.getUnselectedStyle().setFont(this.font.getFont());
            int borderSize = HTMLComponent.getInt(imgElement.getAttributeById(60));
            if (borderSize != 0) {
                imgLabel.putClientProperty(CLIENT_PROPERTY_IMG_BORDER, new Integer(borderSize));
            } else {
                borderSize = 1;
            }
            imgLabel.getUnselectedStyle().setBorder(Border.createLineBorder(borderSize));
            imgLabel.getSelectedStyle().setBorder(Border.createLineBorder(borderSize));
            imgLabel.getUnselectedStyle().setBgTransparency(0);
            imgLabel.getSelectedStyle().setBgTransparency(0);
            Container imgCont = new Container(new BorderLayout());
            imgCont.addComponent("Center", (Component)imgLabel);
            imgCont.getSelectedStyle().setMargin(vspace, vspace, hspace, hspace);
            imgCont.getUnselectedStyle().setMargin(vspace, vspace, hspace, hspace);
            this.curLine.addComponent(imgCont);
            this.x += totalWidth;
            imgLabel.setAlignment(this.getHorizAlign(alignStr, align, false));
            imgLabel.setVerticalAlignment(this.getVertAlign(alignStr, 4));
            if (this.showImages) {
                if (this.docInfo != null) {
                    imageUrl = this.docInfo.convertURL(imageUrl);
                    this.threadQueue.add(imgLabel, imageUrl);
                } else if (DocumentInfo.isAbsoluteURL(imageUrl)) {
                    this.threadQueue.add(imgLabel, imageUrl);
                } else if (this.htmlCallback != null) {
                    this.htmlCallback.parsingError(103, imgElement.getTagName(), imgElement.getAttributeName(new Integer(30)), imageUrl, "Ignoring Image file referred in an IMG tag (" + imageUrl + "), since page was set by setBody/setHTML/setDOM so there's no way to access relative URLs");
                }
            }
            if (this.loadCSS) {
                imgElement.setAssociatedComponents(imgCont);
            }
        }
    }

    private void handleImageMapArea(HTMLElement areaTag) {
        if (this.curImageMap != null) {
            String shape = areaTag.getAttributeById(63);
            boolean supportedShape = false;
            if (shape != null) {
                String hrefStr = areaTag.getAttributeById(14);
                if (shape.equalsIgnoreCase("default")) {
                    supportedShape = true;
                    this.curImageMap.setDefaultLink(hrefStr);
                } else if (shape.equalsIgnoreCase("rect") || shape.equalsIgnoreCase("circle")) {
                    supportedShape = true;
                    String coordsStr = areaTag.getAttributeById(64);
                    if (coordsStr != null && hrefStr != null) {
                        String curValStr = "";
                        int[] coords = new int[4];
                        int curCoord = 0;
                        boolean error = true;
                        try {
                            for (int c = 0; c < coordsStr.length(); ++c) {
                                char ch = coordsStr.charAt(c);
                                if (ch != ',') {
                                    curValStr = curValStr + ch;
                                    continue;
                                }
                                coords[curCoord] = Integer.parseInt(curValStr);
                                ++curCoord;
                                curValStr = "";
                            }
                            if (curValStr.length() > 0) {
                                coords[curCoord] = Integer.parseInt(curValStr);
                                ++curCoord;
                            }
                            if (shape.equalsIgnoreCase("rect")) {
                                if (curCoord == 4) {
                                    this.curImageMap.addRectArea(new Rectangle(coords[0], coords[1], coords[2] - coords[0], coords[3] - coords[1]), hrefStr);
                                    error = false;
                                }
                            } else if (curCoord == 3) {
                                this.curImageMap.addRectArea(new Rectangle(coords[0] - coords[2], coords[1] - coords[2], coords[2] * 2 + 1, coords[2] * 2 + 1), hrefStr);
                                error = false;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (error) {
                            this.notifyImageMapError("AREA tag 'coords' property value is invalid (should be exactly 3 comma seperated numbers for circle, 4 for rectangle): " + coordsStr, 2, 64, coordsStr);
                        }
                    }
                }
            }
            if (!supportedShape) {
                this.notifyImageMapError("Unsupported or missing AREA tag 'shape' property: " + shape, 2, 63, shape);
            }
        } else {
            this.notifyImageMapError("AREA tag is defined without a parent MAP tag - ignoring", 104, -1, null);
        }
    }

    private void notifyImageMapError(String msg, int errorCode, int attrId, String value) {
        if (this.htmlCallback != null) {
            String attr = null;
            if (attrId != -1) {
                attr = HTMLElement.ATTRIBUTE_NAMES[attrId];
            }
            this.htmlCallback.parsingError(errorCode, HTMLElement.TAG_NAMES[72], attr, value, msg);
        }
    }

    private void handleInput(HTMLElement element, int align) {
        String type = element.getAttributeById(19);
        if (type == null) {
            return;
        }
        int typeID = INPUT_TYPES.indexOf(type.toLowerCase());
        if (typeID == -1) {
            if (this.htmlCallback != null && !this.htmlCallback.parsingError(2, element.getTagName(), element.getAttributeName(new Integer(19)), type, "Unsupported input type '" + type + "'. Supported types: text, password, checkbox, radio, submit, reset, hidden, image")) {
                this.cancel();
            }
            return;
        }
        String name = element.getAttributeById(37);
        String id = element.getAttributeById(1);
        String value = element.getAttributeById(38);
        if (value == null) {
            value = "";
        }
        Component cmp = null;
        switch (typeID) {
            case 0: {
                CheckBox cb = new CheckBox();
                if (element.getAttributeById(32) != null) {
                    cb.setSelected(true);
                }
                cmp = cb;
                if (this.curForm == null) break;
                this.curForm.addCheckBox(name, cb, value);
                break;
            }
            case 1: {
                if (this.curForm == null) break;
                this.curForm.addInput(name, value, null);
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                String emptyOk;
                HTMLInputFormat inputFormat;
                TextField tf = new TextField(value);
                tf.setLeftAndRightEditingTrigger(false);
                if (typeID == 2) {
                    tf.setConstraint(65536);
                }
                if (typeID == 9) {
                    tf.setConstraint(1);
                }
                if ((inputFormat = HTMLInputFormat.getInputFormat(element.getAttributeById(34))) != null) {
                    tf = (TextField)inputFormat.applyConstraints(tf);
                    if (this.curForm != null) {
                        this.curForm.setInputFormat(tf, inputFormat);
                    }
                }
                if ((emptyOk = element.getAttributeById(33)) != null && this.curForm != null) {
                    if (emptyOk.equalsIgnoreCase("true")) {
                        this.curForm.setEmptyOK(tf, true);
                    } else if (emptyOk.equalsIgnoreCase("false")) {
                        this.curForm.setEmptyOK(tf, false);
                    }
                }
                int size = HTMLComponent.getInt(element.getAttributeById(31));
                int maxlen = HTMLComponent.getInt(element.getAttributeById(36));
                if (size == 0) {
                    size = 12;
                }
                if (maxlen != 0) {
                    tf.setMaxSize(maxlen);
                    if (size > maxlen) {
                        size = maxlen;
                    }
                }
                tf.setPreferredW(tf.getStyle().getFont().stringWidth("W") * size);
                tf.getSelectedStyle().setFont(this.font.getFont());
                tf.getUnselectedStyle().setFont(this.font.getFont());
                if (element.getAttributeById(72) != null) {
                    tf.setEditable(false);
                }
                cmp = tf;
                if (this.curForm == null) break;
                this.curForm.addInput(name, cmp, value);
                this.textfieldsToForms.put(tf, this.curForm);
                break;
            }
            case 3: {
                RadioButton rb = new RadioButton(" ");
                if (element.getAttributeById(32) != null) {
                    rb.setSelected(true);
                }
                cmp = rb;
                if (this.curForm == null) break;
                this.curForm.addRadioButton(name, rb, value);
                break;
            }
            case 4: {
                Command resetCmd = null;
                if (this.curForm != null) {
                    resetCmd = this.curForm.createResetCommand(value);
                }
                if (resetCmd == null) {
                    resetCmd = new Command(this.getUIManager().localize("html.reset", "Clear"));
                }
                Button resetButton = new Button(resetCmd);
                cmp = resetButton;
                break;
            }
            case 5: 
            case 8: {
                Command submitCmd = null;
                if (this.curForm != null) {
                    submitCmd = this.curForm.createSubmitCommand(name, value);
                }
                if (submitCmd == null) {
                    submitCmd = new Command(value.equals("") ? (value = this.getUIManager().localize("html.submit", "Submit")) : value);
                }
                Button submitButton = new Button(submitCmd);
                cmp = submitButton;
                break;
            }
            case 7: {
                Command submitCmd = null;
                if (this.curForm != null) {
                    submitCmd = this.curForm.createSubmitCommand(name, value);
                }
                this.handleImage(element, align, submitCmd);
            }
        }
        if (cmp != null) {
            String aKey;
            if (element.getAttributeById(71) != null) {
                cmp.setEnabled(false);
            }
            if ((aKey = element.getAttributeById(12)) != null && aKey.length() == 1) {
                this.addAccessKey(aKey.charAt(0), cmp, false);
            }
            if (this.eventsListener != null) {
                this.eventsListener.registerComponent(cmp, element);
            }
            element.setAssociatedComponents(cmp);
            if (this.curForm != null && this.curForm.action == null) {
                cmp.setEnabled(false);
            } else if (this.firstFocusable == null) {
                this.firstFocusable = cmp;
            }
            if (id != null) {
                this.inputFields.put(id, cmp);
            }
        }
        this.addCmp(cmp, align);
    }

    TextArea setInputFormat(final TextArea inputField, String inputFormat) {
        HTMLInputFormat format;
        TextArea returnInputField = inputField;
        HTMLForm form = (HTMLForm)this.textfieldsToForms.get(inputField);
        if (form != null && (format = HTMLInputFormat.getInputFormat(inputFormat)) != null) {
            TextArea newInputField;
            form.setInputFormat(inputField, format);
            returnInputField = newInputField = format.applyConstraints(inputField);
            if (Display.getInstance().getCurrent() != inputField.getComponentForm()) {
                inputField.getParent().replace((Component)inputField, (Component)newInputField, null);
            } else {
                Display.getInstance().callSerially(new Runnable(){

                    public void run() {
                        inputField.getParent().replace((Component)inputField, (Component)newInputField, null);
                    }
                });
            }
            if (this.firstFocusable == inputField) {
                this.firstFocusable = newInputField;
            }
        }
        return returnInputField;
    }

    void setInputRequired(TextArea inputField, boolean inputRequired) {
        HTMLForm form = (HTMLForm)this.textfieldsToForms.get(inputField);
        if (form != null) {
            if (inputRequired) {
                form.setEmptyOK(inputField, false);
            } else {
                form.setEmptyOK(inputField, true);
            }
        }
    }

    private void addCmp(Component cmp, int align) {
        if (cmp != null) {
            this.curLine.addComponent(cmp);
            this.x += cmp.getPreferredW();
        }
    }

    private void updateMargin(int delta) {
        this.leftIndent += delta;
        this.x += delta;
        this.curLine.getStyle().setMargin(1, this.leftIndent);
    }

    private void handleTableCell(HTMLElement tdTag, int align) {
        String cHeight;
        int pH;
        HTMLElement trTag;
        this.newLineIfNotEmpty(align);
        this.tableCells.addElement(this.curContainer);
        Container cell = new Container();
        cell.getStyle().setBgTransparency(0);
        cell.setLayout(new BoxLayout(2));
        for (trTag = (HTMLElement)tdTag.getParent(); trTag != null && trTag.getTagId() != 45; trTag = (HTMLElement)trTag.getParent()) {
        }
        CellConstraint constraint = new CellConstraint();
        int halign = align;
        int valign = 4;
        if (trTag != null) {
            HTMLElement tGroupTag = (HTMLElement)trTag.getParent();
            int tagId = tGroupTag.getTagId();
            if (tagId == 79 || tagId == 78 || tagId == 80) {
                halign = this.getHorizAlign(tGroupTag.getAttributeById(6), halign, false);
                valign = this.getVertAlign(tGroupTag.getAttributeById(49), valign);
            }
            halign = this.getHorizAlign(trTag.getAttributeById(6), halign, false);
            valign = this.getVertAlign(trTag.getAttributeById(49), valign);
        }
        halign = this.getHorizAlign(tdTag.getAttributeById(6), halign, false);
        valign = this.getVertAlign(tdTag.getAttributeById(49), valign);
        int colspan = HTMLComponent.getInt(tdTag.getAttributeById(45));
        int rowspan = HTMLComponent.getInt(tdTag.getAttributeById(47));
        String cWidth = tdTag.getAttributeById(23);
        int pW = this.getPercentage(cWidth);
        if ((pW <= 0 || pW >= 100) && (pW = HTMLComponent.getInt(cWidth)) != 0) {
            cell.setPreferredW(pW);
        }
        if (((pH = this.getPercentage(cHeight = tdTag.getAttributeById(24))) <= 0 || pH >= 100) && (pH = HTMLComponent.getInt(cHeight)) != 0) {
            cell.setPreferredH(pH);
        }
        constraint.setHorizontalAlign(halign);
        constraint.setVerticalAlign(valign);
        if (colspan > 1) {
            constraint.setHorizontalSpan(colspan);
        }
        if (rowspan > 1) {
            constraint.setVerticalSpan(rowspan);
        }
        this.curContainer = cell;
        if (this.curTable != null) {
            this.curTable.addCell(cell, tdTag.getTagId() == 44, constraint);
        }
        if (this.loadCSS) {
            tdTag.setAssociatedComponents(cell);
            if (trTag != null) {
                trTag.addAssociatedComponent(cell);
            }
        }
    }

    private void processTag(HTMLElement element, int align) {
        if (this.cancelled && !this.cancelledCaught) {
            return;
        }
        int curAlign = align;
        HTMLFont oldFont = this.font;
        int oldFontColor = this.textColor;
        block76: for (int i = 0; i < element.getNumChildren() && (!this.cancelled || this.cancelledCaught); ++i) {
            HTMLElement child = (HTMLElement)element.getChildAt(i);
            switch (child.getTagId()) {
                case 82: {
                    String text = child.getText();
                    if (this.curComboBox != null && this.optionTag) {
                        OptionItem oi = new OptionItem(text, this.optionValue);
                        this.curComboBox.addItem(oi);
                        if (!this.optionSelected) break;
                        this.curComboBox.setSelectedItem(oi);
                        if (this.curForm == null) break;
                        this.curForm.setDefaultValue(this.curComboBox, oi);
                        break;
                    }
                    if (this.curTextArea != null) {
                        this.curTextArea.setText(text);
                        if (this.curForm == null) break;
                        this.curForm.setDefaultValue(this.curTextArea, text);
                        break;
                    }
                    if (element.getTagId() == 73) {
                        if (this.fieldsets.size() <= 0) break;
                        Container fset = (Container)this.fieldsets.lastElement();
                        fset.getStyle().setBorder(Border.createLineBorder(1, text));
                        fset.getStyle().setPadding(0, fset.getStyle().getFont().getHeight() + 1);
                        break;
                    }
                    if (this.curTable != null && element.getTagId() == 41) {
                        this.curTable.captionTextTag = child;
                        break;
                    }
                    Vector comps = null;
                    comps = this.preTagCount != 0 ? this.showPreTagText(text, curAlign) : this.showText(text, curAlign);
                    if (!this.loadCSS) break;
                    child.setAssociatedComponents(comps);
                    break;
                }
                case 28: {
                    String aKey;
                    this.link = child.getAttributeById(14);
                    if (this.link != null && this.docInfo == null && !DocumentInfo.isAbsoluteURL(this.link)) {
                        if (this.htmlCallback != null) {
                            this.htmlCallback.parsingError(103, child.getTagName(), child.getAttributeName(new Integer(14)), this.link, "Disabling relative link (" + this.link + "), since page was set by setBody/setHTML/setDOM so there's no way to access relative URLs");
                        }
                        this.link = null;
                    }
                    if (this.link != null && this.htmlCallback != null) {
                        int linkProps = this.htmlCallback.getLinkProperties(this, this.convertURL(this.link));
                        if ((linkProps & 2) != 0) {
                            this.link = null;
                        } else if ((linkProps & 1) != 0) {
                            this.linkVisited = true;
                        }
                    }
                    this.anchor = child.getAttributeById(37);
                    if (this.link == null || (aKey = child.getAttributeById(12)) == null || aKey.length() != 1) break;
                    this.accesskey = aKey.charAt(0);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.font = (HTMLFont)fonts.get(child.getTagName());
                    if (this.font == null) {
                        this.font = oldFont;
                    }
                }
                case 21: {
                    curAlign = this.getHorizAlign(child.getAttributeById(6), align, true);
                    this.adjustAlignment(align, curAlign);
                    this.newLineIfNotEmpty(curAlign);
                    this.newLineIfLastWasNotEmpty(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 12: 
                case 69: {
                    curAlign = child.getTagId() == 12 ? this.getHorizAlign(child.getAttributeById(6), align, true) : 4;
                    this.adjustAlignment(align, curAlign);
                    this.newLineIfNotEmpty(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 59: {
                    this.newLineIfNotEmpty(curAlign);
                    Container newCont = new Container();
                    newCont.setUIID("HTMLFieldset");
                    if (this.fieldsets.size() == 0) {
                        newCont.getStyle().setMargin(1, 0);
                    }
                    newCont.setLayout(new BoxLayout(2));
                    this.curContainer.addComponent(newCont);
                    this.fieldsets.addElement(newCont);
                    this.curContainer = newCont;
                    if (!this.loadCSS) break;
                    child.setAssociatedComponents(newCont);
                    break;
                }
                case 8: {
                    if (this.loadCSS) {
                        child.setAssociatedComponents(this.curLine);
                    }
                    this.newLine(curAlign);
                    break;
                }
                case 29: {
                    this.newLineIfNotEmpty(curAlign);
                    this.newLine(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 30: {
                    this.newLineIfNotEmpty(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 33: 
                case 66: 
                case 70: {
                    this.newLineIfNotEmpty(curAlign);
                    ++this.ulLevel;
                    this.listIndent += INDENT_UL;
                    if (this.ulLevel == 1 && this.olIndex == Integer.MIN_VALUE) {
                        this.newLine(curAlign);
                    } else {
                        this.listIndent += INDENT_UL;
                    }
                    this.pushContainer(child);
                    break;
                }
                case 32: {
                    this.newLineIfNotEmpty(curAlign);
                    if (this.olIndex != Integer.MIN_VALUE) {
                        String indexStr = ORDERED_LIST_TYPE_IDENTIFIERS[this.listType] + "" + this.olIndex;
                        this.olUpperLevelIndex.addElement(indexStr);
                    }
                    this.olIndex = HTMLComponent.getInt(child.getAttributeById(50), 1);
                    this.listType = this.getOrderedListType(child);
                    if (this.olUpperLevelIndex.size() == 0 && this.ulLevel == 0) {
                        this.newLine(curAlign);
                    } else {
                        this.listIndent += INDENT_OL;
                    }
                    this.pushContainer(child);
                    break;
                }
                case 34: {
                    Container listItemCont = new Container(new BorderLayout());
                    listItemCont.getStyle().setMargin(1, this.leftIndent + this.listIndent);
                    this.curContainer.addComponent(listItemCont);
                    this.containers.addElement(this.curContainer);
                    HTMLListItem bullet = null;
                    if (((HTMLElement)child.getParent()).getTagId() == 32) {
                        this.olIndex = HTMLComponent.getInt(child.getAttributeById(38), this.olIndex);
                        int itemListType = this.getOrderedListType(child, this.listType);
                        HTMLListIndex listIndex = new HTMLListIndex(this.olIndex, itemListType);
                        listIndex.getUnselectedStyle().setFgColor(this.textColor);
                        listIndex.getSelectedStyle().setFgColor(this.textColor);
                        listIndex.getUnselectedStyle().setFont(this.font.getFont());
                        bullet = listIndex;
                        bullet.getUnselectedStyle().setAlignment(3);
                        bullet.setPreferredW(this.font.getFont().stringWidth("8888. "));
                    } else {
                        bullet = new HTMLBullet(this.getUnorderedListType(child, this.ulLevel), this.font.getFont().getHeight(), this.textColor, this);
                    }
                    Container bulletCont = new Container(new BorderLayout());
                    bulletCont.addComponent("North", (Component)bullet);
                    listItemCont.addComponent("West", (Component)bulletCont);
                    Container listItemText = new Container(new BoxLayout(2));
                    listItemCont.addComponent("Center", (Component)listItemText);
                    this.curContainer = listItemText;
                    if (!this.loadCSS) break;
                    child.setAssociatedComponents(listItemText);
                    break;
                }
                case 7: {
                    this.newLineIfNotEmpty(curAlign);
                    this.updateMargin(20);
                    this.newLine(curAlign);
                    this.pushContainer(child);
                    break;
                }
                case 31: {
                    this.newLineIfNotEmpty(curAlign);
                    this.updateMargin(20);
                    this.pushContainer(child);
                    break;
                }
                case 52: {
                    this.newLineIfNotEmpty(curAlign);
                    Label hr = new Label();
                    hr.setUIID("HTMLHR");
                    int hrWidth = HTMLComponent.calcSize(this.width, child.getAttributeById(23), this.width, false);
                    int hrHeight = HTMLComponent.getInt(child.getAttributeById(31), 3);
                    hr.setPreferredW(hrWidth);
                    hr.setPreferredH(hrHeight);
                    this.curLine.addComponent(hr);
                    this.newLine(curAlign);
                    if (!this.loadCSS) break;
                    child.setAssociatedComponents(hr);
                    break;
                }
                case 54: {
                    break;
                }
                case 46: {
                    this.handleImage(child, curAlign, null);
                    break;
                }
                case 22: {
                    ++this.preTagCount;
                    this.pushContainer(child);
                }
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 20: 
                case 24: 
                case 26: 
                case 27: 
                case 64: {
                    this.font = (HTMLFont)fonts.get(child.getTagName());
                    if (this.font != null) break;
                    this.font = oldFont;
                    break;
                }
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    this.font = this.getCounterpartFont(child.getTagId(), this.font);
                    break;
                }
                case 35: {
                    this.curForm = new HTMLForm(this, child.getAttributeById(20), child.getAttributeById(22), child.getAttributeById(21));
                    this.pushContainer(child);
                    break;
                }
                case 81: {
                    this.handleInput(child, curAlign);
                    break;
                }
                case 36: {
                    this.handleInput(child, curAlign);
                    break;
                }
                case 38: {
                    String multi = child.getAttributeById(41);
                    if (multi != null || child.getAttributeById(31) != null) {
                        this.curComboBox = new MultiComboBox(multi != null);
                        Container comboCont = new Container(new BorderLayout());
                        this.curComboBox.setItemGap(0);
                        comboCont.setUIID("ComboBox");
                        this.curComboBox.setUIID("List");
                        comboCont.addComponent("Center", (Component)this.curComboBox);
                    } else {
                        this.curComboBox = new HTMLComboBox();
                    }
                    String name = child.getAttributeById(37);
                    if (this.curForm != null) {
                        this.curForm.addInput(name, this.curComboBox, null);
                    }
                    child.setAssociatedComponents(this.curComboBox);
                    if (this.eventsListener != null) {
                        this.eventsListener.registerComponent(this.curComboBox, child);
                    }
                    if (child.getAttributeById(71) == null) break;
                    this.curComboBox.setEnabled(false);
                    break;
                }
                case 53: {
                    String label;
                    if (this.curComboBox == null || (label = child.getAttributeById(52)) == null) break;
                    this.curComboBox.addItem(label);
                    break;
                }
                case 39: {
                    this.optionTag = true;
                    this.optionValue = child.getAttributeById(38);
                    if (this.curComboBox == null || child.getAttributeById(42) == null) break;
                    this.optionSelected = true;
                    break;
                }
                case 40: {
                    this.curTextArea = new TextArea(HTMLComponent.getInt(child.getAttributeById(58), 2), HTMLComponent.getInt(child.getAttributeById(57), 20));
                    if (child.getAttributeById(71) != null) {
                        this.curTextArea.setEnabled(false);
                    }
                    if (child.getAttributeById(72) != null) {
                        this.curTextArea.setEditable(false);
                    }
                    this.addCmp(this.curTextArea, curAlign);
                    if (this.eventsListener != null) {
                        this.eventsListener.registerComponent(this.curTextArea, child);
                    }
                    child.setAssociatedComponents(this.curTextArea);
                    String aKey = element.getAttributeById(12);
                    if (aKey == null || aKey.length() != 1) break;
                    this.addAccessKey(aKey.charAt(0), this.curTextArea, false);
                    break;
                }
                case 23: {
                    this.addQuote(child, curAlign, true);
                    ++this.quoteTagCount;
                    break;
                }
                case 42: {
                    this.newLineIfNotEmpty(curAlign);
                    if (this.curTable != null) {
                        HTMLTableModel newTable;
                        this.tables.addElement(this.curTable);
                        this.curTable = newTable = new HTMLTableModel();
                    } else {
                        this.curTable = new HTMLTableModel();
                    }
                    this.width /= 2;
                    break;
                }
                case 45: {
                    break;
                }
                case 43: 
                case 44: {
                    if (this.curTable == null) break;
                    this.handleTableCell(child, curAlign);
                    break;
                }
                case 37: {
                    this.labelForID = child.getAttributeById(39);
                    String aKey = child.getAttributeById(12);
                    if (aKey == null || aKey.length() != 1) break;
                    this.accesskey = aKey.charAt(0);
                    break;
                }
                case 61: {
                    HTMLFont f;
                    this.textColor = HTMLElement.getColor(child.getAttributeById(61), this.textColor);
                    String family = child.getAttributeById(62);
                    int size = HTMLComponent.getInt(child.getAttributeById(31));
                    if (family == null && size == 0 || (f = this.getClosestHTMLFont(family, size, 0, 0)) == null) break;
                    this.font = f;
                    break;
                }
                case 60: 
                case 63: {
                    if (this.underlineCount == 0) {
                        this.textDecoration |= 1;
                    }
                    ++this.underlineCount;
                    break;
                }
                case 62: 
                case 67: 
                case 68: {
                    if (this.strikethruCount == 0) {
                        this.textDecoration |= 2;
                    }
                    ++this.strikethruCount;
                    break;
                }
                case 71: {
                    String mapName = child.getAttributeById(37);
                    this.curImageMap = new ImageMapData(mapName);
                    break;
                }
                case 72: {
                    this.handleImageMapArea(child);
                    break;
                }
                case 75: {
                    ++this.superscript;
                    break;
                }
                case 74: {
                    --this.superscript;
                    break;
                }
                case 79: {
                    if (this.curTable == null) break;
                    this.curTable.startSegment(1);
                    break;
                }
                case 78: {
                    if (this.curTable == null) break;
                    this.curTable.startSegment(0);
                    break;
                }
                case 80: {
                    if (this.curTable == null) break;
                    this.curTable.startSegment(2);
                }
            }
            if (child.getNumChildren() > 0) {
                this.processTag(child, curAlign);
            }
            switch (child.getTagId()) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.font = oldFont;
                }
                case 21: {
                    curAlign = align;
                    this.newLineIfNotEmpty(curAlign);
                    this.popContainer();
                    this.newLine(curAlign);
                    continue block76;
                }
                case 12: 
                case 69: {
                    curAlign = align;
                    this.newLineIfNotEmpty(curAlign);
                    this.popContainer();
                    continue block76;
                }
                case 59: {
                    this.newLineIfNotEmpty(curAlign);
                    Container fieldsetContainer = (Container)this.fieldsets.lastElement();
                    this.curContainer = fieldsetContainer.getParent();
                    this.fieldsets.removeElement(fieldsetContainer);
                    continue block76;
                }
                case 7: {
                    this.newLineIfNotEmpty(curAlign);
                    this.newLine(curAlign);
                    this.updateMargin(-20);
                    this.popContainer();
                    continue block76;
                }
                case 30: {
                    this.popContainer();
                    continue block76;
                }
                case 31: {
                    this.newLineIfNotEmpty(curAlign);
                    this.updateMargin(-20);
                    this.popContainer();
                    continue block76;
                }
                case 29: {
                    this.newLine(curAlign);
                    this.popContainer();
                    continue block76;
                }
                case 28: {
                    this.link = null;
                    this.linkVisited = false;
                    this.mainLink = null;
                    this.anchor = null;
                    this.accesskey = '\u0000';
                    continue block76;
                }
                case 33: 
                case 66: 
                case 70: {
                    --this.ulLevel;
                    if (this.ulLevel == 0 && this.olIndex == Integer.MIN_VALUE) {
                        this.newLine(curAlign);
                    } else {
                        this.listIndent -= INDENT_UL;
                    }
                    this.listIndent -= INDENT_UL;
                    this.popContainer();
                    continue block76;
                }
                case 32: {
                    if (this.olUpperLevelIndex.size() != 0) {
                        String indexStr = (String)this.olUpperLevelIndex.lastElement();
                        this.olUpperLevelIndex.removeElementAt(this.olUpperLevelIndex.size() - 1);
                        this.listType = this.getOrderedListType(indexStr.charAt(0), 0);
                        this.olIndex = HTMLComponent.getInt(indexStr.substring(1));
                        this.listIndent -= INDENT_OL;
                    } else {
                        this.olIndex = Integer.MIN_VALUE;
                    }
                    if (this.olIndex == Integer.MIN_VALUE && this.ulLevel == 0) {
                        this.newLine(curAlign);
                    }
                    this.popContainer();
                    continue block76;
                }
                case 34: {
                    Container prevContainer;
                    if (this.olIndex != Integer.MIN_VALUE) {
                        ++this.olIndex;
                    }
                    this.newLineIfNotEmpty(curAlign);
                    this.curContainer = prevContainer = (Container)this.containers.lastElement();
                    this.containers.removeElement(this.curContainer);
                    continue block76;
                }
                case 22: {
                    --this.preTagCount;
                    this.popContainer();
                }
                case 61: {
                    this.textColor = oldFontColor;
                }
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 20: 
                case 24: 
                case 26: 
                case 27: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 64: {
                    this.font = oldFont;
                    continue block76;
                }
                case 35: {
                    if (this.curForm != null && !this.curForm.hasSubmitButton && this.curForm.getNumFields() > 0) {
                        Button submitButton = new Button(this.curForm.createSubmitCommand(null, null));
                        this.addCmp(submitButton, curAlign);
                    }
                    this.curForm = null;
                    this.popContainer();
                    continue block76;
                }
                case 40: {
                    String name = child.getAttributeById(37);
                    if (this.curForm != null) {
                        this.curForm.addInput(name, this.curTextArea, null);
                    }
                    this.curTextArea = null;
                    continue block76;
                }
                case 38: {
                    if (this.curComboBox instanceof MultiComboBox) {
                        Container comboCont = this.curComboBox.getParent();
                        int minSize = Math.min(4, this.curComboBox.size());
                        int maxSize = Math.min(this.curComboBox.size(), 6);
                        int size = Math.min(maxSize, Math.max(HTMLComponent.getInt(child.getAttributeById(31)), minSize));
                        Component renderCmp = this.curComboBox.getRenderer().getListCellRendererComponent(this.curComboBox, "X", 0, false);
                        comboCont.setPreferredH((renderCmp.getPreferredH() + renderCmp.getStyle().getMargin(0) + renderCmp.getStyle().getMargin(2) + this.curComboBox.getItemGap()) * size + this.curComboBox.getStyle().getPadding(0) + this.curComboBox.getStyle().getPadding(2));
                        this.addCmp(comboCont, curAlign);
                    } else {
                        this.addCmp(this.curComboBox, curAlign);
                    }
                    this.curComboBox = null;
                    continue block76;
                }
                case 39: {
                    this.optionTag = false;
                    this.optionSelected = false;
                    this.optionValue = null;
                    continue block76;
                }
                case 23: {
                    --this.quoteTagCount;
                    this.addQuote(child, curAlign, false);
                    continue block76;
                }
                case 42: {
                    this.newLineIfNotEmpty(curAlign);
                    this.curTable.commitRowIfNotEmpty();
                    if (this.curTable.getRowCount() != 0) {
                        int padding;
                        HTMLTable table = new HTMLTable(this.curTable);
                        table.getStyle().setBgTransparency(0);
                        if (this.loadCSS) {
                            child.setAssociatedComponents(table);
                        }
                        int borderSize = HTMLComponent.getInt(child.getAttributeById(60));
                        int[] borderPad = new int[4];
                        if (borderSize > 0) {
                            int frame = HTMLUtils.getStringVal(child.getAttributeById(69), HTMLElement.ALLOWED_TABLE_FRAME_STRINGS);
                            Border border = Border.createLineBorder(borderSize);
                            if (frame == -1) {
                                for (int s = 0; s < borderPad.length; ++s) {
                                    borderPad[s] = borderSize;
                                }
                            } else {
                                Border[] borders = new Border[4];
                                for (int j = 0; j < HTMLElement.ALLOWED_TABLE_FRAME_VALS[frame].length; ++j) {
                                    int side = HTMLElement.ALLOWED_TABLE_FRAME_VALS[frame][j];
                                    borders[side] = border;
                                    borderPad[side] = borderSize;
                                }
                                border = Border.createCompoundBorder(borders[0], borders[2], borders[1], borders[3]);
                            }
                            table.getUnselectedStyle().setBorder(border);
                            table.getSelectedStyle().setBorder(border);
                            table.getUnselectedStyle().setPadding(borderPad[0], borderPad[2], borderPad[1], borderPad[3]);
                            table.getSelectedStyle().setPadding(borderPad[0], borderPad[2], borderPad[1], borderPad[3]);
                        } else {
                            table.getUnselectedStyle().setBorder(null);
                            table.getSelectedStyle().setBorder(null);
                            table.setDrawBorder(false);
                        }
                        int rules = HTMLUtils.getStringVal(child.getAttributeById(70), HTMLElement.ALLOWED_TABLE_RULES_STRINGS, 3);
                        table.setInnerBorderMode(rules);
                        int spacing = HTMLComponent.getInt(child.getAttributeById(67), -1);
                        if (spacing != -1) {
                            table.setBorderSpacing(spacing, spacing);
                        }
                        if ((padding = HTMLComponent.getInt(child.getAttributeById(68), -1)) != -1) {
                            for (int r = 0; r < this.curTable.getRowCount(); ++r) {
                                for (int c = 0; c < this.curTable.getColumnCount(); ++c) {
                                    Component cmp = (Component)this.curTable.getValueAt(r, c);
                                    if (cmp == null) continue;
                                    cmp.getUnselectedStyle().setPadding(padding, padding, padding, padding);
                                    cmp.getSelectedStyle().setPadding(padding, padding, padding, padding);
                                }
                            }
                        }
                        if (this.curTable.captionTextTag != null) {
                            Container captionedTable = new Container(new BoxLayout(2));
                            TextArea caption = new TextArea(this.curTable.captionTextTag.getText());
                            this.curTable.captionTextTag.setAssociatedComponents(caption);
                            caption.setUIID("HTMLTableCaption");
                            caption.setEditable(false);
                            caption.setFocusable(false);
                            caption.getStyle().setBorder(null);
                            caption.getStyle().setAlignment(4);
                            captionedTable.addComponent(caption);
                            captionedTable.addComponent(table);
                            this.addCmp(captionedTable, curAlign);
                        } else {
                            this.addCmp(table, curAlign);
                        }
                        this.newLineIfNotEmpty(curAlign);
                    }
                    if (this.tables.size() == 0) {
                        this.curTable = null;
                    } else {
                        this.curTable = (HTMLTableModel)this.tables.lastElement();
                        this.tables.removeElement(this.curTable);
                    }
                    this.width *= 2;
                    if (this.width <= this.displayWidth) continue block76;
                    this.width = this.displayWidth;
                    continue block76;
                }
                case 45: {
                    if (this.curTable == null) continue block76;
                    this.curTable.commitRow();
                    continue block76;
                }
                case 43: 
                case 44: {
                    if (this.curTable == null) continue block76;
                    this.newLineIfNotEmpty(curAlign);
                    this.curContainer = (Container)this.tableCells.lastElement();
                    this.tableCells.removeElement(this.curContainer);
                    continue block76;
                }
                case 37: {
                    this.labelForID = null;
                    this.accesskey = '\u0000';
                    continue block76;
                }
                case 60: 
                case 63: {
                    --this.underlineCount;
                    if (this.underlineCount != 0) continue block76;
                    --this.textDecoration;
                    continue block76;
                }
                case 62: 
                case 67: 
                case 68: {
                    --this.strikethruCount;
                    if (this.strikethruCount != 0) continue block76;
                    this.textDecoration -= 2;
                    continue block76;
                }
                case 71: {
                    if (this.curImageMap == null) continue block76;
                    if (this.imageMapData == null) {
                        this.imageMapData = new Hashtable();
                    }
                    this.imageMapData.put(this.curImageMap.name, this.curImageMap);
                    if (this.imageMapComponents != null && this.imageMapComponents.containsKey(this.curImageMap.name)) {
                        HTMLImageMap imageMap = (HTMLImageMap)this.imageMapComponents.get(this.curImageMap.name);
                        imageMap.mapData = this.curImageMap;
                    }
                    this.curImageMap = null;
                    continue block76;
                }
                case 75: {
                    --this.superscript;
                    continue block76;
                }
                case 74: {
                    ++this.superscript;
                    continue block76;
                }
                case 78: 
                case 79: 
                case 80: {
                    if (this.curTable == null) continue block76;
                    this.curTable.endSegment();
                }
            }
        }
    }

    private void adjustAlignment(int align, int curAlign) {
        if (align != curAlign && this.curLine.getComponentCount() == 0) {
            this.curLine.setLayout(new FlowLayout(curAlign));
        }
    }

    private int getUnorderedListType(HTMLElement element, int defaultType) {
        String listTypeStr = element.getAttributeById(19);
        int type = HTMLComponent.convertULString(listTypeStr);
        if (type == -1) {
            type = defaultType;
        }
        return type;
    }

    private int getOrderedListType(HTMLElement element) {
        return this.getOrderedListType(element, 0);
    }

    private int getOrderedListType(HTMLElement element, int defaultListType) {
        String listTypeStr = element.getAttributeById(19);
        if (listTypeStr != null && listTypeStr.length() > 0) {
            char c = listTypeStr.charAt(0);
            return this.getOrderedListType(c, defaultListType);
        }
        return defaultListType;
    }

    private int getOrderedListType(char c, int defaultListType) {
        for (int j = 0; j < ORDERED_LIST_TYPE_IDENTIFIERS.length; ++j) {
            if (c != ORDERED_LIST_TYPE_IDENTIFIERS[j]) continue;
            return j;
        }
        return defaultListType;
    }

    private void pushContainer(HTMLElement element) {
        if (this.loadCSS) {
            Container cont = new Container(new BoxLayout(2));
            cont.setScrollableX(false);
            cont.getStyle().setBgTransparency(0);
            element.setAssociatedComponents(cont);
            this.curContainer.addComponent(cont);
            this.containers.addElement(this.curContainer);
            this.curContainer = cont;
        }
    }

    private void popContainer() {
        if (this.loadCSS) {
            Container prevContainer;
            this.curContainer = prevContainer = (Container)this.containers.lastElement();
            this.containers.removeElement(this.curContainer);
        }
    }

    private void addQuote(HTMLElement quoteElement, int curAlign, boolean isStartTag) {
        int quoteNum;
        String quote = null;
        int n = quoteNum = isStartTag ? 0 : 1;
        if (this.quoteTagCount == 0) {
            quote = "\"";
        } else {
            quote = "'";
            quoteNum += 2;
        }
        Label quoteLabel = this.addString(quote, curAlign);
        quoteLabel.putClientProperty(CLIENT_PROPERTY_QUOTE, new Integer(quoteNum));
        if (this.loadCSS) {
            quoteElement.addAssociatedComponent(quoteLabel);
        }
    }

    private int getHorizAlign(String alignment, int defaultAlign, boolean allowJustify) {
        if (alignment != null) {
            if (alignment.equals("left")) {
                return 1;
            }
            if (alignment.equals("right")) {
                return 3;
            }
            if (alignment.equals("center") || alignment.equals("middle")) {
                return 4;
            }
            if (alignment.equals("justify")) {
                if (allowJustify) {
                    // empty if block
                }
                return 4;
            }
        }
        return defaultAlign;
    }

    private int getVertAlign(String alignment, int defaultAlign) {
        if (alignment != null) {
            if (alignment.equals("top")) {
                return 0;
            }
            if (alignment.equals("bottom")) {
                return 2;
            }
            if (alignment.equals("center") || alignment.equals("middle")) {
                return 4;
            }
        }
        return defaultAlign;
    }

    static int getInt(String intStr, int defaultValue) {
        try {
            int num = Integer.parseInt(intStr);
            return num;
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    static int getInt(String intStr) {
        return HTMLComponent.getInt(intStr, 0);
    }

    private int getPercentage(String percent) {
        if (percent == null || !percent.endsWith("%")) {
            return 0;
        }
        return HTMLComponent.getInt(percent.substring(0, percent.length() - 1));
    }

    static int calcSize(int origDim, String requestedDim, int defaultDim, boolean negativeAllowed) {
        if (requestedDim == null) {
            return defaultDim;
        }
        boolean percent = false;
        if (requestedDim.endsWith("%")) {
            percent = true;
            requestedDim = requestedDim.substring(0, requestedDim.length() - 1);
        } else if (requestedDim.endsWith("px")) {
            requestedDim = requestedDim.substring(0, requestedDim.length() - 2);
        }
        int dim = 0;
        try {
            dim = Integer.parseInt(requestedDim);
        }
        catch (Exception e) {
            return origDim;
        }
        if (dim < 0 && !negativeAllowed) {
            return origDim;
        }
        if (percent) {
            return origDim * dim / 100;
        }
        return dim;
    }

    Hashtable getInputFields() {
        return this.inputFields;
    }

    void selectComponent(Component cmp) {
        this.getComponentForm().setFocused(cmp);
        this.getComponentForm().scrollComponentToVisible(cmp);
        if (cmp instanceof RadioButton) {
            ((RadioButton)cmp).setSelected(true);
        } else if (cmp instanceof CheckBox) {
            CheckBox cb;
            cb.setSelected(!(cb = (CheckBox)cmp).isSelected());
        }
    }

    String convertURL(String url) {
        if (this.docInfo != null) {
            return this.docInfo.convertURL(url);
        }
        return url;
    }

    void goToAnchor(String anchorName) {
        Label anchorCmp = (Label)this.anchors.get(anchorName);
        if (anchorCmp != null) {
            int cx = anchorCmp.getX();
            int cy = anchorCmp.getY();
            int h = this.getHeight();
            if (anchorCmp.getAbsoluteY() - this.getY() + h > this.getPreferredH()) {
                h = this.getPreferredH() - (anchorCmp.getAbsoluteY() - this.getY());
            }
            this.scrollRectToVisible(cx, cy, this.getWidth(), h, anchorCmp);
        }
    }

    public void layoutContainer() {
        super.layoutContainer();
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.getComponentForm().getFocused() instanceof TextField) {
            return;
        }
        int keyCode = evt.getKeyEvent();
        Object obj = this.accessKeys.get(new Integer(keyCode));
        if (obj != null) {
            if (obj instanceof HTMLLink) {
                HTMLLink htmlLink = (HTMLLink)obj;
                htmlLink.actionPerformed(null);
            } else if (obj instanceof ForLabel) {
                ((ForLabel)obj).triggerAction();
            } else if (obj instanceof Component) {
                this.selectComponent((Component)obj);
            }
        }
    }

    ResourceThreadQueue getThreadQueue() {
        return this.threadQueue;
    }

    public String[] getPropertyNames() {
        return new String[]{"url", "body", "pageUIID"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{String.class, String.class, String.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("url")) {
            return this.pageURL;
        }
        if (name.equals("body")) {
            return this.htmlBody;
        }
        if (name.equals("pageUIID")) {
            return this.pageUIID;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("url")) {
            this.setPage((String)value);
            return null;
        }
        if (name.equals("body")) {
            this.htmlBody = (String)value;
            if (this.htmlBody != null && this.htmlBody.length() > 0) {
                this.setHTML(this.htmlBody, "UTF-8", null, true);
            }
            return null;
        }
        if (name.equals("pageUIID")) {
            this.pageUIID = (String)value;
            if (this.mainContainer != null && this.pageUIID != null) {
                this.mainContainer.setUIID(this.pageUIID);
            }
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    void incCounter(String counterStr, boolean reset) {
        counterStr = counterStr.trim();
        int value = reset ? 0 : 1;
        Vector v = this.getWords(counterStr, 1, false);
        if (v.size() == 0) {
            return;
        }
        counterStr = (String)v.elementAt(0);
        if (v.size() > 1) {
            try {
                value = Integer.parseInt((String)v.elementAt(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.counters == null) {
            this.counters = new Hashtable();
        }
        if (reset) {
            this.counters.put(counterStr, new Integer(value));
        } else {
            int curValue = 0;
            Object obj = this.counters.get(counterStr);
            if (obj != null) {
                curValue = (Integer)obj;
            }
            this.counters.put(counterStr, new Integer(value + curValue));
        }
    }

    int getCounterValue(String counterName) {
        if (this.counters == null) {
            return 0;
        }
        Object obj = this.counters.get(counterName);
        return obj == null ? 0 : (Integer)obj;
    }

    public boolean isSupressExceptions() {
        return this.supressExceptions;
    }

    public void setSupressExceptions(boolean supressExceptions) {
        this.supressExceptions = supressExceptions;
    }

    static int convertULString(String listTypeStr) {
        if (listTypeStr == null) {
            return -1;
        }
        for (int j = 0; j < CSS_UL_TYPES.length; ++j) {
            if (!listTypeStr.equalsIgnoreCase(CSS_UL_TYPES[j])) continue;
            return j;
        }
        return -1;
    }

    static {
        for (int i = 0; i < INPUT_TYPE_STRINGS.length; ++i) {
            INPUT_TYPES.addElement(INPUT_TYPE_STRINGS[i]);
        }
        CSS_OL_TYPES = new String[]{"decimal", "upper-alpha", "lower-alpha", "upper-roman", "lower-roman", "none"};
        ROMAN_NUMERALS_ONES = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
        ROMAN_NUMERALS_TENS = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
        CSS_UL_TYPES = new String[]{"none", "disc", "circle", "square"};
    }

    class HTMLComboBox
    extends ComboBox {
        HTMLComboBox() {
        }

        protected List createPopupList() {
            MultiComboBox l = new MultiComboBox(this.getModel(), false);
            l.setSmoothScrolling(this.isSmoothScrolling());
            l.setFixedSelection(this.getFixedSelection());
            l.setItemGap(this.getItemGap());
            l.setUIID("ComboBoxList");
            return l;
        }
    }

    class HTMLBullet
    extends HTMLListItem {
        private static final int BULLET_NONE = 0;
        private static final int BULLET_DISC = 1;
        private static final int BULLET_CIRCLE = 2;
        private static final int BULLET_SQUARE = 3;
        int level;
        int fontHeight;
        int color;
        HTMLComponent htmlC;

        public HTMLBullet(int level, int fontHeight, int color, HTMLComponent htmlC) {
            this.level = level;
            this.fontHeight = fontHeight;
            this.color = color;
            this.htmlC = htmlC;
            this.getStyle().setBgTransparency(0);
            this.setFocusable(false);
        }

        public void setStyleType(int type) {
            if (type != -1) {
                this.level = type;
                this.setShouldCalcPreferredSize(true);
                this.repaint();
            }
        }

        public void setImage(String imageUrl) {
            if (imageUrl != null) {
                this.htmlC.getThreadQueue().add(this, this.htmlC.convertURL(imageUrl));
            }
        }

        public void paint(Graphics g) {
            if (this.getIcon() != null) {
                super.paint(g);
                return;
            }
            int size = this.fontHeight / 3;
            g.setColor(this.color);
            if (this.level == 1) {
                g.fillArc(this.getX() + (this.getWidth() - (size += 2)) / 2, this.getY() + (this.getHeight() - size) / 2, size, size, 0, 360);
            } else if (this.level == 2) {
                g.drawArc(this.getX() + (this.getWidth() - size) / 2, this.getY() + (this.getHeight() - size) / 2, size, size, 0, 360);
            } else if (this.level == 3) {
                g.fillRect(this.getX() + (this.getWidth() - size) / 2, this.getY() + (this.getHeight() - size) / 2, size, size);
            }
        }

        protected Dimension calcPreferredSize() {
            if (this.getIcon() != null) {
                return super.calcPreferredSize();
            }
            if (this.level == 0) {
                return new Dimension(0, this.fontHeight);
            }
            return new Dimension(this.fontHeight, this.fontHeight);
        }
    }

    class HTMLListIndex
    extends HTMLListItem {
        int index;
        int listType;
        static final int LIST_NUMERIC = 0;
        private static final int LIST_UPPERCASE = 1;
        private static final int LIST_LOWERCASE = 2;
        private static final int LIST_ROMAN_UPPER = 3;
        private static final int LIST_ROMAN_LOWER = 4;
        private static final int LIST_NONE = 5;

        private String getListIndexString(int index, int type) {
            if (index <= 0) {
                return index + ". ";
            }
            switch (type) {
                case 0: {
                    return index + ". ";
                }
                case 1: {
                    return this.getLiteral(index, 'A');
                }
                case 2: {
                    return this.getLiteral(index, 'a');
                }
                case 3: {
                    return this.getRomanIndexString(index);
                }
                case 4: {
                    return this.getRomanIndexString(index).toLowerCase();
                }
            }
            return "    ";
        }

        String getLiteral(int index, char baseChar) {
            String literal = "";
            while (index > 0) {
                literal = (char)(index % 26 + baseChar - 1) + literal;
                index /= 26;
            }
            return literal + ". ";
        }

        private String getRomanIndexString(int index) {
            return ROMAN_NUMERALS_TENS[(index %= 100) / 10] + ROMAN_NUMERALS_ONES[index % 10] + ". ";
        }

        public HTMLListIndex(int index, int listType) {
            this.index = index;
            this.listType = listType;
            this.setText(this.getListIndexString(index, listType));
            this.getStyle().setMargin(0, 0, 0, 0);
            this.getStyle().setPadding(0, 0, 0, 0);
            this.getUnselectedStyle().setBgTransparency(0);
        }

        public void setStyleType(int type) {
            if (type != -1) {
                this.listType = type - 4;
                if (this.listType < 0) {
                    this.listType = 5;
                }
                this.setText(this.getListIndexString(this.index, this.listType));
                this.repaint();
            }
        }

        public void setImage(String imageUrl) {
        }
    }

    class ForLabel
    extends Label {
        String id;
        HTMLComponent htmlC;

        ForLabel(String labelText, HTMLComponent htmlC, String id) {
            super(labelText);
            this.id = id;
            this.htmlC = htmlC;
        }

        public void pointerReleased(int x, int y) {
            this.triggerAction();
            super.pointerReleased(x, y);
        }

        void triggerAction() {
            Component cmp = (Component)this.htmlC.getInputFields().get(this.id);
            if (cmp != null) {
                this.htmlC.selectComponent(cmp);
            }
        }
    }

    class RedirectThread
    implements Runnable {
        int seconds;
        String url;
        HTMLComponent htmlC;
        boolean cancelled;

        public RedirectThread(HTMLComponent htmlC, int seconds, String url) {
            this.seconds = seconds;
            this.url = url;
            this.htmlC = htmlC;
        }

        public void run() {
            try {
                Thread.sleep(this.seconds * 1000);
            }
            catch (InterruptedException ie) {
                System.out.println("Warning: Redirect/Refresh thread sleep interrupted, page may refresh sooner than expected.");
            }
            if (!this.cancelled) {
                boolean redirect = this.url != null;
                this.url = this.htmlC.convertURL(this.url);
                if (redirect) {
                    this.htmlC.setPageStatus(5);
                }
                this.htmlC.setPage(this.url);
            }
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

