/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.util;

import com.codename1.io.Log;
import com.codename1.ui.CN;
import com.codename1.ui.Display;
import com.codename1.ui.EncodedImage;
import com.codename1.ui.Font;
import com.codename1.ui.Image;
import com.codename1.ui.animations.AnimationObject;
import com.codename1.ui.animations.Timeline;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.CSSBorder;
import com.codename1.ui.plaf.RoundBorder;
import com.codename1.ui.plaf.RoundRectBorder;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources {
    private static boolean enableMediaQueries = true;
    static final byte MAGIC_THEME_LEGACY = -9;
    static final byte MAGIC_ANIMATION_LEGACY = -8;
    static final byte MAGIC_INDEXED_IMAGE_LEGACY = -12;
    static final byte MAGIC_FONT_LEGACY = -10;
    static final byte MAGIC_INDEXED_FONT_LEGACY = -5;
    static final byte MAGIC_IMAGE_LEGACY = -13;
    static final byte MAGIC_SVG = -11;
    static final byte MAGIC_TIMELINE = -17;
    static final byte MAGIC_FONT = -4;
    static final byte MAGIC_IMAGE = -3;
    static final byte MAGIC_L10N = -7;
    static final byte MAGIC_DATA = -6;
    static final byte MAGIC_UI = -18;
    static final byte MAGIC_HEADER = -1;
    static final byte MAGIC_PASSWORD = -2;
    private static Resources globalResources;
    private static Resources systemResource;
    short majorVersion;
    short minorVersion;
    private static byte[] key;
    static final byte MAGIC_THEME = -14;
    static final int BORDER_TYPE_EMPTY = 0;
    static final int BORDER_TYPE_LINE = 1;
    static final int BORDER_TYPE_ROUNDED = 2;
    static final int BORDER_TYPE_ETCHED_LOWERED = 4;
    static final int BORDER_TYPE_ETCHED_RAISED = 5;
    static final int BORDER_TYPE_BEVEL_RAISED = 6;
    static final int BORDER_TYPE_BEVEL_LOWERED = 7;
    static final int BORDER_TYPE_IMAGE = 8;
    static final int BORDER_TYPE_IMAGE_HORIZONTAL = 10;
    static final int BORDER_TYPE_IMAGE_VERTICAL = 11;
    static final int BORDER_TYPE_DASHED = 12;
    static final int BORDER_TYPE_DOTTED = 13;
    static final int BORDER_TYPE_DOUBLE = 14;
    static final int BORDER_TYPE_GROOVE = 15;
    static final int BORDER_TYPE_RIDGE = 16;
    static final int BORDER_TYPE_INSET = 17;
    static final int BORDER_TYPE_OUTSET = 18;
    static final int BORDER_TYPE_IMAGE_SCALED = 19;
    static final int BORDER_TYPE_IMAGE_ROUND = 20;
    static final int BORDER_TYPE_UNDERLINE = 21;
    private static Class classLoader;
    private String[] metaData;
    private static Object cachedResource;
    private static String lastLoadedName;
    private static int lastLoadedDPI;
    private static boolean runtimeMultiImages;
    private static final String systemResourceLocation = "/CN1Resource.res";
    private static boolean failOnMissingTruetype;
    private int dpi = -1;
    private HashMap<String, Byte> resourceTypes = new HashMap();
    private HashMap<String, Object> resources = new HashMap();
    private DataInputStream input;
    int keyOffset;

    public static boolean isFailOnMissingTruetype() {
        return failOnMissingTruetype;
    }

    public static void setEnableMediaQueries(boolean enable) {
        enableMediaQueries = enable;
    }

    public static boolean isEnableMediaQueries() {
        return enableMediaQueries;
    }

    public static void setFailOnMissingTruetype(boolean aFailOnMissingTruetype) {
        failOnMissingTruetype = aFailOnMissingTruetype;
    }

    public static void setRuntimeMultiImageEnabled(boolean b) {
        runtimeMultiImages = b;
    }

    static void setClassLoader(Class cls) {
        classLoader = cls;
    }

    Resources() {
    }

    Resources(InputStream input, int dpi) throws IOException {
        this.dpi = dpi;
        this.openFile(input);
    }

    void clear() {
        this.majorVersion = 0;
        this.minorVersion = 0;
        this.resourceTypes.clear();
        this.resources.clear();
        this.input = null;
    }

    Timeline readTimeline(DataInputStream input) throws IOException {
        int duration = input.readInt();
        int width = input.readInt();
        int height = input.readInt();
        AnimationObject[] animations = new AnimationObject[input.readShort()];
        int alen = animations.length;
        for (int iter = 0; iter < alen; ++iter) {
            String name = input.readUTF();
            int startTime = input.readInt();
            int animDuration = input.readInt();
            int x = input.readInt();
            int y = input.readInt();
            Image i = this.getImage(name);
            animations[iter] = i == null ? AnimationObject.createAnimationImage(name, this, x, y) : AnimationObject.createAnimationImage(i, x, y);
            animations[iter].setStartTime(startTime);
            animations[iter].setEndTime(startTime + animDuration);
            int frameDelay = input.readInt();
            if (frameDelay > -1) {
                int frameWidth = input.readInt();
                int frameHeight = input.readInt();
                animations[iter].defineFrames(frameWidth, frameHeight, frameDelay);
            }
            if (input.readBoolean()) {
                animations[iter].defineMotionX(input.readInt(), startTime, animDuration, x, input.readInt());
            }
            if (input.readBoolean()) {
                animations[iter].defineMotionY(input.readInt(), startTime, animDuration, y, input.readInt());
            }
            if (input.readBoolean()) {
                animations[iter].defineWidth(input.readInt(), startTime, animDuration, input.readInt(), input.readInt());
            }
            if (input.readBoolean()) {
                animations[iter].defineHeight(input.readInt(), startTime, animDuration, input.readInt(), input.readInt());
            }
            if (input.readBoolean()) {
                animations[iter].defineOpacity(input.readInt(), startTime, animDuration, input.readInt(), input.readInt());
            }
            if (!input.readBoolean()) continue;
            animations[iter].defineOrientation(input.readInt(), startTime, animDuration, input.readInt(), input.readInt());
        }
        Timeline tl = Timeline.createTimeline(duration, animations, new Dimension(width, height));
        return tl;
    }

    void startingEntry(String id, byte magic) {
    }

    public void override(InputStream input) throws IOException {
        this.openFileImpl(input);
    }

    void openFile(InputStream input) throws IOException {
        this.clear();
        this.openFileImpl(input);
    }

    private void openFileImpl(InputStream input) throws IOException {
        this.input = new DataInputStream(input);
        int resourceCount = this.input.readShort();
        if (resourceCount < 0) {
            throw new IOException("Invalid resource file!");
        }
        boolean password = false;
        this.keyOffset = 0;
        block15: for (int iter = 0; iter < resourceCount; ++iter) {
            byte magic = this.input.readByte();
            String id = this.input.readUTF();
            if (password) {
                magic = (byte)this.decode(magic & 0xFF);
                char[] chars = id.toCharArray();
                int clen = chars.length;
                for (int i = 0; i < clen; ++i) {
                    chars[i] = (char)this.decode(chars[i] & 0xFFFF);
                }
                id = new String(chars);
            }
            this.startingEntry(id, magic);
            switch (magic) {
                case -2: {
                    this.checkKey(id);
                    password = true;
                    continue block15;
                }
                case -1: {
                    this.readHeader();
                    continue block15;
                }
                case -14: {
                    this.setResource(id, (byte)-14, this.loadTheme(id, magic == -14));
                    continue block15;
                }
                case -3: {
                    Image img = this.createImage();
                    img.setImageName(id);
                    this.setResource(id, magic, img);
                    continue block15;
                }
                case -4: {
                    this.setResource(id, magic, this.loadFont(this.input, id, false));
                    continue block15;
                }
                case -6: {
                    this.setResource(id, magic, this.createData());
                    continue block15;
                }
                case -18: {
                    this.setResource(id, magic, this.createData());
                    continue block15;
                }
                case -7: {
                    this.setResource(id, magic, this.loadL10N());
                    continue block15;
                }
                case -13: {
                    this.setResource(id, (byte)-3, this.createImage());
                    continue block15;
                }
                case -12: {
                    this.setResource(id, (byte)-3, this.createPackedImage8());
                    continue block15;
                }
                case -9: {
                    this.setResource(id, (byte)-14, this.loadTheme(id, magic == -14));
                    continue block15;
                }
                case -10: {
                    this.setResource(id, (byte)-4, this.loadFont(this.input, id, false));
                    continue block15;
                }
                case -5: {
                    this.setResource(id, (byte)-4, this.loadFont(this.input, id, true));
                    continue block15;
                }
                default: {
                    throw new IOException("Corrupt theme file unrecognized magic number: " + Integer.toHexString(magic & 0xFF));
                }
            }
        }
    }

    public static void setPassword(String password) {
        try {
            if (password == null) {
                key = null;
                return;
            }
            key = password.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
    }

    void checkKey(String id) {
        if (key == null) {
            throw new IllegalStateException("This is a password protected resource");
        }
        char l = (char)this.decode(id.charAt(0));
        char w = (char)this.decode(id.charAt(1));
        if (l != 'l' || w != 'w') {
            throw new IllegalStateException("Incorrect password");
        }
    }

    private int decode(int val) {
        val = key[this.keyOffset] ^ val;
        ++this.keyOffset;
        if (this.keyOffset == key.length) {
            this.keyOffset = 0;
        }
        return val;
    }

    private void readHeader() throws IOException {
        short size = this.input.readShort();
        this.majorVersion = this.input.readShort();
        this.minorVersion = this.input.readShort();
        this.metaData = new String[this.input.readShort()];
        int mlen = this.metaData.length;
        for (int iter = 0; iter < mlen; ++iter) {
            this.metaData[iter] = this.input.readUTF();
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String[] getMetaData() {
        return this.metaData;
    }

    public String[] getResourceNames() {
        String[] arr = new String[this.resourceTypes.size()];
        Iterator<String> e = this.resourceTypes.keySet().iterator();
        int alen = arr.length;
        for (int iter = 0; iter < alen; ++iter) {
            arr[iter] = e.next();
        }
        return arr;
    }

    public String[] getDataResourceNames() {
        return this.getResourceTypeNames((byte)-6);
    }

    public String[] getUIResourceNames() {
        return this.getResourceTypeNames((byte)-18);
    }

    void setResource(String id, byte type, Object value) {
        if (value == null) {
            this.resources.remove(id);
            this.resourceTypes.remove(id);
        } else {
            this.resources.put(id, value);
            this.resourceTypes.put(id, new Byte(type));
        }
    }

    public String[] getL10NResourceNames() {
        return this.getResourceTypeNames((byte)-7);
    }

    public String[] getFontResourceNames() {
        ArrayList<String> vec = new ArrayList<String>();
        for (String c : this.resourceTypes.keySet()) {
            if (!this.isFont(c)) continue;
            vec.add(c);
        }
        return Resources.toStringArray(vec);
    }

    public String[] getThemeResourceNames() {
        ArrayList<String> vec = new ArrayList<String>();
        for (String c : this.resourceTypes.keySet()) {
            if (!this.isTheme(c)) continue;
            vec.add(c);
        }
        return Resources.toStringArray(vec);
    }

    public String[] getImageResourceNames() {
        ArrayList<String> vec = new ArrayList<String>();
        for (String c : this.resourceTypes.keySet()) {
            if (!this.isImage(c)) continue;
            vec.add(c);
        }
        return Resources.toStringArray(vec);
    }

    byte getResourceType(String name) {
        Byte b = this.resourceTypes.get(name);
        if (b == null) {
            return 0;
        }
        return b;
    }

    private String[] getResourceTypeNames(byte b) {
        ArrayList<String> vec = new ArrayList<String>();
        for (String c : this.resourceTypes.keySet()) {
            if (this.resourceTypes.get(c) != b) continue;
            vec.add(c);
        }
        return Resources.toStringArray(vec);
    }

    private static String[] toStringArray(ArrayList<String> v) {
        String[] s = new String[v.size()];
        int slen = v.size();
        for (int iter = 0; iter < slen; ++iter) {
            s[iter] = v.get(iter);
        }
        return s;
    }

    public boolean isL10N(String name) {
        byte b = this.resourceTypes.get(name);
        return b == -7;
    }

    public boolean isTheme(String name) {
        byte b = this.resourceTypes.get(name);
        return b == -9 || b == -14;
    }

    public boolean isFont(String name) {
        byte b = this.resourceTypes.get(name);
        return b == -4 || b == -10 || b == -5;
    }

    public boolean isAnimation(String name) {
        byte b = this.resourceTypes.get(name);
        return b == -8;
    }

    public boolean isData(String name) {
        byte b = this.resourceTypes.get(name);
        return b == -6;
    }

    public boolean isUI(String name) {
        byte b = this.resourceTypes.get(name);
        return b == -18;
    }

    public boolean isImage(String name) {
        Byte bt = this.resourceTypes.get(name);
        if (bt == null) {
            return false;
        }
        byte b = bt;
        return b == -13 || b == -8 || b == -12 || b == -3 || b == -17;
    }

    public static Resources openLayered(String resource) throws IOException {
        return Resources.openLayered(resource, -1);
    }

    public static Resources open(String resource) throws IOException {
        return Resources.open(resource, -1);
    }

    public static Resources open(InputStream resource) throws IOException {
        return Resources.open(resource, -1);
    }

    public static Resources openLayered(String resource, int dpi) throws IOException {
        Resources r = Resources.open(resource + ".res", dpi);
        String[] over = Display.getInstance().getPlatformOverrides();
        int olen = over.length;
        for (int iter = 0; iter < olen; ++iter) {
            InputStream i = Display.getInstance().getResourceAsStream(classLoader, resource + "_" + over[iter] + ".ovr");
            if (i == null) continue;
            r.override(i);
            i.close();
        }
        return r;
    }

    public static Resources open(String resource, int dpi) throws IOException {
        try {
            Resources r;
            if (resource.equals(systemResourceLocation) && systemResource != null) {
                return systemResource;
            }
            if (lastLoadedName != null && lastLoadedName.equals(resource) && lastLoadedDPI == dpi && (r = (Resources)Display.getInstance().extractHardRef(cachedResource)) != null) {
                return r;
            }
            InputStream is = Display.getInstance().getResourceAsStream(classLoader, resource);
            if (is == null) {
                throw new IOException(resource + " not found");
            }
            Resources r2 = new Resources(is, dpi);
            is.close();
            if (resource.equals(systemResourceLocation)) {
                systemResource = r2;
                return r2;
            }
            lastLoadedDPI = dpi;
            lastLoadedName = resource;
            cachedResource = Display.getInstance().createSoftWeakRef(r2);
            return r2;
        }
        catch (RuntimeException err) {
            Log.e(err);
            throw new IOException(err.getMessage());
        }
    }

    public static Resources open(InputStream resource, int dpi) throws IOException {
        return new Resources(resource, dpi);
    }

    public Image getImage(String id) {
        return (Image)this.resources.get(id);
    }

    public InputStream getData(String id) {
        byte[] data = (byte[])this.resources.get(id);
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }

    InputStream getUi(String id) {
        byte[] d = (byte[])this.resources.get(id);
        if (d == null) {
            return null;
        }
        return new ByteArrayInputStream(d);
    }

    public Hashtable<String, String> getL10N(String id, String locale) {
        return (Hashtable)((Hashtable)this.resources.get(id)).get(locale);
    }

    public Enumeration listL10NLocales(String id) {
        return ((Hashtable)this.resources.get(id)).keys();
    }

    public Collection<String> l10NLocaleSet(String id) {
        return ((Hashtable)this.resources.get(id)).keySet();
    }

    public Font getFont(String id) {
        return (Font)this.resources.get(id);
    }

    public Hashtable getTheme(String id) {
        Hashtable h = (Hashtable)this.resources.get(id);
        if (h != null && h.containsKey("uninitialized")) {
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.endsWith("font") || key.endsWith("Image") && !key.endsWith("scaledImage")) {
                    Object value = h.get(key);
                    if (value == null) {
                        throw new IllegalArgumentException("Couldn't find resource: " + key);
                    }
                    if (value instanceof String) {
                        Object o = key.endsWith("Image") ? this.getImage((String)value) : this.resources.get(value);
                        if (o == null) {
                            throw new IllegalArgumentException("Theme entry for " + key + " could not be found: " + value);
                        }
                        h.put(key, o);
                    }
                }
                if (!key.endsWith("order")) continue;
                Border b = this.confirmBorder(h, key);
                h.put(key, b);
            }
            h.remove("uninitialized");
        }
        return h;
    }

    private Border confirmBorder(Hashtable h, String key) {
        Object val = h.get(key);
        if (val == null) {
            return null;
        }
        if (!(val instanceof Border)) {
            String[] value = (String[])val;
            if (value == null) {
                throw new IllegalArgumentException("Couldn't find resource: " + key);
            }
            Border imageBorder = this.createImageBorder(value);
            return imageBorder;
        }
        return (Border)val;
    }

    private Border createImageBorder(String[] value) {
        if (value[0].equals("h")) {
            return Border.createHorizonalImageBorder(this.getImage(value[1]), this.getImage(value[2]), this.getImage(value[3]));
        }
        if (value[0].equals("v")) {
            return Border.createVerticalImageBorder(this.getImage(value[1]), this.getImage(value[2]), this.getImage(value[3]));
        }
        if (value[0].equals("s")) {
            Image[] images = new Image[value.length - 1];
            int ilen = images.length;
            for (int iter = 0; iter < ilen; ++iter) {
                images[iter] = this.getImage(value[iter + 1]);
            }
            return Border.createImageScaledBorder(images[0], images[1], images[2], images[3], images[4], images[5], images[6], images[7], images[8]);
        }
        Image[] images = new Image[value.length];
        int vlen = value.length;
        for (int iter = 0; iter < vlen; ++iter) {
            images[iter] = this.getImage(value[iter]);
        }
        switch (images.length) {
            case 2: {
                return Border.createImageBorder(images[0], images[1], null);
            }
            case 3: {
                return Border.createImageBorder(images[0], images[1], images[2]);
            }
            case 8: {
                return Border.createImageBorder(images[0], images[1], images[2], images[3], images[4], images[5], images[6], images[7], null);
            }
        }
        return Border.createImageBorder(images[0], images[1], images[2], images[3], images[4], images[5], images[6], images[7], images[8]);
    }

    Object getResourceObject(String res) {
        return this.resources.get(res);
    }

    Image createImage() throws IOException {
        return this.createImage(this.input);
    }

    Image createImage(DataInputStream input) throws IOException {
        if (this.majorVersion == 0 && this.minorVersion == 0) {
            byte[] data = new byte[input.readInt()];
            input.readFully(data, 0, data.length);
            return EncodedImage.create(data);
        }
        int type = input.readByte() & 0xFF;
        switch (type) {
            case 241: 
            case 242: {
                byte[] data = new byte[input.readInt()];
                input.readFully(data, 0, data.length);
                if (this.minorVersion > 3) {
                    int width = input.readInt();
                    int height = input.readInt();
                    boolean opaque = input.readBoolean();
                    return EncodedImage.create(data, width, height, opaque);
                }
                return EncodedImage.create(data);
            }
            case 243: {
                return this.createPackedImage8();
            }
            case 245: {
                int svgSize = input.readInt();
                if (Image.isSVGSupported()) {
                    byte[] s = new byte[svgSize];
                    input.readFully(s);
                    String baseURL = input.readUTF();
                    boolean animated = input.readBoolean();
                    this.loadSVGRatios(input);
                    byte[] fallback = new byte[input.readInt()];
                    if (fallback.length > 0) {
                        input.readFully(fallback, 0, fallback.length);
                    }
                    return Image.createSVG(baseURL, animated, s);
                }
                svgSize = (int)((long)svgSize - input.skip(svgSize));
                while (svgSize > 0) {
                    svgSize = (int)((long)svgSize - input.skip(svgSize));
                }
                input.readUTF();
                input.readBoolean();
                input.readFloat();
                input.readFloat();
                byte[] fallback = new byte[input.readInt()];
                input.readFully(fallback, 0, fallback.length);
                return EncodedImage.create(fallback);
            }
            case 247: {
                int svgSize = input.readInt();
                if (Image.isSVGSupported()) {
                    byte[] s = new byte[svgSize];
                    input.readFully(s);
                    String baseURL = input.readUTF();
                    boolean animated = input.readBoolean();
                    Image img = this.readMultiImage(input, true);
                    Image svg = this.createSVG(animated, s);
                    if (svg.getSVGDocument() == null) {
                        return img;
                    }
                    return svg;
                }
                svgSize = (int)((long)svgSize - input.skip(svgSize));
                while (svgSize > 0) {
                    svgSize = (int)((long)svgSize - input.skip(svgSize));
                }
                String baseURL = input.readUTF();
                input.readBoolean();
                return this.readMultiImage(input);
            }
            case 246: {
                return this.readMultiImage(input);
            }
            case 239: {
                Timeline tl = this.readTimeline(input);
                return tl;
            }
        }
        throw new IOException("Illegal type while creating image: " + Integer.toHexString(type));
    }

    Image createSVG(boolean animated, byte[] data) throws IOException {
        return Image.createSVG(null, animated, data);
    }

    private Image readMultiImage(DataInputStream input) throws IOException {
        return this.readMultiImage(input, false);
    }

    Image readMultiImage(DataInputStream input, boolean skipAll) throws IOException {
        int iter;
        EncodedImage resultImage = null;
        if (this.dpi == -1) {
            this.dpi = Display.getInstance().getDeviceDensity();
        }
        int dpiCount = input.readInt();
        int bestFitOffset = 0;
        int bestFitDPI = 0;
        int[] lengths = new int[dpiCount];
        int[] dpis = new int[dpiCount];
        boolean found = false;
        for (iter = 0; iter < dpiCount; ++iter) {
            int currentDPI = input.readInt();
            lengths[iter] = input.readInt();
            dpis[iter] = currentDPI;
            if (bestFitDPI == this.dpi || this.dpi < currentDPI || currentDPI < bestFitDPI) continue;
            bestFitDPI = currentDPI;
            bestFitOffset = iter;
            found = true;
        }
        if (!found) {
            bestFitDPI = dpis[0];
            bestFitOffset = 0;
            for (iter = 1; iter < dpiCount; ++iter) {
                if (dpis[iter] >= bestFitDPI) continue;
                bestFitDPI = dpis[iter];
                bestFitOffset = iter;
            }
        }
        if (runtimeMultiImages && !skipAll) {
            byte[][] data = new byte[dpiCount][];
            for (int iter2 = 0; iter2 < lengths.length; ++iter2) {
                int size = lengths[iter2];
                data[iter2] = new byte[size];
                input.readFully(data[iter2], 0, size);
            }
            return EncodedImage.createMulti(dpis, data);
        }
        for (iter = 0; iter < lengths.length; ++iter) {
            int size = lengths[iter];
            if (!skipAll && bestFitOffset == iter) {
                byte[] multiImageData = new byte[size];
                input.readFully(multiImageData, 0, size);
                resultImage = EncodedImage.create(multiImageData);
                continue;
            }
            while (size > 0) {
                size = (int)((long)size - input.skip(size));
            }
        }
        return resultImage;
    }

    void loadSVGRatios(DataInputStream input) throws IOException {
        input.readFloat();
        input.readFloat();
    }

    private byte[] createData() throws IOException {
        byte[] data = new byte[this.input.readInt()];
        this.input.readFully(data);
        return data;
    }

    Font loadFont(DataInputStream input, String id, boolean packed) throws IOException {
        boolean bitmapIncluded;
        if (this.majorVersion == 0 && this.minorVersion == 0) {
            Image bitmap = packed ? this.createPackedImage8() : this.createImage(input);
            int charCount = input.readShort();
            int[] cutOffsets = new int[charCount];
            int[] charWidth = new int[charCount];
            for (int iter = 0; iter < charCount; ++iter) {
                cutOffsets[iter] = input.readShort();
                charWidth[iter] = input.readByte();
            }
            String charset = input.readUTF();
            Font old = Font.getBitmapFont(id);
            if (old != null) {
                return old;
            }
            return Font.createBitmapFont(id, bitmap, cutOffsets, charWidth, charset);
        }
        int fallback = input.readByte() & 0xFF;
        boolean trueTypeIncluded = input.readBoolean();
        Font font = null;
        boolean lookupIncluded = input.readBoolean();
        if (lookupIncluded) {
            String lookup = input.readUTF();
            if (font == null && Font.isCreationByStringSupported()) {
                font = Font.create(lookup);
            }
        }
        if (bitmapIncluded = input.readBoolean()) {
            font = this.loadBitmapFont(input, id, font);
        }
        if (font != null) {
            return font;
        }
        return Font.createSystemFont(fallback & 0x60, fallback & 7, fallback & 0x18);
    }

    void readRenderingHint(DataInputStream i) throws IOException {
        i.readByte();
    }

    Font loadBitmapFont(DataInputStream input, String id, Font font) throws IOException {
        int iter;
        Image bitmap = this.createImage(input);
        int charCount = input.readShort();
        int[] cutOffsets = new int[charCount];
        int[] charWidth = new int[charCount];
        for (iter = 0; iter < charCount; ++iter) {
            cutOffsets[iter] = input.readShort();
        }
        for (iter = 0; iter < charCount; ++iter) {
            charWidth[iter] = input.readByte();
        }
        String charset = input.readUTF();
        this.readRenderingHint(input);
        if (font == null && Font.isBitmapFontEnabled()) {
            Font old = Font.getBitmapFont(id);
            if (old != null) {
                return old;
            }
            return Font.createBitmapFont(id, bitmap, cutOffsets, charWidth, charset);
        }
        return font;
    }

    Font createTrueTypeFont(Font f, String fontName, String fileName, float fontSize, int sizeSetting) {
        switch (sizeSetting) {
            case 0: {
                fontSize = Font.createSystemFont(0, 0, 8).getHeight();
                break;
            }
            case 1: {
                fontSize = Font.createSystemFont(0, 0, 0).getHeight();
                break;
            }
            case 2: {
                fontSize = Font.createSystemFont(0, 0, 16).getHeight();
                break;
            }
            case 3: {
                fontSize = (float)Display.getInstance().convertToPixels((int)(fontSize * 10.0f), true) / 10.0f;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                fontSize = (float)Font.getDefaultFont().getHeight() * fontSize;
                break;
            }
            case 6: {
                fontSize = (float)CN.getDisplayWidth() * fontSize / 100.0f;
                break;
            }
            case 7: {
                fontSize = (float)CN.getDisplayHeight() * fontSize / 100.0f;
                break;
            }
            case 8: {
                fontSize = (float)Math.min(CN.getDisplayWidth(), CN.getDisplayHeight()) * fontSize / 100.0f;
                break;
            }
            case 9: {
                fontSize = (float)Math.max(CN.getDisplayWidth(), CN.getDisplayHeight()) * fontSize / 100.0f;
            }
        }
        if (!failOnMissingTruetype) {
            try {
                Font ttf = Font.createTrueTypeFont(fontName, fileName);
                if (ttf != null) {
                    return ttf.derive(fontSize, f.getStyle());
                }
                return f;
            }
            catch (Exception ex) {
                return f;
            }
        }
        return Font.createTrueTypeFont(fontName, fileName).derive(fontSize, f.getStyle());
    }

    /*
     * Could not resolve type clashes
     */
    Hashtable loadTheme(String id, boolean newerVersion) throws IOException {
        Hashtable<String, Object> theme = new Hashtable<String, Object>();
        String densityStr = Display.getInstance().getDensityStr();
        String platformName = Display.getInstance().getPlatformName();
        if ("HTML5".equals(platformName)) {
            platformName = Display.getInstance().getProperty("HTML5.platformName", "mac");
        }
        String deviceType = Display.getInstance().isDesktop() ? "desktop" : (Display.getInstance().isTablet() ? "tablet" : "phone");
        String platformPrefix = "platform-" + platformName + "-";
        String densityPrefix = "density-" + densityStr + "-";
        String devicePrefix = "device-" + deviceType + "-";
        String platformDensityPrefix = platformPrefix + densityPrefix;
        String devicePlatformPrefix = devicePrefix + platformPrefix;
        String devicePlatformDensityPrefix = devicePlatformPrefix + densityPrefix;
        theme.put("name", id);
        theme.put("uninitialized", Boolean.TRUE);
        int size = this.input.readShort();
        ArrayList<String> fontKeys = new ArrayList<String>();
        LinkedHashMap<String, Float> fontScaleRules = null;
        class MediaRule {
            int matchCount;
            int bestMatchScore;
            String rawKey;
            String translatedKey;

            MediaRule() {
            }
        }
        HashMap<String, MediaRule> mediaRules = new HashMap<String, MediaRule>();
        int defaultFontSizeSetPriority = 0;
        for (int iter = 0; iter < size; ++iter) {
            byte p4;
            byte p3;
            String key = this.input.readUTF();
            if (key.startsWith("@")) {
                double adjustedFontSize;
                int themeMedianFontSize;
                theme.put(key, this.input.readUTF());
                if (enableMediaQueries && key.endsWith("-font-scale")) {
                    if (fontScaleRules == null) {
                        fontScaleRules = new LinkedHashMap<String, Float>();
                    }
                    fontScaleRules.put(key, Float.valueOf(Float.parseFloat((String)theme.get(key))));
                }
                if (key.equals("@defaultFontSizeInt") && defaultFontSizeSetPriority < 1 && (themeMedianFontSize = Integer.parseInt((String)theme.get(key))) > 0) {
                    adjustedFontSize = (double)(themeMedianFontSize * CN.convertToPixels(1.0f)) * 25.4 / (double)(CN.isDesktop() ? 96.0f : 160.0f);
                    Font.setDefaultFont(Font.createTrueTypeFont("native:MainRegular", (float)adjustedFontSize / (float)CN.convertToPixels(1.0f)));
                    defaultFontSizeSetPriority = 1;
                }
                if (CN.isTablet() && key.equals("@defaultTabletFontSizeInt") && defaultFontSizeSetPriority < 2 && (themeMedianFontSize = Integer.parseInt((String)theme.get(key))) > 0) {
                    adjustedFontSize = (double)(themeMedianFontSize * CN.convertToPixels(1.0f)) * 25.4 / (double)(CN.isDesktop() ? 96.0f : 160.0f);
                    Font.setDefaultFont(Font.createTrueTypeFont("native:MainRegular", (float)adjustedFontSize / (float)CN.convertToPixels(1.0f)));
                    defaultFontSizeSetPriority = 2;
                }
                if (!CN.isDesktop() || !key.equals("@defaultDesktopFontSizeInt") || defaultFontSizeSetPriority >= 3 || (themeMedianFontSize = Integer.parseInt((String)theme.get(key))) <= 0) continue;
                adjustedFontSize = (double)(themeMedianFontSize * CN.convertToPixels(1.0f)) * 25.4 / (double)(CN.isDesktop() ? 96.0f : 160.0f);
                Font.setDefaultFont(Font.createTrueTypeFont("native:MainRegular", (float)adjustedFontSize / (float)CN.convertToPixels(1.0f)));
                defaultFontSizeSetPriority = 3;
                continue;
            }
            if (enableMediaQueries) {
                String subkey = key;
                boolean mediaMatch = true;
                int matchCount = 0;
                int bestMatchScore = 0;
                if (subkey.startsWith("device-")) {
                    if (!subkey.startsWith(devicePrefix)) {
                        mediaMatch = false;
                    } else {
                        subkey = subkey.substring(devicePrefix.length());
                        ++matchCount;
                        bestMatchScore = Math.max(50, bestMatchScore);
                    }
                }
                if (mediaMatch && subkey.startsWith("platform-")) {
                    if (!subkey.startsWith(platformPrefix)) {
                        mediaMatch = false;
                    } else {
                        subkey = subkey.substring(platformPrefix.length());
                        ++matchCount;
                        bestMatchScore = Math.max(100, bestMatchScore);
                    }
                }
                if (mediaMatch && subkey.startsWith("density-")) {
                    if (!subkey.startsWith(densityPrefix)) {
                        mediaMatch = false;
                    } else {
                        subkey = subkey.substring(densityPrefix.length());
                        ++matchCount;
                        bestMatchScore = Math.max(10, bestMatchScore);
                    }
                }
                if (mediaMatch) {
                    if (mediaRules == null) {
                        mediaRules = new HashMap();
                    }
                    MediaRule rule = (MediaRule)mediaRules.get(subkey);
                    boolean replace = false;
                    if (rule == null) {
                        replace = true;
                    }
                    if (!replace && rule.matchCount <= matchCount) {
                        replace = true;
                    }
                    if (!replace && rule.bestMatchScore <= bestMatchScore) {
                        replace = true;
                    }
                    if (replace) {
                        if (rule == null) {
                            rule = new MediaRule();
                            mediaRules.put(subkey, rule);
                        }
                        rule.bestMatchScore = bestMatchScore;
                        rule.matchCount = matchCount;
                        rule.rawKey = key;
                        rule.translatedKey = subkey;
                    }
                }
            }
            if (key.endsWith("Color")) {
                theme.put(key, Integer.toHexString(this.input.readInt()));
                continue;
            }
            if (key.endsWith("align") || key.endsWith("textDecoration")) {
                theme.put(key, new Integer(this.input.readShort()));
                continue;
            }
            if (key.endsWith("ransparency")) {
                theme.put(key, "" + (this.input.readByte() & 0xFF));
                continue;
            }
            if (key.endsWith("fgAlpha")) {
                theme.put(key, this.input.readInt() & 0xFF);
                continue;
            }
            if (key.endsWith("opacity")) {
                theme.put(key, "" + (this.input.readInt() & 0xFF));
                continue;
            }
            if (key.endsWith("elevation")) {
                theme.put(key, this.input.readInt() & 0xFF);
                continue;
            }
            if (key.endsWith("iconGap")) {
                theme.put(key, Float.valueOf(this.input.readFloat()));
                continue;
            }
            if (key.endsWith("iconGapUnit")) {
                theme.put(key, this.input.readByte());
                continue;
            }
            if (key.endsWith("surface")) {
                theme.put(key, this.input.readBoolean());
                continue;
            }
            if (key.endsWith("adding") || key.endsWith("argin")) {
                if (this.minorVersion > 7) {
                    float p1 = this.input.readFloat();
                    float p2 = this.input.readFloat();
                    float p32 = this.input.readFloat();
                    float p42 = this.input.readFloat();
                    theme.put(key, "" + p1 + "," + p2 + "," + p32 + "," + p42);
                    continue;
                }
                int p1 = this.input.readByte() & 0xFF;
                int p2 = this.input.readByte() & 0xFF;
                p3 = this.input.readByte() & 0xFF;
                p4 = this.input.readByte() & 0xFF;
                theme.put(key, "" + p1 + "," + p2 + "," + p3 + "," + p4);
                continue;
            }
            if (key.endsWith("Unit")) {
                byte p1 = this.input.readByte();
                byte p2 = this.input.readByte();
                p3 = this.input.readByte();
                p4 = this.input.readByte();
                theme.put(key, new byte[]{p1, p2, p3, p4});
                continue;
            }
            if (key.endsWith("order")) {
                int borderType = this.input.readShort() & 0xFFFF;
                Object b = this.createBorder(this.input, borderType);
                theme.put(key, b);
                continue;
            }
            if (key.endsWith("ont")) {
                Font f;
                if (this.input.readBoolean()) {
                    String fontId = this.input.readUTF();
                    f = (Font)this.resources.get(fontId);
                    if (f == null) {
                        theme.put(key, fontId);
                        continue;
                    }
                } else {
                    boolean hasTTF;
                    f = Font.createSystemFont(this.input.readByte(), this.input.readByte(), this.input.readByte());
                    if (this.minorVersion > 4 && (hasTTF = this.input.readBoolean())) {
                        String fileName = this.input.readUTF();
                        String fontName = this.input.readUTF();
                        int sizeSetting = this.input.readInt();
                        float fontSize = this.input.readFloat();
                        if (Font.isTrueTypeFileSupported()) {
                            fontKeys.add(key);
                            f = this.createTrueTypeFont(f, fontName, fileName, fontSize, sizeSetting);
                        }
                    }
                }
                theme.put(key, f);
                continue;
            }
            if (key.endsWith("ackground")) {
                int type = this.input.readByte() & 0xFF;
                int pos = key.indexOf(46);
                key = pos > -1 ? key.substring(0, pos) : "";
                theme.put(key + "bgType", new Byte((byte)type));
                switch (type) {
                    case -12: 
                    case 241: {
                        theme.put(key + "bgImage", this.input.readUTF());
                        break;
                    }
                    case 242: 
                    case 243: 
                    case 245: {
                        String imageName = this.input.readUTF();
                        theme.put(key + "bgImage", imageName);
                        byte align = this.input.readByte();
                        theme.put(key + "bgAlign", new Byte(align));
                        break;
                    }
                    case 246: 
                    case 247: {
                        Float c = new Float(0.5f);
                        theme.put(key + "bgGradient", new Object[]{new Integer(this.input.readInt()), new Integer(this.input.readInt()), c, c, new Float(1.0f)});
                        break;
                    }
                    case 248: {
                        int c1 = this.input.readInt();
                        int c2 = this.input.readInt();
                        float f1 = this.input.readFloat();
                        float f2 = this.input.readFloat();
                        float radialSize = 1.0f;
                        if (this.minorVersion > 1) {
                            radialSize = this.input.readFloat();
                        }
                        theme.put(key + "bgGradient", new Object[]{new Integer(c1), new Integer(c2), new Float(f1), new Float(f2), new Float(radialSize)});
                    }
                }
                continue;
            }
            if (key.endsWith("derive")) {
                theme.put(key, this.input.readUTF());
                continue;
            }
            if (key.endsWith("bgImage")) {
                String imageId = this.input.readUTF();
                Image i = this.getImage(imageId);
                if (i == null) {
                    theme.put(key, imageId);
                    continue;
                }
                theme.put(key, i);
                continue;
            }
            if (key.endsWith("scaledImage")) {
                if (this.input.readBoolean()) {
                    theme.put(key, "true");
                    continue;
                }
                theme.put(key, "false");
                continue;
            }
            if (key.endsWith("bgType") || key.endsWith("bgAlign")) {
                theme.put(key, new Byte(this.input.readByte()));
                continue;
            }
            if (key.endsWith("bgGradient")) {
                if (this.minorVersion < 2) {
                    theme.put(key, new Object[]{new Integer(this.input.readInt()), new Integer(this.input.readInt()), new Float(this.input.readFloat()), new Float(this.input.readFloat())});
                    continue;
                }
                theme.put(key, new Object[]{new Integer(this.input.readInt()), new Integer(this.input.readInt()), new Float(this.input.readFloat()), new Float(this.input.readFloat()), new Float(this.input.readFloat())});
                continue;
            }
            throw new IOException("Error while trying to read theme property: " + key);
        }
        if (enableMediaQueries) {
            if (mediaRules != null && !mediaRules.isEmpty()) {
                for (MediaRule rule : mediaRules.values()) {
                    theme.put(rule.translatedKey, theme.get(rule.rawKey));
                }
            }
            if (fontScaleRules != null && !fontKeys.isEmpty()) {
                float scale = 1.0f;
                for (Map.Entry rule : fontScaleRules.entrySet()) {
                    String key = (String)rule.getKey();
                    String skey = key.substring(1);
                    if (skey.startsWith("device-")) {
                        if (!skey.startsWith(devicePrefix)) continue;
                        skey = skey.substring(devicePrefix.length());
                    }
                    if (skey.startsWith("platform-")) {
                        if (!skey.startsWith(platformPrefix)) continue;
                        skey = skey.substring(platformPrefix.length());
                    }
                    if (skey.startsWith("density-")) {
                        if (!skey.startsWith(densityPrefix)) continue;
                        skey = skey.substring(densityPrefix.length());
                    }
                    if (!"font-scale".equals(skey)) continue;
                    scale *= ((Float)rule.getValue()).floatValue();
                }
                if ((double)Math.abs(scale - 1.0f) > 0.01) {
                    for (String fontKey : fontKeys) {
                        Font f = (Font)theme.get(fontKey);
                        if (f == null || !f.isTTFNativeFont()) continue;
                        try {
                            f = f.derive(f.getPixelSize() * scale, f.getStyle());
                            theme.put(fontKey, f);
                        }
                        catch (Exception ex) {
                            Log.p("Failed to derive font " + f + " while loading font key " + fontKey + " from resource file. " + ex.getMessage());
                            Log.e(ex);
                        }
                    }
                }
            }
        }
        return theme;
    }

    private Object createBorder(DataInputStream input, int type) throws IOException {
        switch (type) {
            case 65281: {
                return Border.getEmpty();
            }
            case 65282: {
                if (this.minorVersion > 8) {
                    if (input.readBoolean()) {
                        if (input.readBoolean()) {
                            return Border.createLineBorder(input.readFloat());
                        }
                        return Border.createLineBorder((int)input.readFloat());
                    }
                    if (input.readBoolean()) {
                        return Border.createLineBorder(input.readFloat(), input.readInt());
                    }
                    return Border.createLineBorder((int)input.readFloat(), input.readInt());
                }
                if (input.readBoolean()) {
                    return Border.createLineBorder(input.readByte());
                }
                return Border.createLineBorder((int)input.readByte(), input.readInt());
            }
            case 65300: {
                if (input.readBoolean()) {
                    if (input.readBoolean()) {
                        return Border.createUndelineBorder(input.readFloat());
                    }
                    return Border.createUndelineBorder((int)input.readFloat());
                }
                if (input.readBoolean()) {
                    return Border.createUnderlineBorder(input.readFloat(), input.readInt());
                }
                return Border.createUnderlineBorder((int)input.readFloat(), input.readInt());
            }
            case 65283: {
                if (input.readBoolean()) {
                    return Border.createRoundBorder(input.readByte(), input.readByte());
                }
                return Border.createRoundBorder((int)input.readByte(), (int)input.readByte(), input.readInt());
            }
            case 65284: {
                if (input.readBoolean()) {
                    return Border.createEtchedLowered();
                }
                return Border.createEtchedLowered(input.readInt(), input.readInt());
            }
            case 65285: {
                if (input.readBoolean()) {
                    return Border.createEtchedRaised();
                }
                return Border.createEtchedRaised(input.readInt(), input.readInt());
            }
            case 65287: {
                if (input.readBoolean()) {
                    return Border.createBevelRaised();
                }
                return Border.createBevelRaised(input.readInt(), input.readInt(), input.readInt(), input.readInt());
            }
            case 65286: {
                if (input.readBoolean()) {
                    return Border.createBevelLowered();
                }
                return Border.createBevelLowered(input.readInt(), input.readInt(), input.readInt(), input.readInt());
            }
            case 65288: {
                String[] imageBorder = this.readImageBorder(input);
                return imageBorder;
            }
            case 65289: {
                return this.readImageBorder(input, "h");
            }
            case 65296: {
                return this.readImageBorder(input, "v");
            }
            case 65297: {
                return this.readScaledImageBorder(input);
            }
            case 65298: {
                return RoundBorder.create().rectangle(input.readBoolean()).color(input.readInt()).opacity(input.readInt()).stroke(input.readFloat(), input.readBoolean()).strokeColor(input.readInt()).strokeOpacity(input.readInt()).shadowBlur(input.readFloat()).shadowOpacity(input.readInt()).shadowSpread(input.readInt(), input.readBoolean()).shadowX(input.readFloat()).shadowY(input.readFloat());
            }
            case 65299: {
                RoundRectBorder out = RoundRectBorder.create().stroke(input.readFloat(), input.readBoolean()).strokeColor(input.readInt()).strokeOpacity(input.readInt()).shadowBlur(input.readFloat()).shadowOpacity(input.readInt()).shadowSpread(input.readFloat()).shadowX(input.readFloat()).shadowY(input.readFloat()).cornerRadius(input.readFloat()).bezierCorners(input.readBoolean());
                if (input.readBoolean()) {
                    out.topOnlyMode(true);
                }
                if (input.readBoolean()) {
                    out.bottomOnlyMode(true);
                }
                return out;
            }
            case 65301: {
                return RoundRectBorder.create().stroke(input.readFloat(), input.readBoolean()).strokeColor(input.readInt()).strokeOpacity(input.readInt()).shadowBlur(input.readFloat()).shadowOpacity(input.readInt()).shadowSpread(input.readFloat()).shadowX(input.readFloat()).shadowY(input.readFloat()).cornerRadius(input.readFloat()).bezierCorners(input.readBoolean()).topLeftMode(input.readBoolean()).topRightMode(input.readBoolean()).bottomRightMode(input.readBoolean()).bottomLeftMode(input.readBoolean());
            }
            case 65302: {
                String cssStyles = input.readUTF();
                try {
                    return new CSSBorder(this, cssStyles);
                }
                catch (Throwable t) {
                    Log.p("Failed to load CSS border: " + cssStyles);
                    Log.e(t);
                    return Border.createEmpty();
                }
            }
        }
        return null;
    }

    private String[] readImageBorder(DataInputStream input, String orientation) throws IOException {
        String[] imageBorder = new String[4];
        imageBorder[0] = orientation;
        for (int iter = 1; iter < 4; ++iter) {
            imageBorder[iter] = input.readUTF();
        }
        return imageBorder;
    }

    private String[] readScaledImageBorder(DataInputStream input) throws IOException {
        String[] a = this.readImageBorder(input);
        String[] b = new String[a.length + 1];
        System.arraycopy(a, 0, b, 1, a.length);
        b[0] = "s";
        return b;
    }

    private String[] readImageBorder(DataInputStream input) throws IOException {
        int size = input.readByte();
        String[] imageBorder = new String[size];
        for (int iter = 0; iter < size; ++iter) {
            imageBorder[iter] = input.readUTF();
        }
        return imageBorder;
    }

    private Hashtable loadL10N() throws IOException {
        int iter;
        Hashtable l10n = new Hashtable();
        int keys = this.input.readShort();
        int languages = this.input.readShort();
        String[] keyArray = new String[keys];
        for (iter = 0; iter < keys; ++iter) {
            String key;
            keyArray[iter] = key = this.input.readUTF();
        }
        for (iter = 0; iter < languages; ++iter) {
            Hashtable<String, String> currentLanguage = new Hashtable<String, String>();
            String lang = this.input.readUTF();
            l10n.put(lang, currentLanguage);
            for (int valueIter = 0; valueIter < keys; ++valueIter) {
                currentLanguage.put(keyArray[valueIter], this.input.readUTF());
            }
        }
        return l10n;
    }

    private Image createPackedImage8() throws IOException {
        int size = this.input.readByte() & 0xFF;
        if (size == 0) {
            size = 256;
        }
        int[] palette = new int[size];
        int plen = palette.length;
        for (int iter = 0; iter < plen; ++iter) {
            palette[iter] = this.input.readInt();
        }
        short width = this.input.readShort();
        short height = this.input.readShort();
        byte[] data = new byte[width * height];
        this.input.readFully(data, 0, data.length);
        return Image.createIndexed(width, height, palette, data);
    }

    public static Resources getSystemResource() {
        try {
            return Resources.open(systemResourceLocation);
        }
        catch (IOException ex) {
            Log.e(ex);
            return null;
        }
    }

    public static void setGlobalResources(Resources res) {
        globalResources = res;
    }

    public static Resources getGlobalResources() {
        return globalResources;
    }

    static {
        classLoader = Resources.class;
        failOnMissingTruetype = true;
    }
}

