/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.util;

import com.codename1.util.TBigInteger;
import com.codename1.util.TBitLevel;

class TMultiplication {
    static final int whenUseKaratsuba = 63;
    static final int[] tenPows;
    static final int[] fivePows;
    static final TBigInteger[] bigTenPows;
    static final TBigInteger[] bigFivePows;

    private TMultiplication() {
    }

    static TBigInteger multiply(TBigInteger x, TBigInteger y) {
        return TMultiplication.karatsuba(x, y);
    }

    static TBigInteger karatsuba(TBigInteger op1, TBigInteger op2) {
        if (op2.numberLength > op1.numberLength) {
            TBigInteger temp = op1;
            op1 = op2;
            op2 = temp;
        }
        if (op2.numberLength < 63) {
            return TMultiplication.multiplyPAP(op1, op2);
        }
        int ndiv2 = (op1.numberLength & 0xFFFFFFFE) << 4;
        TBigInteger upperOp1 = op1.shiftRight(ndiv2);
        TBigInteger upperOp2 = op2.shiftRight(ndiv2);
        TBigInteger lowerOp1 = op1.subtract(upperOp1.shiftLeft(ndiv2));
        TBigInteger lowerOp2 = op2.subtract(upperOp2.shiftLeft(ndiv2));
        TBigInteger upper = TMultiplication.karatsuba(upperOp1, upperOp2);
        TBigInteger lower = TMultiplication.karatsuba(lowerOp1, lowerOp2);
        TBigInteger middle = TMultiplication.karatsuba(upperOp1.subtract(lowerOp1), lowerOp2.subtract(upperOp2));
        middle = middle.add(upper).add(lower);
        middle = middle.shiftLeft(ndiv2);
        upper = upper.shiftLeft(ndiv2 << 1);
        return upper.add(middle).add(lower);
    }

    static TBigInteger multiplyPAP(TBigInteger a, TBigInteger b) {
        int resSign;
        int aLen = a.numberLength;
        int bLen = b.numberLength;
        int resLength = aLen + bLen;
        int n = resSign = a.sign != b.sign ? -1 : 1;
        if (resLength == 2) {
            long val = TMultiplication.unsignedMultAddAdd(a.digits[0], b.digits[0], 0, 0);
            int valueLo = (int)val;
            int valueHi = (int)(val >>> 32);
            return valueHi == 0 ? new TBigInteger(resSign, valueLo) : new TBigInteger(resSign, 2, new int[]{valueLo, valueHi});
        }
        int[] aDigits = a.digits;
        int[] bDigits = b.digits;
        int[] resDigits = new int[resLength];
        TMultiplication.multArraysPAP(aDigits, aLen, bDigits, bLen, resDigits);
        TBigInteger result = new TBigInteger(resSign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static void multArraysPAP(int[] aDigits, int aLen, int[] bDigits, int bLen, int[] resDigits) {
        if (aLen == 0 || bLen == 0) {
            return;
        }
        if (aLen == 1) {
            resDigits[bLen] = TMultiplication.multiplyByInt(resDigits, bDigits, bLen, aDigits[0]);
        } else if (bLen == 1) {
            resDigits[aLen] = TMultiplication.multiplyByInt(resDigits, aDigits, aLen, bDigits[0]);
        } else {
            TMultiplication.multPAP(aDigits, bDigits, resDigits, aLen, bLen);
        }
    }

    static void multPAP(int[] a, int[] b, int[] t, int aLen, int bLen) {
        if (a == b && aLen == bLen) {
            TMultiplication.square(a, aLen, t);
            return;
        }
        for (int i = 0; i < aLen; ++i) {
            long carry = 0L;
            int aI = a[i];
            for (int j = 0; j < bLen; ++j) {
                carry = TMultiplication.unsignedMultAddAdd(aI, b[j], t[i + j], (int)carry);
                t[i + j] = (int)carry;
                carry >>>= 32;
            }
            t[i + bLen] = (int)carry;
        }
    }

    private static int multiplyByInt(int[] res, int[] a, int aSize, int factor) {
        long carry = 0L;
        for (int i = 0; i < aSize; ++i) {
            carry = TMultiplication.unsignedMultAddAdd(a[i], factor, (int)carry, 0);
            res[i] = (int)carry;
            carry >>>= 32;
        }
        return (int)carry;
    }

    static int multiplyByInt(int[] a, int aSize, int factor) {
        return TMultiplication.multiplyByInt(a, a, aSize, factor);
    }

    static TBigInteger multiplyByPositiveInt(TBigInteger val, int factor) {
        int resSign = val.sign;
        if (resSign == 0) {
            return TBigInteger.ZERO;
        }
        int aNumberLength = val.numberLength;
        int[] aDigits = val.digits;
        if (aNumberLength == 1) {
            long res = TMultiplication.unsignedMultAddAdd(aDigits[0], factor, 0, 0);
            int resLo = (int)res;
            int resHi = (int)(res >>> 32);
            return resHi == 0 ? new TBigInteger(resSign, resLo) : new TBigInteger(resSign, 2, new int[]{resLo, resHi});
        }
        int resLength = aNumberLength + 1;
        int[] resDigits = new int[resLength];
        resDigits[aNumberLength] = TMultiplication.multiplyByInt(resDigits, aDigits, aNumberLength, factor);
        TBigInteger result = new TBigInteger(resSign, resLength, resDigits);
        result.cutOffLeadingZeroes();
        return result;
    }

    static TBigInteger pow(TBigInteger base, int exponent) {
        TBigInteger res = TBigInteger.ONE;
        TBigInteger acc = base;
        while (exponent > 1) {
            if ((exponent & 1) != 0) {
                res = res.multiply(acc);
            }
            acc = acc.numberLength == 1 ? acc.multiply(acc) : new TBigInteger(1, TMultiplication.square(acc.digits, acc.numberLength, new int[acc.numberLength << 1]));
            exponent >>= 1;
        }
        res = res.multiply(acc);
        return res;
    }

    static int[] square(int[] a, int aLen, int[] res) {
        long carry;
        int i;
        for (i = 0; i < aLen; ++i) {
            carry = 0L;
            for (int j = i + 1; j < aLen; ++j) {
                carry = TMultiplication.unsignedMultAddAdd(a[i], a[j], res[i + j], (int)carry);
                res[i + j] = (int)carry;
                carry >>>= 32;
            }
            res[i + aLen] = (int)carry;
        }
        TBitLevel.shiftLeftOneBit(res, res, aLen << 1);
        carry = 0L;
        i = 0;
        int index = 0;
        while (i < aLen) {
            carry = TMultiplication.unsignedMultAddAdd(a[i], a[i], res[index], (int)carry);
            res[index] = (int)carry;
            carry >>>= 32;
            res[index] = (int)(carry += (long)res[++index] & 0xFFFFFFFFL);
            carry >>>= 32;
            ++i;
            ++index;
        }
        return res;
    }

    static TBigInteger multiplyByTenPow(TBigInteger val, long exp) {
        return exp < (long)tenPows.length ? TMultiplication.multiplyByPositiveInt(val, tenPows[(int)exp]) : val.multiply(TMultiplication.powerOf10(exp));
    }

    static TBigInteger powerOf10(long exp) {
        long longExp;
        TBigInteger powerOfFive;
        int intExp = (int)exp;
        if (exp < (long)bigTenPows.length) {
            return bigTenPows[intExp];
        }
        if (exp <= 50L) {
            return TBigInteger.TEN.pow(intExp);
        }
        if (exp <= 1000L) {
            return bigFivePows[1].pow(intExp).shiftLeft(intExp);
        }
        long byteArraySize = 1L + (long)((double)exp / 2.4082399653118496);
        if (byteArraySize > 1000000L) {
            throw new ArithmeticException("power of ten too big");
        }
        if (exp <= Integer.MAX_VALUE) {
            return bigFivePows[1].pow(intExp).shiftLeft(intExp);
        }
        TBigInteger res = powerOfFive = bigFivePows[1].pow(Integer.MAX_VALUE);
        intExp = (int)(exp % Integer.MAX_VALUE);
        for (longExp = exp - Integer.MAX_VALUE; longExp > Integer.MAX_VALUE; longExp -= Integer.MAX_VALUE) {
            res = res.multiply(powerOfFive);
        }
        res = res.multiply(bigFivePows[1].pow(intExp));
        res = res.shiftLeft(Integer.MAX_VALUE);
        for (longExp = exp - Integer.MAX_VALUE; longExp > Integer.MAX_VALUE; longExp -= Integer.MAX_VALUE) {
            res = res.shiftLeft(Integer.MAX_VALUE);
        }
        res = res.shiftLeft(intExp);
        return res;
    }

    static TBigInteger multiplyByFivePow(TBigInteger val, int exp) {
        if (exp < fivePows.length) {
            return TMultiplication.multiplyByPositiveInt(val, fivePows[exp]);
        }
        if (exp < bigFivePows.length) {
            return val.multiply(bigFivePows[exp]);
        }
        return val.multiply(bigFivePows[1].pow(exp));
    }

    static long unsignedMultAddAdd(int a, int b, int c, int d) {
        return ((long)a & 0xFFFFFFFFL) * ((long)b & 0xFFFFFFFFL) + ((long)c & 0xFFFFFFFFL) + ((long)d & 0xFFFFFFFFL);
    }

    static {
        int i;
        tenPows = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        fivePows = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        bigTenPows = new TBigInteger[32];
        bigFivePows = new TBigInteger[32];
        long fivePow = 1L;
        for (i = 0; i <= 18; ++i) {
            TMultiplication.bigFivePows[i] = TBigInteger.valueOf(fivePow);
            TMultiplication.bigTenPows[i] = TBigInteger.valueOf(fivePow << i);
            fivePow *= 5L;
        }
        while (i < bigTenPows.length) {
            TMultiplication.bigFivePows[i] = bigFivePows[i - 1].multiply(bigFivePows[1]);
            TMultiplication.bigTenPows[i] = bigTenPows[i - 1].multiply(TBigInteger.TEN);
            ++i;
        }
    }
}

