/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.models;

import com.codename1.charts.models.XYEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XYSeries {
    private String mTitle;
    private final IndexXYMap<Double, Double> mXY = new IndexXYMap();
    private double mMinX = -1.7976931348623157E308;
    private double mMaxX = -1.7976931348623157E308;
    private double mMinY = -1.7976931348623157E308;
    private double mMaxY = -1.7976931348623157E308;
    private final int mScaleNumber;
    private List<String> mAnnotations = new ArrayList<String>();
    private final IndexXYMap<Double, Double> mStringXY = new IndexXYMap();

    public XYSeries(String title) {
        this(title, 0);
    }

    public XYSeries(String title, int scaleNumber) {
        this.mTitle = title;
        this.mScaleNumber = scaleNumber;
        this.initRange();
    }

    public int getScaleNumber() {
        return this.mScaleNumber;
    }

    private void initRange() {
        this.mMinX = -1.7976931348623157E308;
        this.mMaxX = -1.7976931348623157E308;
        this.mMinY = -1.7976931348623157E308;
        this.mMaxY = -1.7976931348623157E308;
        int length = this.getItemCount();
        for (int k = 0; k < length; ++k) {
            double x = this.getX(k);
            double y = this.getY(k);
            this.updateRange(x, y);
        }
        boolean i = false;
    }

    private void updateRange(double x, double y) {
        this.mMinX = this.mMinX == -1.7976931348623157E308 ? x : Math.min(this.mMinX, x);
        this.mMaxX = this.mMaxX == -1.7976931348623157E308 ? x : Math.max(this.mMaxX, x);
        this.mMinY = this.mMinY == -1.7976931348623157E308 ? y : Math.min(this.mMinY, y);
        this.mMaxY = this.mMaxY == -1.7976931348623157E308 ? y : Math.max(this.mMaxY, y);
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public synchronized void add(double x, double y) {
        while (this.mXY.get(x) != null) {
            x += this.getPadding(x);
        }
        this.mXY.put(x, y);
        this.updateRange(x, y);
    }

    public synchronized void add(int index, double x, double y) {
        while (this.mXY.get(x) != null) {
            x += this.getPadding(x);
        }
        this.mXY.put(index, x, y);
        this.updateRange(x, y);
    }

    protected double getPadding(double x) {
        return XYSeries.ulp(x);
    }

    private static double ulp(double value) {
        long bits = Double.doubleToLongBits(value);
        if ((bits & 0x7FF0000000000000L) == 0x7FF0000000000000L) {
            if ((bits & 0xFFFFFFFFFFFFFL) != 0L) {
                return value;
            }
            return Double.longBitsToDouble(0x7FF0000000000000L);
        }
        if ((bits &= Long.MAX_VALUE) == 0x7FEFFFFFFFFFFFFL) {
            return Double.longBitsToDouble(bits) - Double.longBitsToDouble(bits - 1L);
        }
        double nextValue = Double.longBitsToDouble(bits + 1L);
        double result = nextValue - value;
        return result;
    }

    public synchronized void remove(int index) {
        XYEntry<Double, Double> removedEntry = this.mXY.removeByIndex(index);
        double removedX = removedEntry.getKey();
        double removedY = removedEntry.getValue();
        if (removedX == this.mMinX || removedX == this.mMaxX || removedY == this.mMinY || removedY == this.mMaxY) {
            this.initRange();
        }
    }

    public synchronized void clear() {
        this.clearAnnotations();
        this.clearSeriesValues();
    }

    public synchronized void clearSeriesValues() {
        this.mXY.clear();
        this.initRange();
    }

    public synchronized void clearAnnotations() {
        this.mStringXY.clear();
    }

    public synchronized IndexXYMap<Double, Double> getXYMap() {
        return this.mXY;
    }

    public synchronized double getX(int index) {
        return this.mXY.getXByIndex(index);
    }

    public synchronized double getY(int index) {
        return this.mXY.getYByIndex(index);
    }

    public void addAnnotation(String annotation, double x, double y) {
        this.mAnnotations.add(annotation);
        while (this.mStringXY.get(x) != null) {
            x += this.getPadding(x);
        }
        this.mStringXY.put(x, y);
    }

    public void addAnnotation(String annotation, int index, double x, double y) {
        this.mAnnotations.add(index, annotation);
        while (this.mStringXY.get(x) != null) {
            x += this.getPadding(x);
        }
        this.mStringXY.put(x, y);
    }

    public void removeAnnotation(int index) {
        this.mAnnotations.remove(index);
        this.mStringXY.removeByIndex(index);
    }

    public double getAnnotationX(int index) {
        return this.mStringXY.getXByIndex(index);
    }

    public double getAnnotationY(int index) {
        return this.mStringXY.getYByIndex(index);
    }

    public int getAnnotationCount() {
        return this.mAnnotations.size();
    }

    public String getAnnotationAt(int index) {
        return this.mAnnotations.get(index);
    }

    public synchronized SortedMap<Double, Double> getRange(double start, double stop, boolean beforeAfterPoints) {
        if (beforeAfterPoints) {
            SortedMap tailMap;
            SortedMap headMap = this.mXY.headMap(start);
            if (!headMap.isEmpty()) {
                start = headMap.lastKey();
            }
            if (!(tailMap = this.mXY.tailMap(stop)).isEmpty()) {
                Iterator<Double> tailIterator = tailMap.keySet().iterator();
                Double next = tailIterator.next();
                stop = tailIterator.hasNext() ? tailIterator.next() : (stop += next.doubleValue());
            }
        }
        if (start <= stop) {
            return this.mXY.subMap(start, stop);
        }
        return new TreeMap<Double, Double>();
    }

    public int getIndexForKey(double key) {
        return this.mXY.getIndexForKey(key);
    }

    public synchronized int getItemCount() {
        return this.mXY.size();
    }

    public double getMinX() {
        return this.mMinX;
    }

    public double getMinY() {
        return this.mMinY;
    }

    public double getMaxX() {
        return this.mMaxX;
    }

    public double getMaxY() {
        return this.mMaxY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexXYMap<K, V>
    extends TreeMap<K, V> {
        private final List<K> indexList = new ArrayList<K>();
        private double maxXDifference = 0.0;
        private boolean sorted = false;

        @Override
        public V put(K key, V value) {
            this.indexList.add(key);
            this.sorted = false;
            this.updateMaxXDifference();
            return super.put(key, value);
        }

        public V put(int index, K key, V value) {
            this.indexList.add(index, key);
            this.sorted = false;
            this.updateMaxXDifference();
            return super.put(key, value);
        }

        private void updateMaxXDifference() {
            if (this.indexList.size() < 2) {
                this.maxXDifference = 0.0;
                return;
            }
            if (Math.abs((Double)this.indexList.get(this.indexList.size() - 1) - (Double)this.indexList.get(this.indexList.size() - 2)) > this.maxXDifference) {
                this.maxXDifference = Math.abs((Double)this.indexList.get(this.indexList.size() - 1) - (Double)this.indexList.get(this.indexList.size() - 2));
            }
        }

        public double getMaxXDifference() {
            return this.maxXDifference;
        }

        @Override
        public void clear() {
            this.updateMaxXDifference();
            super.clear();
            this.indexList.clear();
        }

        public K getXByIndex(int index) {
            return this.indexList.get(index);
        }

        public V getYByIndex(int index) {
            K key = this.indexList.get(index);
            return this.get(key);
        }

        public XYEntry<K, V> getByIndex(int index) {
            K key = this.indexList.get(index);
            return new XYEntry(key, this.get(key));
        }

        public XYEntry<K, V> removeByIndex(int index) {
            K key = this.indexList.remove(index);
            return new XYEntry(key, this.remove(key));
        }

        public int getIndexForKey(K key) {
            if (!this.sorted) {
                Collections.sort(this.indexList, null);
                this.sorted = true;
            }
            int out = Collections.binarySearch(this.indexList, key, null);
            return out;
        }
    }
}

