/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.cloud;

import com.codename1.cloud.CloudException;
import com.codename1.cloud.CloudObject;
import com.codename1.cloud.CloudPersona;
import com.codename1.cloud.CloudResponse;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.Log;
import com.codename1.io.MultipartRequest;
import com.codename1.io.NetworkManager;
import com.codename1.io.Storage;
import com.codename1.io.Util;
import com.codename1.ui.Display;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudStorage {
    static final String SERVER_URL = "https://codename-one.appspot.com";
    public static final int RETURN_CODE_SUCCESS = 0;
    public static final int RETURN_CODE_FAIL_OBJECT_MODIFIED = 1;
    public static final int RETURN_CODE_FAIL_SERVER_ERROR = 2;
    public static final int RETURN_CODE_FAIL_QUOTA_EXCEEDED = 3;
    public static final int RETURN_CODE_EMPTY_QUEUE = 4;
    public static final int RETURN_CODE_FAIL_PERMISSION_VIOLATION = 5;
    static final String TYPE_FIELD = "CN1Type";
    static final String INDEX_FIELD = "CN1Index";
    private static CloudStorage INSTANCE;
    private Vector storageQueue = (Vector)Storage.getInstance().readObject("CN1StorageQueue");
    private Vector<CloudObject> pendingRefreshes;

    private CloudStorage() {
        if (this.storageQueue == null) {
            this.storageQueue = new Vector();
        }
    }

    public static CloudStorage getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CloudStorage();
        }
        return INSTANCE;
    }

    public synchronized void save(CloudObject object) {
        if (this.storageQueue.contains(object)) {
            this.storageQueue.remove(object);
        }
        this.storageQueue.addElement(object);
        Storage.getInstance().writeObject("CN1StorageQueue", this.storageQueue);
        object.setStatus(3);
    }

    public synchronized void delete(CloudObject cl) {
        this.storageQueue.addElement(cl.getCloudId());
        Storage.getInstance().writeObject("CN1StorageQueue", this.storageQueue);
        cl.setStatus(4);
    }

    public void refresh(CloudObject[] objects, CloudResponse<Integer> response) {
        this.refreshImpl(objects, response);
    }

    public void refreshAsync(CloudObject obj) {
        if (this.pendingRefreshes == null) {
            this.pendingRefreshes = new Vector();
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    CloudObject[] arr = new CloudObject[CloudStorage.this.pendingRefreshes.size()];
                    CloudStorage.this.pendingRefreshes.toArray(arr);
                    CloudStorage.this.pendingRefreshes = null;
                    CloudStorage.this.refresh(arr);
                }
            });
        }
        this.pendingRefreshes.addElement(obj);
        obj.setStatus(6);
    }

    private int refreshImpl(CloudObject[] objects, CloudResponse<Integer> response) {
        RefreshConnection refreshRequest = new RefreshConnection();
        refreshRequest.objects = objects;
        refreshRequest.response = response;
        refreshRequest.setPost(true);
        refreshRequest.setUrl("https://codename-one.appspot.com/objStoreRefresh");
        for (int iter = 0; iter < objects.length; ++iter) {
            objects[iter].setStatus(6);
            refreshRequest.addArgument("i" + iter, objects[iter].getCloudId());
            refreshRequest.addArgument("m" + iter, "" + objects[iter].getLastModified());
        }
        refreshRequest.addArgument("t", CloudPersona.getCurrentPersona().getToken());
        refreshRequest.addArgument("pk", Display.getInstance().getProperty("package_name", null));
        refreshRequest.addArgument("bb", Display.getInstance().getProperty("built_by_user", null));
        if (response != null) {
            NetworkManager.getInstance().addToQueue(refreshRequest);
            return -1;
        }
        NetworkManager.getInstance().addToQueueAndWait(refreshRequest);
        return refreshRequest.returnValue;
    }

    public int refresh(CloudObject[] objects) {
        return this.refreshImpl(objects, null);
    }

    public CloudObject[] fetch(String[] cloudIds) throws CloudException {
        CloudObject[] objs = new CloudObject[cloudIds.length];
        for (int iter = 0; iter < objs.length; ++iter) {
            objs[iter] = new CloudObject();
            objs[iter].setCloudId(cloudIds[iter]);
        }
        int err = this.refresh(objs);
        if (err == 0) {
            return objs;
        }
        throw new CloudException(err);
    }

    public void fetch(String[] cloudIds, final CloudResponse<CloudObject[]> response) {
        final CloudObject[] objs = new CloudObject[cloudIds.length];
        for (int iter = 0; iter < objs.length; ++iter) {
            objs[iter] = new CloudObject();
            objs[iter].setCloudId(cloudIds[iter]);
        }
        this.refresh(objs, new CloudResponse<Integer>(){

            @Override
            public void onSuccess(Integer returnValue) {
                response.onSuccess(objs);
            }

            @Override
            public void onError(CloudException err) {
                response.onError(err);
            }
        });
    }

    public CloudObject[] queryEquals(String type, int index, String value, int page, int limit, int visibilityScope) throws CloudException {
        return (CloudObject[])this.queryImpl(type, value, index, page, limit, visibilityScope, 1, 0, false, false, false, null);
    }

    public CloudObject[] querySorted(String type, int index, boolean ascending, int page, int limit, int visibilityScope) throws CloudException {
        return (CloudObject[])this.queryImpl(type, null, 0, page, limit, visibilityScope, 1, index, ascending, false, false, null);
    }

    public String[] querySortedKeys(String type, int index, boolean ascending, int page, int limit, int visibilityScope) throws CloudException {
        return (String[])this.queryImpl(type, null, 0, page, limit, visibilityScope, 1, index, ascending, false, true, null);
    }

    public String[] queryEqualsKeys(String type, int index, String value, int page, int limit, int visibilityScope) throws CloudException {
        return (String[])this.queryImpl(type, value, index, page, limit, visibilityScope, 1, 0, false, false, true, null);
    }

    public int queryEqualsCount(String type, int index, String value, int visibilityScope) throws CloudException {
        return (Integer)this.queryImpl(type, value, index, 0, 0, visibilityScope, 1, 0, false, true, false, null);
    }

    public int queryGreaterThanCount(String type, int index, String value, int visibilityScope) throws CloudException {
        return (Integer)this.queryImpl(type, value, index, 0, 0, visibilityScope, 2, 0, false, true, false, null);
    }

    public int queryLessThanCount(String type, int index, String value, int visibilityScope) throws CloudException {
        return (Integer)this.queryImpl(type, value, index, 0, 0, visibilityScope, 3, 0, false, true, false, null);
    }

    public CloudObject[] queryGreaterThan(String type, int index, String value, int page, int limit, int visibilityScope) throws CloudException {
        return (CloudObject[])this.queryImpl(type, value, index, page, limit, visibilityScope, 2, 0, false, false, false, null);
    }

    public CloudObject[] queryLessThan(String type, int index, String value, int page, int limit, int visibilityScope) throws CloudException {
        return (CloudObject[])this.queryImpl(type, value, index, page, limit, visibilityScope, 3, 0, false, false, false, null);
    }

    private Object queryImpl(String type, String value, int index, int page, int limit, int visibilityScope, int operator, int sort, boolean asc, boolean countQuery, boolean keyQuery, CloudResponse response) throws CloudException {
        if (CloudPersona.getCurrentPersona().getToken() == null) {
            CloudPersona.createAnonymous();
        }
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.response = response;
        queryRequest.countQuery = countQuery;
        queryRequest.keyQuery = keyQuery;
        queryRequest.setPost(true);
        queryRequest.setUrl("https://codename-one.appspot.com/objStoreQuery");
        queryRequest.addArgument("t", CloudPersona.getCurrentPersona().getToken());
        queryRequest.addArgument("pk", Display.getInstance().getProperty("package_name", null));
        queryRequest.addArgument("bb", Display.getInstance().getProperty("built_by_user", null));
        queryRequest.addArgument("ty", type);
        if (value != null && index > 0) {
            queryRequest.addArgument("k", INDEX_FIELD + index);
            queryRequest.addArgument("v", value);
        }
        queryRequest.addArgument("p", "" + page);
        queryRequest.addArgument("l", "" + limit);
        queryRequest.addArgument("sc", "" + visibilityScope);
        if (sort != 0) {
            queryRequest.addArgument("s", INDEX_FIELD + sort);
            if (asc) {
                queryRequest.addArgument("sd", "0");
            } else {
                queryRequest.addArgument("sd", "1");
            }
        }
        if (countQuery) {
            queryRequest.addArgument("c", "1");
        } else if (keyQuery) {
            queryRequest.addArgument("c", "2");
        }
        queryRequest.addArgument("o", "" + operator);
        if (response != null) {
            NetworkManager.getInstance().addToQueue(queryRequest);
            return null;
        }
        NetworkManager.getInstance().addToQueueAndWait(queryRequest);
        if (queryRequest.returnValue != 0) {
            throw new CloudException(queryRequest.returnValue);
        }
        return queryRequest.returnObject;
    }

    public void querySorted(String type, int index, boolean ascending, int page, int limit, int visibilityScope, CloudResponse<CloudObject[]> response) {
        try {
            this.queryImpl(type, null, 0, page, limit, visibilityScope, 1, index, ascending, false, false, response);
        }
        catch (CloudException e) {
            response.onError(e);
        }
    }

    public void queryEquals(String type, int index, String value, int page, int limit, int visibilityScope, CloudResponse<CloudObject[]> response) {
        try {
            this.queryImpl(type, value, index, page, limit, visibilityScope, 1, 0, false, false, false, response);
        }
        catch (CloudException e) {
            response.onError(e);
        }
    }

    public void queryEqualsCount(String type, int index, String value, int visibilityScope, CloudResponse<Integer> response) {
        try {
            this.queryImpl(type, value, index, 0, 0, visibilityScope, 1, 0, false, true, false, response);
        }
        catch (CloudException e) {
            response.onError(e);
        }
    }

    public void queryGreaterThanCount(String type, int index, String value, int visibilityScope, CloudResponse<Integer> response) {
        try {
            this.queryImpl(type, value, index, 0, 0, visibilityScope, 2, 0, false, true, false, response);
        }
        catch (CloudException e) {
            response.onError(e);
        }
    }

    public void querySortedKeys(String type, int index, boolean ascending, int page, int limit, int visibilityScope, CloudResponse<String[]> response) {
        try {
            this.queryImpl(type, null, 0, page, limit, visibilityScope, 1, index, ascending, false, true, response);
        }
        catch (CloudException e) {
            response.onError(e);
        }
    }

    public void queryEqualsKeys(String type, int index, String value, int page, int limit, int visibilityScope, CloudResponse<String[]> response) {
        try {
            this.queryImpl(type, value, index, page, limit, visibilityScope, 1, 0, false, false, true, response);
        }
        catch (CloudException e) {
            response.onError(e);
        }
    }

    public void queryLessThanCount(String type, int index, String value, int visibilityScope, CloudResponse<Integer> response) {
        try {
            this.queryImpl(type, value, index, 0, 0, visibilityScope, 3, 0, false, true, false, response);
        }
        catch (CloudException e) {
            response.onError(e);
        }
    }

    public void queryGreaterThan(String type, int index, String value, int page, int limit, int visibilityScope, CloudResponse<CloudObject[]> response) {
        try {
            this.queryImpl(type, value, index, page, limit, visibilityScope, 2, 0, false, false, false, response);
        }
        catch (CloudException e) {
            response.onError(e);
        }
    }

    public void queryLessThan(String type, int index, String value, int page, int limit, int visibilityScope, CloudResponse<CloudObject[]> response) {
        try {
            this.queryImpl(type, value, index, page, limit, visibilityScope, 3, 0, false, false, false, response);
        }
        catch (CloudException e) {
            response.onError(e);
        }
    }

    public String uploadCloudFile(String mimeType, String file) throws CloudException, IOException {
        return this.uploadCloudFileImpl(mimeType, file, null, -1);
    }

    public String uploadCloudFile(String mimeType, String filename, InputStream data, int dataSize) throws CloudException, IOException {
        return this.uploadCloudFileImpl(mimeType, filename, data, dataSize);
    }

    private String uploadCloudFileImpl(String mimeType, String file, InputStream data, int dataSize) throws CloudException, IOException {
        String token = CloudPersona.getCurrentPersona().getToken();
        if (token == null || token.length() == 0) {
            if (!CloudPersona.createAnonymous()) {
                throw new CloudException(2, "Error creating anonymous login");
            }
            token = CloudPersona.getCurrentPersona().getToken();
        }
        ConnectionRequest req = new ConnectionRequest();
        req.setPost(false);
        req.setUrl("https://codename-one.appspot.com/fileStoreURLRequest");
        NetworkManager.getInstance().addToQueueAndWait(req);
        int rc = req.getResponseCode();
        if (rc != 200) {
            if (rc == 420) {
                throw new CloudException(3);
            }
            throw new CloudException(2);
        }
        String d = new String(req.getResponseData());
        MultipartRequest uploadReq = new MultipartRequest();
        uploadReq.setUrl(d);
        uploadReq.setManualRedirect(false);
        uploadReq.addArgument("bb", Display.getInstance().getProperty("built_by_user", null));
        uploadReq.addArgument("t", CloudPersona.getCurrentPersona().getToken());
        uploadReq.addArgument("pk", Display.getInstance().getProperty("package_name", null));
        if (data == null) {
            int pos = file.lastIndexOf(47);
            String shortName = file;
            if (pos > -1) {
                shortName = file.substring(pos);
            }
            uploadReq.addData(shortName, file, mimeType);
        } else {
            uploadReq.addData(file, data, dataSize, mimeType);
        }
        NetworkManager.getInstance().addToQueueAndWait(uploadReq);
        if (uploadReq.getResponseCode() != 200) {
            throw new CloudException(2);
        }
        String r = new String(uploadReq.getResponseData());
        if ("ERROR".equals(r)) {
            throw new CloudException(2);
        }
        return r;
    }

    public boolean deleteCloudFile(String fileId) {
        if (CloudPersona.getCurrentPersona().getToken() == null) {
            CloudPersona.createAnonymous();
        }
        ConnectionRequest req = new ConnectionRequest();
        req.setPost(false);
        req.setFailSilently(true);
        req.setUrl("https://codename-one.appspot.com/fileStoreDelete");
        req.addArgument("i", fileId);
        req.addArgument("t", CloudPersona.getCurrentPersona().getToken());
        NetworkManager.getInstance().addToQueueAndWait(req);
        if (req.getResponseCode() == 200) {
            return new String(req.getResponseData()).equals("OK");
        }
        return false;
    }

    public void deleteAllCloudFilesForUser() {
        if (CloudPersona.getCurrentPersona().getToken() == null) {
            return;
        }
        ConnectionRequest req = new ConnectionRequest();
        req.setPost(false);
        req.setFailSilently(true);
        req.setUrl("https://codename-one.appspot.com/purgeCloudFiles");
        req.addArgument("own", CloudPersona.getCurrentPersona().getToken());
        req.addArgument("u", Display.getInstance().getProperty("built_by_user", ""));
        NetworkManager.getInstance().addToQueue(req);
    }

    public void deleteAllCloudFilesBefore(long timestamp, String developerAccount, String developerPassword) {
        if (CloudPersona.getCurrentPersona().getToken() == null) {
            return;
        }
        ConnectionRequest req = new ConnectionRequest();
        req.setPost(false);
        req.setFailSilently(true);
        req.setUrl("https://codename-one.appspot.com/purgeCloudFiles");
        req.addArgument("d", "" + timestamp);
        req.addArgument("u", developerAccount);
        req.addArgument("p", developerPassword);
        NetworkManager.getInstance().addToQueue(req);
    }

    public String getUrlForCloudFileId(String fileId) {
        return "https://codename-one.appspot.com/fileStoreDownload?i=" + fileId;
    }

    public synchronized int commit() {
        if (this.storageQueue.size() > 0) {
            if (CloudPersona.getCurrentPersona().getToken() == null) {
                CloudPersona.createAnonymous();
            }
            StorageRequest req = new StorageRequest();
            req.setContentType("multipart/form-data");
            req.setUrl("https://codename-one.appspot.com/objStoreCommit");
            req.setPost(true);
            NetworkManager.getInstance().addToQueueAndWait(req);
            int i = req.getReturnCode();
            if (i == 0) {
                this.storageQueue.clear();
                Storage.getInstance().deleteStorageFile("CN1StorageQueue");
            }
            return i;
        }
        return 4;
    }

    public void commit(CloudResponse<Integer> response) {
        if (this.storageQueue.size() > 0) {
            if (CloudPersona.getCurrentPersona().getToken() == null) {
                CloudPersona.createAnonymous();
            }
            StorageRequest req = new StorageRequest();
            req.response = response;
            req.setContentType("multipart/form-data");
            req.setUrl("https://codename-one.appspot.com/objStoreCommit");
            req.setPost(true);
            NetworkManager.getInstance().addToQueue(req);
        }
    }

    public synchronized void rollback() {
        this.storageQueue.clear();
        Storage.getInstance().deleteStorageFile("CN1StorageQueue");
    }

    static {
        Util.register("CloudObject", CloudObject.class);
    }

    class StorageRequest
    extends ConnectionRequest {
        CloudResponse<Integer> response;
        private int returnCode = 2;

        StorageRequest() {
        }

        protected void buildRequestBody(OutputStream os) throws IOException {
            DataOutputStream d = new DataOutputStream(os);
            d.writeInt(CloudStorage.this.storageQueue.size());
            d.writeUTF(CloudPersona.getCurrentPersona().getToken());
            d.writeUTF(Display.getInstance().getProperty("package_name", null));
            d.writeUTF(Display.getInstance().getProperty("built_by_user", null));
            for (int iter = 0; iter < CloudStorage.this.storageQueue.size(); ++iter) {
                Object e = CloudStorage.this.storageQueue.elementAt(iter);
                if (e instanceof String) {
                    d.writeByte(1);
                    d.writeUTF((String)e);
                    continue;
                }
                CloudObject cl = (CloudObject)e;
                if (cl.getCloudId() == null) {
                    d.writeByte(2);
                    d.writeInt(cl.getAccessPermissions());
                    Util.writeObject(cl.getValues(), d);
                    continue;
                }
                d.writeByte(3);
                d.writeUTF(cl.getCloudId());
                d.writeLong(cl.getLastModified());
                Util.writeObject(cl.getValues(), d);
            }
            d.writeInt(1);
        }

        protected void readResponse(InputStream input) throws IOException {
            DataInputStream di = new DataInputStream(input);
            this.returnCode = di.readInt();
            if (this.returnCode == 0) {
                long timeStamp = di.readLong();
                for (int iter = 0; iter < CloudStorage.this.storageQueue.size(); ++iter) {
                    Object o = CloudStorage.this.storageQueue.elementAt(iter);
                    if (!(o instanceof CloudObject)) continue;
                    CloudObject c = (CloudObject)o;
                    if (c.getCloudId() == null) {
                        c.setCloudId(di.readUTF());
                    }
                    c.setLastModified(timeStamp);
                    c.setStatus(1);
                }
            }
        }

        protected void postResponse() {
            if (this.response != null) {
                if (this.returnCode == 0) {
                    CloudStorage.this.storageQueue.clear();
                    Storage.getInstance().deleteStorageFile("CN1StorageQueue");
                }
                this.response.onSuccess(new Integer(this.returnCode));
            }
        }

        public int getReturnCode() {
            return this.returnCode;
        }
    }

    class QueryRequest
    extends ConnectionRequest {
        int returnValue = 2;
        CloudResponse response;
        boolean countQuery;
        boolean keyQuery;
        Object returnObject;

        QueryRequest() {
        }

        protected void postResponse() {
            if (this.response != null) {
                if (this.returnValue != 0) {
                    this.response.onError(new CloudException(this.returnValue));
                } else {
                    this.response.onSuccess(this.returnObject);
                }
            }
        }

        protected void handleErrorResponseCode(int code, String message) {
            this.returnValue = 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readResponse(InputStream input) throws IOException {
            DataInputStream di = new DataInputStream(input);
            CloudObject[] objects = null;
            try {
                int count = di.readInt();
                if (this.countQuery) {
                    di.close();
                    this.returnObject = new Integer(count);
                    this.returnValue = 0;
                    return;
                }
                if (this.keyQuery) {
                    String[] result = new String[count];
                    for (int iter = 0; iter < result.length; ++iter) {
                        result[iter] = di.readUTF();
                    }
                    this.returnValue = 0;
                    this.returnObject = result;
                    return;
                }
                objects = new CloudObject[count];
                for (int iter = 0; iter < objects.length; ++iter) {
                    objects[iter] = new CloudObject(di.readInt());
                    objects[iter].setCloudId(di.readUTF());
                    objects[iter].setLastModified(di.readLong());
                    objects[iter].setValues((Hashtable)Util.readObject(di));
                    objects[iter].setStatus(1);
                }
                this.returnValue = 0;
                this.returnObject = objects;
            }
            catch (IOException ex) {
                Log.e(ex);
                this.returnValue = 2;
            }
            finally {
                Util.cleanup(di);
            }
        }
    }

    class RefreshConnection
    extends ConnectionRequest {
        int returnValue;
        CloudObject[] objects;
        CloudResponse<Integer> response;

        RefreshConnection() {
        }

        protected void postResponse() {
            if (this.response != null) {
                if (this.returnValue != 0) {
                    this.response.onError(new CloudException(this.returnValue));
                } else {
                    this.response.onSuccess(new Integer(this.returnValue));
                }
            }
        }

        protected void handleErrorResponseCode(int code, String message) {
            this.returnValue = 2;
        }

        protected void readResponse(InputStream input) throws IOException {
            DataInputStream di = new DataInputStream(input);
            for (int iter = 0; iter < this.objects.length; ++iter) {
                try {
                    if (di.readBoolean()) {
                        this.objects[iter].setLastModified(di.readLong());
                        this.objects[iter].setValues((Hashtable)Util.readObject(di));
                    }
                    this.objects[iter].setStatus(1);
                    continue;
                }
                catch (IOException ex) {
                    Log.e(ex);
                }
            }
            Util.cleanup(di);
            this.returnValue = 0;
        }
    }
}

