/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.io.FileSystemStorage;
import com.codename1.io.Log;
import com.codename1.io.Util;
import com.codename1.ui.Display;
import com.codename1.ui.EncodedImage;
import com.codename1.ui.Image;
import java.io.InputStream;

public class FileEncodedImageAsync
extends EncodedImage {
    private String fileName;
    private boolean changePending;
    private boolean imageCreated;
    private byte[] imageData;
    private byte[] placeholder;
    private Image placeholderImage;
    private boolean queued;
    private static final Object LOCK = new Object();

    private FileEncodedImageAsync(String fileName, byte[] placeholder, int w, int h) {
        super(w, h);
        this.fileName = fileName;
        this.placeholder = placeholder;
    }

    private FileEncodedImageAsync(String fileName, Image placeholderImage) {
        super(placeholderImage.getWidth(), placeholderImage.getHeight());
        this.fileName = fileName;
        this.placeholderImage = placeholderImage;
    }

    protected void resetCache() {
        super.resetCache();
    }

    protected Image getInternal() {
        if (this.imageData == null) {
            if (!this.queued) {
                this.getImageData();
            }
            return this.placeholderImage;
        }
        this.imageCreated = true;
        return super.getInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getImageData() {
        if (this.imageData != null) {
            return this.imageData;
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.queued) {
                return this.placeholder;
            }
            this.queued = true;
            Display.getInstance().scheduleBackgroundTask(new Runnable(){

                public void run() {
                    InputStream i = null;
                    try {
                        final byte[] imageDataLocal = new byte[(int)FileSystemStorage.getInstance().getLength(FileEncodedImageAsync.this.fileName)];
                        i = FileSystemStorage.getInstance().openInputStream(FileEncodedImageAsync.this.fileName);
                        Util.readFully(i, imageDataLocal);
                        i.close();
                        Display.getInstance().callSerially(new Runnable(){

                            public void run() {
                                FileEncodedImageAsync.access$102(FileEncodedImageAsync.this, imageDataLocal);
                                FileEncodedImageAsync.this.resetCache();
                                FileEncodedImageAsync.this.changePending = true;
                                FileEncodedImageAsync.this.imageCreated = false;
                            }
                        });
                    }
                    catch (Throwable ex) {
                        try {
                            Log.e(ex);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            FileEncodedImageAsync.this.queued = false;
                            Util.cleanup(i);
                        }
                    }
                    FileEncodedImageAsync.this.queued = false;
                    Util.cleanup(i);
                }
            });
        }
        if (this.placeholderImage != null) {
            return null;
        }
        return this.placeholder;
    }

    public boolean animate() {
        if (this.changePending) {
            if (this.imageCreated) {
                this.changePending = false;
            }
            return true;
        }
        return false;
    }

    public boolean isAnimation() {
        return true;
    }

    public static FileEncodedImageAsync create(String fileName, byte[] placeholder, int width, int height) {
        return new FileEncodedImageAsync(fileName, placeholder, width, height);
    }

    public static FileEncodedImageAsync create(String fileName, Image placeholder) {
        return new FileEncodedImageAsync(fileName, placeholder);
    }

    static /* synthetic */ byte[] access$102(FileEncodedImageAsync x0, byte[] x1) {
        x0.imageData = x1;
        return x1;
    }
}

