/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.cloud;

import com.codename1.cloud.BindTarget;
import com.codename1.cloud.CloudStorage;
import com.codename1.cloud.CustomProperty;
import com.codename1.io.Externalizable;
import com.codename1.io.Util;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class CloudObject
implements Externalizable {
    public static final int STATUS_NEW = 0;
    public static final int STATUS_COMMITTED = 1;
    public static final int STATUS_MODIFIED = 2;
    public static final int STATUS_COMMIT_IN_PROGRESS = 3;
    public static final int STATUS_DELETE_IN_PROGRESS = 4;
    public static final int STATUS_DELETED = 5;
    public static final int STATUS_REFRESH_IN_PROGRESS = 6;
    public static final int ACCESS_PUBLIC = 1;
    public static final int ACCESS_PUBLIC_READ_ONLY = 2;
    public static final int ACCESS_APPLICATION = 3;
    public static final int ACCESS_APPLICATION_READ_ONLY = 4;
    public static final int ACCESS_PRIVATE = 5;
    public static final int BINDING_DEFERRED = 1;
    public static final int BINDING_IMMEDIATE = 2;
    public static final int BINDING_AUTO_SAVE = 3;
    private static Hashtable<String, CustomProperty> custom = new Hashtable();
    private Hashtable values = new Hashtable();
    private Hashtable deferedValues;
    private String cloudId;
    private long lastModified;
    private int status;
    private boolean owner = true;
    private int accessPermissions = 5;

    public CloudObject() {
    }

    public CloudObject(String type) {
        this.values.put("CN1Type", type);
    }

    public CloudObject(String type, int permissions) {
        this.accessPermissions = permissions;
        this.values.put("CN1Type", type);
    }

    CloudObject(int permissions) {
        this.accessPermissions = permissions;
    }

    public int getStatus() {
        return this.status;
    }

    void setStatus(int s) {
        this.status = s;
    }

    void setValues(Hashtable values) {
        this.values = values;
    }

    Hashtable getValues() {
        return this.values;
    }

    public void setType(String type) {
        this.setString("CN1Type", type);
    }

    public String getType() {
        return this.getString("CN1Type");
    }

    public void setIndexString(int index, String value) {
        if (index > 10 || index < 1) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        this.setString("CN1Index" + index, value);
    }

    public String getIndexString(int index) {
        return this.getString("CN1Index" + index);
    }

    public void setIndexLong(int index, long value) {
        if (index > 10 || index < 1) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        this.setLong("CN1Index" + index, value);
    }

    public Long getIndexLong(int index) {
        return this.getLong("CN1Index" + index);
    }

    public void setIndexDouble(int index, double value) {
        if (index > 10 || index < 1) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        this.setDouble("CN1Index" + index, value);
    }

    public Double getIndexDouble(int index) {
        return this.getDouble("CN1Index" + index);
    }

    public boolean isOwner() {
        return this.owner;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public Object getObject(String key) {
        CustomProperty cp;
        Object o = this.values.get(key);
        if (o == null && (cp = custom.get(key)) != null) {
            return cp.propertyValue(this, key);
        }
        return o;
    }

    public static void setCustomProperty(String key, CustomProperty cp) {
        if (cp == null) {
            custom.remove(key);
        } else {
            custom.put(key, cp);
        }
    }

    public void setString(String key, String value) {
        if (!this.owner) {
            throw new RuntimeException("Read only object, you are not the owner");
        }
        if (value == null) {
            this.values.remove(key);
            return;
        }
        if (value.length() > 512) {
            throw new IllegalArgumentException("String too long!");
        }
        this.status = 2;
        this.values.put(key, value);
    }

    public String getString(String key) {
        return (String)this.getObject(key);
    }

    public void remove(String key) {
        this.values.remove(key);
    }

    public void setLong(String key, long value) {
        if (!this.owner) {
            throw new RuntimeException("Read only object, you are not the owner");
        }
        this.status = 2;
        this.values.put(key, new Long(value));
    }

    public void setLong(String key, Long value) {
        if (!this.owner) {
            throw new RuntimeException("Read only object, you are not the owner");
        }
        this.status = 2;
        this.values.put(key, value);
    }

    public Long getLong(String key) {
        Object o = this.getObject(key);
        if (o instanceof Integer) {
            return new Long(((Integer)o).intValue());
        }
        return (Long)o;
    }

    public void setInteger(String key, int value) {
        if (!this.owner) {
            throw new RuntimeException("Read only object, you are not the owner");
        }
        this.status = 2;
        this.values.put(key, new Integer(value));
    }

    public void setInteger(String key, Integer value) {
        if (!this.owner) {
            throw new RuntimeException("Read only object, you are not the owner");
        }
        this.status = 2;
        this.values.put(key, value);
    }

    public Integer getInteger(String key) {
        Object o = this.getObject(key);
        if (o instanceof Long) {
            return new Integer((int)((Long)o).longValue());
        }
        return (Integer)o;
    }

    public void setDouble(String key, double value) {
        if (!this.owner) {
            throw new RuntimeException("Read only object, you are not the owner");
        }
        this.status = 2;
        this.values.put(key, new Double(value));
    }

    public void setDouble(String key, Double value) {
        if (!this.owner) {
            throw new RuntimeException("Read only object, you are not the owner");
        }
        this.status = 2;
        this.values.put(key, value);
    }

    public Double getDouble(String key) {
        return (Double)this.getObject(key);
    }

    public void setFloat(String key, float value) {
        if (!this.owner) {
            throw new RuntimeException("Read only object, you are not the owner");
        }
        this.status = 2;
        this.values.put(key, new Float(value));
    }

    public void setFloat(String key, Float value) {
        if (!this.owner) {
            throw new RuntimeException("Read only object, you are not the owner");
        }
        this.status = 2;
        this.values.put(key, value);
    }

    public Float getFloat(String key) {
        Object o = this.getObject(key);
        if (o instanceof Double) {
            return new Float(((Double)o).floatValue());
        }
        return (Float)o;
    }

    public void setBoolean(String key, boolean value) {
        if (!this.owner) {
            throw new RuntimeException("Read only object, you are not the owner");
        }
        this.status = 2;
        this.values.put(key, new Boolean(value));
    }

    public void setBoolean(String key, Boolean value) {
        if (!this.owner) {
            throw new RuntimeException("Read only object, you are not the owner");
        }
        this.status = 2;
        this.values.put(key, value);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.getObject(key);
    }

    public int getVersion() {
        return 1;
    }

    public void externalize(DataOutputStream out) throws IOException {
        Util.writeUTF(this.cloudId, out);
        out.writeBoolean(this.owner);
        out.writeByte(this.getAccessPermissions());
        out.writeLong(this.lastModified);
        out.writeInt(this.status);
        Util.writeObject(this.values, out);
    }

    public String getObjectId() {
        return "CloudObject";
    }

    public void internalize(int version, DataInputStream in) throws IOException {
        this.cloudId = Util.readUTF(in);
        this.owner = in.readBoolean();
        this.accessPermissions = in.readByte();
        this.lastModified = in.readLong();
        this.status = in.readInt();
        this.values = (Hashtable)Util.readObject(in);
    }

    public int getAccessPermissions() {
        return this.accessPermissions;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CloudObject)) {
            return false;
        }
        CloudObject cl = (CloudObject)o;
        if (this.cloudId == null && cl.cloudId == null) {
            return this.values.equals(cl.values);
        }
        if (this.cloudId == null || cl.cloudId == null) {
            return false;
        }
        return this.cloudId.equals(cl.cloudId);
    }

    public int hashCode() {
        if (this.cloudId != null) {
            return this.cloudId.hashCode();
        }
        return 0;
    }

    public void bindTree(Container ui, int defer, boolean objectLead) {
        int componentCount = ui.getComponentCount();
        for (int iter = 0; iter < componentCount; ++iter) {
            String attributeName;
            Component c = ui.getComponentAt(iter);
            if (c instanceof Container) {
                this.bindTree((Container)c, defer, objectLead);
                continue;
            }
            String bind = c.getCloudBoundProperty();
            if (bind == null || bind.length() <= 0 || (attributeName = c.getCloudDestinationProperty()) == null) continue;
            this.bindProperty(c, bind, attributeName, defer, objectLead);
        }
    }

    public void unbindTree(Container ui) {
        int componentCount = ui.getComponentCount();
        for (int iter = 0; iter < componentCount; ++iter) {
            String attributeName;
            Component c = ui.getComponentAt(iter);
            if (c instanceof Container) {
                this.unbindTree((Container)c);
                continue;
            }
            String bind = c.getCloudBoundProperty();
            if (bind == null || bind.length() <= 0 || (attributeName = c.getCloudDestinationProperty()) == null) continue;
            this.unbindProperty(c, bind);
        }
    }

    public void bindProperty(Component cmp, String propertyName, final String attributeName, final int defer, boolean objectLead) {
        Object val;
        if (objectLead) {
            val = this.values.get(attributeName);
            Object cmpVal = cmp.getBoundPropertyValue(propertyName);
            if (val == null) {
                if (cmpVal != null) {
                    cmp.setBoundPropertyValue(propertyName, null);
                }
            } else if (cmpVal == null || !val.equals(cmpVal)) {
                cmp.setBoundPropertyValue(propertyName, val);
            }
        } else {
            val = this.values.get(attributeName);
            Object cmpVal = cmp.getBoundPropertyValue(propertyName);
            if (cmpVal == null) {
                if (val != null) {
                    this.values.remove(attributeName);
                    this.status = 2;
                }
            } else if (val == null || !val.equals(cmpVal)) {
                this.values.put(attributeName, cmpVal);
                this.status = 2;
            }
        }
        BindTarget target = new BindTarget(){

            public void propertyChanged(Component source, String propertyName, Object oldValue, Object newValue) {
                switch (defer) {
                    case 1: {
                        if (CloudObject.this.deferedValues == null) {
                            CloudObject.this.deferedValues = new Hashtable();
                        }
                        CloudObject.this.deferedValues.put(attributeName, newValue);
                        break;
                    }
                    case 2: {
                        CloudObject.this.values.put(attributeName, newValue);
                        CloudObject.this.status = 2;
                        break;
                    }
                    case 3: {
                        CloudObject.this.values.put(attributeName, newValue);
                        CloudObject.this.status = 2;
                        CloudStorage.getInstance().save(CloudObject.this);
                    }
                }
            }
        };
        cmp.bindProperty(propertyName, target);
        cmp.putClientProperty("CN1Bind" + propertyName, target);
    }

    public void unbindProperty(Component cmp, String propertyName) {
        BindTarget t = (BindTarget)cmp.getClientProperty("CN1Bind" + propertyName);
        cmp.unbindProperty(propertyName, t);
    }

    public void commitBinding() {
        if (this.deferedValues != null && this.deferedValues.size() > 0) {
            Enumeration en = this.deferedValues.keys();
            while (en.hasMoreElements()) {
                Object k = en.nextElement();
                this.values.put(k, this.deferedValues.get(k));
            }
            this.deferedValues = null;
        }
    }

    public void cancelBinding() {
        this.deferedValues = null;
    }
}

