/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.util.CaseInsensitiveOrder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties
extends HashMap<String, String> {
    protected Properties defaults;
    private static final int NONE = 0;
    private static final int SLASH = 1;
    private static final int UNICODE = 2;
    private static final int CONTINUE = 3;
    private static final int KEY_DONE = 4;
    private static final int IGNORE = 5;

    public Properties() {
    }

    public Properties(Properties properties) {
        this.defaults = properties;
    }

    private void dumpString(StringBuilder buffer, String string, boolean key) {
        int i = 0;
        if (!key && i < string.length() && string.charAt(i) == ' ') {
            buffer.append("\\ ");
            ++i;
        }
        int slen = string.length();
        while (i < slen) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if ("\\#!=:".indexOf(ch) >= 0 || key && ch == ' ') {
                        buffer.append('\\');
                    }
                    if (ch >= ' ' && ch <= '~') {
                        buffer.append(ch);
                        break;
                    }
                    String hex = Integer.toHexString(ch);
                    buffer.append("\\u");
                    int hlen = hex.length();
                    for (int j = 0; j < 4 - hlen; ++j) {
                        buffer.append("0");
                    }
                    buffer.append(hex);
                }
            }
            ++i;
        }
    }

    public String getProperty(String name) {
        String property;
        Object result = super.get(name);
        String string = property = result instanceof String ? (String)result : null;
        if (property == null && this.defaults != null) {
            property = this.defaults.getProperty(name);
        }
        return property;
    }

    public String getProperty(String name, String defaultValue) {
        String property;
        Object result = super.get(name);
        String string = property = result instanceof String ? (String)result : null;
        if (property == null && this.defaults != null) {
            property = this.defaults.getProperty(name);
        }
        if (property == null) {
            return defaultValue;
        }
        return property;
    }

    public synchronized void load(InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        this.load(new InputStreamReader(in, "UTF-8"));
    }

    public synchronized void load(Reader in) throws IOException {
        int intVal;
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        int mode = 0;
        int unicode = 0;
        int count = 0;
        char[] buf = new char[40];
        int offset = 0;
        int keyLength = -1;
        boolean firstChar = true;
        Reader br = in;
        block17: while ((intVal = br.read()) != -1) {
            int nextChar = intVal;
            if (offset == buf.length) {
                char[] newBuf = new char[buf.length * 2];
                System.arraycopy(buf, 0, newBuf, 0, offset);
                buf = newBuf;
            }
            if (mode == 2) {
                int digit = Character.digit((char)nextChar, 16);
                if (digit >= 0) {
                    unicode = (unicode << 4) + digit;
                    if (++count < 4) {
                        continue;
                    }
                } else if (count <= 4) {
                    throw new IllegalArgumentException("Invalid Unicode sequence: illegal character");
                }
                mode = 0;
                buf[offset++] = (char)unicode;
                if (nextChar != 10) continue;
            }
            if (mode == 1) {
                mode = 0;
                switch (nextChar) {
                    case 13: {
                        mode = 3;
                        continue block17;
                    }
                    case 10: {
                        mode = 5;
                        continue block17;
                    }
                    case 98: {
                        nextChar = 8;
                        break;
                    }
                    case 102: {
                        nextChar = 12;
                        break;
                    }
                    case 110: {
                        nextChar = 10;
                        break;
                    }
                    case 114: {
                        nextChar = 13;
                        break;
                    }
                    case 116: {
                        nextChar = 9;
                        break;
                    }
                    case 117: {
                        mode = 2;
                        count = 0;
                        unicode = 0;
                        continue block17;
                    }
                }
            } else {
                switch (nextChar) {
                    case 33: 
                    case 35: {
                        if (!firstChar) break;
                        while ((intVal = br.read()) != -1 && (nextChar = (int)((char)intVal)) != 13 && nextChar != 10) {
                        }
                        continue block17;
                    }
                    case 10: {
                        if (mode == 3) {
                            mode = 5;
                            continue block17;
                        }
                    }
                    case 13: {
                        mode = 0;
                        firstChar = true;
                        if (offset > 0 || offset == 0 && keyLength == 0) {
                            if (keyLength == -1) {
                                keyLength = offset;
                            }
                            String temp = new String(buf, 0, offset);
                            this.put(temp.substring(0, keyLength), temp.substring(keyLength));
                        }
                        keyLength = -1;
                        offset = 0;
                        continue block17;
                    }
                    case 92: {
                        if (mode == 4) {
                            keyLength = offset;
                        }
                        mode = 1;
                        continue block17;
                    }
                    case 58: 
                    case 61: {
                        if (keyLength != -1) break;
                        mode = 0;
                        keyLength = offset;
                        continue block17;
                    }
                }
                if (nextChar == 32 || nextChar == 10 || nextChar == 13 || nextChar == 9) {
                    if (mode == 3) {
                        mode = 5;
                    }
                    if (offset == 0 || offset == keyLength || mode == 5) continue;
                    if (keyLength == -1) {
                        mode = 4;
                        continue;
                    }
                }
                if (mode == 5 || mode == 3) {
                    mode = 0;
                }
            }
            firstChar = false;
            if (mode == 4) {
                keyLength = offset;
                mode = 0;
            }
            buf[offset++] = nextChar;
        }
        if (mode == 2 && count <= 4) {
            throw new IllegalArgumentException("Invalid Unicode sequence: expected format \\uxxxx");
        }
        if (keyLength == -1 && offset > 0) {
            keyLength = offset;
        }
        if (keyLength >= 0) {
            String temp = new String(buf, 0, offset);
            String key = temp.substring(0, keyLength);
            String value = temp.substring(keyLength);
            if (mode == 1) {
                value = value + "\u0000";
            }
            this.put(key, value);
        }
    }

    public Enumeration<?> propertyNames() {
        Hashtable selected = new Hashtable();
        this.selectProperties(selected, false);
        return selected.keys();
    }

    public Set<String> stringPropertyNames() {
        Hashtable stringProperties = new Hashtable();
        this.selectProperties(stringProperties, true);
        return Collections.unmodifiableSet(stringProperties.keySet());
    }

    private <K> void selectProperties(Hashtable<K, Object> selectProperties, boolean isStringOnly) {
        if (this.defaults != null) {
            this.defaults.selectProperties(selectProperties, isStringOnly);
        }
        for (Object key : this.keySet()) {
            if (isStringOnly && !(key instanceof String)) continue;
            Object value = this.get(key);
            selectProperties.put(key, value);
        }
    }

    @Deprecated
    public void save(OutputStream out, String comment) {
        try {
            this.store(out, comment);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object setProperty(String name, String value) {
        return this.put(name, value);
    }

    public synchronized void store(OutputStream out, String comment) throws IOException {
        this.store(new OutputStreamWriter(out, "UTF-8"), comment);
    }

    public synchronized void store(Writer writer, String comment) throws IOException {
        if (comment != null && comment.length() > 0) {
            writer.write("#");
            writer.write(comment);
            writer.write("\n");
            writer.write("#");
            writer.write(new Date().toString());
            writer.write("\n");
        }
        StringBuilder sb = new StringBuilder(200);
        ArrayList k = new ArrayList(this.keySet());
        Collections.sort(k, new CaseInsensitiveOrder());
        for (String key : k) {
            this.dumpString(sb, key, true);
            sb.append('=');
            this.dumpString(sb, (String)this.get(key), false);
            sb.append("\n");
            writer.write(sb.toString());
            sb.setLength(0);
        }
        writer.flush();
    }
}

