/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.html;

import com.codename1.ui.Button;
import com.codename1.ui.ButtonGroup;
import com.codename1.ui.CheckBox;
import com.codename1.ui.ComboBox;
import com.codename1.ui.Command;
import com.codename1.ui.RadioButton;
import com.codename1.ui.TextArea;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.html.DocumentInfo;
import com.codename1.ui.html.HTMLComponent;
import com.codename1.ui.html.HTMLInputFormat;
import com.codename1.ui.html.HTMLUtils;
import com.codename1.ui.html.MultiComboBox;
import com.codename1.ui.html.OptionItem;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class HTMLForm {
    static final String DEFAULT_SUBMIT_TEXT = "Submit";
    static final String DEFAULT_RESET_TEXT = "Clear";
    Hashtable comps = new Hashtable();
    Hashtable defaultValues = new Hashtable();
    Vector defaultCheckedButtons = new Vector();
    Vector defaultUncheckedButtons = new Vector();
    Hashtable inputFormats = new Hashtable();
    Hashtable buttonGroups = new Hashtable();
    Vector emptyOk = new Vector();
    Vector emptyNotOk = new Vector();
    HTMLComponent htmlC;
    String action;
    String encType;
    boolean isPostMethod;
    boolean hasSubmitButton;

    HTMLForm(HTMLComponent htmlC, String action, String method, String encType) {
        int linkProps;
        this.htmlC = htmlC;
        this.action = htmlC.convertURL(action);
        this.encType = encType;
        if (htmlC.getHTMLCallback() != null && ((linkProps = htmlC.getHTMLCallback().getLinkProperties(htmlC, this.action)) & 2) != 0) {
            this.action = null;
        }
        this.isPostMethod = method != null && method.equalsIgnoreCase("post");
    }

    Command createResetCommand(String value) {
        if (value == null || value.equals("")) {
            value = this.htmlC.getUIManager().localize("html.reset", DEFAULT_RESET_TEXT);
        }
        return new NamedCommand(null, value, this, false);
    }

    Command createSubmitCommand(String name, String value) {
        this.hasSubmitButton = true;
        if (value == null || value.equals("")) {
            value = this.htmlC.getUIManager().localize("html.submit", DEFAULT_SUBMIT_TEXT);
        }
        return new NamedCommand(name, value, this, true);
    }

    void addInput(String key, Object input, String defaultValue) {
        String autoVal;
        if (defaultValue != null) {
            this.defaultValues.put(input, defaultValue);
        }
        if (key == null) {
            return;
        }
        this.comps.put(key, input);
        if (this.htmlC.getHTMLCallback() != null && input instanceof TextArea && (autoVal = this.htmlC.getHTMLCallback().getAutoComplete(this.htmlC, this.action, key)) != null) {
            ((TextArea)input).setText(autoVal);
        }
    }

    void setInputFormat(TextArea ta, HTMLInputFormat inputFormat) {
        this.inputFormats.put(ta, inputFormat);
    }

    void setEmptyOK(TextArea ta, boolean ok) {
        if (ok) {
            this.emptyOk.addElement(ta);
        } else {
            this.emptyNotOk.addElement(ta);
        }
    }

    void setDefaultValue(Object input, Object defaultValue) {
        if (input != null && defaultValue != null) {
            this.defaultValues.put(input, defaultValue);
        }
    }

    void addCheckBox(String key, CheckBox cb, String value) {
        if (cb.isSelected()) {
            this.defaultCheckedButtons.addElement(cb);
        } else {
            this.defaultUncheckedButtons.addElement(cb);
        }
        if (key == null) {
            return;
        }
        Hashtable<CheckBox, String> internal = (Hashtable<CheckBox, String>)this.comps.get(key);
        if (internal == null) {
            internal = new Hashtable<CheckBox, String>();
            this.comps.put(key, internal);
        }
        internal.put(cb, value);
    }

    void addRadioButton(String key, RadioButton rb, String value) {
        if (rb.isSelected()) {
            this.defaultCheckedButtons.addElement(rb);
        } else {
            this.defaultUncheckedButtons.addElement(rb);
        }
        if (key == null) {
            return;
        }
        Hashtable<RadioButton, String> internal = (Hashtable<RadioButton, String>)this.comps.get(key);
        ButtonGroup group = null;
        if (internal == null) {
            internal = new Hashtable<RadioButton, String>();
            this.comps.put(key, internal);
            group = new ButtonGroup();
            this.buttonGroups.put(key, group);
        } else {
            group = (ButtonGroup)this.buttonGroups.get(key);
        }
        group.add(rb);
        internal.put(rb, value);
    }

    int getNumFields() {
        return this.comps.size();
    }

    void submit(String submitKey, String submitVal) {
        if (this.action == null) {
            return;
        }
        boolean error = false;
        String url = this.action;
        String params = null;
        if (this.comps.size() > 0) {
            params = "";
            Enumeration e = this.comps.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object input = this.comps.get(key);
                key = HTMLUtils.encodeString(key);
                String value = "";
                if (input instanceof String) {
                    value = HTMLUtils.encodeString((String)input);
                    params = params + key + "=" + value + "&";
                    continue;
                }
                if (input instanceof Hashtable) {
                    Hashtable options = (Hashtable)input;
                    Enumeration e2 = options.keys();
                    while (e2.hasMoreElements()) {
                        Button b = (Button)e2.nextElement();
                        if (!b.isSelected()) continue;
                        params = params + key + "=" + HTMLUtils.encodeString((String)options.get(b)) + "&";
                    }
                    continue;
                }
                if (input instanceof TextArea) {
                    HTMLInputFormat inputFormat;
                    TextArea tf = (TextArea)input;
                    String text = tf.getText();
                    String errorMsg = null;
                    boolean ok = false;
                    if (text.equals("")) {
                        if (this.emptyNotOk.contains(tf)) {
                            errorMsg = this.htmlC.getUIManager().localize("html.format.emptynotok", "Field can't be empty");
                            error = true;
                        } else if (this.emptyOk.contains(tf)) {
                            ok = true;
                        }
                    }
                    if (!(error || ok || (inputFormat = (HTMLInputFormat)this.inputFormats.get(tf)) == null || inputFormat.verifyString(text))) {
                        String emptyStr = "";
                        if (this.emptyOk.contains(tf)) {
                            emptyStr = this.htmlC.getUIManager().localize("html.format.oremptyok", " or an empty string");
                        } else if (this.emptyNotOk.contains(tf)) {
                            emptyStr = this.htmlC.getUIManager().localize("html.format.andemptynotok", " and cannot be an empty string");
                        }
                        errorMsg = this.htmlC.getUIManager().localize("html.format.errordesc", "Malformed text. Correct value: ") + inputFormat.toString() + emptyStr;
                        error = true;
                    }
                    if (this.htmlC.getHTMLCallback() != null) {
                        int type = 0;
                        if ((tf.getConstraint() & 0x10000) != 0) {
                            type = 1;
                        }
                        text = this.htmlC.getHTMLCallback().fieldSubmitted(this.htmlC, tf, url, key, text, type, errorMsg);
                    }
                    if (errorMsg != null) continue;
                    params = params + key + "=" + HTMLUtils.encodeString(text) + "&";
                    continue;
                }
                if (input instanceof ComboBox) {
                    Object item = ((ComboBox)input).getSelectedItem();
                    if (!(item instanceof OptionItem)) continue;
                    value = ((OptionItem)item).getValue();
                    params = params + key + "=" + HTMLUtils.encodeString(value) + "&";
                    continue;
                }
                if (!(input instanceof MultiComboBox)) continue;
                Vector selected = ((MultiComboBox)input).getSelected();
                for (int i = 0; i < selected.size(); ++i) {
                    Object item = selected.elementAt(i);
                    if (!(item instanceof OptionItem)) continue;
                    value = ((OptionItem)item).getValue();
                    params = params + key + "=" + HTMLUtils.encodeString(value) + "&";
                }
            }
            if (params.endsWith("&")) {
                params = params.substring(0, params.length() - 1);
            }
        }
        if (submitKey != null) {
            if (params == null) {
                params = "";
            }
            if (!params.equals("")) {
                params = params + "&";
            }
            params = params + HTMLUtils.encodeString(submitKey) + "=" + HTMLUtils.encodeString(submitVal);
        }
        if (!error) {
            DocumentInfo docInfo = new DocumentInfo(url, params, this.isPostMethod);
            if (this.encType != null && !this.encType.equals("")) {
                docInfo.setEncoding(this.encType);
            }
            this.htmlC.setPage(docInfo);
        }
    }

    void reset() {
        Button b;
        Enumeration<Object> e = this.defaultValues.keys();
        while (e.hasMoreElements()) {
            Object defVal;
            Object input = e.nextElement();
            if (input instanceof TextArea) {
                defVal = (String)this.defaultValues.get(input);
                if (defVal == null) {
                    defVal = "";
                }
                ((TextArea)input).setText((String)defVal);
                continue;
            }
            if (!(input instanceof ComboBox)) continue;
            defVal = (OptionItem)this.defaultValues.get(input);
            ComboBox combo = (ComboBox)input;
            if (defVal != null) {
                combo.setSelectedItem(defVal);
                continue;
            }
            if (combo.size() <= 0) continue;
            combo.setSelectedIndex(0);
        }
        e = this.defaultCheckedButtons.elements();
        while (e.hasMoreElements()) {
            b = (Button)e.nextElement();
            if (b.isSelected()) continue;
            this.setButton(b, true);
        }
        e = this.defaultUncheckedButtons.elements();
        while (e.hasMoreElements()) {
            b = (Button)e.nextElement();
            if (!b.isSelected()) continue;
            this.setButton(b, false);
        }
    }

    private void setButton(Button button, boolean checkedX) {
        if (button instanceof RadioButton) {
            ((RadioButton)button).setSelected(checkedX);
        } else {
            ((CheckBox)button).setSelected(checkedX);
        }
    }

    class NamedCommand
    extends Command {
        HTMLForm htmlForm;
        String key;
        String value;
        boolean isSubmit;

        NamedCommand(String key, String value, HTMLForm htmlForm, boolean isSubmit) {
            super(value);
            this.key = key;
            this.htmlForm = htmlForm;
            this.value = value;
            this.isSubmit = isSubmit;
        }

        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            if (this.isSubmit) {
                this.htmlForm.submit(this.key, this.value);
            } else {
                this.htmlForm.reset();
            }
        }

        public void setCommandName(String name) {
            this.value = name;
        }

        public String getCommandName() {
            return this.value;
        }
    }
}

