/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.html;

import com.codename1.io.ConnectionRequest;
import com.codename1.io.FileSystemStorage;
import com.codename1.io.Log;
import com.codename1.io.NetworkManager;
import com.codename1.ui.html.DefaultDocumentRequestHandler;
import com.codename1.ui.html.DocumentInfo;
import com.codename1.ui.html.IOCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class AsyncDocumentRequestHandlerImpl
extends DefaultDocumentRequestHandler {
    protected static final Object LOCK = new Object();

    public void resourceRequestedAsync(DocumentInfo docInfo, IOCallback callback) {
        String url = docInfo.getUrl();
        if (url.startsWith("jar://") || url.startsWith("res://") || url.startsWith("local://")) {
            super.resourceRequestedAsync(docInfo, callback);
            return;
        }
        this.visitingURL(url);
        this.resourceRequested(docInfo, callback);
    }

    public InputStream resourceRequested(DocumentInfo docInfo) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream resourceRequested(DocumentInfo docInfo, IOCallback callback) {
        try {
            if (docInfo.getUrl().startsWith("file://")) {
                String url = docInfo.getUrl();
                int hash = url.indexOf(35);
                if (hash != -1) {
                    url = url.substring(0, hash);
                }
                callback.streamReady(FileSystemStorage.getInstance().openInputStream(url), docInfo);
                return null;
            }
        }
        catch (IOException ex) {
            Log.e(ex);
        }
        Object[] response = new Object[1];
        ConnectionRequest reqest = this.createConnectionRequest(docInfo, callback, response);
        reqest.setPost(docInfo.isPostRequest());
        if (docInfo.isPostRequest()) {
            reqest.setUrl(docInfo.getUrl());
            reqest.setWriteRequest(true);
        } else {
            reqest.setUrl(docInfo.getFullUrl());
        }
        NetworkManager.getInstance().addToQueue(reqest);
        if (callback == null) {
            Object object = LOCK;
            synchronized (object) {
                while (response[0] == null) {
                    try {
                        LOCK.wait(50L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                if (response[0] instanceof InputStream) {
                    return (InputStream)response[0];
                }
                if (response[0] instanceof Throwable) {
                    ((Throwable)response[0]).printStackTrace();
                }
            }
        }
        return null;
    }

    protected ConnectionRequest createConnectionRequest(final DocumentInfo docInfo, final IOCallback callback, final Object[] response) {
        return new ConnectionRequest(){

            protected void buildRequestBody(OutputStream os) throws IOException {
                if (this.isPost() && docInfo.getParams() != null) {
                    OutputStreamWriter w = new OutputStreamWriter(os, docInfo.getEncoding());
                    w.write(docInfo.getParams());
                }
            }

            protected void handleIOException(IOException err) {
                if (callback == null) {
                    response[0] = err;
                }
                super.handleIOException(err);
            }

            protected boolean shouldAutoCloseResponse() {
                return callback != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void readResponse(InputStream input) throws IOException {
                if (callback != null) {
                    callback.streamReady(input, docInfo);
                } else {
                    response[0] = input;
                    Object object = LOCK;
                    synchronized (object) {
                        LOCK.notify();
                    }
                }
            }
        };
    }
}

