/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maps;

import com.codename1.location.Location;
import com.codename1.location.LocationManager;
import com.codename1.maps.BoundingBox;
import com.codename1.maps.CacheProviderProxy;
import com.codename1.maps.Coord;
import com.codename1.maps.LayerWithZoomLevels;
import com.codename1.maps.MapListener;
import com.codename1.maps.Mercator;
import com.codename1.maps.PositionedTile;
import com.codename1.maps.Tile;
import com.codename1.maps.layers.Layer;
import com.codename1.maps.layers.PointsLayer;
import com.codename1.maps.providers.MapProvider;
import com.codename1.maps.providers.OpenStreetMapProvider;
import com.codename1.ui.Button;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.ImageFactory;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Point;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.UITimer;
import com.codename1.util.MathUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class MapComponent
extends Container {
    private Coord _center;
    private int _zoom;
    private MapProvider _map;
    private Vector _layers;
    private boolean _debugInfo = false;
    private boolean _needTiles = true;
    private int draggedx;
    private int draggedy;
    private int pressedx;
    private int pressedy;
    private Vector _tiles;
    private Point _delta = null;
    private double latitude = Double.NaN;
    private double longitude = Double.NaN;
    private boolean drawMapPointer = false;
    private double oldDistance = -1.0;
    private Image buffer = null;
    private boolean refreshLayers = false;
    private int scaleX = 0;
    private int scaleY = 0;
    private int translateX;
    private int translateY;
    private int zoomCenterX = 0;
    private int zoomCenterY = 0;
    private long lastPressed = -1L;
    private int tapCount = 0;
    private int singleTapThreshold = 200;
    private int doubleTapThreshold = 200;
    private static Font attributionFont = Font.createSystemFont(64, 2, 8);
    private ArrayList<MapListener> listeners;

    public MapComponent() {
        this(new OpenStreetMapProvider());
    }

    public MapComponent(MapProvider provider) {
        this(provider, (Coord)null, 4, true);
    }

    public MapComponent(MapProvider provider, Location centerPosition, int zoomLevel) {
        this(provider, centerPosition, zoomLevel, true);
    }

    public MapComponent(MapProvider provider, Location centerPosition, int zoomLevel, boolean cacheEnabled) {
        this(provider, new Coord(centerPosition.getLatitude(), centerPosition.getLongitude()), zoomLevel, cacheEnabled);
    }

    public MapComponent(MapProvider provider, Coord centerPosition, int zoomLevel) {
        this(provider, centerPosition, zoomLevel, true);
    }

    public MapComponent(MapProvider provider, Coord centerPosition, int zoomLevel, boolean cacheEnabled) {
        Coord p;
        Location l;
        this._map = cacheEnabled ? new CacheProviderProxy(provider) : provider;
        this._center = centerPosition == null ? ((l = LocationManager.getLocationManager().getLastKnownLocation()) != null ? ((p = new Coord(l.getLatitude(), l.getLongitude())).isProjected() ? p : this._map.projection().fromWGS84(p)) : new Coord(0.0, 0.0, true)) : (centerPosition.isProjected() ? centerPosition : this._map.projection().fromWGS84(centerPosition));
        this._zoom = zoomLevel;
        this._layers = new Vector();
        this.setFocusable(false);
        if (Display.getInstance().isTouchScreenDevice() && this.getUIManager().isThemeConstant("mapZoomButtonsBool", true)) {
            this.setLayout(new BorderLayout());
            Container buttonsbar = new Container(new FlowLayout(3));
            Button out = new Button("-");
            out.setUIID("MapZoomOut");
            out.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MapComponent.this.zoomOut();
                    MapComponent.this.repaint();
                    MapComponent.this.fireMapListenerEvent();
                }
            });
            buttonsbar.addComponent(out);
            Button in = new Button("+");
            in.setUIID("MapZoomIn");
            in.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MapComponent.this.zoomIn();
                    MapComponent.this.repaint();
                    MapComponent.this.fireMapListenerEvent();
                }
            });
            buttonsbar.addComponent(in);
            this.addComponent("South", (Component)buttonsbar);
        }
        this.drawMapPointer = UIManager.getInstance().isThemeConstant("drawMapPointerBool", false);
    }

    public void paintBackground(Graphics g) {
        super.paintBackground(g);
        if (Display.getInstance().areMutableImagesFast()) {
            if (this.buffer == null) {
                this.buffer = ImageFactory.createImage(this, this.getWidth(), this.getHeight(), 0);
            }
            if (this._needTiles || this.refreshLayers) {
                this.paintmap(this.buffer.getGraphics());
                this.refreshLayers = false;
            }
            g.translate(-this.translateX, -this.translateY);
            if (this.scaleX > 0) {
                float tx = (float)this.zoomCenterX / (float)this.getWidth();
                float ty = (float)this.zoomCenterY / (float)this.getHeight();
                g.drawImage(this.buffer, -((int)(tx *= (float)(this.scaleX - this.getWidth()))), -((int)(ty *= (float)(this.scaleY - this.getHeight()))), this.scaleX, this.scaleY);
            } else {
                g.drawImage(this.buffer, (this.getWidth() - this.buffer.getWidth()) / 2, (this.getHeight() - this.buffer.getHeight()) / 2);
            }
            g.translate(this.translateX, this.translateY);
        } else {
            int clipx = g.getClipX();
            int clipy = g.getClipY();
            int clipw = g.getClipWidth();
            int cliph = g.getClipHeight();
            if (this.scaleX > 0) {
                float sx = (float)this.scaleX / (float)this.getWidth();
                float sy = (float)this.scaleY / (float)this.getHeight();
                float tx = (float)this.zoomCenterX / (float)this.getWidth();
                tx = -tx * (float)(this.scaleX - this.getWidth()) / sx;
                float ty = (float)this.zoomCenterY / (float)this.getHeight();
                ty = -ty * (float)(this.scaleY - this.getHeight()) / sy;
                g.translate((int)tx, (int)ty);
                g.scale(sx, sy);
                this.paintmap(g);
                g.resetAffine();
                g.translate(-((int)tx), -((int)ty));
            } else {
                g.translate(-this.translateX, -this.translateY);
                this.paintmap(g);
                g.translate(this.translateX, this.translateY);
            }
            g.setClip(clipx, clipy, clipw, cliph);
        }
    }

    protected void laidOut() {
        super.laidOut();
        this.refreshLayers = true;
        this._needTiles = true;
        this.buffer = null;
    }

    protected boolean shouldBlockSideSwipe() {
        return true;
    }

    protected Dimension calcPreferredSize() {
        return new Dimension(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
    }

    protected void focusGained() {
        this.setHandlesInput(true);
    }

    public void pointerDragged(int x, int y) {
        super.pointerDragged(x, y);
        if (this.oldDistance == -1.0) {
            this.translateX += this.draggedx - x;
            this.translateY += this.draggedy - y;
            this.draggedx = x;
            this.draggedy = y;
            if (Math.abs(this.translateX) > 10 || Math.abs(this.translateY) > 10) {
                Coord scale = this._map.scale(this._zoom);
                this._center = this._center.translate((double)this.translateY * -scale.getLatitude(), (double)this.translateX * scale.getLongitude());
                this._needTiles = true;
                this.translateX = 0;
                this.translateY = 0;
            }
        }
        super.repaint();
    }

    public void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.lastPressed = System.currentTimeMillis();
        this.pressedx = x;
        this.pressedy = y;
        this.draggedx = x;
        this.draggedy = y;
    }

    public void pointerDragged(int[] x, int[] y) {
        if (x.length > 1) {
            double currentDis = this.distance(x, y);
            if (this.oldDistance == -1.0) {
                this.oldDistance = currentDis;
                this.zoomCenterX = (x[0] + x[1]) / 2 - this.getAbsoluteX();
                this.zoomCenterY = (y[0] + y[1]) / 2 - this.getAbsoluteY();
                this.scaleX = this.getWidth();
                this.scaleY = this.getHeight();
            }
            if (Math.abs(currentDis - this.oldDistance) > 10.0) {
                double scale = currentDis / this.oldDistance;
                if (scale > 1.0) {
                    if (this._zoom == this.getProvider().maxZoomLevel()) {
                        this.scaleX = 0;
                        this.scaleY = 0;
                        this.oldDistance = -1.0;
                        return;
                    }
                } else if (this._zoom == this.getProvider().minZoomLevel()) {
                    this.scaleX = 0;
                    this.scaleY = 0;
                    this.oldDistance = -1.0;
                    return;
                }
                this.scaleX = (int)(scale * (double)this.scaleX);
                this.scaleY = (int)(scale * (double)this.scaleY);
                this.oldDistance = currentDis;
                super.repaint();
            }
        } else {
            super.pointerDragged(x, y);
        }
    }

    private double distance(int[] x, int[] y) {
        int disx = x[0] - x[1];
        int disy = y[0] - y[1];
        return Math.sqrt(disx * disx + disy * disy);
    }

    protected void pointerTapped(int x, int y, int tapCount) {
        if (tapCount == 2) {
            Coord c = this.getCoordFromPosition(x, y);
            this._center = this._map.projection().fromWGS84(c);
            this.zoomIn();
            super.repaint();
        }
    }

    public void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        long currTime = System.currentTimeMillis();
        if (currTime - this.lastPressed < (long)this.singleTapThreshold) {
            ++this.tapCount;
            final int tapX = x;
            final int tapY = y;
            final int currTapCount = this.tapCount;
            UITimer timer = new UITimer(new Runnable(){

                public void run() {
                    if (currTapCount == MapComponent.this.tapCount) {
                        MapComponent.this.pointerTapped(tapX, tapY, MapComponent.this.tapCount);
                        MapComponent.this.tapCount = 0;
                    }
                }
            });
            timer.schedule(this.doubleTapThreshold, false, this.getComponentForm());
        } else {
            this.tapCount = 0;
        }
        if (this.oldDistance != -1.0) {
            double scale = (double)this.scaleX / (double)this.getWidth();
            Coord refCoord = this.getCoordFromPosition(this.zoomCenterX + this.getAbsoluteX(), this.zoomCenterY + this.getAbsoluteY());
            int oldZoom = this._zoom;
            if (scale > 1.0) {
                if (!(scale < 1.2)) {
                    if (scale < 1.6) {
                        this.zoomIn();
                    } else if (scale < 2.0) {
                        this.zoomIn();
                        this.zoomIn();
                    } else if (scale < 2.4) {
                        this.zoomIn();
                        this.zoomIn();
                        this.zoomIn();
                    } else {
                        this.zoomIn();
                        this.zoomIn();
                        this.zoomIn();
                        this.zoomIn();
                    }
                }
            } else if (!(scale > 0.8)) {
                if (scale > 0.5) {
                    this.zoomOut();
                } else if (scale > 0.2) {
                    this.zoomOut();
                    this.zoomOut();
                } else {
                    this.zoomOut();
                    this.zoomOut();
                    this.zoomOut();
                }
            }
            if (oldZoom != this._zoom) {
                Coord c1 = this.getCoordFromPosition(0, 0);
                Coord c2 = this.getCoordFromPosition(this.getWidth(), this.getHeight());
                Coord pixelToCoord = new Coord((c2.getLatitude() - c1.getLatitude()) / (double)this.getHeight(), (c2.getLongitude() - c1.getLongitude()) / (double)this.getWidth());
                float offX = this.getWidth() / 2 - this.zoomCenterX;
                float offY = this.getHeight() / 2 - this.zoomCenterY;
                this._center = this._map.projection().fromWGS84(refCoord.translate((double)offY * pixelToCoord.getLatitude(), (double)offX * pixelToCoord.getLongitude()));
            }
            this.translateX = 0;
            this.translateY = 0;
            this.scaleX = 0;
            this.scaleY = 0;
            this.oldDistance = -1.0;
            if (this.buffer != null) {
                this.buffer = null;
                this.refreshLayers = true;
            }
            if (Display.getInstance().areMutableImagesFast()) {
                super.repaint();
            } else {
                this.getComponentForm().repaint();
            }
            this.fireMapListenerEvent();
            return;
        }
        Coord scale = this._map.scale(this._zoom);
        this._center = this._center.translate((double)this.translateY * -scale.getLatitude(), (double)this.translateX * scale.getLongitude());
        this._needTiles = true;
        this.translateX = 0;
        this.translateY = 0;
        Tile t = this.screenTile();
        Coord southWest = t.position((x -= this.getAbsoluteX()) - 20, t.dimension().getHeight() - (y -= this.getAbsoluteY()) - 20);
        Coord c = Mercator.inverseMercator(southWest.getLatitude(), southWest.getLongitude());
        Coord northEast = t.position(x + 20, t.dimension().getHeight() - y + 20);
        c = Mercator.inverseMercator(northEast.getLatitude(), northEast.getLongitude());
        BoundingBox bbox = new BoundingBox(southWest, northEast);
        Enumeration e = this._layers.elements();
        while (e.hasMoreElements()) {
            LayerWithZoomLevels layer = (LayerWithZoomLevels)e.nextElement();
            if (!(layer.layer instanceof PointsLayer)) continue;
            ((PointsLayer)layer.layer).fireActionEvent(bbox);
        }
        super.repaint();
        this.fireMapListenerEvent();
    }

    public Coord getCoordFromPosition(int x, int y) {
        Tile t = this.screenTile();
        Coord c = t.position(x -= this.getAbsoluteX(), t.dimension().getHeight() - (y -= this.getAbsoluteY()));
        return this._map.projection().toWGS84(c);
    }

    public Point getPointFromCoord(Coord coord) {
        if (!coord.isProjected()) {
            coord = this._map.projection().fromWGS84(coord);
        }
        return this.screenTile().pointPosition(coord);
    }

    public void keyPressed(int keyCode) {
        int oldZoom = this._zoom;
        Coord oldCenter = this._center;
        if (this.isLeftKey(keyCode)) {
            this.moveLeft();
        } else if (this.isRightKey(keyCode)) {
            this.moveRight();
        } else if (this.isDownKey(keyCode)) {
            this.moveDown();
        } else if (this.isUpKey(keyCode)) {
            this.moveUp();
        }
        if (!this._map.projection().extent().contains(this._center)) {
            this._center = oldCenter;
        }
        if (this.isZoomInKey(keyCode)) {
            this.zoomIn();
        }
        if (this.isZoomOutKey(keyCode)) {
            this.zoomOut();
        }
        if (this.isZoomToLayersKey(keyCode)) {
            this.zoomToLayers();
        }
        super.keyPressed(keyCode);
        if (this._center != oldCenter || this._zoom != oldZoom) {
            this._needTiles = true;
        }
        super.repaint();
        this.fireMapListenerEvent();
    }

    private void paintmap(Graphics g) {
        g.translate(this.getX(), this.getY());
        if (this._needTiles) {
            this.getTiles();
            this._needTiles = false;
        }
        this.drawTiles(g);
        this.drawLayers(g);
        if (this._debugInfo) {
            this.drawDebug(g);
        }
        this.drawPointer(g);
        this.drawAttribution(g, this._map.attribution());
        g.translate(-this.getX(), -this.getY());
    }

    private Tile screenTile() {
        Dimension componentDimension = new Dimension(this.getWidth(), this.getHeight());
        Coord southWest = this._map.translate(this._center, this._zoom, -this.getWidth() / 2, -this.getHeight() / 2);
        Coord northEast = this._map.translate(this._center, this._zoom, this.getWidth() / 2, this.getHeight() / 2);
        BoundingBox bbox = new BoundingBox(southWest, northEast);
        return new Tile(componentDimension, bbox, null);
    }

    private void getTiles() throws RuntimeException {
        this._tiles = new Vector();
        Dimension tileSize = this._map.tileSize();
        int posY = 0;
        this._delta = null;
        while (posY - tileSize.getHeight() < this.getHeight()) {
            int posX = 0;
            while (posX - tileSize.getWidth() < this.getWidth()) {
                Coord cur = this._map.translate(this._center, this._zoom, posX - this.getWidth() / 2, this.getHeight() / 2 - posY);
                if (this._map.projection().extent().contains(cur)) {
                    Tile tile = this._map.tileFor(this._map.bboxFor(cur, this._zoom));
                    if (this._delta == null) {
                        this._delta = tile.pointPosition(cur);
                    }
                    tile.setsTileReadyListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            MapComponent.this.refreshLayers = true;
                            MapComponent.this.repaint();
                        }
                    });
                    this._tiles.addElement(new PositionedTile(new Point(posX, posY), tile));
                }
                posX += tileSize.getWidth();
            }
            posY += tileSize.getHeight();
        }
    }

    private void drawTiles(Graphics g) {
        if (this._delta == null) {
            System.out.println("Delta is null!");
            return;
        }
        Enumeration e = this._tiles.elements();
        g.translate(-this._delta.getX(), -this._delta.getY());
        while (e.hasMoreElements()) {
            PositionedTile pt = (PositionedTile)e.nextElement();
            pt.tile().paint(g, pt.position().getX(), pt.position().getY());
        }
        g.translate(this._delta.getX(), this._delta.getY());
    }

    private void drawAttribution(Graphics g, String attribution) {
        if (attribution == null) {
            return;
        }
        g.setColor(0);
        g.setFont(attributionFont);
        Font f = g.getFont();
        g.drawString(attribution, this.getWidth() - f.stringWidth(attribution) - 2, this.getHeight() - f.getHeight() - 2);
    }

    private void drawLayers(Graphics g) {
        Enumeration e = this._layers.elements();
        Tile screenTile = this.screenTile();
        while (e.hasMoreElements()) {
            LayerWithZoomLevels layer = (LayerWithZoomLevels)e.nextElement();
            if (this._zoom < layer.minZoomLevel || this._zoom > layer.maxZoomLevel) continue;
            layer.layer.paint(g, screenTile);
        }
    }

    private void drawPointer(Graphics g) {
        if (this.drawMapPointer) {
            g.setColor(0xFF0000);
            int centerX = this.getWidth() / 2;
            int centerY = this.getHeight() / 2;
            int halfSize = 5;
            g.drawRoundRect(centerX - halfSize, centerY - halfSize, 2 * halfSize, 2 * halfSize, halfSize, halfSize);
        }
    }

    private void drawDebug(Graphics g) {
        g.setColor(0);
        g.setFont(Font.createSystemFont(64, 0, 0));
        g.drawString(this._map.projection().toWGS84(this._center).toString(), 5, 5);
        g.drawString("Zoom:" + this._zoom, 5, 5 + g.getFont().getHeight());
        for (int i = 0; i < this._layers.size(); ++i) {
            LayerWithZoomLevels lwzl = (LayerWithZoomLevels)this._layers.elementAt(i);
            g.drawString("Layer " + lwzl.layer.getName(), 5, 5 + (i + 2) * g.getFont().getHeight());
        }
    }

    public void addLayer(Layer layer) {
        this.addLayer(layer, 0, this._map.maxZoomLevel());
    }

    public void addLayer(Layer layer, int minZoomLevel, int maxZoomLevel) {
        this._layers.addElement(new LayerWithZoomLevels(layer, minZoomLevel, maxZoomLevel));
        this.refreshLayers = true;
        super.repaint();
    }

    public void removeLayer(Layer layer) {
        int no;
        int length = this._layers.size();
        for (no = 0; no < length && ((LayerWithZoomLevels)this._layers.elementAt((int)no)).layer != layer; ++no) {
        }
        this._layers.removeElementAt(no);
        this.refreshLayers = true;
        super.repaint();
    }

    public void removeAllLayers() {
        this._layers.removeAllElements();
        this.refreshLayers = true;
        super.repaint();
    }

    public int getLayersConut() {
        return this._layers.size();
    }

    public Layer getLayerAt(int index) {
        Layer l = ((LayerWithZoomLevels)this._layers.elementAt((int)index)).layer;
        return l;
    }

    public MapProvider getProvider() {
        return this._map;
    }

    public void repaint() {
        this.refreshLayers = true;
        this._needTiles = true;
        super.repaint();
    }

    public void moveLeft() {
        Coord scale = this._map.scale(this._zoom);
        double partX = 1.0 * (double)this.getWidth() / 4.0;
        this._center = this._center.translate(0.0, partX * -scale.getLongitude());
        this._needTiles = true;
    }

    public void moveRight() {
        Coord scale = this._map.scale(this._zoom);
        double partX = 1.0 * (double)this.getWidth() / 4.0;
        this._center = this._center.translate(0.0, partX * scale.getLongitude());
        this._needTiles = true;
    }

    public void moveUp() {
        Coord scale = this._map.scale(this._zoom);
        double partY = 1.0 * (double)this.getHeight() / 4.0;
        this._center = this._center.translate(partY * scale.getLatitude(), 0.0);
        this._needTiles = true;
    }

    public void moveDown() {
        Coord scale = this._map.scale(this._zoom);
        double partY = 1.0 * (double)this.getHeight() / 4.0;
        this._center = this._center.translate(partY * -scale.getLatitude(), 0.0);
        this._needTiles = true;
    }

    public void zoomIn() {
        if (this._zoom < this._map.maxZoomLevel()) {
            ++this._zoom;
            this._needTiles = true;
        }
    }

    public void zoomOut() {
        if (this._zoom > this._map.minZoomLevel()) {
            --this._zoom;
            this._needTiles = true;
        }
    }

    public void zoomTo(BoundingBox boundingBox) {
        if (boundingBox.projected()) {
            throw new IllegalArgumentException("boundingBox should be wg84 format");
        }
        Dimension dimension = null;
        dimension = this.getWidth() == 0 || this.getHeight() == 0 ? this.getPreferredSize() : new Dimension(this.getWidth(), this.getHeight());
        BoundingBox projectedBBOX = this._map.projection().fromWGS84(boundingBox);
        Tile tile = new Tile(dimension, projectedBBOX, null);
        this._zoom = this._map.maxZoomFor(tile);
        this._center = tile.position(tile.dimension().getWidth() / 2, tile.dimension().getHeight() / 2);
        this._needTiles = true;
        super.repaint();
    }

    public void zoomTo(Coord coord, int zoomLevel) {
        if (coord.isProjected()) {
            throw new IllegalArgumentException("coord should be wg84 format");
        }
        this._center = this._map.projection().fromWGS84(coord);
        this._zoom = zoomLevel;
        this._needTiles = true;
        super.repaint();
    }

    public void zoomToLayers() {
        BoundingBox bbox = null;
        Enumeration e = this._layers.elements();
        while (e.hasMoreElements()) {
            LayerWithZoomLevels layer = (LayerWithZoomLevels)e.nextElement();
            BoundingBox layerBbox = layer.layer.boundingBox();
            if (layerBbox == null) continue;
            if (bbox == null) {
                bbox = layerBbox;
                continue;
            }
            bbox = bbox.extend(layerBbox);
        }
        if (bbox != null) {
            if (bbox.projected()) {
                bbox = this._map.projection().toWGS84(bbox);
            }
            this.zoomTo(bbox);
        }
        this._needTiles = true;
    }

    public Coord getCenter() {
        return this._map.projection().toWGS84(this._center);
    }

    public int getZoomLevel() {
        return this._zoom;
    }

    public void setZoomLevel(int zoom) {
        if (zoom <= this.getMaxZoomLevel() && zoom >= this.getMinZoomLevel()) {
            this._zoom = zoom;
            this._needTiles = true;
            super.repaint();
        } else {
            System.out.println("zoom level must be bigger then the min zoom level and smaller then the max zoom level");
        }
    }

    public int getMaxZoomLevel() {
        return this._map.maxZoomLevel();
    }

    public int getMinZoomLevel() {
        return this._map.minZoomLevel();
    }

    public Coord center() {
        return this._map.projection().toWGS84(this._center);
    }

    protected boolean isLeftKey(int keyCode) {
        int game = Display.getInstance().getGameAction(keyCode);
        return game == 2;
    }

    protected boolean isRightKey(int keyCode) {
        int game = Display.getInstance().getGameAction(keyCode);
        return game == 5;
    }

    protected boolean isDownKey(int keyCode) {
        int game = Display.getInstance().getGameAction(keyCode);
        return game == 6;
    }

    protected boolean isUpKey(int keyCode) {
        int game = Display.getInstance().getGameAction(keyCode);
        return game == 1;
    }

    protected boolean isZoomInKey(int keyCode) {
        return keyCode == 49;
    }

    protected boolean isZoomOutKey(int keyCode) {
        return keyCode == 51;
    }

    protected boolean isZoomToLayersKey(int keyCode) {
        return keyCode == 53;
    }

    public static long distance(double latitude1, double longitude1, double latitude2, double longitude2) {
        double latitudeSin = Math.sin(Math.toRadians(latitude2 - latitude1) / 2.0);
        double longitudeSin = Math.sin(Math.toRadians(longitude2 - longitude1) / 2.0);
        double a = latitudeSin * latitudeSin + Math.cos(Math.toRadians(latitude1)) * Math.cos(Math.toRadians(latitude2)) * longitudeSin * longitudeSin;
        double c = 2.0 * MathUtil.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return (long)(6378137.0 * c);
    }

    private void setLatitude(double latitude) {
        this.latitude = latitude;
        this.setCoord(latitude, this.longitude);
    }

    private void setLongitude(double longitude) {
        this.longitude = longitude;
        this.setCoord(this.latitude, longitude);
    }

    private void setCoord(double latitude, double longitude) {
        if (Double.isNaN(latitude) && Double.isNaN(longitude)) {
            this._center = this._map.projection().fromWGS84(new Coord(latitude, longitude));
            this._needTiles = true;
            super.repaint();
        }
    }

    private void fireMapListenerEvent() {
        if (this.listeners != null) {
            for (MapListener l : this.listeners) {
                l.mapPositionUpdated(this, this._zoom, this.getCenter());
            }
        }
    }

    public void addMapListener(MapListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeMapListener(MapListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public String[] getPropertyNames() {
        return new String[]{"latitude", "longitude", "zoom"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{Double.class, Double.class, Integer.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("latitude")) {
            Coord c = this._map.projection().toWGS84(this._center);
            return new Double(c.getLatitude());
        }
        if (name.equals("longitude")) {
            Coord c = this._map.projection().toWGS84(this._center);
            return new Double(c.getLongitude());
        }
        if (name.equals("zoom")) {
            return new Integer(this.getZoomLevel());
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("latitude")) {
            this.setLatitude((Double)value);
            return null;
        }
        if (name.equals("longitude")) {
            this.setLongitude((Double)value);
            return null;
        }
        if (name.equals("zoom")) {
            this.setZoomLevel((Integer)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }
}

