/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.views;

import com.codename1.charts.compat.Canvas;
import com.codename1.charts.compat.GradientDrawable;
import com.codename1.charts.compat.Paint;
import com.codename1.charts.models.CategorySeries;
import com.codename1.charts.models.Point;
import com.codename1.charts.models.SeriesSelection;
import com.codename1.charts.renderers.DefaultRenderer;
import com.codename1.charts.renderers.SimpleSeriesRenderer;
import com.codename1.charts.views.PieMapper;
import com.codename1.charts.views.PkgUtils;
import com.codename1.charts.views.RoundChart;
import com.codename1.ui.geom.Rectangle2D;
import com.codename1.ui.geom.Shape;
import java.util.ArrayList;

public class PieChart
extends RoundChart {
    private PieMapper mPieMapper = new PieMapper();

    public PieChart(CategorySeries dataset, DefaultRenderer renderer) {
        super(dataset, renderer);
    }

    public void draw(Canvas canvas, int x, int y, int width, int height, Paint paint) {
        boolean loadPieCfg;
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int legendSize = this.getLegendSize(this.mRenderer, height / 5, 0.0f);
        int left = x;
        int top = y;
        int right = x + width;
        int sLength = this.mDataset.getItemCount();
        double total = 0.0;
        String[] titles = new String[sLength];
        for (int i = 0; i < sLength; ++i) {
            total += this.mDataset.getValue(i);
            titles[i] = this.mDataset.getCategory(i);
        }
        if (this.mRenderer.isFitLegend()) {
            legendSize = this.drawLegend(canvas, this.mRenderer, titles, left, right, y, width, height, legendSize, paint, true);
        }
        int bottom = y + height - legendSize;
        this.drawBackground(this.mRenderer, canvas, x, y, width, height, paint, false, 0);
        float currentAngle = this.mRenderer.getStartAngle();
        int mRadius = Math.min(Math.abs(right - left), Math.abs(bottom - top));
        int radius = (int)((double)mRadius * 0.35 * (double)this.mRenderer.getScale());
        if (this.autoCalculateCenter || this.mCenterX == Integer.MAX_VALUE) {
            this.mCenterX = (left + right) / 2;
        }
        if (this.autoCalculateCenter || this.mCenterY == Integer.MAX_VALUE) {
            this.mCenterY = (bottom + top) / 2;
        }
        this.mPieMapper.setDimensions(radius, this.mCenterX, this.mCenterY);
        boolean bl = loadPieCfg = !this.mPieMapper.areAllSegmentPresent(sLength);
        if (loadPieCfg) {
            this.mPieMapper.clearPieSegments();
        }
        float shortRadius = (float)radius * 0.9f;
        float longRadius = (float)radius * 1.1f;
        Rectangle2D oval = PkgUtils.makeRect(this.mCenterX - radius, this.mCenterY - radius, this.mCenterX + radius, this.mCenterY + radius);
        ArrayList<Rectangle2D> prevLabelsBounds = new ArrayList<Rectangle2D>();
        for (int i = 0; i < sLength; ++i) {
            SimpleSeriesRenderer seriesRenderer = this.mRenderer.getSeriesRendererAt(i);
            boolean gradient = false;
            GradientDrawable gradientDrawable = null;
            if (seriesRenderer.isGradientEnabled()) {
                gradient = true;
                gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{seriesRenderer.getGradientStartColor(), seriesRenderer.getGradientStopColor()});
                paint.setColor(seriesRenderer.getGradientStartColor());
            } else {
                paint.setColor(seriesRenderer.getColor());
            }
            float value = (float)this.mDataset.getValue(i);
            float angle = (float)((double)value / total * 360.0);
            if (seriesRenderer.isHighlighted()) {
                double rAngle = Math.toRadians(90.0f - (currentAngle + angle / 2.0f));
                float translateX = (float)((double)radius * 0.1 * Math.sin(rAngle));
                float translateY = (float)((double)radius * 0.1 * Math.cos(rAngle));
                oval.translate(translateX, translateY);
                if (gradient) {
                    canvas.drawArcWithGradient(oval, currentAngle, angle, true, paint, gradientDrawable);
                } else {
                    canvas.drawArc(oval, currentAngle, angle, true, paint);
                }
                oval.translate(-translateX, -translateY);
            } else if (gradient) {
                canvas.drawArcWithGradient(oval, currentAngle, angle, true, paint, gradientDrawable);
            } else {
                canvas.drawArc(oval, currentAngle, angle, true, paint);
            }
            paint.setColor(seriesRenderer.getColor());
            this.drawLabel(canvas, this.mDataset.getCategory(i), this.mRenderer, prevLabelsBounds, this.mCenterX, this.mCenterY, shortRadius, longRadius, currentAngle, angle, left, right, this.mRenderer.getLabelsColor(), paint, true, false);
            if (this.mRenderer.isDisplayValues()) {
                this.drawLabel(canvas, this.getLabel(this.mRenderer.getSeriesRendererAt(i).getChartValuesFormat(), this.mDataset.getValue(i)), this.mRenderer, prevLabelsBounds, this.mCenterX, this.mCenterY, shortRadius / 2.0f, longRadius / 2.0f, currentAngle, angle, left, right, this.mRenderer.getLabelsColor(), paint, false, true);
            }
            if (loadPieCfg) {
                this.mPieMapper.addPieSegment(i, value, currentAngle, angle);
            }
            currentAngle += angle;
        }
        prevLabelsBounds.clear();
        this.drawLegend(canvas, this.mRenderer, titles, left, right, y, width, height, legendSize, paint, false);
        this.drawTitle(canvas, x, y, width, paint);
    }

    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point screenPoint) {
        return this.mPieMapper.getSeriesAndPointForScreenCoordinate(screenPoint);
    }

    public Shape getSegmentShape(int pointIndex) {
        return this.mPieMapper.getSegmentShape(pointIndex);
    }
}

