/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.io.Log;
import com.codename1.io.SocketConnection;
import com.codename1.io.Util;
import com.codename1.ui.Display;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Socket {
    private Socket() {
    }

    public static boolean isSupported() {
        return Util.getImplementation().isSocketAvailable();
    }

    public static boolean isServerSocketSupported() {
        return Util.getImplementation().isServerSocketAvailable();
    }

    public static void connect(final String host, final int port, final SocketConnection sc) {
        if (host.indexOf(46) > -1 && host.indexOf(58) > -1) {
            throw new IllegalArgumentException("Port should be provided separately");
        }
        Display.getInstance().startThread(new Runnable(){

            public void run() {
                Object connection = Util.getImplementation().connectSocket(host, port, sc.getConnectTimeout());
                if (connection != null) {
                    sc.setConnected(true);
                    sc.input = new SocketInputStream(connection, sc);
                    sc.output = new SocketOutputStream(connection, sc);
                    sc.connectionEstablished(sc.input, sc.output);
                } else {
                    sc.setConnected(false);
                    if (connection == null) {
                        sc.connectionError(-1, "Failed to connect");
                    } else {
                        sc.connectionError(Util.getImplementation().getSocketErrorCode(connection), Util.getImplementation().getSocketErrorMessage(connection));
                    }
                }
            }
        }, "Connection to " + host).start();
    }

    public static Close connectWithClose(final String host, final int port, final SocketConnection sc) {
        if (host.indexOf(46) > -1 && host.indexOf(58) > -1) {
            throw new IllegalArgumentException("Port should be provided separately");
        }
        final Object[] connection = new Object[1];
        Display.getInstance().startThread(new Runnable(){

            public void run() {
                connection[0] = Util.getImplementation().connectSocket(host, port, sc.getConnectTimeout());
                if (connection[0] != null) {
                    sc.setConnected(true);
                    sc.input = new SocketInputStream(connection[0], sc);
                    sc.output = new SocketOutputStream(connection[0], sc);
                    sc.connectionEstablished(sc.input, sc.output);
                } else {
                    sc.setConnected(false);
                    if (connection[0] == null) {
                        sc.connectionError(-1, "Failed to connect");
                    } else {
                        sc.connectionError(Util.getImplementation().getSocketErrorCode(connection[0]), Util.getImplementation().getSocketErrorMessage(connection[0]));
                    }
                }
            }
        }, "Connection to " + host).start();
        return new Close(){

            public void close() throws IOException {
                while (connection[0] == null) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        Log.e(e);
                        throw new RuntimeException(e.getMessage());
                    }
                }
                if (Util.getImplementation().isSocketConnected(connection[0])) {
                    Util.getImplementation().disconnectSocket(connection[0]);
                }
                connection[0] = null;
            }
        };
    }

    public static StopListening listen(final int port, final Class scClass) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Listener
        implements StopListening,
        Runnable {
            private boolean stopped;

            Listener() {
            }

            @Override
            public void run() {
                try {
                    while (!this.stopped) {
                        final Object connection = Util.getImplementation().listenSocket(port);
                        final SocketConnection sc = (SocketConnection)scClass.newInstance();
                        if (connection != null) {
                            sc.setConnected(true);
                            Display.getInstance().startThread(new Runnable(){

                                public void run() {
                                    sc.input = new SocketInputStream(connection, sc);
                                    sc.output = new SocketOutputStream(connection, sc);
                                    sc.connectionEstablished(sc.input, sc.output);
                                    sc.setConnected(false);
                                }
                            }, "Connection " + port).start();
                            continue;
                        }
                        sc.connectionError(Util.getImplementation().getSocketErrorCode(connection), Util.getImplementation().getSocketErrorMessage(connection));
                    }
                }
                catch (Exception err) {
                    Log.e(err);
                }
            }

            @Override
            public void stop() {
                this.stopped = true;
            }
        }
        Listener l = new Listener();
        Display.getInstance().startThread(l, "Listening on " + port).start();
        return l;
    }

    public static String getHostOrIP() {
        return Util.getImplementation().getHostOrIP();
    }

    public static interface StopListening {
        public void stop();
    }

    static class SocketOutputStream
    extends OutputStream {
        private Object impl;
        private SocketConnection con;

        SocketOutputStream(Object impl, SocketConnection con) {
            this.impl = impl;
            this.con = con;
        }

        public synchronized void close() throws IOException {
            if (this.con.isConnected() && Util.getImplementation().isSocketConnected(this.impl)) {
                Util.getImplementation().disconnectSocket(this.impl);
                this.con.setConnected(false);
            }
        }

        public void flush() throws IOException {
        }

        private void handleSocketError() {
            int code = Util.getImplementation().getSocketErrorCode(this.impl);
            String msg = Util.getImplementation().getSocketErrorMessage(this.impl);
            if (code > 0 || msg != null) {
                this.con.connectionError(code, msg);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (off == 0 && len == b.length) {
                Util.getImplementation().writeToSocketStream(this.impl, b);
                this.handleSocketError();
                return;
            }
            byte[] arr = new byte[len];
            System.arraycopy(b, off, arr, 0, len);
            Util.getImplementation().writeToSocketStream(this.impl, arr);
            this.handleSocketError();
        }

        public void write(byte[] b) throws IOException {
            Util.getImplementation().writeToSocketStream(this.impl, b);
            this.handleSocketError();
        }

        public void write(int b) throws IOException {
            Util.getImplementation().writeToSocketStream(this.impl, new byte[]{(byte)b});
            this.handleSocketError();
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            catch (Throwable err) {
                Log.e(err);
            }
        }
    }

    static class SocketInputStream
    extends InputStream {
        private Object impl;
        private byte[] buffer;
        private int bufferOffset;
        private SocketConnection con;
        private boolean closed;

        SocketInputStream(Object impl, SocketConnection con) {
            this.impl = impl;
            this.con = con;
        }

        public boolean markSupported() {
            return false;
        }

        public synchronized void reset() throws IOException {
        }

        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                if (Util.getImplementation().isSocketConnected(this.impl)) {
                    Util.getImplementation().disconnectSocket(this.impl);
                    this.con.setConnected(false);
                }
            }
        }

        public int available() throws IOException {
            return Util.getImplementation().getSocketAvailableInput(this.impl);
        }

        private void throwEOF() throws IOException {
            if (this.closed) {
                throw new EOFException();
            }
        }

        private boolean getDataIfAvailable() {
            try {
                if (this.available() > 0) {
                    this.buffer = Util.getImplementation().readFromSocketStream(this.impl);
                    this.bufferOffset = 0;
                    return this.buffer != null && this.buffer.length > 0;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        private boolean getSomeData() {
            while (!(this.closed || this.buffer != null && this.bufferOffset < this.buffer.length)) {
                if (!Util.getImplementation().isSocketConnected(this.impl)) {
                    return false;
                }
                this.buffer = Util.getImplementation().readFromSocketStream(this.impl);
                this.bufferOffset = 0;
                if (this.buffer != null && this.buffer.length != 0 || this.closed || !Util.getImplementation().isSocketConnected(this.impl)) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.buffer != null && this.buffer.length > 0;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.throwEOF();
            if (!this.getSomeData()) {
                return -1;
            }
            int bytesRead = 0;
            while (true) {
                if (bytesRead < len && this.bufferOffset < this.buffer.length) {
                    b[off + bytesRead++] = this.buffer[this.bufferOffset++];
                    continue;
                }
                if (bytesRead >= len || !this.getDataIfAvailable()) break;
            }
            return bytesRead;
        }

        public int read(byte[] b) throws IOException {
            this.throwEOF();
            return this.read(b, 0, b.length);
        }

        public int read() throws IOException {
            this.throwEOF();
            byte[] b = new byte[1];
            int v = this.read(b);
            if (v == -1) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            catch (Throwable err) {
                Log.e(err);
            }
        }
    }

    static interface Close {
        public void close() throws IOException;
    }
}

