/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.io.Log;
import com.codename1.ui.CN;
import com.codename1.ui.Component;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.Graphics;
import com.codename1.ui.animations.Transition;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.plaf.Style;

public class CommonProgressAnimations {

    public static class LoadingTextAnimation
    extends ProgressAnimation {
        private static final String loremIpsum = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";
        private int lettersPerChunk = 3;
        private int cyclesPerChunk = 3;
        private int pauseCounter = 0;
        private int pauseLength = Display.getInstance().getFrameRate();
        private int rows = 3;
        private int cols = 40;
        private int cycleCount;
        private int strlen = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.".length();
        private int strpos = 0;

        public LoadingTextAnimation() {
            this.getStyle().setFgColor(0x666666);
            this.getStyle().setOpacity(102);
            ComponentSelector.$(this).setPaddingMillimeters(2.0f);
        }

        public boolean animate() {
            if (this.pauseCounter > 0) {
                --this.pauseCounter;
                if (this.pauseCounter == 0) {
                    this.strpos = 0;
                }
                return true;
            }
            this.cycleCount = (this.cycleCount + 1) % this.cyclesPerChunk;
            if (this.cycleCount == 1) {
                this.strpos += this.lettersPerChunk;
                if (this.strpos >= this.strlen) {
                    this.pauseCounter = this.pauseLength;
                } else {
                    this.strpos %= this.strlen;
                }
            }
            return true;
        }

        public void paint(Graphics g) {
            super.paint(g);
        }

        protected void paintBackground(Graphics g) {
            Font f;
            this.strlen = loremIpsum.length();
            g.setColor(this.getStyle().getFgColor());
            int alpha = g.getAlpha();
            float pauseRatio = 1.0f;
            if (this.pauseCounter > 0) {
                pauseRatio = (float)this.pauseCounter / (float)this.pauseLength;
            }
            g.setAlpha((int)((float)this.getStyle().getOpacity() / 255.0f * (float)alpha * pauseRatio));
            g.concatenateAlpha(this.getStyle().getFgAlpha());
            Font font = f = this.cmp == null ? this.getStyle().getFont() : this.cmp.getStyle().getFont();
            if (f == null) {
                f = Font.getDefaultFont();
            }
            int h = f.getHeight();
            int w = f.charWidth('M');
            Style s = this.cmp == null ? this.getStyle() : this.cmp.getStyle();
            int paddingTop = s.getPaddingTop();
            int paddingLeft = s.getPaddingLeftNoRTL();
            int paddingRight = s.getPaddingRightNoRTL();
            int paddingBottom = s.getPaddingBottom();
            int leftBounds = this.getX() + paddingLeft;
            int rightBounds = this.getX() + this.getWidth() - paddingRight;
            int bottomBounds = this.getY() + this.getHeight() - paddingBottom;
            int topBounds = this.getY() + paddingBottom;
            int x = leftBounds;
            int y = topBounds;
            int wordStartX = x;
            int wordStartPos = 0;
            int leading = h / 2;
            int row = 0;
            for (int i = 0; i < this.strpos; ++i) {
                char c = loremIpsum.charAt(i);
                if (c == ' ') {
                    if (wordStartX < x) {
                        g.fillRect(wordStartX, y, x - wordStartX, h);
                    }
                    wordStartX = x += w;
                    wordStartPos = i + 1;
                } else {
                    x += w;
                }
                if (x > rightBounds) {
                    ++row;
                    x = leftBounds;
                    i = wordStartPos - 1;
                    wordStartX = x;
                    y += h + leading;
                }
                if (y + h <= bottomBounds && row <= this.rows - 1) continue;
                this.strlen = i + 1;
                break;
            }
            g.setAlpha(alpha);
        }

        protected Dimension calcPreferredSize() {
            Font f = this.getStyle().getFont();
            if (f == null) {
                f = Font.getDefaultFont();
            }
            int charWidth = f.charWidth('M');
            int charHeight = f.getHeight();
            int leading = charHeight / 2;
            Dimension out = new Dimension(charWidth * this.cols + this.getStyle().getHorizontalPadding(), this.rows * (charHeight + leading) - leading + this.getStyle().getVerticalPadding());
            return out;
        }

        public int rows() {
            return this.rows;
        }

        public int cols() {
            return this.cols;
        }

        public LoadingTextAnimation rows(int rows) {
            this.rows = rows;
            return this;
        }

        public LoadingTextAnimation cols(int cols) {
            this.cols = cols;
            return this;
        }

        public static LoadingTextAnimation markComponentLoading(Component cmp) {
            return (LoadingTextAnimation)LoadingTextAnimation.markComponentLoading(cmp, LoadingTextAnimation.class);
        }
    }

    public static class EmptyAnimation
    extends ProgressAnimation {
        protected Dimension calcPreferredSize() {
            Dimension out = new Dimension(CN.convertToPixels(8.0f), CN.convertToPixels(8.0f));
            return out;
        }

        public static EmptyAnimation markComponentLoading(Component cmp) {
            return (EmptyAnimation)EmptyAnimation.markComponentLoading(cmp, EmptyAnimation.class);
        }
    }

    public static class CircleProgress
    extends ProgressAnimation {
        int stepSize = (int)Math.round((double)(360 / Display.getInstance().getFrameRate()) / 1.5);
        int step = 0;

        public void paint(Graphics g) {
            super.paint(g);
        }

        public boolean animate() {
            this.step += this.stepSize;
            this.step %= 720;
            return true;
        }

        protected void paintBackground(Graphics g) {
            g.setColor(this.getStyle().getFgColor());
            int alpha = g.concatenateAlpha(this.getStyle().getFgAlpha());
            boolean anti = g.isAntiAliased();
            g.setAntiAliased(true);
            int d = Math.min(this.getWidth(), this.getHeight());
            int x = this.getX() + (this.getWidth() - d) / 2;
            int y = this.getY() + (this.getHeight() - d) / 2;
            int w = d;
            int h = d;
            if (this.step <= 360) {
                g.fillArc(x, y, w, h, 0, -this.step);
            } else {
                g.fillArc(x, y, w, h, 0, 720 - this.step);
            }
            g.setAntiAliased(anti);
            g.setAlpha(alpha);
        }

        protected Dimension calcPreferredSize() {
            Dimension out = new Dimension(CN.convertToPixels(8.0f), CN.convertToPixels(8.0f));
            return out;
        }

        public static CircleProgress markComponentLoading(Component cmp) {
            return (CircleProgress)CircleProgress.markComponentLoading(cmp, CircleProgress.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ProgressAnimation
    extends Component {
        private static final String PROGRESS_KEY = "$$ProgressAnimation";
        protected Component cmp;

        public static ProgressAnimation markComponentLoading(Component cmp, Class<? extends ProgressAnimation> type) {
            if (type == null) {
                type = CircleProgress.class;
            }
            if (ProgressAnimation.getProgressAnimation(cmp) != null) {
                return ProgressAnimation.getProgressAnimation(cmp);
            }
            try {
                ProgressAnimation prg = type.newInstance();
                prg.setPreferredH(cmp.getPreferredH());
                prg.setPreferredW(cmp.getPreferredW());
                ProgressAnimation.replaceUntilReady(cmp, prg);
                return prg;
            }
            catch (Throwable t) {
                Log.e(t);
                throw new RuntimeException("Failed to create progress component: " + t.getMessage());
            }
        }

        private static void replaceUntilReady(Component cmp, ProgressAnimation progress) {
            if (cmp.getClientProperty(PROGRESS_KEY) instanceof ProgressAnimation) {
                throw new IllegalStateException("Component already has ProgressAnimation assigned to it");
            }
            if (cmp.getParent() == null) {
                throw new IllegalStateException("Component has no parent so cannot be replaced by progress");
            }
            cmp.putClientProperty(PROGRESS_KEY, progress);
            cmp.getParent().replace(cmp, (Component)progress, null);
            progress.cmp = cmp;
        }

        public static void markComponentReady(Component cmp, Transition t) {
            ProgressAnimation progress = (ProgressAnimation)cmp.getClientProperty(PROGRESS_KEY);
            if (progress == null) {
                return;
            }
            cmp.putClientProperty(PROGRESS_KEY, null);
            Container parent = progress.getParent();
            if (parent != null) {
                parent.replace((Component)progress, cmp, t);
                if (t == null) {
                    parent.revalidateLater();
                }
            }
        }

        public static void markComponentReady(Component cmp) {
            ProgressAnimation.markComponentReady(cmp, null);
        }

        public static ProgressAnimation getProgressAnimation(Component cmp) {
            return (ProgressAnimation)cmp.getClientProperty(PROGRESS_KEY);
        }

        @Override
        protected void initComponent() {
            super.initComponent();
            this.getComponentForm().registerAnimated(this);
        }

        @Override
        protected void deinitialize() {
            this.getComponentForm().deregisterAnimated(this);
            super.deinitialize();
        }
    }
}

