/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.plaf;

import com.codename1.charts.util.ColorUtil;
import com.codename1.io.Log;
import com.codename1.io.Util;
import com.codename1.ui.CN;
import com.codename1.ui.Component;
import com.codename1.ui.EncodedImage;
import com.codename1.ui.Font;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Stroke;
import com.codename1.ui.Transform;
import com.codename1.ui.geom.GeneralPath;
import com.codename1.ui.geom.Rectangle2D;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.util.Resources;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSBorder
extends Border {
    public static final byte REPEAT_NONE = 0;
    public static final byte REPEAT_BOTH = 1;
    public static final byte REPEAT_X = 2;
    public static final byte REPEAT_Y = 3;
    public static final byte VPOSITION_TOP = 0;
    public static final byte VPOSITION_BOTTOM = 1;
    public static final byte VPOSITION_CENTER = 2;
    public static final byte VPOSITION_OTHER = 99;
    public static final byte HPOSITION_LEFT = 0;
    public static final byte HPOSITION_RIGHT = 1;
    public static final byte HPOSITION_CENTER = 2;
    public static final byte HPOSITION_OTHER = 99;
    public static final byte SIZE_AUTO = 0;
    public static final byte SIZE_CONTAIN = 1;
    public static final byte SIZE_COVER = 2;
    public static final byte SIZE_OTHER = 99;
    public static final byte STYLE_NONE = 0;
    public static final byte STYLE_HIDDEN = 1;
    public static final byte STYLE_DOTTED = 2;
    public static final byte STYLE_DASHED = 3;
    public static final byte STYLE_SOLID = 4;
    private static final Map<String, Decorator> decorators = new HashMap<String, Decorator>();
    private Color backgroundColor;
    private BackgroundImage[] backgroundImages;
    private BorderImage borderImage;
    private BorderStroke[] stroke;
    private BoxShadow boxShadow;
    private BorderRadius borderRadius;
    private Resources res;
    public static final byte UNIT_PIXELS = 0;
    public static final byte UNIT_MM = 2;
    public static final byte UNIT_PERCENT = 1;
    public static final byte UNIT_EM = 4;
    private static Context context;
    private static Map<String, Byte> styleMap;
    private Rectangle2D contentRect;

    private void setAlpha(Graphics g, Color c) {
        g.setAlpha(c == null ? 0 : c.alpha);
    }

    public CSSBorder() {
        this.res = Resources.getGlobalResources();
    }

    public CSSBorder(Resources res) {
        this.res = res;
    }

    public CSSBorder(String css) {
        this(Resources.getGlobalResources(), css);
    }

    public CSSBorder(Resources res, String css) {
        String[] parts;
        this.res = res;
        for (String part : parts = Util.split(css, ";")) {
            int colonPos = part.indexOf(":");
            if (colonPos == -1) continue;
            String key = part.substring(0, colonPos).trim().toLowerCase();
            String value = part.substring(colonPos + 1).trim();
            Decorator decorator = decorators.get(key);
            if (decorator == null) {
                throw new IllegalArgumentException("Unsupported CSS property: " + key);
            }
            decorator.decorate(this, key, value);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    public String toCSSString() {
        StringBuilder sb = new StringBuilder();
        if (this.backgroundColor != null) {
            sb.append("background-color:").append(this.backgroundColor.toCSSString()).append(";");
        }
        if (this.backgroundImages != null) {
            sb.append("background-image:");
            boolean first = true;
            for (BackgroundImage img : this.backgroundImages) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(img.toCSSString());
            }
            sb.append(";");
            sb.append("background-position:");
            first = true;
            for (BackgroundImage img : this.backgroundImages) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(img.getBackgroundPositionCSSString());
            }
            sb.append(";");
        }
        if (this.borderRadius != null) {
            sb.append("border-radius:");
            sb.append(this.borderRadius.toCSSString());
            sb.append(";");
        }
        if (this.stroke != null) {
            sb.append("border-width:");
            sb.append(this.stroke[0].toBorderWidthCSSString()).append(" ").append(this.stroke[3].toBorderWidthCSSString()).append(" ").append(this.stroke[2].toBorderWidthCSSString()).append(" ").append(this.stroke[1].toBorderWidthCSSString());
            sb.append(";");
            sb.append("border-style:").append(this.stroke[0].toBorderStyleCSSString()).append(" ").append(this.stroke[3].toBorderStyleCSSString()).append(" ").append(this.stroke[2].toBorderStyleCSSString()).append(" ").append(this.stroke[1].toBorderStyleCSSString());
            sb.append(";");
            sb.append("border-color:").append(this.stroke[0].toBorderColorCSSString()).append(" ").append(this.stroke[3].toBorderColorCSSString()).append(" ").append(this.stroke[2].toBorderColorCSSString()).append(" ").append(this.stroke[1].toBorderColorCSSString());
            sb.append(";");
        }
        if (this.boxShadow != null) {
            sb.append("box-shadow:").append(this.boxShadow.toCSSString()).append(";");
        }
        if (this.borderImage != null) {
            sb.append("border-image:").append(this.borderImage.toCSSString()).append(";");
        }
        return sb.toString();
    }

    private float floatPx(ScalarUnit u) {
        return u == null ? 0.0f : u.floatPx();
    }

    private float floatPx(ScalarUnit u, Component c, Rectangle2D contentRect, boolean horizontal) {
        return u == null ? 0.0f : u.floatPx(c, contentRect, horizontal);
    }

    private static boolean isTransparent(Color color) {
        return color == null || color.isTransparent();
    }

    private static Map<String, Byte> styleMap() {
        if (styleMap == null) {
            styleMap = new HashMap<String, Byte>();
            styleMap.put("none", (byte)0);
            styleMap.put("hidden", (byte)1);
            styleMap.put("dotted", (byte)2);
            styleMap.put("dashed", (byte)3);
            styleMap.put("solid", (byte)4);
        }
        return styleMap;
    }

    private static byte getBorderStyle(String style) {
        style = style.trim();
        CSSBorder.styleMap();
        Byte b = styleMap.get(style);
        if (b == null) {
            throw new IllegalArgumentException("Unsupported border style " + style);
        }
        return b;
    }

    private static boolean validateBorderStyle(String style) {
        return CSSBorder.styleMap().containsKey(style);
    }

    private boolean hasBorderRadius() {
        return this.borderRadius != null && this.borderRadius.hasNonZeroRadius();
    }

    private void calculateContentRect(int outerWidth, int outerHeight, Rectangle2D rect) {
        int paddingLeft = 0;
        int paddingRight = 0;
        int paddingBottom = 0;
        int paddingTop = 0;
        if (this.stroke != null) {
            if (this.stroke[0] != null) {
                paddingTop = (int)((double)paddingTop + Math.ceil(this.stroke[0].thickness.floatPx() / 2.0f));
            }
            if (this.stroke[1] != null) {
                paddingLeft = (int)((double)paddingLeft + Math.ceil(this.stroke[1].thickness.floatPx() / 2.0f));
            }
            if (this.stroke[3] != null) {
                paddingRight = (int)((double)paddingRight + Math.ceil(this.stroke[3].thickness.floatPx() / 2.0f));
            }
            if (this.stroke[2] != null) {
                paddingBottom = (int)((double)paddingBottom + Math.ceil(this.stroke[2].thickness.floatPx() / 2.0f));
            }
        }
        if (this.boxShadow != null && !this.boxShadow.inset) {
            paddingTop += -this.boxShadow.vOffsetPx() + this.boxShadow.blurPx() + this.boxShadow.spreadPx();
            paddingBottom += this.boxShadow.vOffsetPx() + this.boxShadow.blurPx() + this.boxShadow.spreadPx();
            paddingLeft += -this.boxShadow.hOffsetPx() + this.boxShadow.blurPx() + this.boxShadow.spreadPx();
            paddingRight += this.boxShadow.hOffsetPx() + this.boxShadow.blurPx() + this.boxShadow.spreadPx();
        }
        rect.setX(paddingLeft);
        rect.setY(paddingTop);
        rect.setWidth(outerWidth - paddingLeft - paddingRight);
        rect.setHeight(outerHeight - paddingTop - paddingBottom);
    }

    private GeneralPath createShape(GeneralPath out, double x, double y, double width, double height, Arrow arrow) {
        int arrowHeightPixels;
        double tx = x;
        double ty = y;
        y = 0.0;
        x = 0.0;
        if (arrow != null) {
            arrowHeightPixels = CN.convertToPixels(arrow.size);
            switch (arrow.direction) {
                case 0: {
                    y = arrowHeightPixels;
                }
                case 2: {
                    height -= (double)arrowHeightPixels;
                    break;
                }
                case 1: {
                    x = arrowHeightPixels;
                }
                case 3: {
                    width -= (double)arrowHeightPixels;
                }
            }
        }
        if (this.hasBorderRadius()) {
            out.reset();
            out.moveTo(x + (double)this.borderRadius.topLeftRadiusX(), y);
            out.lineTo(x + width - (double)this.borderRadius.topRightRadiusX(), y);
            out.quadTo(x + width, y, x + width, y + (double)this.borderRadius.topRightRadiusY());
            out.lineTo(x + width, y + height - (double)this.borderRadius.bottomRightY());
            out.quadTo(x + width, y + height, x + width - (double)this.borderRadius.bottomRightX(), y + height);
            out.lineTo(x + (double)this.borderRadius.bottomLeftX(), y + height);
            out.quadTo(x, y + height, x, y + height - (double)this.borderRadius.bottomLeftY());
            out.lineTo(x, y + (double)this.borderRadius.topLeftRadiusY());
            out.quadTo(x, y, x + (double)this.borderRadius.topLeftRadiusX(), y);
            out.closePath();
        } else {
            out.reset();
            out.moveTo(x, y);
            out.lineTo(x + width, y);
            out.lineTo(x + width, y + height);
            out.lineTo(x, y + height);
            out.closePath();
        }
        if (arrow != null) {
            int actualArrowPosition;
            if (arrow.direction == 1) {
                arrowHeightPixels = CN.convertToPixels(arrow.size);
                actualArrowPosition = (int)Math.min(y + height, Math.max((double)arrow.position, y + (double)this.borderRadius.topLeftRadiusY()));
                out.moveTo(x, (double)actualArrowPosition);
                out.lineTo(x - (double)arrowHeightPixels, (double)((float)actualArrowPosition + (float)arrowHeightPixels / 2.0f));
                out.lineTo(x, (double)(actualArrowPosition + arrowHeightPixels));
                out.closePath();
            }
            if (arrow.direction == 3) {
                arrowHeightPixels = CN.convertToPixels(arrow.size);
                actualArrowPosition = (int)Math.min(y + height, Math.max((double)arrow.position, y + (double)this.borderRadius.topRightRadiusY()));
                out.moveTo(x + width, (double)actualArrowPosition);
                out.lineTo(x + width + (double)arrowHeightPixels, (double)((float)actualArrowPosition + (float)arrowHeightPixels / 2.0f));
                out.lineTo(x + width, (double)(actualArrowPosition + arrowHeightPixels));
                out.closePath();
            }
            if (arrow.direction == 2) {
                arrowHeightPixels = CN.convertToPixels(arrow.size);
                actualArrowPosition = (int)Math.min(x + width, Math.max((double)arrow.position, x + (double)this.borderRadius.topLeftRadiusX()));
                out.moveTo((double)actualArrowPosition, y + height);
                out.lineTo((double)((float)actualArrowPosition + (float)arrowHeightPixels / 2.0f), y + height + (double)arrowHeightPixels);
                out.lineTo((double)(actualArrowPosition + arrowHeightPixels), y + height);
                out.closePath();
            }
            if (arrow.direction == 0) {
                arrowHeightPixels = CN.convertToPixels(arrow.size);
                actualArrowPosition = (int)Math.min(x + width, Math.max((double)arrow.position, x + (double)this.borderRadius.topLeftRadiusX()));
                out.moveTo((double)actualArrowPosition, y);
                out.lineTo((double)((float)actualArrowPosition + (float)arrowHeightPixels / 2.0f), y - (double)arrowHeightPixels);
                out.lineTo((double)(actualArrowPosition + arrowHeightPixels), y);
                out.closePath();
            }
        }
        out.transform(Transform.makeTranslation((float)tx, (float)ty));
        return out;
    }

    private boolean hasBackgroundImages() {
        return this.backgroundImages != null && this.backgroundImages.length > 0;
    }

    private void setColor(Graphics g, Color c) {
        if (c != null) {
            g.setAlpha(c.alpha);
            g.setColor(c.color);
        }
    }

    boolean allSidesHaveSameStroke() {
        if (this.stroke == null) {
            return true;
        }
        return this.stroke[0].equals(this.stroke[2]) && this.stroke[1].equals(this.stroke[3]) && this.stroke[0].equals(this.stroke[1]);
    }

    @Override
    public boolean isBackgroundPainter() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorderBackground(Graphics g, Component c) {
        if (this.borderImage != null) {
            this.borderImage.internal().paintBorderBackground(g, c);
            return;
        }
        int alpha = g.getAlpha();
        int color = g.getColor();
        boolean antialias = g.isAntiAliased();
        g.setAntiAliased(true);
        Style s = c.getStyle();
        try {
            if (this.contentRect == null) {
                this.contentRect = new Rectangle2D();
            }
            this.calculateContentRect(c.getWidth(), c.getHeight(), this.contentRect);
            this.contentRect.setX(this.contentRect.getX() + (double)c.getX());
            this.contentRect.setY(this.contentRect.getY() + (double)c.getY());
            context = new Context(c, this.contentRect);
            String borderPathKey = "$$CSSBorderPath";
            GeneralPath p = (GeneralPath)c.getClientProperty(borderPathKey);
            if (p == null) {
                p = new GeneralPath();
                c.putClientProperty(borderPathKey, p);
            }
            this.createShape(p, this.contentRect.getX(), this.contentRect.getY(), this.contentRect.getWidth(), this.contentRect.getHeight(), this.createArrow(c));
            if (this.boxShadow != null) {
                this.boxShadow.paint(g, c, this.contentRect);
            }
            if (s.getBgTransparency() != 0) {
                g.setColor(s.getBgColor());
                int tp = s.getBgTransparency() & 0xFF;
                int al = (int)Math.round((double)(alpha * tp) / 255.0);
                g.setAlpha(al);
                g.fillShape(p);
                g.setColor(color);
                g.setAlpha(alpha);
            }
            if (this.hasBackgroundImages()) {
                int[] oldClip = g.getClip();
                g.setClip(p);
                g.clipRect(oldClip[0], oldClip[1], oldClip[2], oldClip[3]);
                for (BackgroundImage img : this.backgroundImages) {
                    img.paint(g, c, this.contentRect);
                }
                g.setClip(oldClip);
            }
            if (this.stroke != null) {
                if (this.allSidesHaveSameStroke() && this.stroke[0].isVisible()) {
                    this.setColor(g, this.stroke[0].color);
                    g.drawShape(p, this.stroke[0].getStroke(c, this.contentRect, true));
                } else {
                    p.reset();
                    double x = this.contentRect.getX();
                    double y = this.contentRect.getY();
                    double w = this.contentRect.getWidth();
                    double h = this.contentRect.getHeight();
                    if (this.hasBorderRadius()) {
                        if (this.stroke[0].isVisible()) {
                            p.moveTo(x, y + (double)this.borderRadius.topLeftRadiusY());
                            p.quadTo(x, y, x + (double)this.borderRadius.topLeftRadiusX(), y);
                            p.lineTo(x + w - (double)this.borderRadius.topRightRadiusX(), y);
                            p.quadTo(x + w, y, x + w, y + (double)this.borderRadius.topRightRadiusY());
                            this.setColor(g, this.stroke[0].color);
                            g.drawShape(p, this.stroke[0].getStroke(c, this.contentRect, true));
                        }
                        if (this.stroke[2].isVisible()) {
                            p.reset();
                            p.moveTo(x, y + h - (double)this.borderRadius.bottomLeftY());
                            p.quadTo(x, y + h, x + (double)this.borderRadius.bottomLeftX(), y + h);
                            p.lineTo(x + w - (double)this.borderRadius.bottomRightX(), y + h);
                            p.quadTo(x + w, y + h, x + w, y + h - (double)this.borderRadius.bottomLeftY());
                            this.setColor(g, this.stroke[2].color);
                            g.drawShape(p, this.stroke[2].getStroke(c, this.contentRect, true));
                        }
                        if (this.stroke[1].isVisible()) {
                            p.reset();
                            p.moveTo(x, y + (double)this.borderRadius.topLeftRadiusY());
                            p.lineTo(x, y + h - (double)this.borderRadius.bottomLeftY());
                            this.setColor(g, this.stroke[1].color);
                            g.drawShape(p, this.stroke[1].getStroke(c, this.contentRect, false));
                        }
                        if (this.stroke[3].isVisible()) {
                            p.reset();
                            p.moveTo(x + w, y + (double)this.borderRadius.topRightRadiusY());
                            p.lineTo(x + w, y + h - (double)this.borderRadius.bottomRightY());
                            this.setColor(g, this.stroke[3].color);
                            g.drawShape(p, this.stroke[3].getStroke(c, this.contentRect, false));
                        }
                    } else {
                        if (this.stroke[0].isVisible()) {
                            p.reset();
                            p.moveTo(x, y);
                            p.lineTo(x + w, y);
                            this.setColor(g, this.stroke[0].color);
                            Stroke st = this.stroke[0].getStroke(c, this.contentRect, true);
                            g.drawShape(p, st);
                        }
                        if (this.stroke[2].isVisible()) {
                            p.reset();
                            p.moveTo(x, y + h);
                            p.lineTo(x + w, y + h);
                            this.setColor(g, this.stroke[2].color);
                            g.drawShape(p, this.stroke[2].getStroke(c, this.contentRect, true));
                        }
                        if (this.stroke[1].isVisible()) {
                            p.reset();
                            p.moveTo(x, y);
                            p.lineTo(x, y + h);
                            this.setColor(g, this.stroke[1].color);
                            g.drawShape(p, this.stroke[1].getStroke(c, this.contentRect, false));
                        }
                        if (this.stroke[3].isVisible()) {
                            p.reset();
                            p.moveTo(x + w, y);
                            p.lineTo(x + w, y + h);
                            this.setColor(g, this.stroke[3].color);
                            g.drawShape(p, this.stroke[3].getStroke(c, this.contentRect, false));
                        }
                    }
                }
            }
        }
        finally {
            g.setAlpha(alpha);
            g.setColor(color);
            g.setAntiAliased(antialias);
        }
    }

    @Override
    public int getMinimumHeight() {
        if (this.borderImage != null) {
            return this.borderImage.internal().getMinimumHeight();
        }
        return super.getMinimumHeight();
    }

    @Override
    public int getMinimumWidth() {
        if (this.borderImage != null) {
            return this.borderImage.internal().getMinimumWidth();
        }
        return super.getMinimumWidth();
    }

    public CSSBorder borderImage(Image borderImage, double ... slicePoints) {
        this.borderImage = new BorderImage(borderImage, slicePoints);
        return this;
    }

    public CSSBorder borderImageWithName(String borderImageName, double ... slicePoints) {
        this.borderImage = new BorderImage(borderImageName, slicePoints);
        return this;
    }

    private CSSBorder borderImage(String cssProperty) {
        String[] parts = Util.split(cssProperty, " ");
        parts[0] = Util.decode(parts[0], "UTF-8", false);
        int len = parts.length;
        double[] splices = new double[len - 1];
        for (int i = 1; i < len; ++i) {
            splices[i - 1] = Double.parseDouble(parts[i]);
        }
        return this.borderImageWithName(parts[0], splices);
    }

    public CSSBorder borderRadius(String radius) {
        this.borderRadius = new BorderRadius(radius);
        return this;
    }

    public CSSBorder borderStroke(String ... strokeStrs) {
        this.stroke = new BorderStroke[4];
        int len = strokeStrs.length;
        if (len == 4) {
            this.stroke[0] = new BorderStroke(strokeStrs[0]);
            this.stroke[3] = new BorderStroke(strokeStrs[1]);
            this.stroke[2] = new BorderStroke(strokeStrs[2]);
            this.stroke[1] = new BorderStroke(strokeStrs[3]);
        } else if (len == 2) {
            this.stroke[0] = new BorderStroke(strokeStrs[0]);
            this.stroke[2] = new BorderStroke(this.stroke[0]);
            this.stroke[1] = new BorderStroke(strokeStrs[1]);
            this.stroke[3] = new BorderStroke(this.stroke[1]);
        } else if (len == 3) {
            this.stroke[0] = new BorderStroke(strokeStrs[0]);
            this.stroke[1] = new BorderStroke(strokeStrs[1]);
            this.stroke[3] = new BorderStroke(this.stroke[1]);
            this.stroke[2] = new BorderStroke(strokeStrs[2]);
        } else if (len == 1) {
            this.stroke[0] = new BorderStroke(strokeStrs[0]);
            this.stroke[3] = new BorderStroke(this.stroke[0]);
            this.stroke[2] = new BorderStroke(this.stroke[0]);
            this.stroke[1] = new BorderStroke(this.stroke[0]);
        } else {
            throw new IllegalArgumentException("Border stroke expects 1 to 4 parameters for top, right, bottom, left");
        }
        return this;
    }

    public CSSBorder borderColor(String ... colors) {
        if (this.stroke == null) {
            return this.borderStroke("solid").borderColor(colors);
        }
        int len = colors.length;
        if (len == 1 && colors[0].indexOf(" ") != -1) {
            return this.borderColor(Util.split(colors[0], " "));
        }
        if (len == 4) {
            this.stroke[0].color = Color.parse(colors[0]);
            this.stroke[3].color = Color.parse(colors[1]);
            this.stroke[2].color = Color.parse(colors[2]);
            this.stroke[1].color = Color.parse(colors[3]);
        } else if (len == 3) {
            this.stroke[0].color = Color.parse(colors[0]);
            this.stroke[3].color = Color.parse(colors[1]);
            this.stroke[1].color = Color.parse(colors[1]);
            this.stroke[2].color = Color.parse(colors[2]);
        } else if (len == 2) {
            this.stroke[0].color = this.stroke[2].color = Color.parse(colors[0]);
            this.stroke[1].color = this.stroke[3].color = Color.parse(colors[1]);
        } else if (len == 1) {
            this.stroke[1].color = this.stroke[3].color = Color.parse(colors[0]);
            this.stroke[2].color = this.stroke[3].color;
            this.stroke[0].color = this.stroke[3].color;
        } else {
            throw new IllegalArgumentException("borderColor expects 1-4 parameters");
        }
        return this;
    }

    public CSSBorder borderWidth(String ... widths) {
        if (this.stroke == null) {
            return this.borderStroke("solid").borderWidth(widths);
        }
        int len = widths.length;
        if (len == 4) {
            this.stroke[0].thickness = BorderStroke.parseThickness(widths[0]);
            this.stroke[3].thickness = BorderStroke.parseThickness(widths[1]);
            this.stroke[2].thickness = BorderStroke.parseThickness(widths[2]);
            this.stroke[1].thickness = BorderStroke.parseThickness(widths[3]);
        } else if (len == 3) {
            this.stroke[0].thickness = BorderStroke.parseThickness(widths[0]);
            this.stroke[1].thickness = BorderStroke.parseThickness(widths[1]);
            this.stroke[3].thickness = this.stroke[1].thickness.copy();
            this.stroke[2].thickness = BorderStroke.parseThickness(widths[2]);
        } else if (len == 2) {
            this.stroke[0].thickness = BorderStroke.parseThickness(widths[0]);
            this.stroke[2].thickness = this.stroke[0].thickness.copy();
            this.stroke[1].thickness = BorderStroke.parseThickness(widths[1]);
            this.stroke[3].thickness = this.stroke[1].thickness.copy();
        } else if (len == 1) {
            if (widths[0].indexOf(" ") != -1) {
                return this.borderWidth(Util.split(widths[0], " "));
            }
            this.stroke[0].thickness = BorderStroke.parseThickness(widths[0]);
            this.stroke[3].thickness = BorderStroke.parseThickness(widths[0]);
            this.stroke[2].thickness = BorderStroke.parseThickness(widths[0]);
            this.stroke[1].thickness = BorderStroke.parseThickness(widths[0]);
        } else {
            throw new IllegalArgumentException("Border width expects 1 to 4 parameters");
        }
        return this;
    }

    public CSSBorder borderStyle(String ... styles) {
        try {
            if (this.stroke == null) {
                return this.borderStroke("solid").borderStyle(styles);
            }
            int len = styles.length;
            switch (len) {
                case 4: {
                    this.stroke[0].type = CSSBorder.getBorderStyle(styles[0]);
                    this.stroke[3].type = CSSBorder.getBorderStyle(styles[1]);
                    this.stroke[2].type = CSSBorder.getBorderStyle(styles[2]);
                    this.stroke[1].type = CSSBorder.getBorderStyle(styles[3]);
                    break;
                }
                case 3: {
                    this.stroke[0].type = CSSBorder.getBorderStyle(styles[0]);
                    this.stroke[3].type = CSSBorder.getBorderStyle(styles[1]);
                    this.stroke[2].type = CSSBorder.getBorderStyle(styles[2]);
                    this.stroke[1].type = CSSBorder.getBorderStyle(styles[1]);
                    break;
                }
                case 2: {
                    this.stroke[0].type = CSSBorder.getBorderStyle(styles[0]);
                    this.stroke[3].type = CSSBorder.getBorderStyle(styles[1]);
                    this.stroke[2].type = CSSBorder.getBorderStyle(styles[0]);
                    this.stroke[1].type = CSSBorder.getBorderStyle(styles[1]);
                    break;
                }
                case 1: {
                    if (styles[0].indexOf(" ") != -1) {
                        return this.borderStyle(Util.split(styles[0], " "));
                    }
                    this.stroke[0].type = CSSBorder.getBorderStyle(styles[0]);
                    this.stroke[3].type = CSSBorder.getBorderStyle(styles[0]);
                    this.stroke[2].type = CSSBorder.getBorderStyle(styles[0]);
                    this.stroke[1].type = CSSBorder.getBorderStyle(styles[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("borderSTyle expects 1 to 4 arguments");
                }
            }
        }
        catch (Throwable t) {
            Log.e(t);
            throw new RuntimeException("Failed parsing border style: " + Arrays.toString(styles));
        }
        return this;
    }

    public CSSBorder backgroundColor(String color) {
        this.backgroundColor = Color.parse(color);
        return this;
    }

    public CSSBorder backgroundImage(String cssDirective) {
        String[] parts = Util.split(cssDirective, ",");
        ArrayList<Image> imgs = new ArrayList<Image>();
        for (String part : parts) {
            Image im;
            if ((part = part.trim()).indexOf("url(") == 0) {
                part = part.substring(4, part.length() - 1);
            }
            if (part.charAt(0) == '\"' || part.charAt(0) == '\"') {
                part = part.substring(1, part.length() - 1);
            }
            if (part.indexOf("/") != -1) {
                part = part.substring(part.lastIndexOf("/") + 1);
            }
            if ((im = this.res.getImage(part)) == null) {
                try {
                    im = EncodedImage.create("/" + part);
                    im.setImageName(part);
                }
                catch (IOException ex) {
                    Log.e(ex);
                    throw new IllegalArgumentException("Failed to parse image: " + part);
                }
            }
            imgs.add(im);
        }
        return this.backgroundImage(imgs.toArray(new Image[imgs.size()]));
    }

    public CSSBorder backgroundImage(Image ... images) {
        int len = images.length;
        if (this.backgroundImages == null) {
            this.backgroundImages = new BackgroundImage[len];
        } else if (this.backgroundImages.length < len) {
            BackgroundImage[] tmp = new BackgroundImage[len];
            System.arraycopy(this.backgroundImages, 0, tmp, 0, this.backgroundImages.length);
            this.backgroundImages = tmp;
        }
        for (int i = 0; i < len; ++i) {
            if (this.backgroundImages[i] == null) {
                this.backgroundImages[i] = new BackgroundImage(images[i]);
                continue;
            }
            this.backgroundImages[i].image = images[i];
        }
        return this;
    }

    static byte parseRepeat(String repeat) {
        if ("repeat-x".equals(repeat)) {
            return 2;
        }
        if ("repeat-y".equals(repeat)) {
            return 3;
        }
        if ("repeat".equals(repeat)) {
            return 1;
        }
        if ("repeat-none".equals(repeat)) {
            return 0;
        }
        throw new IllegalArgumentException("Unrecognized option for background-repeat");
    }

    public CSSBorder backgroundRepeat(String ... repeat) {
        int len = repeat.length;
        if (len == 1 && repeat[0].indexOf(",") != -1) {
            return this.backgroundRepeat(Util.split(repeat[0], ","));
        }
        if (this.backgroundImages == null) {
            this.backgroundImages = new BackgroundImage[len];
        } else if (this.backgroundImages.length < len) {
            BackgroundImage[] tmp = new BackgroundImage[len];
            System.arraycopy(this.backgroundImages, 0, tmp, 0, this.backgroundImages.length);
            this.backgroundImages = tmp;
        }
        for (int i = 0; i < len; ++i) {
            if (this.backgroundImages[i] == null) {
                this.backgroundImages[i] = new BackgroundImage();
            }
            this.backgroundImages[i].repeat = CSSBorder.parseRepeat(repeat[i].trim());
        }
        return this;
    }

    public CSSBorder backgroundPosition(String ... pos) {
        int len = pos.length;
        if (len == 1 && pos[0].indexOf(",") != -1) {
            return this.backgroundPosition(Util.split(pos[0], ","));
        }
        if (this.backgroundImages == null) {
            this.backgroundImages = new BackgroundImage[len];
        } else if (this.backgroundImages.length < len) {
            BackgroundImage[] tmp = new BackgroundImage[len];
            System.arraycopy(this.backgroundImages, 0, tmp, 0, this.backgroundImages.length);
            this.backgroundImages = tmp;
        }
        for (int i = 0; i < len; ++i) {
            if (this.backgroundImages[i] == null) {
                this.backgroundImages[i] = new BackgroundImage();
            }
            this.backgroundImages[i].setPosition(pos[i].trim());
        }
        return this;
    }

    private Arrow createArrow(Component c) {
        if (this.getTrackComponent() == null) {
            return null;
        }
        return new Arrow(c);
    }

    static {
        decorators.put("background-color", new Decorator(){

            public CSSBorder decorate(CSSBorder border, String cssProperty, String cssPropertyValue) {
                return border.backgroundColor(cssPropertyValue);
            }
        });
        decorators.put("background-image", new Decorator(){

            public CSSBorder decorate(CSSBorder border, String cssProperty, String cssPropertyValue) {
                return border.backgroundImage(cssPropertyValue);
            }
        });
        decorators.put("background-position", new Decorator(){

            public CSSBorder decorate(CSSBorder border, String cssProperty, String cssPropertyValue) {
                return border.backgroundPosition(cssPropertyValue);
            }
        });
        decorators.put("background-repeat", new Decorator(){

            public CSSBorder decorate(CSSBorder border, String cssProperty, String cssPropertyValue) {
                return border.backgroundRepeat(cssPropertyValue);
            }
        });
        decorators.put("border-color", new Decorator(){

            public CSSBorder decorate(CSSBorder border, String cssProperty, String cssPropertyValue) {
                return border.borderColor(cssPropertyValue);
            }
        });
        decorators.put("border-radius", new Decorator(){

            public CSSBorder decorate(CSSBorder border, String cssProperty, String cssPropertyValue) {
                return border.borderRadius(cssPropertyValue);
            }
        });
        decorators.put("border-stroke", new Decorator(){

            public CSSBorder decorate(CSSBorder border, String cssProperty, String cssPropertyValue) {
                return border.borderStroke(cssPropertyValue);
            }
        });
        decorators.put("border-style", new Decorator(){

            public CSSBorder decorate(CSSBorder border, String cssProperty, String cssPropertyValue) {
                return border.borderStyle(cssPropertyValue);
            }
        });
        decorators.put("border-width", new Decorator(){

            public CSSBorder decorate(CSSBorder border, String cssProperty, String cssPropertyValue) {
                return border.borderWidth(cssPropertyValue);
            }
        });
        decorators.put("border-image", new Decorator(){

            public CSSBorder decorate(CSSBorder border, String cssProperty, String cssPropertyValue) {
                return border.borderImage(cssPropertyValue);
            }
        });
    }

    private class Arrow {
        int direction = -1;
        float size = 1.5f;
        float position = -1.0f;
        int trackComponentSide = -1;
        float trackComponentHorizontalPosition = -1.0f;
        float trackComponentVerticalPosition = -1.0f;

        Arrow(Component c) {
            if (CSSBorder.this.getTrackComponent() != null) {
                int cabsY = c.getAbsoluteY();
                int trackY = CSSBorder.this.getTrackComponent().getY();
                int trackX = CSSBorder.this.getTrackComponent().getX();
                int cabsX = c.getAbsoluteX();
                int arrowWH = CN.convertToPixels(this.size);
                if (cabsY >= trackY + CSSBorder.this.getTrackComponent().getHeight()) {
                    this.direction = 0;
                    this.position = trackX + CSSBorder.this.getTrackComponent().getWidth() / 2 - cabsX - arrowWH / 2;
                } else if (this.trackComponentSide == 2 || cabsY + c.getHeight() <= trackY) {
                    this.direction = 2;
                    this.position = trackX + CSSBorder.this.getTrackComponent().getWidth() / 2 - cabsX - arrowWH / 2;
                } else if (cabsX >= trackX + CSSBorder.this.getTrackComponent().getWidth()) {
                    this.direction = 1;
                    this.position = trackY + CSSBorder.this.getTrackComponent().getHeight() / 2 - cabsY - arrowWH / 2;
                } else if (cabsX + c.getWidth() <= trackX) {
                    this.direction = 3;
                    this.position = trackY + CSSBorder.this.getTrackComponent().getHeight() / 2 - cabsY - arrowWH / 2;
                }
            } else if (this.trackComponentSide >= 0) {
                switch (this.trackComponentSide) {
                    case 0: {
                        this.direction = 0;
                        this.position = 0.0f;
                        if (!(this.trackComponentHorizontalPosition >= 0.0f)) break;
                        this.position = (int)((float)c.getWidth() * this.trackComponentHorizontalPosition);
                        break;
                    }
                    case 2: {
                        this.direction = 2;
                        this.position = 0.0f;
                        if (!(this.trackComponentHorizontalPosition >= 0.0f)) break;
                        this.position = (int)((float)c.getWidth() * this.trackComponentHorizontalPosition);
                        break;
                    }
                    case 1: {
                        this.direction = 1;
                        this.position = 0.0f;
                        if (!(this.trackComponentVerticalPosition >= 0.0f)) break;
                        this.position = (int)((float)c.getHeight() * this.trackComponentVerticalPosition);
                        break;
                    }
                    case 3: {
                        this.direction = 3;
                        this.position = 0.0f;
                        if (!(this.trackComponentVerticalPosition >= 0.0f)) break;
                        this.position = (int)((float)c.getHeight() * this.trackComponentVerticalPosition);
                        break;
                    }
                }
            }
        }
    }

    private class BackgroundImage {
        LinearGradient linearGradient;
        RadialGradient radialGradient;
        byte verticalPositionType;
        byte horizontalPositionType;
        byte verticalSizeType;
        byte horizontalSizeType;
        ScalarUnit verticalPosition;
        ScalarUnit horizontalPosition;
        ScalarUnit verticalSize;
        ScalarUnit horizontalSize;
        Image image;
        byte repeat;

        BackgroundImage() {
            this.repeat = 0;
            this.verticalPositionType = 0;
            this.horizontalPositionType = 0;
        }

        BackgroundImage(Image image) {
            this.image = image;
            this.repeat = 0;
            this.verticalPositionType = 0;
            this.horizontalPositionType = 0;
        }

        public String toCSSString() {
            if (this.linearGradient != null) {
                return this.linearGradient.toCSSString();
            }
            if (this.radialGradient != null) {
                return this.radialGradient.toCSSString();
            }
            if (this.image != null && this.image.getImageName() != null) {
                return "url(\"" + this.image.getImageName() + "\"";
            }
            return "none";
        }

        private void setPosition(String pos) {
        }

        private String getBackgroundPositionCSSString() {
            StringBuilder sb = new StringBuilder();
            switch (this.verticalPositionType) {
                case 0: {
                    sb.append("top").append(" ");
                    break;
                }
                case 1: {
                    sb.append("bottom").append(" ");
                    break;
                }
                case 2: {
                    sb.append("center").append(" ");
                }
            }
            if (this.verticalPosition != null) {
                sb.append(this.verticalPosition.toCSSString()).append(" ");
            }
            switch (this.horizontalPositionType) {
                case 0: {
                    sb.append("left").append(" ");
                    break;
                }
                case 1: {
                    sb.append("right").append(" ");
                    break;
                }
                case 2: {
                    sb.append("center").append(" ");
                }
            }
            if (this.horizontalPosition != null) {
                sb.append(this.horizontalPosition.toCSSString()).append(" ");
            }
            return sb.toString().trim();
        }

        private Rectangle2D getTargetRect(Component c, Rectangle2D out, Rectangle2D contentRect) {
            if (this.image != null) {
                double w = this.image.getWidth();
                double h = this.image.getHeight();
                switch (this.verticalSizeType) {
                    case 1: {
                        if (w > contentRect.getWidth()) {
                            h = h * contentRect.getWidth() / w;
                            w = contentRect.getWidth();
                        }
                        if (!(h > contentRect.getHeight())) break;
                        w = contentRect.getHeight() / h;
                        h = contentRect.getHeight();
                        break;
                    }
                    case 2: {
                        double aspect = w / h;
                        w = this.image.getWidth();
                        h = w / aspect;
                        if (!(h < (double)this.image.getHeight())) break;
                        h = this.image.getHeight();
                        w = h * aspect;
                        break;
                    }
                    case 99: {
                        w = CSSBorder.this.floatPx(this.horizontalSize, c, contentRect, true);
                        h = CSSBorder.this.floatPx(this.verticalSize, c, contentRect, false);
                    }
                }
                double x = contentRect.getX();
                double y = contentRect.getY();
                switch (this.verticalPositionType) {
                    case 1: {
                        y = contentRect.getY() + contentRect.getHeight() - h;
                        break;
                    }
                    case 2: {
                        y = contentRect.getY() + contentRect.getHeight() / 2.0 - h / 2.0;
                        break;
                    }
                    case 99: {
                        y = contentRect.getY() + (double)CSSBorder.this.floatPx(this.verticalPosition, c, contentRect, false);
                    }
                }
                switch (this.horizontalPositionType) {
                    case 1: {
                        x = contentRect.getX() + contentRect.getWidth() - w;
                        break;
                    }
                    case 2: {
                        x = contentRect.getX() + contentRect.getWidth() / 2.0 - w / 2.0;
                        break;
                    }
                    case 99: {
                        x = contentRect.getX() + (double)CSSBorder.this.floatPx(this.horizontalPosition, c, contentRect, true);
                    }
                }
                out.setBounds(x, y, w, h);
                return out;
            }
            out.setBounds(contentRect.getX(), contentRect.getY(), contentRect.getWidth(), contentRect.getHeight());
            return out;
        }

        void paint(Graphics g, Component c, Rectangle2D contentRect) {
            if (this.image != null) {
                switch (this.repeat) {
                    case 0: {
                        Rectangle2D targetRect = this.getTargetRect(c, new Rectangle2D(), contentRect);
                        g.drawImage(this.image, (int)targetRect.getX(), (int)targetRect.getY(), (int)targetRect.getWidth(), (int)targetRect.getHeight());
                        break;
                    }
                    case 2: {
                        double offX;
                        Rectangle2D targetRect = this.getTargetRect(c, new Rectangle2D(), contentRect);
                        Image scaled = this.image.scaled((int)targetRect.getWidth(), (int)targetRect.getHeight());
                        for (offX = targetRect.getX() - contentRect.getX(); offX > 0.0; offX -= targetRect.getWidth()) {
                        }
                        g.tileImage(scaled, (int)(contentRect.getX() + offX), (int)targetRect.getY(), (int)(contentRect.getWidth() - offX), (int)targetRect.getHeight());
                        break;
                    }
                    case 3: {
                        double offY;
                        Rectangle2D targetRect = this.getTargetRect(c, new Rectangle2D(), contentRect);
                        Image scaled = this.image.scaled((int)targetRect.getWidth(), (int)targetRect.getHeight());
                        for (offY = targetRect.getY() - contentRect.getY(); offY > 0.0; offY -= targetRect.getHeight()) {
                        }
                        g.tileImage(scaled, (int)targetRect.getX(), (int)(contentRect.getY() + offY), (int)targetRect.getWidth(), (int)(contentRect.getHeight() - offY));
                        break;
                    }
                    case 1: {
                        double offX;
                        double offY;
                        Rectangle2D targetRect = this.getTargetRect(c, new Rectangle2D(), contentRect);
                        Image scaled = this.image.scaled((int)targetRect.getWidth(), (int)targetRect.getHeight());
                        for (offY = targetRect.getY() - contentRect.getY(); offY > 0.0; offY -= targetRect.getHeight()) {
                        }
                        for (offX = targetRect.getX() - contentRect.getX(); offX > 0.0; offX -= targetRect.getWidth()) {
                        }
                        g.tileImage(scaled, (int)(contentRect.getX() + offX), (int)(contentRect.getY() + offY), (int)(contentRect.getWidth() - offX), (int)(contentRect.getHeight() - offY));
                        break;
                    }
                }
            } else {
                if (this.linearGradient != null) {
                    ColorStop prevColor = null;
                    double contentWidth = contentRect.getWidth() * Math.cos(this.linearGradient.directionRadian()) + contentRect.getHeight() * Math.sin(this.linearGradient.directionRadian());
                    double contentHeight = contentRect.getHeight() + Math.cos(this.linearGradient.directionRadian()) + contentRect.getWidth() * Math.sin(this.linearGradient.directionRadian());
                    double contentX = contentRect.getX() + contentRect.getWidth() / 2.0 - contentWidth / 2.0;
                    double contentY = contentRect.getY() + contentRect.getHeight() / 2.0 - contentHeight / 2.0;
                    double x = contentX;
                    Transform existingT = null;
                    if (this.linearGradient.directionRadian() != 0.0) {
                        existingT = Transform.makeIdentity();
                        g.getTransform(existingT);
                        Transform newT = existingT.copy();
                        newT.rotate((float)this.linearGradient.directionRadian(), (float)(contentX + contentWidth / 2.0), (int)(contentY + contentHeight / 2.0));
                        g.setTransform(newT);
                    }
                    for (ColorStop colorStop : this.linearGradient.colors) {
                        if (prevColor == null) {
                            prevColor = colorStop;
                            continue;
                        }
                        int alpha = g.getAlpha();
                        CSSBorder.this.setAlpha(g, colorStop.color);
                        double nextX = x + contentWidth * (double)colorStop.position / 100.0;
                        g.fillLinearGradient(prevColor.color.color, colorStop.color.color, (int)x, (int)contentY, (int)(nextX - x), (int)contentHeight, true);
                        g.setAlpha(alpha);
                        x = nextX;
                    }
                    if (existingT != null) {
                        g.setTransform(existingT);
                    }
                }
                if (this.radialGradient != null) {
                    // empty if block
                }
            }
        }
    }

    private class BorderImage {
        Image image;
        double[] slices;
        Border internal;
        String imageName;

        BorderImage(String imageName, double ... slces) {
            this.imageName = imageName;
            this.slices = new double[4];
            if (slces.length == 4) {
                System.arraycopy(slces, 0, this.slices, 0, 4);
            } else if (slces.length == 3) {
                this.slices[0] = slces[0];
                this.slices[1] = this.slices[3] = slces[1];
                this.slices[2] = slces[2];
            } else if (slces.length == 2) {
                this.slices[0] = this.slices[2] = slces[0];
                this.slices[1] = this.slices[3] = slces[1];
            } else if (slces.length == 1) {
                this.slices[2] = this.slices[3] = slces[0];
                this.slices[1] = this.slices[3];
                this.slices[0] = this.slices[3];
            } else {
                throw new IllegalArgumentException("Slices expected to be length 1 to 4, but found size " + slces.length + ": " + Arrays.toString(slces));
            }
        }

        BorderImage(Image img, double ... slces) {
            this.image = img;
            this.slices = new double[4];
            if (slces.length == 4) {
                System.arraycopy(slces, 0, this.slices, 0, 4);
            } else if (slces.length == 3) {
                this.slices[0] = slces[0];
                this.slices[1] = this.slices[3] = slces[1];
                this.slices[2] = slces[2];
            } else if (slces.length == 2) {
                this.slices[0] = this.slices[2] = slces[0];
                this.slices[1] = this.slices[3] = slces[1];
            } else if (slces.length == 1) {
                this.slices[2] = this.slices[3] = slces[0];
                this.slices[1] = this.slices[3];
                this.slices[0] = this.slices[3];
            } else {
                throw new IllegalArgumentException("Slices expected to be length 1 to 4, but found size " + slces.length + ": " + Arrays.toString(slces));
            }
            this.internal = Border.createImageSplicedBorder(img, this.slices[0], this.slices[1], this.slices[2], this.slices[3]);
        }

        void paint(Graphics g, Component c, Rectangle2D contentRect) {
            this.internal().paint(g, (int)contentRect.getX(), (int)contentRect.getY(), (int)contentRect.getWidth(), (int)contentRect.getHeight(), c);
        }

        Image image() {
            if (this.image == null) {
                this.image = CSSBorder.this.res.getImage(this.imageName);
                if (this.image == null) {
                    try {
                        this.image = EncodedImage.create("/" + this.imageName);
                    }
                    catch (IOException ex) {
                        Log.p("Failed to load image named " + this.imageName + " for CSSBorder");
                        throw new IllegalStateException("Failed to load image " + this.imageName);
                    }
                }
            }
            return this.image;
        }

        Border internal() {
            if (this.internal == null) {
                this.internal = Border.createImageSplicedBorder(this.image(), this.slices[0], this.slices[1], this.slices[2], this.slices[3]);
            }
            return this.internal;
        }

        String toCSSString() {
            String imgName = this.imageName;
            if (imgName == null && this.image != null) {
                imgName = this.image.getImageName();
            }
            return Util.encodeUrl(imgName) + " " + this.slices[0] + " " + this.slices[1] + " " + this.slices[2] + " " + this.slices[3];
        }
    }

    private static class BorderStroke {
        byte type;
        ScalarUnit thickness;
        Color color;

        public String toBorderWidthCSSString() {
            return this.thickness.toCSSString();
        }

        public String toBorderColorCSSString() {
            return this.color.toCSSString();
        }

        public String toBorderStyleCSSString() {
            switch (this.type) {
                case 4: {
                    return "solid";
                }
                case 2: {
                    return "dotted";
                }
                case 3: {
                    return "dashed";
                }
                case 1: {
                    return "hidden";
                }
                case 0: {
                    return "none";
                }
            }
            return "none";
        }

        BorderStroke(String value) {
            String[] parts = Util.split(value, " ");
            if (parts.length == 3) {
                this.thickness = BorderStroke.parseThickness(parts[0]);
                this.type = CSSBorder.getBorderStyle(parts[1]);
                this.color = Color.parse(parts[2]);
            } else if (parts.length == 2) {
                int index = 0;
                if (BorderStroke.validateThickness(parts[index])) {
                    this.thickness = BorderStroke.parseThickness(parts[index]);
                    ++index;
                } else {
                    this.thickness = BorderStroke.parseThickness("medium");
                }
                if (CSSBorder.validateBorderStyle(parts[index])) {
                    this.type = CSSBorder.getBorderStyle(parts[index]);
                    ++index;
                } else {
                    this.type = 0;
                }
                if (index < 2) {
                    this.color = Color.parse(parts[index]);
                    ++index;
                } else {
                    this.color = Color.parse("transparent");
                }
                if (index < 2) {
                    throw new IllegalArgumentException("Illegal border stroke parameter " + value);
                }
            } else if (parts.length == 1) {
                boolean used = false;
                if (BorderStroke.validateThickness(value)) {
                    this.thickness = BorderStroke.parseThickness(value);
                    used = true;
                } else {
                    this.thickness = BorderStroke.parseThickness("medium");
                }
                if (!used && CSSBorder.validateBorderStyle(value)) {
                    this.type = CSSBorder.getBorderStyle(value);
                    used = true;
                } else {
                    this.type = 0;
                }
                if (!used && Color.validate(value)) {
                    this.color = Color.parse(value);
                    used = true;
                } else {
                    this.color = Color.parse("transparent");
                }
                if (!used) {
                    throw new IllegalArgumentException("Illegal border stroke parameter " + value);
                }
            } else {
                throw new IllegalArgumentException("Illegal border stroke parameter " + value);
            }
        }

        BorderStroke(BorderStroke stroke) {
            this.type = stroke.type;
            this.thickness = stroke.thickness.copy();
            this.color = stroke.color;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BorderStroke) {
                BorderStroke s = (BorderStroke)obj;
                return s.type == this.type && s.thickness.equals(this.thickness) && s.color.equals(this.color);
            }
            return false;
        }

        boolean isVisible() {
            return this.color != null && !CSSBorder.isTransparent(this.color) && this.type != 0 && this.type != 1;
        }

        static boolean validateThickness(String val) {
            return ScalarUnit.validate(val) || "thin".equals(val) || "medium".equals(val) || "thick".equals(val);
        }

        static ScalarUnit parseThickness(String val) {
            if (ScalarUnit.validate(val = val.trim())) {
                return new ScalarUnit(val);
            }
            if ("thin".equals(val)) {
                return new ScalarUnit("1px");
            }
            if ("medium".equals(val)) {
                return new ScalarUnit("0.75mm");
            }
            if ("thick".equals(val)) {
                return new ScalarUnit("1.4mm");
            }
            throw new IllegalArgumentException("Illegal thickness value " + val);
        }

        Stroke getStroke(Component c, Rectangle2D contentRect, boolean horizontal) {
            return new Stroke(this.thickness.floatPx(c, contentRect, horizontal), 0, 0, 100.0f);
        }
    }

    private class RadialGradient {
        byte shape;
        byte size;
        float xPos;
        float yPos;
        ColorStop[] colors;

        private RadialGradient() {
        }

        private String toCSSString() {
            throw new RuntimeException("RadialGradlient toCSSString() not implemented yet");
        }
    }

    private class LinearGradient {
        float angle;
        ColorStop[] colors;

        private LinearGradient() {
        }

        double directionRadian() {
            return (double)this.angle * Math.PI / 180.0;
        }

        private String toCSSString() {
            StringBuilder sb = new StringBuilder();
            sb.append("linear-gradient(");
            sb.append(this.angle).append("deg");
            sb.append(",");
            boolean first = true;
            for (ColorStop cs : this.colors) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(cs.toCSSString());
            }
            sb.append(")");
            return sb.toString();
        }
    }

    private class ColorStop {
        Color color;
        int position;

        private ColorStop() {
        }

        public String toCSSString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.color.toCSSString());
            if (this.position > 0) {
                sb.append(" ").append(this.position).append("%");
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Color {
        int color;
        int alpha;
        static final int CACHE_SIZE = 100;
        static Map<String, Color> cache;

        static Map<String, Color> cache() {
            if (cache == null) {
                cache = new HashMap<String, Color>();
            }
            return cache;
        }

        private String padLeft(String str, int len) {
            while (str.length() < len) {
                str = "0" + str;
            }
            return str;
        }

        public String toCSSString() {
            StringBuilder sb = new StringBuilder();
            sb.append("#");
            sb.append(this.padLeft(Integer.toHexString(this.color), 6));
            sb.append(this.padLeft(Integer.toHexString(this.alpha), 2));
            return sb.toString();
        }

        static Color parse(String value) {
            value = value.trim();
            if (!Color.cache().containsKey(value)) {
                if (cache.size() > 100) {
                    cache.clear();
                }
                cache.put(value, new Color(value));
            }
            return cache.get(value);
        }

        static boolean validate(String value) {
            return value.startsWith("#") || value.startsWith("rgb(") || value.startsWith("rbga(") || "transparent".equals(value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Color) {
                Color c = (Color)obj;
                return c.alpha == this.alpha && c.color == this.color;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Color(String value) {
            if (value.startsWith("#")) {
                if (value.length() == 9) {
                    this.alpha = Integer.parseInt(value.substring(7, 9), 16);
                    this.color = Integer.parseInt(value.substring(1, 7), 16);
                    return;
                } else if (value.length() == 7) {
                    this.alpha = 255;
                    this.color = Integer.parseInt(value.substring(1, 7), 16);
                    return;
                } else if (value.length() == 5) {
                    String rStr = value.substring(1, 2);
                    String gStr = value.substring(2, 3);
                    String bStr = value.substring(3, 4);
                    String aStr = value.substring(4, 5);
                    this.alpha = Integer.parseInt(aStr + aStr, 16);
                    this.color = 0xFFFFFF & ColorUtil.rgb(Integer.parseInt(rStr + rStr, 16), Integer.parseInt(gStr + gStr, 16), Integer.parseInt(bStr + bStr, 16));
                    return;
                } else {
                    if (value.length() != 4) throw new IllegalArgumentException("Illegal color value " + value);
                    this.alpha = 255;
                    String rStr = value.substring(1, 2);
                    String gStr = value.substring(2, 3);
                    String bStr = value.substring(3, 4);
                    this.color = 0xFFFFFF & ColorUtil.rgb(Integer.parseInt(rStr + rStr, 16), Integer.parseInt(gStr + gStr, 16), Integer.parseInt(bStr + bStr, 16));
                }
                return;
            } else {
                if (value.startsWith("rgb(")) {
                    throw new IllegalArgumentException("rgb() color values not supported yet: " + value);
                }
                if (!"transparent".equals(value)) throw new IllegalArgumentException("Unsuppored color value: " + value);
                this.alpha = 0;
                this.color = 0;
            }
        }

        boolean isTransparent() {
            return this.alpha == 0;
        }
    }

    private class BorderRadius {
        private ScalarUnit topLeftX;
        private ScalarUnit topRightX;
        private ScalarUnit bottomLeftX;
        private ScalarUnit bottomRightX;
        private ScalarUnit topLeftY;
        private ScalarUnit topRightY;
        private ScalarUnit bottomLeftY;
        private ScalarUnit bottomRightY;

        ScalarUnit[] all() {
            return new ScalarUnit[]{this.topLeftX, this.topLeftY, this.topRightX, this.topRightY, this.bottomRightX, this.bottomRightY, this.bottomLeftX, this.bottomLeftY};
        }

        ScalarUnit[] horizontal() {
            return new ScalarUnit[]{this.topLeftX, this.topRightX, this.bottomRightX, this.bottomLeftX};
        }

        ScalarUnit[] vertical() {
            return new ScalarUnit[]{this.topLeftY, this.topRightY, this.bottomRightY, this.bottomLeftY};
        }

        ScalarUnit[] topLeft() {
            return new ScalarUnit[]{this.topLeftX, this.topLeftY};
        }

        ScalarUnit[] topRight() {
            return new ScalarUnit[]{this.topRightX, this.topRightY};
        }

        ScalarUnit[] bottomRight() {
            return new ScalarUnit[]{this.bottomRightX, this.bottomRightY};
        }

        ScalarUnit[] bottomLeft() {
            return new ScalarUnit[]{this.bottomLeftX, this.bottomLeftY};
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        BorderRadius(String value) {
            if (value.indexOf("/") > 0) {
                String[] parts = Util.split(value, "/");
                String[] hVals = Util.split(parts[0].trim(), " ");
                Object[] vVals = Util.split(parts[1].trim(), " ");
                if (hVals.length == 1) {
                    this.topLeftX = new ScalarUnit(hVals[0]);
                    this.topRightX = new ScalarUnit(this.topLeftX);
                    this.bottomLeftX = new ScalarUnit(this.topLeftX);
                    this.bottomRightX = new ScalarUnit(this.topLeftX);
                } else if (hVals.length == 2) {
                    this.topLeftX = new ScalarUnit(hVals[0]);
                    this.bottomRightX = new ScalarUnit(this.topLeftX);
                    this.topRightX = new ScalarUnit(hVals[1]);
                    this.bottomLeftX = new ScalarUnit(this.topRightX);
                } else if (hVals.length == 3) {
                    this.topLeftX = new ScalarUnit(hVals[0]);
                    this.topRightX = new ScalarUnit(hVals[1]);
                    this.bottomLeftX = new ScalarUnit(this.topRightX);
                    this.bottomRightX = new ScalarUnit(hVals[2]);
                } else {
                    if (hVals.length != 4) throw new IllegalArgumentException("Border radius should include 1, 2, 3, of 4 params only");
                    this.topLeftX = new ScalarUnit(hVals[0]);
                    this.topRightX = new ScalarUnit(hVals[1]);
                    this.bottomRightX = new ScalarUnit(hVals[2]);
                    this.bottomLeftX = new ScalarUnit(hVals[3]);
                }
                if (vVals.length == 1) {
                    this.topLeftY = new ScalarUnit(vVals[0]);
                    this.topRightY = new ScalarUnit(this.topLeftY);
                    this.bottomLeftY = new ScalarUnit(this.topLeftY);
                    this.bottomRightY = new ScalarUnit(this.topLeftY);
                    return;
                } else if (vVals.length == 2) {
                    this.topLeftY = new ScalarUnit(vVals[0]);
                    this.bottomRightY = new ScalarUnit(this.topLeftY);
                    this.topRightY = new ScalarUnit(hVals[1]);
                    this.bottomLeftY = new ScalarUnit(this.topRightY);
                    return;
                } else if (vVals.length == 3) {
                    this.topLeftY = new ScalarUnit(hVals[0]);
                    this.topRightY = new ScalarUnit(hVals[1]);
                    this.bottomLeftY = new ScalarUnit(this.topRightY);
                    this.bottomRightY = new ScalarUnit(hVals[2]);
                    return;
                } else {
                    if (vVals.length != 4) throw new IllegalArgumentException("Border radius should include 1, 2, 3, of 4 params only: " + Arrays.toString(vVals));
                    this.topLeftY = new ScalarUnit(vVals[0]);
                    this.topRightY = new ScalarUnit((String)vVals[1]);
                    this.bottomRightY = new ScalarUnit((String)vVals[2]);
                    this.bottomLeftY = new ScalarUnit((String)vVals[3]);
                }
                return;
            } else {
                String[] vals = Util.split(value, " ");
                switch (vals.length) {
                    case 1: {
                        this.topLeftX = new ScalarUnit(vals[0]);
                        this.topLeftY = this.topLeftX.copy();
                        this.topRightX = this.topLeftX.copy();
                        this.topRightY = this.topLeftX.copy();
                        this.bottomRightX = this.topLeftX.copy();
                        this.bottomRightY = this.topLeftX.copy();
                        this.bottomLeftX = this.topLeftX.copy();
                        this.bottomLeftY = this.topLeftX.copy();
                        return;
                    }
                    case 2: {
                        this.topLeftX = new ScalarUnit(vals[0]);
                        this.topLeftY = this.topLeftX.copy();
                        this.bottomRightX = this.topLeftX.copy();
                        this.bottomRightY = this.topLeftX.copy();
                        this.topRightX = new ScalarUnit(vals[1]);
                        this.topRightY = this.topRightX.copy();
                        this.bottomLeftX = this.topRightX.copy();
                        this.bottomLeftY = this.topRightX.copy();
                        return;
                    }
                    case 3: {
                        this.topLeftX = new ScalarUnit(vals[0]);
                        this.topLeftY = this.topLeftX.copy();
                        this.topRightX = new ScalarUnit(vals[1]);
                        this.topRightY = this.topRightX.copy();
                        this.bottomLeftX = this.topRightX.copy();
                        this.bottomLeftY = this.topRightX.copy();
                        this.bottomRightX = new ScalarUnit(vals[2]);
                        this.bottomRightY = this.bottomRightX.copy();
                        return;
                    }
                    case 4: {
                        this.topLeftX = new ScalarUnit(vals[0]);
                        this.topLeftY = this.topLeftX.copy();
                        this.topRightX = new ScalarUnit(vals[1]);
                        this.topRightY = this.topRightX.copy();
                        this.bottomRightX = new ScalarUnit(vals[2]);
                        this.bottomRightY = this.bottomRightX.copy();
                        this.bottomLeftX = new ScalarUnit(vals[3]);
                        this.bottomLeftY = this.bottomLeftX.copy();
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal input for border radius: " + value);
                    }
                }
            }
        }

        boolean hasNonZeroRadius() {
            return this.topLeftX != null && !this.topLeftX.isZero() || this.topRightX != null && !this.topRightX.isZero() || this.bottomLeftX != null && !this.bottomLeftX.isZero() || this.bottomRightX != null && !this.bottomRightX.isZero() || this.topLeftY != null && !this.topLeftY.isZero() || this.topRightY != null && !this.topRightY.isZero() || this.bottomLeftY != null && !this.bottomLeftY.isZero() || this.bottomRightY != null && !this.bottomRightY.isZero();
        }

        float topLeftRadiusX() {
            if (context != null) {
                return CSSBorder.this.floatPx(this.topLeftX, context.component, context.contentRect, true);
            }
            return CSSBorder.this.floatPx(this.topLeftX);
        }

        float topLeftRadiusY() {
            if (context != null) {
                return CSSBorder.this.floatPx(this.topLeftY, context.component, context.contentRect, false);
            }
            return CSSBorder.this.floatPx(this.topLeftY);
        }

        float topRightRadiusX() {
            if (context != null) {
                return CSSBorder.this.floatPx(this.topRightX, context.component, context.contentRect, true);
            }
            return CSSBorder.this.floatPx(this.topRightX);
        }

        float topRightRadiusY() {
            if (context != null) {
                return CSSBorder.this.floatPx(this.topRightY, context.component, context.contentRect, false);
            }
            return CSSBorder.this.floatPx(this.topRightY);
        }

        float bottomLeftX() {
            if (context != null) {
                return CSSBorder.this.floatPx(this.bottomLeftX, context.component, context.contentRect, true);
            }
            return CSSBorder.this.floatPx(this.bottomLeftX);
        }

        float bottomLeftY() {
            if (context != null) {
                return CSSBorder.this.floatPx(this.bottomLeftY, context.component, context.contentRect, false);
            }
            return CSSBorder.this.floatPx(this.bottomLeftY);
        }

        float bottomRightX() {
            if (context != null) {
                return CSSBorder.this.floatPx(this.bottomRightX, context.component, context.contentRect, true);
            }
            return CSSBorder.this.floatPx(this.bottomRightX);
        }

        float bottomRightY() {
            if (context != null) {
                return CSSBorder.this.floatPx(this.bottomRightY, context.component, context.contentRect, false);
            }
            return CSSBorder.this.floatPx(this.bottomRightY);
        }

        private String toCSSString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.topLeftX.toCSSString()).append(" ").append(this.topRightX.toCSSString()).append(" ").append(this.bottomRightX.toCSSString()).append(" ").append(this.bottomLeftX.toCSSString()).append(" / ").append(this.topLeftY.toCSSString()).append(" ").append(this.topRightY.toCSSString()).append(" ").append(this.bottomRightY.toCSSString()).append(" ").append(this.bottomLeftY.toCSSString());
            return sb.toString();
        }
    }

    private static class Context {
        Component component;
        Rectangle2D contentRect;

        Context(Component comp, Rectangle2D contentRect) {
            this.component = comp;
            this.contentRect = contentRect;
        }
    }

    private class BoxShadow {
        ScalarUnit hOffset;
        ScalarUnit vOffset;
        ScalarUnit blurRadius;
        ScalarUnit spread;
        boolean inset;
        Color color;

        private BoxShadow() {
        }

        int spreadPx() {
            return this.spread != null ? this.spread.px() : 0;
        }

        int blurPx() {
            return this.blurRadius != null ? this.blurRadius.px() : 0;
        }

        int vOffsetPx() {
            return this.vOffset != null ? this.vOffset.px() : 0;
        }

        int hOffsetPx() {
            return this.hOffset != null ? this.hOffset.px() : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void paint(Graphics g, Component c, Rectangle2D contentRect) {
            int alpha = g.getAlpha();
            int color = g.getColor();
            boolean antialiased = g.isAntiAliased();
            CSSBorder.this.setColor(g, this.color);
            GeneralPath p = GeneralPath.createFromPool();
            try {
                CSSBorder.this.createShape(p, contentRect.getX(), contentRect.getY(), contentRect.getWidth(), contentRect.getHeight(), CSSBorder.this.createArrow(c));
                p.transform(Transform.makeTranslation(this.hOffset.floatPx(c, contentRect, true), this.vOffset.floatPx(c, contentRect, false)));
                g.fillShape(p);
            }
            finally {
                GeneralPath.recycle(p);
                g.setAlpha(alpha);
                g.setColor(color);
                g.setAntiAliased(antialiased);
            }
        }

        private String toCSSString() {
            throw new RuntimeException("Box-shadow not fully supported yet");
        }
    }

    private static class ScalarUnit {
        float value;
        byte type;

        ScalarUnit copy() {
            return new ScalarUnit(this);
        }

        ScalarUnit(String unit) {
            if ("0".equals(unit) || "0.0".equals(unit)) {
                this.value = 0.0f;
                this.type = 0;
            } else if (unit.endsWith("mm")) {
                this.value = Float.parseFloat(unit.substring(0, unit.length() - 2));
                this.type = (byte)2;
            } else if (unit.endsWith("px")) {
                this.value = Integer.parseInt(unit.substring(0, unit.length() - 2));
                this.type = 0;
            } else if (unit.endsWith("em")) {
                this.value = Float.parseFloat(unit.substring(0, unit.length() - 2));
                this.type = (byte)4;
            } else if (unit.endsWith("%")) {
                this.value = Float.parseFloat(unit.substring(0, unit.length() - 1));
                this.type = 1;
            } else if (unit.endsWith("pt")) {
                this.value = Float.parseFloat(unit.substring(0, unit.length() - 2)) / 72.0f * 25.4f;
                this.type = (byte)2;
            } else if (unit.endsWith("in")) {
                this.value = Float.parseFloat(unit.substring(0, unit.length() - 2)) * 25.4f;
                this.type = (byte)2;
            } else {
                throw new IllegalArgumentException("Illegal unit " + unit);
            }
        }

        ScalarUnit(ScalarUnit u) {
            this.value = u.value;
            this.type = u.type;
        }

        ScalarUnit(float value, byte type) {
            this.value = value;
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ScalarUnit) {
                ScalarUnit u = (ScalarUnit)obj;
                return u.value == 0.0f && this.value == 0.0f || u.value == this.value && u.type == this.type;
            }
            return false;
        }

        static boolean validate(String val) {
            val = val.trim();
            int len = val.length();
            if ("0".equals(val) || "0.0".equals(val)) {
                return true;
            }
            if (val.endsWith("px") && ScalarUnit.isInt(val.substring(0, len - 2))) {
                return true;
            }
            if ((val.endsWith("em") || val.endsWith("mm") || val.endsWith("pt") || val.endsWith("in")) && ScalarUnit.isFloat(val.substring(0, len - 2))) {
                return true;
            }
            return val.endsWith("%") && ScalarUnit.isFloat(val.substring(0, len - 1));
        }

        private static boolean isInt(String val) {
            try {
                Integer.parseInt(val);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }

        private static boolean isFloat(String val) {
            try {
                Float.parseFloat(val);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }

        boolean isZero() {
            return this.value == 0.0f;
        }

        int px() {
            switch (this.type) {
                case 0: {
                    return (int)this.value;
                }
                case 2: {
                    return CN.convertToPixels(this.value);
                }
            }
            throw new IllegalArgumentException("Can't get px() units for type " + this.type + " without providing content rect");
        }

        float floatPx() {
            switch (this.type) {
                case 0: {
                    return this.value;
                }
                case 2: {
                    return (float)CN.convertToPixels(this.value * 1000.0f) / 1000.0f;
                }
            }
            throw new IllegalArgumentException("Can't get px() units for type " + this.type + " without providing content rect");
        }

        float floatPx(Component c, Rectangle2D contentRect, boolean horizontal) {
            switch (this.type) {
                case 0: {
                    return this.value;
                }
                case 2: {
                    return (float)CN.convertToPixels(this.value * 1000.0f) / 1000.0f;
                }
                case 1: {
                    return (float)(horizontal ? contentRect.getWidth() * (double)this.value / 100.0 : contentRect.getHeight() * (double)this.value / 100.0);
                }
                case 4: {
                    Font f = c.getStyle().getFont();
                    return f != null ? c.getStyle().getFont().getPixelSize() : Font.getDefaultFont().getPixelSize();
                }
            }
            throw new IllegalArgumentException("Can't get px() units for type " + this.type + " without providing content rect");
        }

        private String toCSSString() {
            StringBuilder sb = new StringBuilder();
            if (Math.ceil(this.value) == Math.floor(this.value)) {
                sb.append((int)this.value);
            } else {
                sb.append(this.value);
            }
            switch (this.type) {
                case 0: {
                    sb.append("px");
                    break;
                }
                case 2: {
                    sb.append("mm");
                    break;
                }
                case 1: {
                    sb.append("%");
                    break;
                }
                case 4: {
                    sb.append("em");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported unit type " + this.type);
                }
            }
            return sb.toString();
        }
    }

    private static interface Decorator {
        public CSSBorder decorate(CSSBorder var1, String var2, String var3);
    }
}

