/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.processing;

import com.codename1.processing.AbstractEvaluator;
import com.codename1.processing.StructuredContent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

class IndexEvaluator
extends AbstractEvaluator {
    static String FUNC_LAST = "last()";
    static String FUNC_POSITION = "position()";

    public IndexEvaluator(String expr) {
        super(expr);
    }

    private List _getByPositionLess(List elements, int rvalue) {
        if (rvalue > elements.size()) {
            return elements;
        }
        if (rvalue < 0) {
            return null;
        }
        AbstractList array = elements instanceof Vector ? new Vector() : new ArrayList();
        for (int i = 0; i < rvalue; ++i) {
            array.add(elements.get(i));
        }
        return array;
    }

    private List _getByPositionGreater(List elements, int rvalue) {
        if (rvalue >= elements.size()) {
            return null;
        }
        if (rvalue <= 0) {
            return elements;
        }
        AbstractList array = elements instanceof Vector ? new Vector() : new ArrayList();
        for (int i = rvalue; i < elements.size(); ++i) {
            array.add(elements.get(i));
        }
        return array;
    }

    private StructuredContent _getByLast(List elements, String expr) throws IllegalArgumentException {
        int index = expr.indexOf("-");
        if (index == -1) {
            throw new IllegalArgumentException("Could not handle expression: " + expr);
        }
        String rvalue = expr.substring(index + 1).trim();
        int dim = elements.size() - 1 - Integer.parseInt(rvalue);
        if (dim < 0) {
            return null;
        }
        return (StructuredContent)elements.get(dim);
    }

    protected Object evaluateSingle(List elements, String expr) {
        if (this.isNumeric(expr)) {
            int dim = Integer.parseInt(expr);
            if (dim < 0 || dim >= elements.size()) {
                return null;
            }
            return (StructuredContent)elements.get(dim);
        }
        if (expr.equals(FUNC_LAST)) {
            if (elements.size() == 0) {
                return null;
            }
            return (StructuredContent)elements.get(elements.size() - 1);
        }
        if (expr.indexOf(FUNC_LAST) != -1) {
            return this._getByLast(elements, expr);
        }
        if (expr.equals(FUNC_POSITION)) {
            return elements;
        }
        return null;
    }

    protected Object evaluateLeftLessRight(List elements, String lvalue, String rvalue) {
        if (FUNC_POSITION.equals(lvalue)) {
            return this._getByPositionLess(elements, Integer.parseInt(rvalue));
        }
        return null;
    }

    protected Object evaluateLeftGreaterRight(List elements, String lvalue, String rvalue) {
        if (FUNC_POSITION.equals(lvalue)) {
            return this._getByPositionGreater(elements, Integer.parseInt(rvalue));
        }
        return null;
    }
}

