/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maps;

public class Coord {
    private double longitude;
    private double latitude;
    private boolean projected;
    private static double DELTA = 1.0E-7;

    public Coord(double latitude, double longitude) {
        this(latitude, longitude, false);
    }

    public Coord(double latitude, double longitude, boolean projected) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.projected = projected;
    }

    public Coord(Coord toClone) {
        this.longitude = toClone.getLongitude();
        this.latitude = toClone.getLatitude();
        this.projected = toClone.isProjected();
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public String toString() {
        return "{'longitude':" + this.getLongitude() + ", 'latitude':" + this.getLatitude() + "}";
    }

    public Coord translate(double latitude, double longitude) {
        return new Coord(latitude + this.getLatitude(), longitude + this.getLongitude(), this.isProjected());
    }

    public Coord translate(Coord coordinates) {
        return this.translate(coordinates.getLatitude(), coordinates.getLongitude());
    }

    public boolean equals(Object other) {
        if (!(other instanceof Coord)) {
            return false;
        }
        Coord o = (Coord)other;
        return Math.abs(this.longitude - o.longitude) < DELTA && Math.abs(this.latitude - o.latitude) < DELTA;
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.longitude) ^ Double.doubleToLongBits(this.longitude) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.latitude) ^ Double.doubleToLongBits(this.latitude) >>> 32);
        return hash;
    }

    public final boolean isProjected() {
        return this.projected;
    }

    public void setProjected(boolean projected) {
        this.projected = projected;
    }
}

