/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.analytics;

import com.codename1.io.ConnectionRequest;
import com.codename1.io.Log;
import com.codename1.io.NetworkManager;
import com.codename1.ui.Display;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;

public class AnalyticsService {
    private static AnalyticsService instance;
    private static boolean appsMode;
    private String agent;
    private String domain;
    private static boolean failSilently;
    private ConnectionRequest lastRequest;
    private static int timeout;
    private static int readTimeout;

    public static boolean isFailSilently() {
        return failSilently;
    }

    public static void setFailSilently(boolean aFailSilently) {
        failSilently = aFailSilently;
    }

    public static boolean isAppsMode() {
        return appsMode;
    }

    public static void setTimeout(int ms) {
        timeout = ms;
    }

    public static void setReadTimeout(int ms) {
        readTimeout = ms;
    }

    public static void setAppsMode(boolean aAppsMode) {
        appsMode = aAppsMode;
    }

    public static boolean isEnabled() {
        return instance != null && instance.isAnalyticsEnabled();
    }

    protected boolean isAnalyticsEnabled() {
        return this.agent != null;
    }

    public static void init(String agent, String domain) {
        if (instance == null) {
            instance = new AnalyticsService();
        }
        AnalyticsService.instance.agent = agent;
        AnalyticsService.instance.domain = domain;
    }

    public static void init(AnalyticsService i) {
        instance = i;
    }

    public static void visit(String page, String referer) {
        instance.visitPage(page, referer);
    }

    protected void decorateVisitPageRequest(String page, String referer, ConnectionRequest request) {
    }

    protected void visitPage(String page, String referer) {
        if (this.lastRequest != null) {
            final String fPage = page;
            final String fReferer = referer;
            ActionListener onComplete = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AnalyticsService.this.visitPage(fPage, fReferer);
                }
            };
            this.lastRequest.addResponseListener(onComplete);
            this.lastRequest.addResponseCodeListener(onComplete);
            this.lastRequest.addExceptionListener(onComplete);
            return;
        }
        if (appsMode) {
            final ConnectionRequest req = AnalyticsService.GetGARequest();
            req.addArgument("t", "appview");
            req.addArgument("an", Display.getInstance().getProperty("AppName", "Codename One App"));
            String version = Display.getInstance().getProperty("AppVersion", "1.0");
            req.addArgument("av", version);
            req.addArgument("cd", page);
            ActionListener onComplete = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (req == AnalyticsService.this.lastRequest) {
                        AnalyticsService.this.lastRequest = null;
                    }
                }
            };
            req.addResponseListener(onComplete);
            req.addResponseCodeListener(onComplete);
            req.addExceptionListener(onComplete);
            this.lastRequest = req;
            this.decorateVisitPageRequest(page, referer, req);
            NetworkManager.getInstance().addToQueue(req);
        } else {
            String url = Display.getInstance().getProperty("cloudServerURL", "https://codename-one.appspot.com/") + "anal";
            final ConnectionRequest r = new ConnectionRequest();
            r.setUrl(url);
            r.setPost(false);
            r.setFailSilently(failSilently);
            r.addArgument("guid", "ON");
            r.addArgument("utmac", AnalyticsService.instance.agent);
            r.addArgument("utmn", Integer.toString((int)(System.currentTimeMillis() % Integer.MAX_VALUE)));
            if (page == null || page.length() == 0) {
                page = "-";
            }
            r.addArgument("utmp", page);
            if (referer == null || referer.length() == 0) {
                referer = "-";
            }
            r.addArgument("utmr", referer);
            r.addArgument("d", AnalyticsService.instance.domain);
            r.setPriority((byte)30);
            if (timeout > 0) {
                r.setTimeout(timeout);
            }
            if (readTimeout > 0) {
                r.setReadTimeout(readTimeout);
            }
            ActionListener onComplete = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (r == AnalyticsService.this.lastRequest) {
                        AnalyticsService.this.lastRequest = null;
                    }
                }
            };
            r.addResponseListener(onComplete);
            r.addResponseCodeListener(onComplete);
            r.addExceptionListener(onComplete);
            this.lastRequest = r;
            this.decorateVisitPageRequest(page, referer, r);
            NetworkManager.getInstance().addToQueue(r);
        }
    }

    public static void sendCrashReport(Throwable t, String message, boolean fatal) {
        ConnectionRequest req = AnalyticsService.GetGARequest();
        req.addArgument("t", "exception");
        System.out.println(message);
        req.addArgument("exd", message.substring(0, Math.min(message.length(), 150) - 1));
        if (fatal) {
            req.addArgument("exf", "1");
        } else {
            req.addArgument("exf", "0");
        }
        NetworkManager.getInstance().addToQueue(req);
    }

    private static ConnectionRequest GetGARequest() {
        ConnectionRequest req = new ConnectionRequest();
        req.setUrl("https://www.google-analytics.com/collect");
        req.setPost(true);
        req.setFailSilently(true);
        req.addArgument("v", "1");
        req.addArgument("tid", AnalyticsService.instance.agent);
        if (timeout > 0) {
            req.setTimeout(timeout);
        }
        if (readTimeout > 0) {
            req.setReadTimeout(readTimeout);
        }
        long uniqueId = Log.getUniqueDeviceId();
        req.addArgument("cid", String.valueOf(uniqueId));
        return req;
    }

    static {
        appsMode = true;
        failSilently = true;
    }
}

