/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maps;

import com.codename1.maps.BoundingBox;
import com.codename1.maps.Coord;

public abstract class Projection {
    private BoundingBox extent;

    protected Projection(BoundingBox extent) {
        this.extent = extent;
    }

    public BoundingBox extent() {
        return this.extent;
    }

    public abstract Coord fromWGS84(Coord var1);

    public abstract Coord toWGS84(Coord var1);

    public final Coord[] fromWGS84(Coord[] coords) {
        Coord[] newCoords = new Coord[coords.length];
        int length = coords.length;
        for (int i = 0; i < length; ++i) {
            newCoords[i] = this.fromWGS84(coords[i]);
        }
        return newCoords;
    }

    public final BoundingBox fromWGS84(BoundingBox bbox) {
        return new BoundingBox(this.fromWGS84(bbox.getSouthWest()), this.fromWGS84(bbox.getNorthEast()));
    }

    public final BoundingBox toWGS84(BoundingBox bbox) {
        return new BoundingBox(this.toWGS84(bbox.getSouthWest()), this.toWGS84(bbox.getNorthEast()));
    }
}

