/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.annotations.Async;
import com.codename1.capture.VideoCaptureConstraints;
import com.codename1.codescan.CodeScanner;
import com.codename1.contacts.Contact;
import com.codename1.db.Database;
import com.codename1.impl.CodenameOneImplementation;
import com.codename1.impl.CodenameOneThread;
import com.codename1.impl.ImplementationFactory;
import com.codename1.impl.VirtualKeyboardInterface;
import com.codename1.io.Log;
import com.codename1.io.Preferences;
import com.codename1.io.Util;
import com.codename1.l10n.L10NManager;
import com.codename1.location.LocationManager;
import com.codename1.media.Media;
import com.codename1.media.MediaRecorderBuilder;
import com.codename1.messaging.Message;
import com.codename1.notifications.LocalNotification;
import com.codename1.payment.Purchase;
import com.codename1.plugin.PluginSupport;
import com.codename1.plugin.event.IsGalleryTypeSupportedEvent;
import com.codename1.plugin.event.OpenGalleryEvent;
import com.codename1.system.CrashReport;
import com.codename1.ui.BlockingDisallowedException;
import com.codename1.ui.BrowserComponent;
import com.codename1.ui.CN;
import com.codename1.ui.CN1Constants;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Font;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.MenuBar;
import com.codename1.ui.RunnableWrapper;
import com.codename1.ui.TextArea;
import com.codename1.ui.animations.Animation;
import com.codename1.ui.animations.CommonTransitions;
import com.codename1.ui.animations.Transition;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.MessageEvent;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;
import com.codename1.ui.util.ImageIO;
import com.codename1.util.AsyncResource;
import com.codename1.util.RunnableWithResultSync;
import com.codename1.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Display
extends CN1Constants {
    private CrashReport crashReporter;
    private EventDispatcher errorHandler;
    boolean codenameOneExited;
    private boolean inNativeUI;
    private Runnable bookmark;
    private EventDispatcher messageListeners;
    public static final String SOUND_TYPE_ALARM = "alarm";
    public static final String SOUND_TYPE_CONFIRMATION = "confirmation";
    public static final String SOUND_TYPE_ERROR = "error";
    public static final String SOUND_TYPE_INFO = "info";
    public static final String SOUND_TYPE_WARNING = "warning";
    public static final String SOUND_TYPE_BUTTON_PRESS = "press";
    public static final int KEYBOARD_TYPE_UNKNOWN = 0;
    public static final int KEYBOARD_TYPE_NUMERIC = 1;
    public static final int KEYBOARD_TYPE_QWERTY = 2;
    public static final int KEYBOARD_TYPE_VIRTUAL = 3;
    public static final int KEYBOARD_TYPE_HALF_QWERTY = 4;
    private static final int POINTER_PRESSED = 1;
    private static final int POINTER_RELEASED = 2;
    private static final int POINTER_DRAGGED = 3;
    private static final int POINTER_HOVER = 8;
    private static final int POINTER_HOVER_RELEASED = 11;
    private static final int POINTER_HOVER_PRESSED = 12;
    private static final int KEY_PRESSED = 4;
    private static final int KEY_RELEASED = 5;
    private static final int KEY_LONG_PRESSED = 6;
    private static final int SIZE_CHANGED = 7;
    private static final int HIDE_NOTIFY = 9;
    private static final int SHOW_NOTIFY = 10;
    private static final int POINTER_PRESSED_MULTI = 21;
    private static final int POINTER_RELEASED_MULTI = 22;
    private static final int POINTER_DRAGGED_MULTI = 23;
    private boolean disableInvokeAndBlock;
    private boolean enableAsyncStackTraces;
    private boolean pureTouch;
    private Graphics codenameOneGraphics;
    private boolean touchScreen;
    private HashMap<String, String> localProperties;
    private boolean noSleep = false;
    private boolean autoFoldVKBOnFormSwitch = true;
    private int framerateLock = 15;
    public static final int GAME_FIRE = 8;
    public static final int GAME_LEFT = 2;
    public static final int GAME_RIGHT = 5;
    public static final int GAME_UP = 1;
    public static final int GAME_DOWN = 6;
    public static final int MEDIA_KEY_SKIP_FORWARD = 20;
    public static final int MEDIA_KEY_SKIP_BACK = 21;
    public static final int MEDIA_KEY_PLAY = 22;
    public static final int MEDIA_KEY_STOP = 23;
    public static final int MEDIA_KEY_PLAY_STOP = 24;
    public static final int MEDIA_KEY_PLAY_PAUSE = 25;
    public static final int MEDIA_KEY_FAST_FORWARD = 26;
    public static final int MEDIA_KEY_FAST_BACKWARD = 27;
    public static final int KEY_POUND = 35;
    static final Display INSTANCE = new Display();
    static int transitionDelay = -1;
    static CodenameOneImplementation impl;
    private boolean codenameOneRunning = false;
    private ArrayList<Runnable> pendingSerialCalls = new ArrayList();
    private ArrayList<Runnable> pendingIdleSerialCalls = new ArrayList();
    private Thread edt;
    private ArrayList<Animation> animationQueue;
    private boolean thirdSoftButton = false;
    public static final int SHOW_DURING_EDIT_IGNORE = 1;
    public static final int SHOW_DURING_EDIT_EXCEPTION = 2;
    public static final int SHOW_DURING_EDIT_ALLOW_DISCARD = 3;
    public static final int SHOW_DURING_EDIT_ALLOW_SAVE = 4;
    public static final int SHOW_DURING_EDIT_SET_AS_NEXT = 5;
    private int showDuringEdit;
    static final Object lock;
    private int[] inputEventStack = new int[1000];
    private int inputEventStackPointer;
    private int[] inputEventStackTmp = new int[1000];
    private int inputEventStackPointerTmp;
    private boolean longPointerCharged;
    private boolean pointerPressedAndNotReleasedOrDragged;
    private boolean recursivePointerReleaseA;
    private boolean recursivePointerReleaseB;
    private int pointerX;
    private int pointerY;
    private boolean keyRepeatCharged;
    private boolean longPressCharged;
    private long longKeyPressTime;
    private int longPressInterval = 500;
    private long nextKeyRepeatEvent;
    private int keyRepeatValue;
    private int keyRepeatInitialIntervalTime = 800;
    private int keyRepeatNextIntervalTime = 10;
    private boolean lastInteractionWasKeypad;
    private boolean dragOccured;
    private boolean processingSerialCalls;
    private int PATHLENGTH;
    private float[] dragPathX;
    private float[] dragPathY;
    private long[] dragPathTime;
    private int dragPathOffset = 0;
    private int dragPathLength = 0;
    private Boolean darkMode;
    private PluginSupport pluginSupport;
    private long displayInitTime = 0L;
    private boolean allowMinimizing;
    public static final int COMMAND_BEHAVIOR_DEFAULT = 1;
    public static final int COMMAND_BEHAVIOR_SOFTKEY = 2;
    public static final int COMMAND_BEHAVIOR_TOUCH_MENU = 3;
    public static final int COMMAND_BEHAVIOR_BUTTON_BAR = 4;
    public static final int COMMAND_BEHAVIOR_BUTTON_BAR_TITLE_BACK = 5;
    public static final int COMMAND_BEHAVIOR_BUTTON_BAR_TITLE_RIGHT = 6;
    public static final int COMMAND_BEHAVIOR_ICS = 7;
    public static final int COMMAND_BEHAVIOR_SIDE_NAVIGATION = 8;
    public static final int COMMAND_BEHAVIOR_NATIVE = 10;
    private static String selectedVirtualKeyboard;
    private static Map<String, VirtualKeyboardInterface> virtualKeyboards;
    private boolean dropEvents;
    private ArrayList<Runnable> backgroundTasks;
    private Thread backgroundThread;
    private boolean multiKeyMode;
    private ActionListener virtualKeyboardListener;
    private EventDispatcher virtualKeyboardListeners;
    private int lastSizeChangeEventWH = -1;
    private DebugRunnable currentEdtContext;
    private static final int MAX_ASYNC_EXCEPTION_DEPTH = 10;
    long time;
    private final LinkedList<Runnable> runningSerialCallsQueue = new LinkedList();
    private int previousKeyPressed;
    private int lastKeyPressed;
    private int lastDragOffset;
    private Rectangle tmpRect = new Rectangle();
    private Form eventForm;
    private static final int[] xArray1;
    private static final int[] yArray1;

    public void setBookmark(Runnable bookmark) {
        this.bookmark = bookmark;
    }

    public void restoreToBookmark() {
        if (this.bookmark != null) {
            this.bookmark.run();
        }
    }

    private Display() {
    }

    public static void init(Object m) {
        if (!Display.INSTANCE.codenameOneRunning) {
            Display.INSTANCE.codenameOneRunning = true;
            Display.INSTANCE.pluginSupport = new PluginSupport();
            Display.INSTANCE.displayInitTime = System.currentTimeMillis();
            int commandBehaviour = 1;
            if (impl != null) {
                commandBehaviour = impl.getCommandBehavior();
            }
            impl = (CodenameOneImplementation)ImplementationFactory.getInstance().createImplementation();
            impl.setDisplayLock(lock);
            impl.initImpl(m);
            Display.INSTANCE.codenameOneGraphics = new Graphics(impl.getNativeGraphics());
            Display.INSTANCE.codenameOneGraphics.paintPeersBehind = impl.paintNativePeersBehind();
            impl.setCodenameOneGraphics(Display.INSTANCE.codenameOneGraphics);
            if (impl.isThirdSoftButton()) {
                Display.INSTANCE.thirdSoftButton = true;
            }
            if (impl.getSoftkeyCount() > 0) {
                MenuBar.leftSK = impl.getSoftkeyCode(0)[0];
                if (impl.getSoftkeyCount() > 1) {
                    MenuBar.rightSK = impl.getSoftkeyCode(1)[0];
                    if (impl.getSoftkeyCode(1).length > 1) {
                        MenuBar.rightSK2 = impl.getSoftkeyCode(1)[1];
                    }
                }
            }
            MenuBar.backSK = impl.getBackKeyCode();
            MenuBar.backspaceSK = impl.getBackspaceKeyCode();
            MenuBar.clearSK = impl.getClearKeyCode();
            Display.INSTANCE.PATHLENGTH = impl.getDragPathLength();
            Display.INSTANCE.dragPathX = new float[Display.INSTANCE.PATHLENGTH];
            Display.INSTANCE.dragPathY = new float[Display.INSTANCE.PATHLENGTH];
            Display.INSTANCE.dragPathTime = new long[Display.INSTANCE.PATHLENGTH];
            StringUtil.setImplementation(impl);
            Util.setImplementation(impl);
            if (Display.INSTANCE.edt == null) {
                Display.INSTANCE.touchScreen = impl.isTouchDevice();
                Display.INSTANCE.edt = new CodenameOneThread(new RunnableWrapper(null, 3), "EDT");
                impl.setThreadPriority(Display.INSTANCE.edt, impl.getEDTThreadPriority());
                Display.INSTANCE.edt.start();
            }
            impl.postInit();
            INSTANCE.setCommandBehavior(commandBehaviour);
        } else {
            impl.confirmControlView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deinitialize() {
        Display.INSTANCE.codenameOneRunning = false;
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInitialized() {
        if (!Display.INSTANCE.codenameOneRunning) return false;
        if (impl == null) return false;
        if (!impl.isInitialized()) return false;
        return true;
    }

    public static Display getInstance() {
        return INSTANCE;
    }

    public PluginSupport getPluginSupport() {
        return this.pluginSupport;
    }

    public int getDragStartPercentage() {
        return this.getImplementation().getDragStartPercentage();
    }

    public void setDragStartPercentage(int dragStartPercentage) {
        this.getImplementation().setDragStartPercentage(dragStartPercentage);
    }

    CodenameOneImplementation getImplementation() {
        return impl;
    }

    public void setFramerate(int rate) {
        this.framerateLock = 1000 / rate;
    }

    public void vibrate(int duration) {
        impl.vibrate(duration);
    }

    public void flashBacklight(int duration) {
        impl.flashBacklight(duration);
    }

    public void setShowDuringEditBehavior(int showDuringEdit) {
        this.showDuringEdit = showDuringEdit;
    }

    public int getShowDuringEditBehavior() {
        return this.showDuringEdit;
    }

    public int getFrameRate() {
        return 1000 / this.framerateLock;
    }

    public boolean isEdt() {
        return this.edt == Thread.currentThread();
    }

    void playDialogSound(int type) {
        impl.playDialogSound(type);
    }

    public void stopRemoteControl() {
        impl.stopRemoteControl();
    }

    public void startRemoteControl() {
        impl.startRemoteControl();
    }

    public Boolean isDarkMode() {
        if (this.darkMode != null) {
            return this.darkMode;
        }
        return impl.isDarkMode();
    }

    public void setDarkMode(Boolean darkMode) {
        this.darkMode = darkMode;
    }

    public boolean isEnableAsyncStackTraces() {
        return this.enableAsyncStackTraces;
    }

    public void setEnableAsyncStackTraces(boolean enableAsyncStackTraces) {
        this.enableAsyncStackTraces = enableAsyncStackTraces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSerially(Runnable r) {
        if (r == null) {
            throw new NullPointerException();
        }
        if (this.codenameOneRunning) {
            Object object = lock;
            synchronized (object) {
                this.scheduleSerialCall(this.isEnableAsyncStackTraces() ? new DebugRunnable(r) : r);
                lock.notifyAll();
            }
        } else {
            r.run();
        }
    }

    private void scheduleSerialCall(@Async.Schedule Runnable r) {
        this.pendingSerialCalls.add(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSeriallyOnIdle(Runnable r) {
        if (this.codenameOneRunning) {
            Object object = lock;
            synchronized (object) {
                this.pendingIdleSerialCalls.add(r);
                lock.notifyAll();
            }
        } else {
            r.run();
        }
    }

    public String getLineSeparator() {
        return impl.getLineSeparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleBackgroundTask(@Async.Schedule Runnable r) {
        Object object = lock;
        synchronized (object) {
            if (this.backgroundTasks == null) {
                this.backgroundTasks = new ArrayList();
            }
            this.backgroundTasks.add(r);
            if (this.backgroundThread == null) {
                this.backgroundThread = new CodenameOneThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        while (true) {
                            Runnable nextTask = null;
                            Object object = lock;
                            synchronized (object) {
                                if (Display.this.backgroundTasks.size() <= 0) {
                                    Display.this.backgroundThread = null;
                                    return;
                                }
                                nextTask = (Runnable)Display.this.backgroundTasks.get(0);
                                Display.this.backgroundTasks.remove(0);
                            }
                            try {
                                Display.this.executeBackgroundTaskRunnable(nextTask);
                            }
                            catch (Throwable e) {
                                Log.e(e);
                            }
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                    }
                }, "Task Thread");
                this.backgroundThread.setPriority(2);
                this.backgroundThread.start();
            }
        }
    }

    private void executeBackgroundTaskRunnable(@Async.Execute Runnable r) {
        r.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSeriallyAndWait(Runnable r) {
        if (this.isEdt()) {
            throw new RuntimeException("This method MUST NOT be invoked on the EDT");
        }
        RunnableWrapper c = new RunnableWrapper(r, 0);
        this.callSerially(c);
        this.flushEdt();
        Object object = lock;
        synchronized (object) {
            while (!c.isDone()) {
                try {
                    lock.wait(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean platformUsesInputMode() {
        return impl.platformUsesInputMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSeriallyAndWait(Runnable r, int timeout) {
        RunnableWrapper c = new RunnableWrapper(r, 0);
        this.callSerially(c);
        Object object = lock;
        synchronized (object) {
            long t = System.currentTimeMillis();
            while (!c.isDone()) {
                try {
                    lock.wait(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - t < (long)timeout) continue;
                return;
            }
        }
    }

    void flushEdt() {
        if (!this.isEdt()) {
            return;
        }
        while (!this.shouldEDTSleepNoFormAnimation()) {
            this.edtLoopImpl();
        }
        while (this.animationQueue != null && this.animationQueue.size() > 0) {
            this.edtLoopImpl();
        }
    }

    private void restoreMenu(Form f) {
        if (f != null) {
            f.restoreMenu();
        }
    }

    public boolean isInTransition() {
        if (this.animationQueue != null && this.animationQueue.size() > 0) {
            Animation ani = this.animationQueue.get(0);
            return ani instanceof Transition;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintTransitionAnimation() {
        Animation ani = this.animationQueue.get(0);
        if (!ani.animate()) {
            this.animationQueue.remove(0);
            if (ani instanceof Transition) {
                Form source = (Form)((Transition)ani).getSource();
                this.restoreMenu(source);
                if (this.animationQueue.size() > 0) {
                    ani = this.animationQueue.get(0);
                    if (ani instanceof Transition) {
                        ((Transition)ani).initTransition();
                    }
                } else {
                    Form f = (Form)((Transition)ani).getDestination();
                    this.restoreMenu(f);
                    if (source == null || source == impl.getCurrentForm() || source == this.getCurrent()) {
                        this.setCurrentForm(f);
                    }
                    ((Transition)ani).cleanup();
                }
                return;
            }
        }
        ani.paint(this.codenameOneGraphics);
        impl.flushGraphics();
        if (transitionDelay > 0) {
            try {
                Object source = lock;
                synchronized (source) {
                    lock.wait(transitionDelay);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mainEDTLoop() {
        Runnable r;
        block24: {
            impl.initEDT();
            UIManager.getInstance();
            try {
                while (impl.getCurrentForm() == null) {
                    Object object = lock;
                    synchronized (object) {
                        if (this.shouldEDTSleep()) {
                            if (this.pendingIdleSerialCalls.size() > 0) {
                                r = this.pendingIdleSerialCalls.get(0);
                                this.pendingIdleSerialCalls.remove(0);
                                this.callSerially(r);
                            } else {
                                lock.wait();
                            }
                        }
                        if (this.animationQueue != null && this.animationQueue.size() > 0) {
                            this.paintTransitionAnimation();
                            continue;
                        }
                    }
                    this.processSerialCalls();
                }
            }
            catch (Throwable err) {
                Log.e(err);
                if (this.crashReporter != null) {
                    this.crashReporter.exception(err);
                }
                if (impl.handleEDTException(err)) break block24;
                if (this.errorHandler != null) {
                    this.errorHandler.fireActionEvent(new ActionEvent((Object)err, ActionEvent.Type.Exception));
                }
                Dialog.show("Error", "An internal application error occurred: " + err.toString(), "OK", null);
            }
        }
        while (this.codenameOneRunning) {
            try {
                Object err = lock;
                synchronized (err) {
                    if (this.shouldEDTSleep()) {
                        if (this.pendingIdleSerialCalls.size() > 0) {
                            r = this.pendingIdleSerialCalls.get(0);
                            this.pendingIdleSerialCalls.remove(0);
                            this.callSerially(r);
                        } else {
                            impl.edtIdle(true);
                            lock.wait();
                            impl.edtIdle(false);
                        }
                    }
                }
                this.edtLoopImpl();
            }
            catch (Throwable err) {
                if (!this.codenameOneRunning) {
                    return;
                }
                Log.e(err);
                if (this.crashReporter != null) {
                    CodenameOneThread.handleException(err);
                }
                if (impl.handleEDTException(err)) continue;
                if (this.errorHandler != null) {
                    this.errorHandler.fireActionEvent(new ActionEvent((Object)err, ActionEvent.Type.Exception));
                    continue;
                }
                Dialog.show("Error", "An internal application error occurred: " + err.toString(), "OK", null);
            }
        }
        impl.deinitialize();
        Display.INSTANCE.edt = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void edtLoopImpl() {
        block18: {
            try {
                if (this.animationQueue == null || this.animationQueue.size() == 0) {
                    if (this.noSleep) break block18;
                    Object object = lock;
                    synchronized (object) {
                        impl.edtIdle(true);
                        lock.wait(Math.max(1L, (long)this.framerateLock - this.time));
                        impl.edtIdle(false);
                        break block18;
                    }
                }
                this.paintTransitionAnimation();
                return;
            }
            catch (Exception ignor) {
                Log.e(ignor);
            }
        }
        long currentTime = System.currentTimeMillis();
        Object object = lock;
        synchronized (object) {
            this.inputEventStackPointerTmp = this.inputEventStackPointer;
            this.inputEventStackPointer = 0;
            this.lastDragOffset = -1;
            int[] qt = this.inputEventStackTmp;
            this.inputEventStackTmp = this.inputEventStack;
            if (qt[qt.length - 1] == Integer.MAX_VALUE) {
                this.inputEventStack = new int[qt.length];
            } else {
                this.inputEventStack = qt;
                qt[qt.length - 1] = 0;
            }
        }
        int actualTmpPointer = this.inputEventStackPointerTmp;
        this.inputEventStackPointerTmp = 0;
        int[] actualStack = this.inputEventStackTmp;
        int offset = 0;
        actualStack[actualStack.length - 1] = Integer.MAX_VALUE;
        while (offset < actualTmpPointer) {
            offset = this.handleEvent(offset, actualStack);
        }
        actualStack[actualStack.length - 1] = 0;
        if (!impl.isInitialized()) {
            return;
        }
        this.codenameOneGraphics.setGraphics(impl.getNativeGraphics());
        Form current = impl.getCurrentForm();
        if (current != null) {
            current.flushRevalidateQueue();
        }
        impl.paintDirty();
        if (current != null) {
            current.repaintAnimations();
            long t = System.currentTimeMillis();
            if (this.keyRepeatCharged && this.nextKeyRepeatEvent <= t) {
                current.keyRepeated(this.keyRepeatValue);
                this.nextKeyRepeatEvent = t + (long)this.keyRepeatNextIntervalTime;
            }
            if (this.longPressCharged && (long)this.longPressInterval <= t - this.longKeyPressTime) {
                this.longPressCharged = false;
                current.longKeyPress(this.keyRepeatValue);
            }
            if (this.longPointerCharged && (long)this.longPressInterval <= t - this.longKeyPressTime) {
                this.longPointerCharged = false;
                current.longPointerPress(this.pointerX, this.pointerY);
            }
        }
        this.processSerialCalls();
        this.time = System.currentTimeMillis() - currentTime;
    }

    boolean hasNoSerialCallsPending() {
        return this.pendingSerialCalls.size() == 0;
    }

    public void onEditingComplete(final Component c, final String text) {
        if (!this.isEdt() && this.codenameOneRunning) {
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    Display.this.onEditingComplete(c, text);
                }
            });
            return;
        }
        c.onEditComplete(text);
        c.fireActionEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSerialCalls() {
        this.processingSerialCalls = true;
        int size = this.pendingSerialCalls.size();
        if (size > 0) {
            Object object = lock;
            synchronized (object) {
                size = this.pendingSerialCalls.size();
                this.runningSerialCallsQueue.addAll(this.pendingSerialCalls);
                if (size == this.pendingSerialCalls.size()) {
                    this.pendingSerialCalls.clear();
                } else {
                    for (int iter = 0; iter < size; ++iter) {
                        this.pendingSerialCalls.remove(0);
                    }
                }
            }
            while (!this.runningSerialCallsQueue.isEmpty()) {
                this.executeSerialCall(this.runningSerialCallsQueue.remove(0));
            }
            object = lock;
            synchronized (object) {
                lock.notify();
            }
        }
        this.processingSerialCalls = false;
    }

    private void executeSerialCall(@Async.Execute Runnable r) {
        r.run();
    }

    boolean isProcessingSerialCalls() {
        return this.processingSerialCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDisplay() {
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }

    public void invokeWithoutBlocking(Runnable r) {
        if (this.disableInvokeAndBlock || !this.isEdt()) {
            r.run();
        } else {
            this.disableInvokeAndBlock = true;
            try {
                r.run();
            }
            finally {
                this.disableInvokeAndBlock = false;
            }
        }
    }

    public <T> T invokeWithoutBlockingWithResultSync(RunnableWithResultSync<T> r) {
        if (this.disableInvokeAndBlock || !this.isEdt()) {
            return r.run();
        }
        this.disableInvokeAndBlock = true;
        try {
            T t = r.run();
            return t;
        }
        finally {
            this.disableInvokeAndBlock = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndBlock(Runnable r, boolean dropEvents) {
        block23: {
            this.dropEvents = dropEvents;
            try {
                if (this.isEdt()) {
                    if (this.disableInvokeAndBlock) {
                        throw new BlockingDisallowedException();
                    }
                    RunnableWrapper w = new RunnableWrapper(r, 1);
                    RunnableWrapper.pushToThreadPool(w);
                    Object object = lock;
                    synchronized (object) {
                        if (this.inputEventStackPointerTmp > 0) {
                            this.inputEventStackPointerTmp = this.inputEventStackPointer;
                        }
                        try {
                            lock.wait(2L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        while (!this.runningSerialCallsQueue.isEmpty()) {
                            this.pendingSerialCalls.add(0, this.runningSerialCallsQueue.removeLast());
                        }
                    }
                    while (!w.isDone() && this.codenameOneRunning) {
                        this.edtLoopImpl();
                        object = lock;
                        synchronized (object) {
                            if (this.shouldEDTSleep()) {
                                impl.edtIdle(true);
                                try {
                                    lock.wait(10L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                impl.edtIdle(false);
                            }
                        }
                    }
                    if (w.getErr() != null) {
                        throw w.getErr();
                    }
                    break block23;
                }
                r.run();
            }
            catch (RuntimeException re) {
                if (!(re instanceof BlockingDisallowedException)) {
                    Log.e(re);
                }
                throw re;
            }
            finally {
                this.dropEvents = false;
            }
        }
    }

    public void invokeAndBlock(Runnable r) {
        this.invokeAndBlock(r, false);
    }

    public boolean isTouchScreenDevice() {
        return this.touchScreen;
    }

    public void setTouchScreenDevice(boolean touchScreen) {
        this.touchScreen = touchScreen;
    }

    public void setNoSleep(boolean noSleep) {
        this.noSleep = noSleep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrent(Form newForm, boolean reverse) {
        Object t;
        Animation o;
        if (this.edt == null) {
            throw new IllegalStateException("Initialize must be invoked before setCurrent!");
        }
        Form current = impl.getCurrentForm();
        if (this.autoFoldVKBOnFormSwitch && !(newForm instanceof Dialog)) {
            this.setShowVirtualKeyboard(false);
        }
        if (current == newForm) {
            current.revalidate();
            current.repaint();
            current.onShowCompletedImpl();
            return;
        }
        if (impl.isEditingText()) {
            switch (this.showDuringEdit) {
                case 3: {
                    break;
                }
                case 4: {
                    impl.saveTextEditingState();
                    break;
                }
                case 2: {
                    throw new IllegalStateException("Show during edit");
                }
                case 1: {
                    return;
                }
                case 5: {
                    impl.setCurrentForm(newForm);
                    return;
                }
            }
        }
        if (!this.isEdt()) {
            this.callSerially(new RunnableWrapper(newForm, null, reverse));
            return;
        }
        if (current != null) {
            if (current.isInitialized()) {
                current.deinitializeImpl();
            } else {
                Form fg = this.getCurrentUpcoming();
                if (fg != current && fg.isInitialized()) {
                    fg.deinitializeImpl();
                }
            }
        }
        if (!newForm.isInitialized()) {
            newForm.initComponentImpl();
        }
        if (newForm.getWidth() != this.getDisplayWidth() || newForm.getHeight() != this.getDisplayHeight()) {
            newForm.setSize(new Dimension(this.getDisplayWidth(), this.getDisplayHeight()));
            newForm.setShouldCalcPreferredSize(true);
            newForm.layoutContainer();
            newForm.revalidate();
        } else {
            newForm.layoutContainer();
            newForm.revalidate();
        }
        boolean transitionExists = false;
        if (this.animationQueue != null && this.animationQueue.size() > 0 && (o = this.animationQueue.get(this.animationQueue.size() - 1)) instanceof Transition) {
            current = (Form)((Transition)o).getDestination();
            impl.setCurrentForm(current);
        }
        if (current != null) {
            if (current instanceof Dialog && ((Dialog)current).isMenu()) {
                t = current.getTransitionOutAnimator();
                if (t != null && ((Dialog)current).getPreviousForm() != null) {
                    this.initTransition(((Transition)t).copy(false), current, ((Dialog)current).getPreviousForm());
                }
                current = ((Dialog)current).getPreviousForm();
                impl.setCurrentForm(current);
            }
            if (newForm != current && (current != null && current.getTransitionOutAnimator() != null || newForm.getTransitionInAnimator() != null)) {
                if (this.animationQueue == null) {
                    this.animationQueue = new ArrayList();
                }
                if (current != null && !(newForm instanceof Dialog)) {
                    t = current.getTransitionOutAnimator();
                    if (current != null && t != null) {
                        transitionExists = this.initTransition(((Transition)t).copy(reverse), current, newForm);
                    }
                }
                if (current != null && !(current instanceof Dialog) && (t = newForm.getTransitionInAnimator()) != null) {
                    transitionExists = this.initTransition(((Transition)t).copy(reverse), current, newForm);
                }
            }
        }
        t = lock;
        synchronized (t) {
            lock.notify();
        }
        if (!transitionExists) {
            if (this.animationQueue == null || this.animationQueue.size() == 0) {
                this.setCurrentForm(newForm);
            } else {
                t = CommonTransitions.createEmpty();
                this.initTransition((Transition)t, current, newForm);
            }
        }
    }

    private boolean initTransition(Transition transition, Form source, Form dest) {
        try {
            dest.setVisible(true);
            transition.init(source, dest);
            if (source != null) {
                source.setLightweightMode(true);
            }
            if (dest != null) {
                dest.setLightweightMode(true);
            }
            transition = impl.getNativeTransition(transition);
            this.animationQueue.add(transition);
            if (this.animationQueue.size() == 1) {
                transition.initTransition();
            }
        }
        catch (Throwable e) {
            Log.e(e);
            transition.cleanup();
            this.animationQueue.remove(transition);
            return false;
        }
        return true;
    }

    void setCurrentForm(Form newForm) {
        boolean forceShow = false;
        Form current = impl.getCurrentForm();
        if (current != null) {
            current.setVisible(false);
        } else {
            forceShow = true;
        }
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        this.longPointerCharged = false;
        current = newForm;
        impl.setCurrentForm(current);
        current.setVisible(true);
        if (forceShow || !this.allowMinimizing || this.inNativeUI) {
            impl.confirmControlView();
        }
        int w = current.getWidth();
        int h = current.getHeight();
        if (this.isEdt() && (w != impl.getDisplayWidth() || h != impl.getDisplayHeight())) {
            current.sizeChangedInternal(impl.getDisplayWidth(), impl.getDisplayHeight());
        } else {
            this.repaint(current);
        }
        this.lastKeyPressed = 0;
        this.previousKeyPressed = 0;
        newForm.onShowCompletedImpl();
    }

    public void setTransitionYield(int transitionD) {
        transitionDelay = transitionD;
    }

    public void editString(Component cmp, int maxSize, int constraint, String text) {
        this.editString(cmp, maxSize, constraint, text, 0);
    }

    public void editString(Component cmp, int maxSize, int constraint, String text, int initiatingKeycode) {
        Form f;
        if (this.isTextEditing(cmp)) {
            return;
        }
        cmp.requestFocus();
        if (cmp instanceof TextArea) {
            ((TextArea)cmp).setSuppressActionEvent(false);
        }
        if ((f = cmp.getComponentForm()) == null) {
            return;
        }
        Component.setDisableSmoothScrolling(true);
        f.scrollComponentToVisible(cmp);
        Component.setDisableSmoothScrolling(false);
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        this.lastKeyPressed = 0;
        this.previousKeyPressed = 0;
        impl.editStringImpl(cmp, maxSize, constraint, text, initiatingKeycode);
    }

    public void stopEditing(Component cmp) {
        if (this.isTextEditing(cmp)) {
            impl.stopTextEditing();
        }
    }

    public void stopEditing(Component cmp, Runnable onFinish) {
        if (this.isTextEditing(cmp)) {
            impl.stopTextEditing(onFinish);
        } else if (onFinish != null) {
            onFinish.run();
        }
    }

    boolean isTextEditing(Component c) {
        if (c instanceof Form && c == this.getCurrent()) {
            return impl.isEditingText();
        }
        return impl.isEditingText(c);
    }

    boolean isNativeEditorVisible(Component c) {
        return impl.isNativeEditorVisible(c);
    }

    public boolean minimizeApplication() {
        return this.getImplementation().minimizeApplication();
    }

    public boolean isMinimized() {
        return this.getImplementation().isMinimized();
    }

    public void restoreMinimizedApplication() {
        this.getImplementation().restoreMinimizedApplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSingleArgumentEvent(int type, int code) {
        Object object = lock;
        synchronized (object) {
            if (this.dropEvents) {
                return;
            }
            this.inputEventStack[this.inputEventStackPointer] = type;
            ++this.inputEventStackPointer;
            this.inputEventStack[this.inputEventStackPointer] = code;
            ++this.inputEventStackPointer;
            lock.notify();
        }
    }

    public boolean isControlKeyDown() {
        return impl.isControlKeyDown();
    }

    public boolean isMetaKeyDown() {
        return impl.isMetaKeyDown();
    }

    public boolean isAltKeyDown() {
        return impl.isAltKeyDown();
    }

    public boolean isAltGraphKeyDown() {
        return impl.isAltGraphKeyDown();
    }

    public boolean isRightMouseButtonDown() {
        return impl.isRightMouseButtonDown();
    }

    public boolean isShiftKeyDown() {
        return impl.isShiftKeyDown();
    }

    public void keyPressed(int keyCode) {
        if (impl.getCurrentForm() == null) {
            return;
        }
        this.addSingleArgumentEvent(4, keyCode);
        this.lastInteractionWasKeypad = this.lastInteractionWasKeypad || keyCode != MenuBar.leftSK && keyCode != MenuBar.clearSK && keyCode != MenuBar.backSK;
        this.longPressCharged = this.keyRepeatCharged = keyCode >= 0 || this.getGameAction(keyCode) > 0 || keyCode == impl.getClearKeyCode();
        this.longKeyPressTime = System.currentTimeMillis();
        this.keyRepeatValue = keyCode;
        this.nextKeyRepeatEvent = System.currentTimeMillis() + (long)this.keyRepeatInitialIntervalTime;
        this.previousKeyPressed = this.lastKeyPressed;
        this.lastKeyPressed = keyCode;
    }

    public void keyReleased(int keyCode) {
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        if (impl.getCurrentForm() == null) {
            return;
        }
        if (!this.multiKeyMode) {
            if (keyCode != this.lastKeyPressed) {
                if (keyCode != this.previousKeyPressed) {
                    return;
                }
                this.previousKeyPressed = 0;
            } else {
                this.lastKeyPressed = 0;
            }
        }
        this.addSingleArgumentEvent(5, keyCode);
    }

    void keyRepeatedInternal(int keyCode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPointerEvent(int type, int x, int y) {
        Object object = lock;
        synchronized (object) {
            if (this.dropEvents) {
                return;
            }
            this.inputEventStack[this.inputEventStackPointer] = type;
            ++this.inputEventStackPointer;
            this.inputEventStack[this.inputEventStackPointer] = x;
            ++this.inputEventStackPointer;
            this.inputEventStack[this.inputEventStackPointer] = y;
            ++this.inputEventStackPointer;
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPointerEvent(int type, int[] x, int[] y) {
        Object object = lock;
        synchronized (object) {
            int iter;
            if (this.dropEvents) {
                return;
            }
            this.inputEventStack[this.inputEventStackPointer] = type;
            ++this.inputEventStackPointer;
            this.inputEventStack[this.inputEventStackPointer] = x.length;
            ++this.inputEventStackPointer;
            for (iter = 0; iter < x.length; ++iter) {
                this.inputEventStack[this.inputEventStackPointer] = x[iter];
                ++this.inputEventStackPointer;
            }
            this.inputEventStack[this.inputEventStackPointer] = y.length;
            ++this.inputEventStackPointer;
            for (iter = 0; iter < y.length; ++iter) {
                this.inputEventStack[this.inputEventStackPointer] = y[iter];
                ++this.inputEventStackPointer;
            }
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPointerDragEventWithTimestamp(int x, int y) {
        Object object = lock;
        synchronized (object) {
            if (this.dropEvents) {
                return;
            }
            try {
                if (this.lastDragOffset > -1) {
                    this.inputEventStack[this.lastDragOffset] = x;
                    this.inputEventStack[this.lastDragOffset + 1] = y;
                    this.inputEventStack[this.lastDragOffset + 2] = (int)(System.currentTimeMillis() - this.displayInitTime);
                } else {
                    this.inputEventStack[this.inputEventStackPointer] = 3;
                    ++this.inputEventStackPointer;
                    this.lastDragOffset = this.inputEventStackPointer;
                    this.inputEventStack[this.inputEventStackPointer] = x;
                    ++this.inputEventStackPointer;
                    this.inputEventStack[this.inputEventStackPointer] = y;
                    ++this.inputEventStackPointer;
                    this.inputEventStack[this.inputEventStackPointer] = (int)(System.currentTimeMillis() - this.displayInitTime);
                    ++this.inputEventStackPointer;
                }
            }
            catch (ArrayIndexOutOfBoundsException err) {
                Log.p("EDT performance is very slow triggering this exception!");
                Log.e(err);
            }
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPointerEventWithTimestamp(int type, int x, int y) {
        Object object = lock;
        synchronized (object) {
            if (this.dropEvents) {
                return;
            }
            try {
                this.inputEventStack[this.inputEventStackPointer] = type;
                ++this.inputEventStackPointer;
                this.inputEventStack[this.inputEventStackPointer] = x;
                ++this.inputEventStackPointer;
                this.inputEventStack[this.inputEventStackPointer] = y;
                ++this.inputEventStackPointer;
                this.inputEventStack[this.inputEventStackPointer] = (int)(System.currentTimeMillis() - this.displayInitTime);
                ++this.inputEventStackPointer;
            }
            catch (ArrayIndexOutOfBoundsException err) {
                Log.p("EDT performance is very slow triggering this exception!");
                Log.e(err);
            }
            lock.notify();
        }
    }

    public void pointerDragged(int[] x, int[] y) {
        if (impl.getCurrentForm() == null) {
            return;
        }
        this.longPointerCharged = false;
        if (x.length == 1) {
            this.addPointerDragEventWithTimestamp(x[0], y[0]);
        } else {
            this.addPointerEvent(23, x, y);
        }
    }

    public void pointerHover(int[] x, int[] y) {
        if (impl.getCurrentForm() == null) {
            return;
        }
        if (x.length == 1) {
            this.addPointerEventWithTimestamp(8, x[0], y[0]);
        } else {
            this.addPointerEvent(8, x, y);
        }
    }

    public void pointerHoverPressed(int[] x, int[] y) {
        if (impl.getCurrentForm() == null) {
            return;
        }
        this.addPointerEvent(12, x[0], y[0]);
    }

    public void pointerHoverReleased(int[] x, int[] y) {
        if (impl.getCurrentForm() == null) {
            return;
        }
        this.addPointerEvent(11, x[0], y[0]);
    }

    public void pointerPressed(int[] x, int[] y) {
        if (impl.getCurrentForm() == null) {
            return;
        }
        this.lastInteractionWasKeypad = false;
        this.longPointerCharged = true;
        this.longKeyPressTime = System.currentTimeMillis();
        this.pointerX = x[0];
        this.pointerY = y[0];
        if (x.length == 1) {
            this.addPointerEvent(1, x[0], y[0]);
        } else {
            this.addPointerEvent(21, x, y);
        }
    }

    public void pointerReleased(int[] x, int[] y) {
        this.longPointerCharged = false;
        if (impl.getCurrentForm() == null) {
            return;
        }
        if (x.length == 1) {
            this.addPointerEvent(2, x[0], y[0]);
        } else {
            this.addPointerEvent(22, x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSizeChangeEvent(int type, int w, int h) {
        Object object = lock;
        synchronized (object) {
            this.inputEventStack[this.inputEventStackPointer] = type;
            ++this.inputEventStackPointer;
            this.inputEventStack[this.inputEventStackPointer] = w;
            ++this.inputEventStackPointer;
            this.inputEventStack[this.inputEventStackPointer] = h;
            ++this.inputEventStackPointer;
            lock.notify();
        }
    }

    public void sizeChanged(int w, int h) {
        Form current = impl.getCurrentForm();
        if (current == null) {
            return;
        }
        if (w == current.getWidth() && h == current.getHeight() && (this.lastSizeChangeEventWH == -1 || this.lastSizeChangeEventWH == w + h)) {
            return;
        }
        this.lastSizeChangeEventWH = w + h;
        this.addSizeChangeEvent(7, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotifyEvent(int type) {
        Object object = lock;
        synchronized (object) {
            this.inputEventStack[this.inputEventStackPointer] = type;
            ++this.inputEventStackPointer;
            lock.notify();
        }
    }

    public void hideNotify() {
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        this.longPointerCharged = false;
        this.pointerPressedAndNotReleasedOrDragged = false;
        this.addNotifyEvent(9);
    }

    public void showNotify() {
        this.addNotifyEvent(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldEDTSleepNoFormAnimation() {
        boolean b;
        Object object = lock;
        synchronized (object) {
            b = this.inputEventStackPointer == 0 && this.hasNoSerialCallsPending() && (!this.keyRepeatCharged || !this.longPressCharged);
        }
        return b;
    }

    private void updateDragSpeedStatus(int x, int y, int timestamp) {
        this.dragPathX[this.dragPathOffset] = x;
        this.dragPathY[this.dragPathOffset] = y;
        this.dragPathTime[this.dragPathOffset] = this.displayInitTime + (long)timestamp;
        if (this.dragPathLength < this.PATHLENGTH) {
            ++this.dragPathLength;
        }
        ++this.dragPathOffset;
        if (this.dragPathOffset >= this.PATHLENGTH) {
            this.dragPathOffset = 0;
        }
    }

    boolean isRecursivePointerRelease() {
        return this.recursivePointerReleaseB;
    }

    private int[] readArrayStackArgument(int offset) {
        int[] a = new int[this.inputEventStackTmp[offset]];
        ++offset;
        int alen = a.length;
        for (int iter = 0; iter < alen; ++iter) {
            a[iter] = this.inputEventStackTmp[offset + iter];
        }
        return a;
    }

    private int handleEvent(int offset, int[] inputEventStackTmp) {
        Form f = this.getCurrentUpcomingForm(true);
        if (f == null) {
            return offset;
        }
        int type = inputEventStackTmp[offset];
        ++offset;
        switch (type) {
            case 4: {
                f.keyPressed(inputEventStackTmp[offset]);
                ++offset;
                this.eventForm = f;
                break;
            }
            case 5: {
                Form xf = this.eventForm;
                this.eventForm = null;
                if (xf != f && !this.multiKeyMode) break;
                f.keyReleased(inputEventStackTmp[offset]);
                ++offset;
                break;
            }
            case 1: {
                if (this.recursivePointerReleaseA) {
                    this.recursivePointerReleaseB = true;
                }
                this.dragOccured = false;
                this.dragPathLength = 0;
                this.pointerPressedAndNotReleasedOrDragged = true;
                Display.xArray1[0] = inputEventStackTmp[offset];
                Display.yArray1[0] = inputEventStackTmp[++offset];
                ++offset;
                f.pointerPressed(xArray1, yArray1);
                this.eventForm = f;
                break;
            }
            case 21: {
                if (this.recursivePointerReleaseA) {
                    this.recursivePointerReleaseB = true;
                }
                this.dragOccured = false;
                this.dragPathLength = 0;
                this.pointerPressedAndNotReleasedOrDragged = true;
                int[] array1 = this.readArrayStackArgument(offset);
                int[] array2 = this.readArrayStackArgument(offset += array1.length + 1);
                offset += array2.length + 1;
                f.pointerPressed(array1, array2);
                this.eventForm = f;
                break;
            }
            case 2: {
                this.recursivePointerReleaseA = true;
                this.pointerPressedAndNotReleasedOrDragged = false;
                Form x = this.eventForm;
                this.eventForm = null;
                if (x == f || f.shouldSendPointerReleaseToOtherForm()) {
                    Display.xArray1[0] = inputEventStackTmp[offset];
                    Display.yArray1[0] = inputEventStackTmp[++offset];
                    ++offset;
                    f.pointerReleased(xArray1, yArray1);
                }
                this.recursivePointerReleaseA = false;
                this.recursivePointerReleaseB = false;
                break;
            }
            case 22: {
                this.recursivePointerReleaseA = true;
                this.pointerPressedAndNotReleasedOrDragged = false;
                Form xy = this.eventForm;
                this.eventForm = null;
                if (xy == f || f != null && f.shouldSendPointerReleaseToOtherForm()) {
                    int[] array1 = this.readArrayStackArgument(offset);
                    int[] array2 = this.readArrayStackArgument(offset += array1.length + 1);
                    offset += array2.length + 1;
                    f.pointerReleased(array1, array1);
                }
                this.recursivePointerReleaseA = false;
                this.recursivePointerReleaseB = false;
                break;
            }
            case 3: {
                this.dragOccured = true;
                int arg1 = inputEventStackTmp[offset];
                int arg2 = inputEventStackTmp[++offset];
                int timestamp = inputEventStackTmp[++offset];
                ++offset;
                this.updateDragSpeedStatus(arg1, arg2, timestamp);
                this.pointerPressedAndNotReleasedOrDragged = false;
                Display.xArray1[0] = arg1;
                Display.yArray1[0] = arg2;
                f.pointerDragged(xArray1, yArray1);
                break;
            }
            case 23: {
                this.dragOccured = true;
                this.pointerPressedAndNotReleasedOrDragged = false;
                int[] array1 = this.readArrayStackArgument(offset);
                int[] array2 = this.readArrayStackArgument(offset += array1.length + 1);
                offset += array2.length + 1;
                f.pointerDragged(array1, array2);
                break;
            }
            case 8: {
                int arg1 = inputEventStackTmp[offset];
                int arg2 = inputEventStackTmp[++offset];
                int timestamp = inputEventStackTmp[++offset];
                ++offset;
                this.updateDragSpeedStatus(arg1, arg2, timestamp);
                Display.xArray1[0] = arg1;
                Display.yArray1[0] = arg2;
                f.pointerHover(xArray1, yArray1);
                break;
            }
            case 11: {
                int arg1 = inputEventStackTmp[offset];
                int arg2 = inputEventStackTmp[++offset];
                ++offset;
                Display.xArray1[0] = arg1;
                Display.yArray1[0] = arg2;
                f.pointerHoverReleased(xArray1, yArray1);
                break;
            }
            case 12: {
                int arg1 = inputEventStackTmp[offset];
                int arg2 = inputEventStackTmp[++offset];
                ++offset;
                Display.xArray1[0] = arg1;
                Display.yArray1[0] = arg2;
                f.pointerHoverPressed(xArray1, yArray1);
                break;
            }
            case 7: {
                int w = inputEventStackTmp[offset];
                int h = inputEventStackTmp[++offset];
                ++offset;
                f.sizeChangedInternal(w, h);
                break;
            }
            case 9: {
                f.hideNotify();
                break;
            }
            case 10: {
                f.showNotify();
            }
        }
        return offset;
    }

    public boolean hasDragOccured() {
        return this.dragOccured;
    }

    private int[] pointerEvent(int off, int[] event) {
        int[] peX = new int[(event.length - 1) / 2];
        int offset = 0;
        for (int iter = off; iter < event.length - 1; iter += 2) {
            peX[offset] = event[iter];
            ++offset;
        }
        return peX;
    }

    boolean shouldEDTSleep() {
        Form current = impl.getCurrentForm();
        return (current == null || !current.hasAnimations()) && (this.animationQueue == null || this.animationQueue.size() == 0) && this.inputEventStackPointer == 0 && !impl.hasPendingPaints() && this.hasNoSerialCallsPending() && !this.keyRepeatCharged && !this.longPointerCharged || this.isMinimized() && this.hasNoSerialCallsPending();
    }

    Form getCurrentInternal() {
        return impl.getCurrentForm();
    }

    Form getCurrentUpcoming() {
        return this.getCurrentUpcomingForm(false);
    }

    private Form getCurrentUpcomingForm(boolean includeMenus) {
        Form upcoming = null;
        if (this.animationQueue != null) {
            int size = this.animationQueue.size();
            for (int iter = 0; iter < size; ++iter) {
                Animation o = this.animationQueue.get(iter);
                if (!(o instanceof Transition)) continue;
                upcoming = (Form)((Transition)o).getDestination();
            }
        }
        if (upcoming == null) {
            if (includeMenus) {
                Form f = impl.getCurrentForm();
                if (f instanceof Dialog && ((Dialog)f).isDisposed()) {
                    return this.getCurrent();
                }
                return f;
            }
            return this.getCurrent();
        }
        return upcoming;
    }

    public Form getCurrent() {
        Form current = impl.getCurrentForm();
        if (current != null && current instanceof Dialog && (((Dialog)current).isMenu() || ((Dialog)current).isDisposed())) {
            Form p = current.getPreviousForm();
            if (p != null) {
                return p;
            }
            if (this.animationQueue != null) {
                int size = this.animationQueue.size();
                for (int iter = 0; iter < size; ++iter) {
                    Animation o = this.animationQueue.get(iter);
                    if (!(o instanceof Transition)) continue;
                    return (Form)((Transition)o).getDestination();
                }
            }
        }
        return current;
    }

    public int numAlphaLevels() {
        return impl.numAlphaLevels();
    }

    public int numColors() {
        return impl.numColors();
    }

    public int getDisplayWidth() {
        return impl.getDisplayWidth();
    }

    public int getDisplayHeight() {
        return impl.getDisplayHeight();
    }

    void repaint(Animation cmp) {
        impl.repaint(cmp);
    }

    public int convertToPixels(int dipCount, boolean horizontal) {
        return impl.convertToPixels(dipCount, horizontal);
    }

    public int convertToPixels(float value, byte unitType) {
        return this.convertToPixels(value, unitType, true);
    }

    public int convertToPixels(float value, byte unitType, boolean horizontal) {
        switch (unitType) {
            case 7: {
                return Math.round(value * (float)Font.getDefaultFont().getHeight());
            }
            case 4: {
                return Math.round(value / 100.0f * (float)CN.getDisplayHeight());
            }
            case 3: {
                return Math.round(value / 100.0f * (float)CN.getDisplayWidth());
            }
            case 5: {
                return Math.round(value / 100.0f * (float)Math.min(CN.getDisplayWidth(), CN.getDisplayHeight()));
            }
            case 6: {
                return Math.round(value / 100.0f * (float)Math.min(CN.getDisplayWidth(), CN.getDisplayHeight()));
            }
            case 2: {
                return Display.getInstance().convertToPixels(value);
            }
            case 1: {
                if (!horizontal) {
                    float h = Display.getInstance().getDisplayHeight();
                    h = h / 100.0f * value;
                    return (int)h;
                }
                float w = Display.getInstance().getDisplayWidth();
                w = w / 100.0f * value;
                return (int)w;
            }
        }
        return (int)value;
    }

    public int convertToPixels(float dipCount) {
        return Math.round((float)impl.convertToPixels((int)(dipCount * 1000.0f), true) / 1000.0f);
    }

    boolean supportsNativeImageCache() {
        return impl.supportsNativeImageCache();
    }

    public int getGameAction(int keyCode) {
        return impl.getGameAction(keyCode);
    }

    public int getKeyCode(int gameAction) {
        return impl.getKeyCode(gameAction);
    }

    public boolean isThirdSoftButton() {
        return this.thirdSoftButton;
    }

    public void setThirdSoftButton(boolean thirdSoftButton) {
        this.thirdSoftButton = thirdSoftButton;
    }

    public void setShowVirtualKeyboard(boolean show) {
        VirtualKeyboardInterface vkb;
        if (this.isTouchScreenDevice() && (vkb = this.getDefaultVirtualKeyboard()) != null) {
            vkb.showKeyboard(show);
        }
    }

    public boolean isVirtualKeyboardShowing() {
        if (!this.isTouchScreenDevice()) {
            return false;
        }
        return this.getDefaultVirtualKeyboard() != null && this.getDefaultVirtualKeyboard().isVirtualKeyboardShowing();
    }

    public String[] getSupportedVirtualKeyboard() {
        String[] retVal = new String[virtualKeyboards.size()];
        int index = 0;
        for (String k : virtualKeyboards.keySet()) {
            retVal[index++] = k;
        }
        return retVal;
    }

    public void registerVirtualKeyboard(VirtualKeyboardInterface vkb) {
        virtualKeyboards.put(vkb.getVirtualKeyboardName(), vkb);
    }

    public void setDefaultVirtualKeyboard(VirtualKeyboardInterface vkb) {
        if (vkb != null) {
            selectedVirtualKeyboard = vkb.getVirtualKeyboardName();
            if (!virtualKeyboards.containsKey(selectedVirtualKeyboard)) {
                this.registerVirtualKeyboard(vkb);
            }
        } else {
            selectedVirtualKeyboard = null;
        }
    }

    public VirtualKeyboardInterface getDefaultVirtualKeyboard() {
        if (selectedVirtualKeyboard == null) {
            return null;
        }
        return virtualKeyboards.get(selectedVirtualKeyboard);
    }

    public void setVirtualKeyboardListener(ActionListener l) {
        if (this.virtualKeyboardListener != null) {
            this.removeVirtualKeyboardListener(l);
        }
        this.virtualKeyboardListener = l;
        this.addVirtualKeyboardListener(l);
    }

    public ActionListener getVirtualKeyboardListener() {
        return this.virtualKeyboardListener;
    }

    public synchronized void addVirtualKeyboardListener(ActionListener l) {
        if (this.virtualKeyboardListeners == null) {
            this.virtualKeyboardListeners = new EventDispatcher();
        }
        this.virtualKeyboardListeners.addListener(l);
    }

    public synchronized void removeVirtualKeyboardListener(ActionListener l) {
        if (this.virtualKeyboardListeners != null) {
            this.virtualKeyboardListeners.removeListener(l);
        }
    }

    public void fireVirtualKeyboardEvent(boolean show) {
        if (this.virtualKeyboardListeners != null) {
            this.virtualKeyboardListeners.fireActionEvent(new ActionEvent(show));
        }
    }

    public int getInvisibleAreaUnderVKB() {
        return impl.getInvisibleAreaUnderVKB();
    }

    public int getKeyboardType() {
        return impl.getKeyboardType();
    }

    public boolean isNativeInputSupported() {
        return impl.isNativeInputSupported();
    }

    public boolean isMultiTouch() {
        return impl.isMultiTouch();
    }

    public boolean isClickTouchScreen() {
        return impl.isClickTouchScreen();
    }

    public float getDragSpeed(boolean yAxis) {
        float speed = yAxis ? impl.getDragSpeed(this.dragPathY, this.dragPathTime, this.dragPathOffset, this.dragPathLength) : impl.getDragSpeed(this.dragPathX, this.dragPathTime, this.dragPathOffset, this.dragPathLength);
        return speed;
    }

    public boolean isBidiAlgorithm() {
        return impl.isBidiAlgorithm();
    }

    public void setBidiAlgorithm(boolean activate) {
        impl.setBidiAlgorithm(activate);
    }

    public String convertBidiLogicalToVisual(String s) {
        return impl.convertBidiLogicalToVisual(s);
    }

    public int getCharLocation(String source, int index) {
        return impl.getCharLocation(source, index);
    }

    public boolean isRTL(char c) {
        return impl.isRTL(c);
    }

    public InputStream getResourceAsStream(Class cls, String resource) {
        return impl.getResourceAsStream(cls, resource);
    }

    public void addEdtErrorHandler(ActionListener e) {
        if (this.errorHandler == null) {
            this.errorHandler = new EventDispatcher();
        }
        this.errorHandler.addListener(e);
    }

    public void removeEdtErrorHandler(ActionListener e) {
        if (this.errorHandler != null) {
            this.errorHandler.removeListener(e);
            Collection v = this.errorHandler.getListenerCollection();
            if (v == null || v.size() == 0) {
                this.errorHandler = null;
            }
        }
    }

    public void setAllowMinimizing(boolean allowMinimizing) {
        this.allowMinimizing = allowMinimizing;
    }

    public boolean isAllowMinimizing() {
        return this.allowMinimizing;
    }

    public boolean shouldRenderSelection() {
        return !this.pureTouch || this.pointerPressedAndNotReleasedOrDragged || this.lastInteractionWasKeypad;
    }

    public boolean shouldRenderSelection(Component c) {
        if (c.isCellRenderer()) {
            return this.shouldRenderSelection();
        }
        return !this.pureTouch || this.lastInteractionWasKeypad || this.pointerPressedAndNotReleasedOrDragged && c.contains(this.pointerX, this.pointerY) || c.shouldRenderComponentSelection();
    }

    public boolean isPureTouch() {
        return this.pureTouch;
    }

    public void setPureTouch(boolean pureTouch) {
        this.pureTouch = pureTouch;
    }

    public boolean isNativeCommands() {
        return this.getCommandBehavior() == 10;
    }

    public void setNativeCommands(boolean nativeCommands) {
        this.setCommandBehavior(10);
    }

    public void exitApplication() {
        this.codenameOneExited = true;
        impl.exit();
    }

    public boolean isFullScreenSupported() {
        return impl.isFullScreenSupported();
    }

    public boolean requestFullScreen() {
        return impl.requestFullScreen();
    }

    public boolean exitFullScreen() {
        return impl.exitFullScreen();
    }

    public boolean isInFullScreenMode() {
        return impl.isInFullScreenMode();
    }

    public void showNativeScreen(Object nativeFullScreenPeer) {
        this.inNativeUI = true;
        impl.showNativeScreen(nativeFullScreenPeer);
    }

    public boolean isAutoFoldVKBOnFormSwitch() {
        return this.autoFoldVKBOnFormSwitch;
    }

    public void setAutoFoldVKBOnFormSwitch(boolean autoFoldVKBOnFormSwitch) {
        this.autoFoldVKBOnFormSwitch = autoFoldVKBOnFormSwitch;
    }

    public int getCommandBehavior() {
        return impl.getCommandBehavior();
    }

    public void postMessage(MessageEvent message) {
        impl.postMessage(message);
    }

    public void addMessageListener(ActionListener<MessageEvent> l) {
        if (this.messageListeners == null) {
            this.messageListeners = new EventDispatcher();
        }
        this.messageListeners.addListener(l);
    }

    public void removeMessageListener(ActionListener<MessageEvent> l) {
        if (this.messageListeners != null) {
            this.messageListeners.removeListener(l);
        }
    }

    public void dispatchMessage(MessageEvent evt) {
        if (this.messageListeners != null && this.messageListeners.hasListeners()) {
            this.messageListeners.fireActionEvent(evt);
        }
    }

    public void setCommandBehavior(int commandBehavior) {
        if (commandBehavior == 8) {
            String message = "WARNING: Display.setCommandBehavior() is deprecated, Using it may result in unexpected behaviour. In particular, using COMMAND_BEHAVIOR_SIDE_NAVIGATION in conjunction with Toolbar.setOnTopSideMenu(true) may result in runtime errors.";
            Log.p(message, 3);
        }
        impl.setCommandBehavior(commandBehavior);
    }

    public String getProperty(String key, String defaultValue) {
        String v;
        if ("AppArg".equals(key)) {
            String out = impl.getAppArg();
            return out == null ? defaultValue : out;
        }
        if ("Component.revalidateOnStyleChange".equals(key)) {
            return Component.revalidateOnStyleChange ? "true" : "false";
        }
        if (this.localProperties != null && (v = this.localProperties.get(key)) != null) {
            return v;
        }
        return impl.getProperty(key, defaultValue);
    }

    public void setProperty(String key, String value) {
        if ("AppArg".equals(key)) {
            impl.setAppArg(value);
            return;
        }
        if ("blockOverdraw".equals(key)) {
            Container.blockOverdraw = true;
            return;
        }
        if ("blockCopyPaste".equals(key)) {
            impl.blockCopyPaste("true".equals(value));
        }
        if ("Component.revalidateOnStyleChange".equals(key)) {
            Component.revalidateOnStyleChange = "true".equalsIgnoreCase(value);
        }
        if (key.startsWith("platformHint.")) {
            impl.setPlatformHint(key, value);
            return;
        }
        if (this.localProperties == null) {
            this.localProperties = new HashMap();
        }
        if (value == null) {
            this.localProperties.remove(key);
        } else {
            this.localProperties.put(key, value);
        }
    }

    public Boolean canExecute(String url) {
        return impl.canExecute(url);
    }

    public void execute(String url) {
        impl.execute(url);
    }

    public void execute(String url, ActionListener response) {
        impl.execute(url, response);
    }

    public int getDeviceDensity() {
        return impl.getDeviceDensity();
    }

    public String getDensityStr() {
        switch (this.getDeviceDensity()) {
            case 10: {
                return "very-low";
            }
            case 20: {
                return "low";
            }
            case 30: {
                return "medium";
            }
            case 40: {
                return "high";
            }
            case 50: {
                return "very-high";
            }
            case 60: {
                return "hd";
            }
            case 65: {
                return "560";
            }
            case 70: {
                return "2hd";
            }
            case 80: {
                return "4k";
            }
        }
        throw new IllegalStateException("Unknown density " + this.getDeviceDensity());
    }

    public void playBuiltinSound(String soundIdentifier) {
        impl.playBuiltinSound(soundIdentifier);
    }

    public Rectangle getDisplaySafeArea(Rectangle rect) {
        return impl.getDisplaySafeArea(rect);
    }

    public void installBuiltinSound(String soundIdentifier, InputStream data) throws IOException {
        impl.installBuiltinSound(soundIdentifier, data);
    }

    public boolean isBuiltinSoundAvailable(String soundIdentifier) {
        return impl.isBuiltinSoundAvailable(soundIdentifier);
    }

    public void setBuiltinSoundsEnabled(boolean enabled) {
        impl.setBuiltinSoundsEnabled(enabled);
    }

    public boolean isBuiltinSoundsEnabled() {
        return impl.isBuiltinSoundsEnabled();
    }

    public Media createMedia(String uri, boolean isVideo, Runnable onCompletion) throws IOException {
        return impl.createMedia(uri, isVideo, onCompletion);
    }

    public AsyncResource<Media> createMediaAsync(String uri, boolean video, Runnable onCompletion) {
        return impl.createMediaAsync(uri, video, onCompletion);
    }

    public void addCompletionHandler(Media media, Runnable onCompletion) {
        impl.addCompletionHandler(media, onCompletion);
    }

    public void removeCompletionHandler(Media media, Runnable onCompletion) {
        impl.removeCompletionHandler(media, onCompletion);
    }

    public Media createMedia(InputStream stream, String mimeType, Runnable onCompletion) throws IOException {
        return impl.createMedia(stream, mimeType, onCompletion);
    }

    public AsyncResource<Media> createMediaAsync(InputStream stream, String mimeType, Runnable onCompletion) {
        return impl.createMediaAsync(stream, mimeType, onCompletion);
    }

    public Object createSoftWeakRef(Object o) {
        return impl.createSoftWeakRef(o);
    }

    public Object extractHardRef(Object o) {
        return impl.extractHardRef(o);
    }

    public boolean hasNativeTheme() {
        return impl.hasNativeTheme();
    }

    public void installNativeTheme() {
        impl.installNativeTheme();
    }

    public void copyToClipboard(Object obj) {
        impl.copyToClipboard(obj);
    }

    public Object getPasteDataFromClipboard() {
        return impl.getPasteDataFromClipboard();
    }

    public boolean isPortrait() {
        return impl.isPortrait();
    }

    public boolean canForceOrientation() {
        return impl.canForceOrientation();
    }

    public void lockOrientation(boolean portrait) {
        impl.lockOrientation(portrait);
    }

    public void unlockOrientation() {
        impl.unlockOrientation();
    }

    public boolean isTablet() {
        return impl.isTablet();
    }

    public boolean isDesktop() {
        return impl.isDesktop();
    }

    public boolean canDial() {
        return impl.canDial();
    }

    public boolean areMutableImagesFast() {
        return impl.areMutableImagesFast();
    }

    public LocationManager getLocationManager() {
        return impl.getLocationManager();
    }

    public void capturePhoto(ActionListener response) {
        impl.capturePhoto(response);
    }

    public void captureAudio(ActionListener response) {
        impl.captureAudio(response);
    }

    public void captureAudio(MediaRecorderBuilder recordingOptions, ActionListener response) {
        impl.captureAudio(recordingOptions, response);
    }

    public void captureVideo(ActionListener response) {
        impl.captureVideo(response);
    }

    public void captureVideo(VideoCaptureConstraints constraints, ActionListener response) {
        impl.captureVideo(constraints, response);
    }

    public void openImageGallery(ActionListener response) {
        if (this.pluginSupport.firePluginEvent(new OpenGalleryEvent(response, 0)).isConsumed()) {
            return;
        }
        impl.openImageGallery(response);
    }

    public void openGallery(ActionListener response, int type) {
        if (this.pluginSupport.firePluginEvent(new OpenGalleryEvent(response, type)).isConsumed()) {
            return;
        }
        impl.openGallery(response, type);
    }

    public boolean isGalleryTypeSupported(int type) {
        IsGalleryTypeSupportedEvent evt = new IsGalleryTypeSupportedEvent(type);
        if (this.pluginSupport.firePluginEvent(evt).isConsumed()) {
            return (Boolean)evt.getPluginEventResponse();
        }
        return impl.isGalleryTypeSupported(type);
    }

    public String getPlatformName() {
        return impl.getPlatformName();
    }

    public String[] getPlatformOverrides() {
        return impl.getPlatformOverrides();
    }

    public void sendMessage(String[] recipients, String subject, Message msg) {
        impl.sendMessage(recipients, subject, msg);
    }

    public void dial(String phoneNumber) {
        impl.dial(phoneNumber);
    }

    public int getSMSSupport() {
        return impl.getSMSSupport();
    }

    public void sendSMS(String phoneNumber, String message) throws IOException {
        impl.sendSMS(phoneNumber, message, false);
    }

    public void sendSMS(String phoneNumber, String message, boolean interactive) throws IOException {
        impl.sendSMS(phoneNumber, message, interactive);
    }

    public void notifyStatusBar(String tickerText, String contentTitle, String contentBody, boolean vibrate, boolean flashLights) {
        this.notifyStatusBar(tickerText, contentTitle, contentBody, vibrate, flashLights, null);
    }

    public boolean isNotificationSupported() {
        return impl.isNotificationSupported();
    }

    public Object notifyStatusBar(String tickerText, String contentTitle, String contentBody, boolean vibrate, boolean flashLights, Hashtable args) {
        return impl.notifyStatusBar(tickerText, contentTitle, contentBody, vibrate, flashLights, args);
    }

    public void dismissNotification(Object o) {
        impl.dismissNotification(o);
    }

    public boolean isBadgingSupported() {
        return impl.isBadgingSupported();
    }

    public void setBadgeNumber(int number) {
        impl.setBadgeNumber(number);
    }

    public boolean isOpenNativeNavigationAppSupported() {
        return impl.isOpenNativeNavigationAppSupported();
    }

    public void openNativeNavigationApp(double latitude, double longitude) {
        impl.openNativeNavigationApp(latitude, longitude);
    }

    public void openNativeNavigationApp(String location) {
        impl.openNativeNavigationApp(location);
    }

    public String[] getAllContacts(boolean withNumbers) {
        return impl.getAllContacts(withNumbers);
    }

    public Contact[] getAllContacts(boolean withNumbers, boolean includesFullName, boolean includesPicture, boolean includesNumbers, boolean includesEmail, boolean includeAddress) {
        return impl.getAllContacts(withNumbers, includesFullName, includesPicture, includesNumbers, includesEmail, includeAddress);
    }

    public boolean isGetAllContactsFast() {
        return impl.isGetAllContactsFast();
    }

    public String[] getLinkedContactIds(Contact c) {
        return impl.getLinkedContactIds(c);
    }

    public Contact getContactById(String id) {
        return impl.getContactById(id);
    }

    public Contact getContactById(String id, boolean includesFullName, boolean includesPicture, boolean includesNumbers, boolean includesEmail, boolean includeAddress) {
        return impl.getContactById(id, includesFullName, includesPicture, includesNumbers, includesEmail, includeAddress);
    }

    public boolean isContactsPermissionGranted() {
        return impl.isContactsPermissionGranted();
    }

    public String createContact(String firstName, String familyName, String officePhone, String homePhone, String cellPhone, String email) {
        return impl.createContact(firstName, familyName, officePhone, homePhone, cellPhone, email);
    }

    public boolean deleteContact(String id) {
        return impl.deleteContact(id);
    }

    public boolean isNativeVideoPlayerControlsIncluded() {
        return impl.isNativeVideoPlayerControlsIncluded();
    }

    public boolean isNativeShareSupported() {
        return impl.isNativeShareSupported();
    }

    public void share(String toShare) {
        this.share(toShare, null, null);
    }

    public void share(String text, String image, String mimeType) {
        this.share(text, image, mimeType, null);
    }

    public void share(String textOrPath, String image, String mimeType, Rectangle sourceRect) {
        impl.share(textOrPath, image, mimeType, sourceRect);
    }

    public L10NManager getLocalizationManager() {
        return impl.getLocalizationManager();
    }

    public void registerPush(String id, boolean noFallback) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("googlePlay", id);
        this.registerPush(h, noFallback);
    }

    public void registerPush(Hashtable metaData, boolean noFallback) {
        if (Preferences.get("push_id", -1L) == -1L) {
            impl.registerPush(metaData, noFallback);
        }
    }

    public void registerPush() {
        impl.registerPush(new Hashtable(), false);
    }

    public void deregisterPush() {
        impl.deregisterPush();
    }

    public Media createMediaRecorder(String path) throws IOException {
        return this.createMediaRecorder(path, this.getAvailableRecordingMimeTypes()[0]);
    }

    public Media createMediaRecorder(MediaRecorderBuilder builder) throws IOException {
        return impl.createMediaRecorder(builder);
    }

    public Media createMediaRecorder(String path, String mimeType) throws IOException {
        return impl.createMediaRecorder(path, mimeType);
    }

    public ImageIO getImageIO() {
        return impl.getImageIO();
    }

    public String getMediaRecorderingMimeType() {
        return impl.getAvailableRecordingMimeTypes()[0];
    }

    public Database openOrCreate(String databaseName) throws IOException {
        return impl.openOrCreateDB(databaseName);
    }

    public boolean isDatabaseCustomPathSupported() {
        return impl.isDatabaseCustomPathSupported();
    }

    public void delete(String databaseName) throws IOException {
        impl.deleteDB(databaseName);
    }

    public boolean exists(String databaseName) {
        return impl.existsDB(databaseName);
    }

    public String getDatabasePath(String databaseName) {
        return impl.getDatabasePath(databaseName);
    }

    public void setPollingFrequency(int freq) {
        impl.setPollingFrequency(freq);
    }

    public Thread createThread(Runnable r, String name) {
        return new CodenameOneThread(r, name);
    }

    public Thread startThread(Runnable r, String name) {
        return new CodenameOneThread(r, name);
    }

    public boolean isNativeTitle() {
        return impl.isNativeTitle();
    }

    public void refreshNativeTitle() {
        impl.refreshNativeTitle();
    }

    public CrashReport getCrashReporter() {
        return this.crashReporter;
    }

    public void setCrashReporter(CrashReport crashReporter) {
        this.crashReporter = crashReporter;
    }

    public String getUdid() {
        return impl.getUdid();
    }

    public String getMsisdn() {
        return impl.getMsisdn();
    }

    public Purchase getInAppPurchase() {
        return impl.getInAppPurchase();
    }

    public Purchase getInAppPurchase(boolean d) {
        return this.getInAppPurchase();
    }

    public CodeScanner getCodeScanner() {
        if (!this.hasCamera()) {
            return null;
        }
        return impl.getCodeScanner();
    }

    public String[] getAvailableRecordingMimeTypes() {
        return impl.getAvailableRecordingMimeTypes();
    }

    public boolean isScreenSaverDisableSupported() {
        return impl.isScreenLockSupported();
    }

    public boolean isScrollWheeling() {
        return impl.isScrollWheeling();
    }

    public void setScreenSaverEnabled(boolean e) {
        if (e) {
            impl.unlockScreen();
        } else {
            impl.lockScreen();
        }
    }

    public boolean hasCamera() {
        return impl.hasCamera();
    }

    public boolean isNativePickerTypeSupported(int pickerType) {
        return impl.isNativePickerTypeSupported(pickerType);
    }

    public Object showNativePicker(int type, Component source, Object currentValue, Object data) {
        return impl.showNativePicker(type, source, currentValue, data);
    }

    public boolean isMultiKeyMode() {
        return this.multiKeyMode;
    }

    public void setMultiKeyMode(boolean multiKeyMode) {
        this.multiKeyMode = multiKeyMode;
    }

    public void setLongPointerPressInterval(int v) {
        this.longPressInterval = v;
    }

    public int getLongPointerPressInterval() {
        return this.longPressInterval;
    }

    public void scheduleLocalNotification(LocalNotification n, long firstTime, int repeat) {
        if (n.getId() == null || n.getId().length() == 0) {
            throw new IllegalArgumentException("Notification ID must be set");
        }
        if (firstTime < System.currentTimeMillis()) {
            throw new IllegalArgumentException("Cannot schedule a notification to a past time");
        }
        if (n.getAlertSound() != null && n.getAlertSound().length() > 0 && !n.getAlertSound().startsWith("/notification_sound")) {
            throw new IllegalArgumentException("Alert sound file name must start with the 'notification_sound' prefix");
        }
        impl.scheduleLocalNotification(n, firstTime, repeat);
    }

    public void cancelLocalNotification(String notificationId) {
        impl.cancelLocalNotification(notificationId);
    }

    public void setPreferredBackgroundFetchInterval(int seconds) {
        impl.setPreferredBackgroundFetchInterval(seconds);
    }

    public int getPreferredBackgroundFetchInterval(int seconds) {
        return impl.getPreferredBackgroundFetchInterval();
    }

    public boolean isBackgroundFetchSupported() {
        return impl.isBackgroundFetchSupported();
    }

    public boolean isSimulator() {
        return impl.isSimulator();
    }

    public Media createBackgroundMedia(String uri) throws IOException {
        return impl.createBackgroundMedia(uri);
    }

    public AsyncResource<Media> createBackgroundMediaAsync(String uri) {
        return impl.createBackgroundMediaAsync(uri);
    }

    public Image gaussianBlurImage(Image image, float radius) {
        return impl.gaussianBlurImage(image, radius);
    }

    public boolean isGaussianBlurSupported() {
        return impl.isGaussianBlurSupported();
    }

    public void refreshContacts() {
        impl.refreshContacts();
    }

    public boolean isJailbrokenDevice() {
        return impl.isJailbrokenDevice();
    }

    public Map<String, String> getProjectBuildHints() {
        return impl.getProjectBuildHints();
    }

    public void setProjectBuildHint(String key, String value) {
        impl.setProjectBuildHint(key, value);
    }

    public boolean canInstallOnHomescreen() {
        return impl.canInstallOnHomescreen();
    }

    public boolean promptInstallOnHomescreen() {
        return impl.promptInstallOnHomescreen();
    }

    public void onCanInstallOnHomescreen(Runnable r) {
        impl.onCanInstallOnHomescreen(r);
    }

    public Image captureScreen() {
        return impl.captureScreen();
    }

    public Timer setTimeout(int timeout, final @Async.Schedule Runnable r) {
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            public void run() {
                Display.this.executeTimeoutRunnable(r);
            }
        }, timeout);
        return t;
    }

    private void executeTimeoutRunnable(@Async.Execute Runnable r) {
        CN.callSerially(r);
    }

    public Timer setInterval(int period, final @Async.Schedule Runnable r) {
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            public void run() {
                Display.this.executeTimeoutRunnable(r);
            }
        }, period, (long)period);
        return t;
    }

    public BrowserComponent getSharedJavascriptContext() {
        return impl.getSharedJavscriptContext();
    }

    static {
        lock = new Object();
        selectedVirtualKeyboard = null;
        virtualKeyboards = new HashMap<String, VirtualKeyboardInterface>();
        xArray1 = new int[1];
        yArray1 = new int[1];
    }

    private class DebugRunnable
    implements Runnable {
        private final Runnable internal;
        private EdtException exceptionWrapper;
        private DebugRunnable parentContext;
        private int depth;
        private int totalDepth;

        DebugRunnable(Runnable internal) {
            this.internal = internal;
            this.parentContext = Display.this.currentEdtContext;
            if (this.parentContext != null) {
                this.depth = this.parentContext.depth + 1;
                this.totalDepth = this.parentContext.totalDepth + 1;
            }
            if (Display.this.isEnableAsyncStackTraces()) {
                this.exceptionWrapper = new EdtException();
                if (this.parentContext != null) {
                    if (this.depth < 10) {
                        this.exceptionWrapper.parent = this.parentContext.exceptionWrapper;
                        this.parentContext = null;
                    } else {
                        this.depth = 0;
                    }
                }
            } else {
                this.exceptionWrapper = null;
                this.parentContext = null;
            }
        }

        public void run() {
            if (this.exceptionWrapper != null) {
                try {
                    Display.this.currentEdtContext = this;
                    this.internal.run();
                }
                catch (RuntimeException t) {
                    this.exceptionWrapper.throwRoot(t);
                }
            } else {
                this.internal.run();
            }
        }
    }

    private class EdtException
    extends RuntimeException {
        private Throwable cause;
        private EdtException parent;

        private EdtException() {
        }

        public void setCause(Throwable t) {
            this.cause = t;
        }

        public synchronized Throwable getCause() {
            return this.cause;
        }

        private void throwRoot(Throwable cause) {
            HashSet<Throwable> circuitCheck = new HashSet<Throwable>();
            circuitCheck.add(cause);
            EdtException root = this;
            if (root != cause) {
                root.setCause(cause);
                circuitCheck.add(root);
            } else {
                root = (EdtException)cause;
            }
            while (root.parent != null && !circuitCheck.contains(root.parent)) {
                root.parent.setCause(root);
                circuitCheck.add(root.parent);
                root = root.parent;
            }
            throw root;
        }
    }
}

