/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.media;

import com.codename1.media.AsyncMedia;
import com.codename1.media.MediaManager;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.util.EventDispatcher;
import com.codename1.util.SuccessCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMedia
implements AsyncMedia {
    private final EventDispatcher stateChangeListeners = new EventDispatcher();
    private final EventDispatcher errorListeners = new EventDispatcher();
    private AsyncMedia.PlayRequest pendingPlayRequest;
    private AsyncMedia.PauseRequest pendingPauseRequest;

    @Override
    public AsyncMedia.State getState() {
        if (this.isPlaying()) {
            return AsyncMedia.State.Playing;
        }
        return AsyncMedia.State.Paused;
    }

    protected AsyncMedia.MediaStateChangeEvent fireMediaStateChange(AsyncMedia.State newState) {
        AsyncMedia.MediaStateChangeEvent evt = new AsyncMedia.MediaStateChangeEvent(this, this.getState(), newState);
        if (this.stateChangeListeners.hasListeners()) {
            this.stateChangeListeners.fireActionEvent(evt);
        }
        return evt;
    }

    @Override
    public void addMediaStateChangeListener(ActionListener<AsyncMedia.MediaStateChangeEvent> l) {
        this.stateChangeListeners.addListener(l);
    }

    @Override
    public void removeMediaStateChangeListener(ActionListener<AsyncMedia.MediaStateChangeEvent> l) {
        this.stateChangeListeners.removeListener(l);
    }

    protected AsyncMedia.MediaErrorEvent fireMediaError(AsyncMedia.MediaException ex) {
        AsyncMedia.MediaErrorEvent evt = new AsyncMedia.MediaErrorEvent(this, ex);
        if (this.errorListeners.hasListeners()) {
            this.errorListeners.fireActionEvent(evt);
        }
        return evt;
    }

    @Override
    public void addMediaErrorListener(ActionListener<AsyncMedia.MediaErrorEvent> l) {
        this.errorListeners.addListener(l);
    }

    @Override
    public void removeMediaErrorListener(ActionListener<AsyncMedia.MediaErrorEvent> l) {
        this.errorListeners.removeListener(l);
    }

    @Override
    public void addMediaCompletionHandler(Runnable onComplete) {
        MediaManager.addCompletionHandler(this, onComplete);
    }

    @Override
    public AsyncMedia.PlayRequest playAsync() {
        return this.playAsync(new AsyncMedia.PlayRequest(){

            public void complete(AsyncMedia value) {
                if (this == AbstractMedia.this.pendingPlayRequest) {
                    AbstractMedia.this.pendingPlayRequest = null;
                }
                super.complete(value);
            }

            public void error(Throwable t) {
                if (this == AbstractMedia.this.pendingPlayRequest) {
                    AbstractMedia.this.pendingPlayRequest = null;
                }
                super.error(t);
            }
        });
    }

    private AsyncMedia.PlayRequest playAsync(final AsyncMedia.PlayRequest out) {
        ActionListener<AsyncMedia.MediaErrorEvent> onError;
        if (out.isDone()) {
            return out;
        }
        if (this.pendingPauseRequest != null) {
            this.pendingPauseRequest.ready(new SuccessCallback<AsyncMedia>(){

                @Override
                public void onSucess(AsyncMedia value) {
                    if (!out.isDone()) {
                        AbstractMedia.this.playAsync(out);
                    }
                }
            }).except(new SuccessCallback<Throwable>(){

                @Override
                public void onSucess(Throwable value) {
                    if (!out.isDone()) {
                        AbstractMedia.this.playAsync(out);
                    }
                }
            });
            this.pendingPauseRequest = null;
            this.pendingPlayRequest = out;
            return out;
        }
        if (this.pendingPlayRequest != null && this.pendingPlayRequest != out) {
            this.pendingPlayRequest.ready(new SuccessCallback<AsyncMedia>(){

                @Override
                public void onSucess(AsyncMedia value) {
                    if (!out.isDone()) {
                        out.complete(value);
                    }
                }
            }).except(new SuccessCallback<Throwable>(){

                @Override
                public void onSucess(Throwable value) {
                    if (!out.isDone()) {
                        out.error(value);
                    }
                }
            });
            return out;
        }
        this.pendingPlayRequest = out;
        if (this.getState() == AsyncMedia.State.Playing) {
            out.complete(this);
            return out;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class StateChangeListener
        implements ActionListener<AsyncMedia.MediaStateChangeEvent> {
            ActionListener<AsyncMedia.MediaErrorEvent> onError;

            StateChangeListener() {
            }

            @Override
            public void actionPerformed(AsyncMedia.MediaStateChangeEvent evt) {
                if (!out.isDone() && evt.getNewState() == AsyncMedia.State.Playing) {
                    AbstractMedia.this.stateChangeListeners.removeListener(this);
                    if (this.onError != null) {
                        AbstractMedia.this.errorListeners.removeListener(this.onError);
                    }
                    out.complete(AbstractMedia.this);
                }
            }
        }
        final StateChangeListener onStateChange = new StateChangeListener();
        onStateChange.onError = onError = new ActionListener<AsyncMedia.MediaErrorEvent>(){
            {
            }

            @Override
            public void actionPerformed(AsyncMedia.MediaErrorEvent evt) {
                AbstractMedia.this.stateChangeListeners.removeListener(onStateChange);
                AbstractMedia.this.errorListeners.removeListener(this);
                if (!out.isDone()) {
                    out.error(evt.getMediaException());
                }
            }
        };
        this.stateChangeListeners.addListener(onStateChange);
        this.errorListeners.addListener(onError);
        this.playImpl();
        return out;
    }

    @Override
    public AsyncMedia.PauseRequest pauseAsync() {
        return this.pauseAsync(new AsyncMedia.PauseRequest(){

            public void complete(AsyncMedia value) {
                if (AbstractMedia.this.pendingPauseRequest == this) {
                    AbstractMedia.this.pendingPauseRequest = null;
                }
                super.complete(value);
            }

            public void error(Throwable t) {
                if (AbstractMedia.this.pendingPauseRequest == this) {
                    AbstractMedia.this.pendingPauseRequest = null;
                }
                super.error(t);
            }
        });
    }

    private AsyncMedia.PauseRequest pauseAsync(final AsyncMedia.PauseRequest out) {
        ActionListener<AsyncMedia.MediaErrorEvent> onError;
        if (out.isDone()) {
            return out;
        }
        if (this.pendingPlayRequest != null) {
            this.pendingPlayRequest.ready(new SuccessCallback<AsyncMedia>(){

                @Override
                public void onSucess(AsyncMedia value) {
                    if (!out.isDone()) {
                        AbstractMedia.this.pauseAsync(out);
                    }
                }
            }).except(new SuccessCallback<Throwable>(){

                @Override
                public void onSucess(Throwable value) {
                    if (!out.isDone()) {
                        AbstractMedia.this.pauseAsync(out);
                    }
                }
            });
            this.pendingPlayRequest = null;
            this.pendingPauseRequest = out;
            return out;
        }
        if (this.pendingPauseRequest != null && this.pendingPauseRequest != out) {
            this.pendingPauseRequest.ready(new SuccessCallback<AsyncMedia>(){

                @Override
                public void onSucess(AsyncMedia value) {
                    if (!out.isDone()) {
                        out.complete(value);
                    }
                }
            }).except(new SuccessCallback<Throwable>(){

                @Override
                public void onSucess(Throwable value) {
                    if (!out.isDone()) {
                        out.error(value);
                    }
                }
            });
            return out;
        }
        this.pendingPauseRequest = out;
        if (this.getState() == AsyncMedia.State.Paused) {
            out.complete(this);
            return out;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class StateChangeListener
        implements ActionListener<AsyncMedia.MediaStateChangeEvent> {
            ActionListener<AsyncMedia.MediaErrorEvent> onError;

            StateChangeListener() {
            }

            @Override
            public void actionPerformed(AsyncMedia.MediaStateChangeEvent evt) {
                if (!out.isDone() && evt.getNewState() == AsyncMedia.State.Paused) {
                    AbstractMedia.this.stateChangeListeners.removeListener(this);
                    if (this.onError != null) {
                        AbstractMedia.this.errorListeners.removeListener(this.onError);
                    }
                    out.complete(AbstractMedia.this);
                }
            }
        }
        final StateChangeListener onStateChange = new StateChangeListener();
        onStateChange.onError = onError = new ActionListener<AsyncMedia.MediaErrorEvent>(){
            {
            }

            @Override
            public void actionPerformed(AsyncMedia.MediaErrorEvent evt) {
                AbstractMedia.this.stateChangeListeners.removeListener(onStateChange);
                AbstractMedia.this.errorListeners.removeListener(this);
                if (!out.isDone()) {
                    out.error(evt.getMediaException());
                }
            }
        };
        this.stateChangeListeners.addListener(onStateChange);
        this.errorListeners.addListener(onError);
        this.pauseImpl();
        return out;
    }

    protected abstract void playImpl();

    protected abstract void pauseImpl();

    @Override
    public final void play() {
        this.playAsync();
    }

    @Override
    public final void pause() {
        this.pauseAsync();
    }
}

