/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.testing;

import com.codename1.io.Log;
import com.codename1.testing.TestReporting;
import com.codename1.testing.UnitTest;
import com.codename1.ui.CN;
import com.codename1.ui.Display;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class DeviceRunner {
    private static final int VERSION = 1;
    private int failedTests;
    private int passedTests;

    public void runTests() {
        this.failedTests = 0;
        this.passedTests = 0;
        Log.p("-----STARTING TESTS-----");
        try {
            int iter;
            InputStream is = this.getClass().getResourceAsStream("/tests.dat");
            if (is == null) {
                is = Display.getInstance().getResourceAsStream(null, "/tests.dat");
            }
            if (is == null) {
                Log.p("Test data not found in the file, make sure the ant task was executed in full");
                System.exit(2);
                return;
            }
            DataInputStream di = new DataInputStream(is);
            int version = di.readInt();
            if (version > 1) {
                Log.p("Tests were built with a new version of Codename One and can't be executed with this runner");
                System.exit(4);
                return;
            }
            String[] tests = new String[di.readInt()];
            for (iter = 0; iter < tests.length; ++iter) {
                tests[iter] = di.readUTF();
            }
            di.close();
            for (iter = 0; iter < tests.length; ++iter) {
                this.runTest(tests[iter]);
            }
        }
        catch (IOException err) {
            TestReporting.getInstance().logException(err);
        }
        TestReporting.getInstance().testExecutionFinished();
        if (this.failedTests > 0) {
            Log.p("Test execution finished, some failed tests occured. Passed: " + this.passedTests + " tests. Failed: " + this.failedTests + " tests.");
        } else {
            Log.p("All tests passed. Total " + this.passedTests + " tests passed");
        }
        Log.p("-----FINISHED TESTS-----");
    }

    protected abstract void startApplicationInstance();

    protected abstract void stopApplicationInstance();

    public void runTest(String testClassName) {
        try {
            final UnitTest t = (UnitTest)Class.forName(testClassName).newInstance();
            try {
                TestReporting.getInstance().startingTestCase(t);
                this.startApplicationInstance();
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class RunTestImpl
                implements Runnable {
                    boolean result;

                    RunTestImpl() {
                    }

                    @Override
                    public void run() {
                        try {
                            t.prepare();
                            this.result = t.runTest();
                            if (this.result) {
                                DeviceRunner.this.passedTests++;
                            } else {
                                DeviceRunner.this.failedTests++;
                            }
                            t.cleanup();
                        }
                        catch (Throwable err) {
                            DeviceRunner.this.failedTests++;
                            TestReporting.getInstance().logException(err);
                            TestReporting.getInstance().finishedTestCase(t, false);
                        }
                    }
                }
                RunTestImpl runTest = new RunTestImpl();
                if (t.shouldExecuteOnEDT() && !CN.isEdt()) {
                    CN.callSeriallyAndWait(runTest);
                } else if (!t.shouldExecuteOnEDT() && CN.isEdt()) {
                    CN.invokeAndBlock(runTest);
                } else {
                    runTest.run();
                }
                this.stopApplicationInstance();
                TestReporting.getInstance().finishedTestCase(t, runTest.result);
            }
            catch (Throwable err) {
                ++this.failedTests;
                TestReporting.getInstance().logException(err);
                TestReporting.getInstance().finishedTestCase(t, false);
            }
        }
        catch (Throwable t) {
            TestReporting.getInstance().logMessage("Failed to create instance of " + testClassName);
            TestReporting.getInstance().logMessage("Verify the class is public and doesn't have a specialized constructor");
            TestReporting.getInstance().logException(t);
        }
    }
}

