/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.io.Log;
import com.codename1.ui.AnimationManager;
import com.codename1.ui.Button;
import com.codename1.ui.CN;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.LeadUtil;
import com.codename1.ui.MenuBar;
import com.codename1.ui.Painter;
import com.codename1.ui.ReleasableComponent;
import com.codename1.ui.RunnableWrapper;
import com.codename1.ui.TextArea;
import com.codename1.ui.TextSelection;
import com.codename1.ui.Toolbar;
import com.codename1.ui.TooltipManager;
import com.codename1.ui.VirtualInputDevice;
import com.codename1.ui.animations.Animation;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.animations.Transition;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.list.ListCellRenderer;
import com.codename1.ui.plaf.LookAndFeel;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Form
extends Container {
    private Command sourceCommand;
    private boolean globalAnimationLock;
    static int activePeerCount;
    private Painter glassPane;
    private Container layeredPane;
    private Container formLayeredPane;
    private final Container contentPane;
    Container titleArea = new Container(new BorderLayout());
    private Label title = new Label("", "Title");
    private MenuBar menuBar;
    private Component dragged;
    private boolean enableCursors;
    static Motion rippleMotion;
    static Component rippleComponent;
    static int rippleX;
    static int rippleY;
    private TextSelection textSelection;
    private ArrayList<Component> componentsAwaitingRelease;
    private VirtualInputDevice currentInputDevice;
    private AnimationManager animMananger = new AnimationManager(this);
    protected boolean focusScrolling;
    static boolean comboLock;
    private ArrayList<Animation> internalAnimatableComponents;
    private ArrayList<Animation> animatableComponents;
    private Component focused;
    private ArrayList<Component> mediaComponents;
    private boolean bottomPaddingMode;
    private Transition transitionInAnimator;
    private Transition transitionOutAnimator;
    private EventDispatcher commandListener;
    private Form previousForm;
    boolean tint;
    private int tintColor;
    private HashMap<Integer, ArrayList<ActionListener>> keyListeners;
    private HashMap<Integer, ArrayList<ActionListener>> gameKeyListeners;
    private boolean cyclicFocus = true;
    private int tactileTouchDuration;
    EventDispatcher showListener;
    int initialPressX;
    int initialPressY;
    private EventDispatcher orientationListener;
    private EventDispatcher sizeChangedListener;
    private EventDispatcher pasteListener;
    private UIManager uiManager;
    private Component stickyDrag;
    private boolean dragStopFlag;
    private Toolbar toolbar;
    private TextArea editOnShow;
    private Set<Container> pendingRevalidateQueue = new HashSet<Container>();
    private ArrayList<Container> revalidateQueue = new ArrayList();
    boolean revalidateFromRoot = "true".equals(CN.getProperty("Form.revalidateFromRoot", "true"));
    private boolean safeAreaDirty = true;
    private final Rectangle safeArea = new Rectangle();
    private static final String Z_INDEX_PROP = "cn1$_zIndex";
    private Component pressedCmp;
    private Rectangle pressedCmpAbsBounds = new Rectangle();
    private Object currentPointerPress;
    private boolean inInternalPaint;

    public Form() {
        this(new FlowLayout());
    }

    public Form(Layout contentPaneLayout) {
        super(new BorderLayout());
        this.setSafeAreaRoot(true);
        this.contentPane = new Container(contentPaneLayout);
        this.setUIID("Form");
        this.setVisible(false);
        Style formStyle = this.getStyle();
        Display d = Display.getInstance();
        int w = d.getDisplayWidth() - formStyle.getHorizontalMargins();
        int h = d.getDisplayHeight() - formStyle.getVerticalMargins();
        this.setWidth(w);
        this.setHeight(h);
        this.setPreferredSize(new Dimension(w, h));
        super.setAlwaysTensile(false);
        this.title.setEndsWith3Points(false);
        this.titleArea.addComponent("Center", (Component)this.title);
        this.titleArea.setUIID("TitleArea");
        this.addComponentToForm("North", this.titleArea);
        this.addComponentToForm("Center", this.contentPane);
        this.initAdPadding(d);
        this.contentPane.setUIID("ContentPane");
        this.contentPane.setScrollableY(true);
        if (this.title.getText() != null && this.title.shouldTickerStart()) {
            this.title.startTicker(this.getUIManager().getLookAndFeel().getTickerSpeed(), true);
        }
        this.initTitleBarStatus();
        formStyle.setBgTransparency(255);
        this.initGlobalToolbar();
    }

    @Override
    public void setAllowEnableLayoutOnPaint(boolean allow) {
        super.setAllowEnableLayoutOnPaint(allow);
    }

    public void addPasteListener(ActionListener l) {
        if (this.pasteListener == null) {
            this.pasteListener = new EventDispatcher();
        }
        this.pasteListener.addListener(l);
    }

    public void removePasteListener(ActionListener l) {
        if (this.pasteListener == null) {
            return;
        }
        this.pasteListener.removeListener(l);
    }

    void revalidateLater(Container cnt) {
        if (!this.pendingRevalidateQueue.contains(cnt)) {
            Iterator<Container> it = this.pendingRevalidateQueue.iterator();
            while (it.hasNext()) {
                Container existing = it.next();
                if (existing.contains(cnt)) {
                    return;
                }
                if (!cnt.contains(existing)) continue;
                it.remove();
            }
            this.pendingRevalidateQueue.add(cnt);
        }
    }

    void removeFromRevalidateQueue(Container cnt) {
        this.pendingRevalidateQueue.remove(cnt);
    }

    void flushRevalidateQueue() {
        if (!this.pendingRevalidateQueue.isEmpty()) {
            this.revalidateQueue.addAll(this.pendingRevalidateQueue);
            this.pendingRevalidateQueue.clear();
            int len = this.revalidateQueue.size();
            for (int i = 0; i < len; ++i) {
                Container cnt = this.revalidateQueue.get(i);
                cnt.revalidateWithAnimationSafetyInternal(false);
            }
            this.revalidateQueue.clear();
        }
    }

    public void dispatchPaste(ActionEvent l) {
        if (this.pasteListener != null) {
            this.pasteListener.fireActionEvent(l);
        }
    }

    public TextSelection getTextSelection() {
        if (this.textSelection == null) {
            this.textSelection = new TextSelection(this.getContentPane());
        }
        return this.textSelection;
    }

    public boolean isEnableCursors() {
        return this.enableCursors;
    }

    public void setEnableCursors(boolean e) {
        this.enableCursors = e;
    }

    public void setSourceCommand(Command sourceCommand) {
        this.sourceCommand = sourceCommand;
    }

    public Command getSourceCommand() {
        return this.sourceCommand;
    }

    public void setCurrentInputDevice(VirtualInputDevice device) throws Exception {
        if (this.currentInputDevice != null) {
            this.currentInputDevice.close();
        }
        this.currentInputDevice = device;
    }

    public VirtualInputDevice getCurrentInputDevice() {
        return this.currentInputDevice;
    }

    protected void initGlobalToolbar() {
        if (Toolbar.isGlobalToolbar()) {
            this.setToolbar(new Toolbar());
        }
    }

    static int getInvisibleAreaUnderVKB(Form f) {
        if (f == null) {
            return 0;
        }
        return f.getInvisibleAreaUnderVKB();
    }

    public int getInvisibleAreaUnderVKB() {
        if (this.bottomPaddingMode) {
            return 0;
        }
        return Display.impl.getInvisibleAreaUnderVKB();
    }

    @Override
    public AnimationManager getAnimationManager() {
        return this.animMananger;
    }

    public void setFormBottomPaddingEditingMode(boolean b) {
        this.bottomPaddingMode = b;
    }

    public boolean isFormBottomPaddingEditingMode() {
        return this.bottomPaddingMode;
    }

    public Rectangle getSafeArea() {
        if (this.safeAreaDirty) {
            Display.impl.getDisplaySafeArea(this.safeArea);
        }
        return this.safeArea;
    }

    void initAdPadding(Display d) {
        String adPaddingBottom = d.getProperty("adPaddingBottom", null);
        if (adPaddingBottom != null && adPaddingBottom.length() > 0) {
            Container pad = new Container();
            int dim = Integer.parseInt(adPaddingBottom);
            dim = d.convertToPixels(dim, true);
            if (Display.getInstance().isTablet()) {
                dim *= 2;
            }
            pad.setPreferredSize(new Dimension(dim, dim));
            this.addComponentToForm("South", pad);
        }
    }

    protected boolean shouldPaintStatusBar() {
        return this.getUIManager().isThemeConstant("paintsTitleBarBool", false);
    }

    protected Component createStatusBar() {
        if (this.getUIManager().isThemeConstant("statusBarScrollsUpBool", true)) {
            Button bar = new Button();
            bar.setShowEvenIfBlank(true);
            if (this.getUIManager().isThemeConstant("landscapeTitleUiidBool", false)) {
                bar.setUIID("StatusBar", "StatusBarLandscape");
            } else {
                bar.setUIID("StatusBar");
            }
            bar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Component c = Form.this.findScrollableChild(Form.this.getContentPane());
                    if (c != null) {
                        c.scrollRectToVisible(new Rectangle(0, 0, 10, 10), c);
                    }
                }
            });
            return bar;
        }
        Container bar = new Container();
        if (this.getUIManager().isThemeConstant("landscapeTitleUiidBool", false)) {
            bar.setUIID("StatusBar", "StatusBarLandscape");
        } else {
            bar.setUIID("StatusBar");
        }
        return bar;
    }

    void initTitleBarStatus() {
        if (this.shouldPaintStatusBar() && ((BorderLayout)this.titleArea.getLayout()).getNorth() == null) {
            this.titleArea.addComponent("North", this.createStatusBar());
            this.titleArea.revalidateLater();
        }
    }

    Component findScrollableChild(Container c) {
        if (c.isScrollableY()) {
            return c;
        }
        int count = c.getComponentCount();
        for (int iter = 0; iter < count; ++iter) {
            Component chld;
            Component comp = c.getComponentAt(iter);
            if (comp.isScrollableY()) {
                return comp;
            }
            if (!(comp instanceof Container) || (chld = this.findScrollableChild((Container)comp)) == null) continue;
            return chld;
        }
        return null;
    }

    @Override
    public boolean isAlwaysTensile() {
        return this.getContentPane().isAlwaysTensile();
    }

    public boolean grabAnimationLock() {
        if (this.globalAnimationLock) {
            return false;
        }
        this.globalAnimationLock = true;
        return true;
    }

    public void releaseAnimationLock() {
        this.globalAnimationLock = false;
    }

    public Component findCurrentlyEditingComponent() {
        return ComponentSelector.select("*", this).filter(new ComponentSelector.Filter(){

            public boolean filter(Component c) {
                return c.isEditing();
            }
        }).asComponent();
    }

    @Override
    public void setAlwaysTensile(boolean alwaysTensile) {
        this.getContentPane().setAlwaysTensile(alwaysTensile);
    }

    public Container getTitleArea() {
        if (this.toolbar != null && this.toolbar.getParent() != null) {
            return this.toolbar;
        }
        return this.titleArea;
    }

    @Override
    public UIManager getUIManager() {
        if (this.uiManager != null) {
            return this.uiManager;
        }
        return UIManager.getInstance();
    }

    @Override
    public void setUIManager(UIManager uiManager) {
        this.uiManager = uiManager;
        this.refreshTheme(false);
    }

    public void addShowListener(ActionListener l) {
        if (this.showListener == null) {
            this.showListener = new EventDispatcher();
        }
        this.showListener.addListener(l);
    }

    public void removeShowListener(ActionListener l) {
        if (this.showListener == null) {
            return;
        }
        this.showListener.removeListener(l);
    }

    public void removeAllShowListeners() {
        if (this.showListener != null) {
            this.showListener.getListenerCollection().clear();
            this.showListener = null;
        }
    }

    public void addOrientationListener(ActionListener l) {
        if (this.orientationListener == null) {
            this.orientationListener = new EventDispatcher();
        }
        this.orientationListener.addListener(l);
    }

    public void removeOrientationListener(ActionListener l) {
        if (this.orientationListener == null) {
            return;
        }
        this.orientationListener.removeListener(l);
    }

    public void addSizeChangedListener(ActionListener l) {
        if (this.sizeChangedListener == null) {
            this.sizeChangedListener = new EventDispatcher();
        }
        this.sizeChangedListener.addListener(l);
    }

    public void removeSizeChangedListener(ActionListener l) {
        if (this.sizeChangedListener == null) {
            return;
        }
        this.sizeChangedListener.removeListener(l);
    }

    protected void hideNotify() {
        this.setVisible(false);
    }

    protected void showNotify() {
        this.setVisible(true);
    }

    protected void sizeChanged(int w, int h) {
    }

    public void setSafeAreaChanged() {
        this.safeAreaDirty = true;
    }

    void sizeChangedInternal(int w, int h) {
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        this.sizeChanged(w, h);
        Style formStyle = this.getStyle();
        this.setSize(new Dimension(w -= formStyle.getHorizontalMargins(), h -= formStyle.getVerticalMargins()));
        this.setShouldCalcPreferredSize(true);
        this.safeAreaDirty = true;
        this.doLayout();
        this.focused = this.getFocused();
        if (this.focused != null) {
            Component.setDisableSmoothScrolling(true);
            this.scrollComponentToVisible(this.focused);
            Component.setDisableSmoothScrolling(false);
        }
        if (oldWidth != w && oldHeight != h) {
            if (this.orientationListener != null) {
                this.orientationListener.fireActionEvent(new ActionEvent((Object)this, ActionEvent.Type.OrientationChange));
            }
            boolean a = this.getContentPane().onOrientationChange();
            if (this.getToolbar() != null) {
                if (this.getToolbar().onOrientationChange() || a) {
                    this.forceRevalidate();
                }
            } else if (a) {
                this.forceRevalidate();
            }
        }
        if (this.sizeChangedListener != null) {
            this.sizeChangedListener.fireActionEvent(new ActionEvent((Object)this, ActionEvent.Type.SizeChange, w, h));
        }
        this.repaint();
        this.revalidateLater();
    }

    public void setGlassPane(Painter glassPane) {
        this.glassPane = glassPane;
        this.repaint();
    }

    @Override
    public boolean isDragRegion(int x, int y) {
        Component c;
        if (this.getMenuBar().isDragRegion(x, y)) {
            return true;
        }
        if (this.formLayeredPane != null && this.formLayeredPane.isDragRegion(x, y)) {
            return true;
        }
        Container actual = this.getActualPane();
        for (c = actual.getComponentAt(x, y); c != null && c.isIgnorePointerEvents(); c = c.getParent()) {
        }
        return c != null && c.isDragRegion(x, y);
    }

    @Override
    public int getDragRegionStatus(int x, int y) {
        int formLayeredPaneDrag;
        int menuBarDrag = this.getMenuBar().getDragRegionStatus(x, y);
        if (menuBarDrag != 1) {
            return menuBarDrag;
        }
        int n = formLayeredPaneDrag = this.formLayeredPane != null ? this.formLayeredPane.getDragRegionStatus(x, y) : 1;
        if (formLayeredPaneDrag != 1) {
            return formLayeredPaneDrag;
        }
        Container actual = this.getActualPane();
        if (actual != null) {
            Component c;
            for (c = actual.getComponentAt(x, y); c != null && c.isIgnorePointerEvents(); c = c.getParent()) {
            }
            if (c != null) {
                return c.getDragRegionStatus(x, y);
            }
            if (this.isScrollable()) {
                return 22;
            }
        }
        return 1;
    }

    @Override
    void paintGlassImpl(Graphics g) {
        if (this.getParent() != null) {
            super.paintGlassImpl(g);
            return;
        }
        if (this.glassPane != null) {
            int tx = g.getTranslateX();
            int ty = g.getTranslateY();
            g.translate(-tx, -ty);
            this.glassPane.paint(g, this.getBounds());
            g.translate(tx, ty);
        }
        this.paintGlass(g);
        if (this.dragged != null && this.dragged.isDragAndDropInitialized()) {
            int[] c = g.getClip();
            g.setClip(0, 0, this.getWidth(), this.getHeight());
            this.dragged.drawDraggedImage(g);
            g.setClip(c);
        }
    }

    public Painter getGlassPane() {
        return this.glassPane;
    }

    public void setTitleStyle(Style s) {
        this.title.setUnselectedStyle(s);
    }

    public Label getTitleComponent() {
        return this.title;
    }

    public void setTitleComponent(Label title) {
        this.titleArea.replace((Component)this.title, (Component)title, false);
        this.title = title;
    }

    public void setTitleComponent(Label title, Transition t) {
        this.titleArea.replace((Component)this.title, (Component)title, t);
        this.title = title;
    }

    public void addKeyListener(int keyCode, ActionListener listener) {
        if (this.keyListeners == null) {
            this.keyListeners = new HashMap();
        }
        this.addKeyListener(keyCode, listener, this.keyListeners);
    }

    public void removeKeyListener(int keyCode, ActionListener listener) {
        if (this.keyListeners == null) {
            return;
        }
        this.removeKeyListener(keyCode, listener, this.keyListeners);
    }

    public void removeGameKeyListener(int keyCode, ActionListener listener) {
        if (this.gameKeyListeners == null) {
            return;
        }
        this.removeKeyListener(keyCode, listener, this.gameKeyListeners);
    }

    private void addKeyListener(int keyCode, ActionListener listener, HashMap<Integer, ArrayList<ActionListener>> keyListeners) {
        Integer code;
        ArrayList<ActionListener<Object>> vec;
        if (keyListeners == null) {
            keyListeners = new HashMap();
        }
        if ((vec = keyListeners.get(code = new Integer(keyCode))) == null) {
            vec = new ArrayList();
            vec.add(listener);
            keyListeners.put(code, vec);
            return;
        }
        if (!vec.contains(listener)) {
            vec.add(listener);
        }
    }

    private void removeKeyListener(int keyCode, ActionListener listener, HashMap<Integer, ArrayList<ActionListener>> keyListeners) {
        if (keyListeners == null) {
            return;
        }
        Integer code = new Integer(keyCode);
        ArrayList<ActionListener> vec = keyListeners.get(code);
        if (vec == null) {
            return;
        }
        vec.remove(listener);
        if (vec.size() == 0) {
            keyListeners.remove(code);
        }
    }

    public void addGameKeyListener(int keyCode, ActionListener listener) {
        if (this.gameKeyListeners == null) {
            this.gameKeyListeners = new HashMap();
        }
        this.addKeyListener(keyCode, listener, this.gameKeyListeners);
    }

    public int getSoftButtonCount() {
        return this.menuBar.getSoftButtons().length;
    }

    public Button getSoftButton(int offset) {
        return this.menuBar.getSoftButtons()[offset];
    }

    public Style getMenuStyle() {
        return this.menuBar.getMenuStyle();
    }

    public Style getTitleStyle() {
        return this.title.getStyle();
    }

    Form getPreviousForm() {
        return this.previousForm;
    }

    @Override
    protected void initLaf(UIManager uim) {
        super.initLaf(uim);
        LookAndFeel laf = uim.getLookAndFeel();
        this.transitionOutAnimator = laf.getDefaultFormTransitionOut();
        this.transitionInAnimator = laf.getDefaultFormTransitionIn();
        this.focusScrolling = laf.isFocusScrolling();
        if (this.menuBar == null || !this.menuBar.getClass().equals(laf.getMenuBarClass())) {
            try {
                this.menuBar = (MenuBar)laf.getMenuBarClass().newInstance();
            }
            catch (Exception ex) {
                Log.e(ex);
                this.menuBar = new MenuBar();
            }
            this.menuBar.initMenuBar(this);
        }
        this.tintColor = laf.getDefaultFormTintColor();
        this.tactileTouchDuration = laf.getTactileTouchDuration();
    }

    void setDraggedComponent(Component dragged) {
        this.dragged = LeadUtil.leadParentImpl(dragged);
    }

    Component getDraggedComponent() {
        return this.dragged;
    }

    private boolean isInSameColumn(Component source, Component dest) {
        if (source == null || dest == null) {
            return false;
        }
        return Rectangle.intersects(source.getAbsoluteX(), 0, source.getWidth(), Integer.MAX_VALUE, dest.getAbsoluteX(), dest.getAbsoluteY(), dest.getWidth(), dest.getHeight());
    }

    private boolean isInSameRow(Component source, Component dest) {
        return Rectangle.intersects(0, source.getAbsoluteY(), Integer.MAX_VALUE, source.getHeight(), dest.getAbsoluteX(), dest.getAbsoluteY(), dest.getWidth(), dest.getHeight());
    }

    public void setDefaultCommand(Command defaultCommand) {
        this.menuBar.setDefaultCommand(defaultCommand);
    }

    public Command getDefaultCommand() {
        return this.menuBar.getDefaultCommand();
    }

    public void setClearCommand(Command clearCommand) {
        this.menuBar.setClearCommand(clearCommand);
    }

    public Command getClearCommand() {
        return this.menuBar.getClearCommand();
    }

    public void setBackCommand(Command backCommand) {
        this.menuBar.setBackCommand(backCommand);
    }

    public Command setBackCommand(String name, Image icon, ActionListener ev) {
        Command cmd = Command.create(name, icon, ev);
        this.menuBar.setBackCommand(cmd);
        return cmd;
    }

    public Command getBackCommand() {
        return this.menuBar.getBackCommand();
    }

    public Form(String title) {
        this();
        this.setTitle(title);
    }

    public Form(String title, Layout contentPaneLayout) {
        this(contentPaneLayout);
        this.setTitle(title);
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public Container getLayeredPane() {
        return this.getLayeredPane(null, false);
    }

    public Container getLayeredPane(Class c, boolean top) {
        Container layeredPaneImpl = this.getLayeredPaneImpl();
        if (c == null) {
            for (Component cmp : layeredPaneImpl.getChildrenAsList(true)) {
                if (cmp.getClientProperty("cn1$_cls") != null) continue;
                return (Container)cmp;
            }
        }
        String n = c.getName();
        List<Component> children = layeredPaneImpl.getChildrenAsList(true);
        for (Component cmp : children) {
            if (!n.equals(cmp.getClientProperty("cn1$_cls"))) continue;
            return (Container)cmp;
        }
        Container cnt = new Container();
        int zIndex = 0;
        int componentCount = children.size();
        if (top) {
            Integer z;
            if (componentCount > 0 && (z = (Integer)children.get(componentCount - 1).getClientProperty(Z_INDEX_PROP)) != null) {
                zIndex = z;
            }
            layeredPaneImpl.add(cnt);
        } else {
            Integer z;
            if (componentCount > 0 && componentCount > 0 && (z = (Integer)children.get(0).getClientProperty(Z_INDEX_PROP)) != null) {
                zIndex = z;
            }
            layeredPaneImpl.addComponent(0, (Component)cnt);
        }
        cnt.putClientProperty("cn1$_cls", n);
        cnt.putClientProperty(Z_INDEX_PROP, zIndex);
        return cnt;
    }

    public Container getLayeredPane(Class c, int zIndex) {
        Container layeredPaneImpl = this.getLayeredPaneImpl();
        if (c == null) {
            for (Component cmp : layeredPaneImpl.getChildrenAsList(true)) {
                if (cmp.getClientProperty("cn1$_cls") != null) continue;
                return (Container)cmp;
            }
        }
        String n = c.getName();
        List<Component> children = layeredPaneImpl.getChildrenAsList(true);
        for (Component cmp : children) {
            if (!n.equals(cmp.getClientProperty("cn1$_cls"))) continue;
            return (Container)cmp;
        }
        Container cnt = new Container();
        cnt.putClientProperty(Z_INDEX_PROP, zIndex);
        int len = children.size();
        int insertIndex = -1;
        for (int i = 0; i < len; ++i) {
            int cmpZ;
            Component cmp = children.get(i);
            Integer cmpZIndex = (Integer)cmp.getClientProperty(Z_INDEX_PROP);
            int n2 = cmpZ = cmpZIndex == null ? 0 : cmpZIndex;
            if (cmpZ < zIndex) continue;
            insertIndex = i;
            break;
        }
        if (insertIndex == -1) {
            layeredPaneImpl.add(cnt);
        } else {
            layeredPaneImpl.addComponent(insertIndex, (Component)cnt);
        }
        cnt.putClientProperty("cn1$_cls", n);
        return cnt;
    }

    public Container getFormLayeredPane(Class c, boolean top) {
        if (this.formLayeredPane == null) {
            this.formLayeredPane = new Container(new LayeredLayout()){

                protected void paintBackground(Graphics g) {
                    if (this.getComponentCount() > 0 && this.isVisible()) {
                        this.setVisible(false);
                        Form.this.paint(g);
                        this.setVisible(true);
                    }
                }

                public void paintBackgrounds(Graphics g) {
                }
            };
            this.formLayeredPane.setName("FormLayeredPane");
            this.addComponentToForm("Overlay", this.formLayeredPane);
        }
        if (c == null) {
            for (Component cmp : this.formLayeredPane.getChildrenAsList(true)) {
                if (cmp.getClientProperty("cn1$_cls") != null) continue;
                return (Container)cmp;
            }
            Container cnt = new Container();
            cnt.setWidth(this.getWidth());
            cnt.setHeight(this.getHeight());
            cnt.setShouldLayout(false);
            cnt.setName("FormLayer: " + c.getName());
            this.formLayeredPane.add(cnt);
            return cnt;
        }
        String n = c.getName();
        for (Component cmp : this.formLayeredPane.getChildrenAsList(true)) {
            if (!n.equals(cmp.getClientProperty("cn1$_cls"))) continue;
            return (Container)cmp;
        }
        Container cnt = new Container();
        cnt.setWidth(this.getWidth());
        cnt.setHeight(this.getHeight());
        cnt.setShouldLayout(false);
        cnt.setName("FormLayer: " + c.getName());
        if (top) {
            this.formLayeredPane.add(cnt);
        } else {
            this.formLayeredPane.addComponent(0, (Component)cnt);
        }
        cnt.putClientProperty("cn1$_cls", n);
        return cnt;
    }

    protected Container getLayeredPaneIfExists() {
        return this.layeredPane;
    }

    protected Container getFormLayeredPaneIfExists() {
        return this.formLayeredPane;
    }

    private Container getLayeredPaneImpl() {
        if (this.layeredPane == null) {
            this.layeredPane = new Container(new LayeredLayout());
            Container parent = this.contentPane.wrapInLayeredPane();
            this.layeredPane.add(new Container());
            parent.addComponent(this.layeredPane);
            this.revalidateWithAnimationSafety();
        }
        return this.layeredPane;
    }

    Container getActualPane() {
        if (this.layeredPane != null) {
            return this.layeredPane.getParent();
        }
        return this.contentPane;
    }

    private Container getActualPane(Container overlay, int x, int y) {
        if (overlay != null && overlay.getResponderAt(x, y) != null) {
            return overlay;
        }
        if (this.menuBar != null && this.menuBar.contains(x, y) && !this.getToolbar().contains(x, y)) {
            return this.menuBar;
        }
        return this.getActualPane();
    }

    @Override
    public void removeAll() {
        this.contentPane.removeAll();
    }

    public void setBgImage(Image bgImage) {
        this.getStyle().setBgImage(bgImage);
    }

    @Override
    public void setLayout(Layout layout) {
        if (layout instanceof BorderLayout) {
            this.setScrollable(false);
        }
        this.contentPane.setLayout(layout);
    }

    void updateIcsIconCommandBehavior() {
        Image i;
        int b = Display.getInstance().getCommandBehavior();
        if (b == 7 && this.getTitleComponent().getIcon() == null && (i = Display.impl.getApplicationIconImage()) != null) {
            int h = this.getTitleComponent().getStyle().getFont().getHeight();
            i = i.scaled(h, h);
            this.getTitleComponent().setIcon(i);
        }
    }

    @Override
    public void stopEditing(Runnable onFinish) {
        Display.getInstance().stopEditing(this, onFinish);
    }

    @Override
    public boolean isEditing() {
        return Display.getInstance().isTextEditing(this);
    }

    public void setTitle(String title) {
        if (this.toolbar != null) {
            this.toolbar.setTitle(title);
            return;
        }
        this.title.setText(title);
        if (!Display.getInstance().isNativeTitle()) {
            this.updateIcsIconCommandBehavior();
            if (this.isInitialized() && this.title.isTickerEnabled()) {
                int b = Display.getInstance().getCommandBehavior();
                if (b == 5 || b == 6 || b == 7 || b == 8) {
                    this.titleArea.revalidateLater();
                }
                if (this.title.shouldTickerStart()) {
                    this.title.startTicker(this.getUIManager().getLookAndFeel().getTickerSpeed(), true);
                } else if (this.title.isTickerRunning()) {
                    this.title.stopTicker();
                }
            }
        } else {
            if (super.contains(this.titleArea)) {
                this.removeComponentFromForm(this.titleArea);
            }
            if (Display.getInstance().getCurrent() == this) {
                Display.getInstance().refreshNativeTitle();
            }
        }
    }

    public String getTitle() {
        if (this.toolbar != null) {
            Component cmp = this.toolbar.getTitleComponent();
            if (cmp instanceof Label) {
                return ((Label)cmp).getText();
            }
            return null;
        }
        return this.title.getText();
    }

    @Override
    public void addComponent(Component cmp) {
        this.contentPane.addComponent(cmp);
    }

    @Override
    public void addComponent(Object constraints, Component cmp) {
        this.contentPane.addComponent(constraints, cmp);
    }

    @Override
    public void addComponent(int index, Object constraints, Component cmp) {
        this.contentPane.addComponent(index, constraints, cmp);
    }

    @Override
    public void addComponent(int index, Component cmp) {
        this.contentPane.addComponent(index, cmp);
    }

    @Override
    public void replace(Component current, Component next, Transition t) {
        this.contentPane.replace(current, next, t);
    }

    @Override
    public void replaceAndWait(Component current, Component next, Transition t) {
        this.contentPane.replaceAndWait(current, next, t);
    }

    @Override
    public void removeComponent(Component cmp) {
        this.contentPane.removeComponent(cmp);
    }

    @Override
    public void animateHierarchy(int duration) {
        this.contentPane.animateHierarchy(duration);
    }

    @Override
    public void animateHierarchyAndWait(int duration) {
        this.contentPane.animateHierarchyAndWait(duration);
    }

    @Override
    public void animateHierarchyFade(int duration, int startingOpacity) {
        this.contentPane.animateHierarchyFade(duration, startingOpacity);
    }

    @Override
    public void animateHierarchyFadeAndWait(int duration, int startingOpacity) {
        this.contentPane.animateHierarchyFadeAndWait(duration, startingOpacity);
    }

    @Override
    public void animateLayout(int duration) {
        this.contentPane.animateLayout(duration);
    }

    @Override
    public void animateLayoutAndWait(int duration) {
        this.contentPane.animateLayoutAndWait(duration);
    }

    @Override
    public void animateLayoutFade(int duration, int startingOpacity) {
        this.contentPane.animateLayoutFade(duration, startingOpacity);
    }

    @Override
    public void animateLayoutFadeAndWait(int duration, int startingOpacity) {
        this.contentPane.animateLayoutFadeAndWait(duration, startingOpacity);
    }

    @Override
    public void animateUnlayout(int duration, int opacity, Runnable callback) {
        this.contentPane.animateUnlayout(duration, opacity, callback);
    }

    @Override
    public void animateUnlayoutAndWait(int duration, int opacity) {
        this.contentPane.animateUnlayoutAndWait(duration, opacity);
    }

    final void addComponentToForm(Object constraints, Component cmp) {
        super.addComponent(constraints, cmp);
    }

    void removeComponentFromForm(Component cmp) {
        super.removeComponent(cmp);
    }

    void registerMediaComponent(Component mediaCmp) {
        if (this.mediaComponents == null) {
            this.mediaComponents = new ArrayList();
        }
        if (!this.mediaComponents.contains(mediaCmp)) {
            this.mediaComponents.add(mediaCmp);
        }
    }

    public final boolean hasMedia() {
        return this.mediaComponents != null && this.mediaComponents.size() > 0;
    }

    void deregisterMediaComponent(Component mediaCmp) {
        this.mediaComponents.remove(mediaCmp);
    }

    public void registerAnimated(Animation cmp) {
        if (this.animatableComponents == null) {
            this.animatableComponents = new ArrayList();
        }
        if (!this.animatableComponents.contains(cmp)) {
            this.animatableComponents.add(cmp);
        }
        Display.getInstance().notifyDisplay();
    }

    void registerAnimatedInternal(Animation cmp) {
        if (this.internalAnimatableComponents == null) {
            this.internalAnimatableComponents = new ArrayList();
        }
        if (!this.internalAnimatableComponents.contains(cmp)) {
            this.internalAnimatableComponents.add(cmp);
        }
        Display.getInstance().notifyDisplay();
    }

    void deregisterAnimatedInternal(Animation cmp) {
        if (this.internalAnimatableComponents != null) {
            this.internalAnimatableComponents.remove(cmp);
        }
    }

    public void deregisterAnimated(Animation cmp) {
        if (this.animatableComponents != null) {
            this.animatableComponents.remove(cmp);
        }
    }

    @Override
    public boolean animate() {
        if (this.getParent() != null) {
            this.repaintAnimations();
        }
        return super.animate();
    }

    void repaintAnimations() {
        if (rippleComponent != null) {
            rippleComponent.repaint();
            if (rippleMotion == null) {
                rippleComponent = null;
            }
        }
        if (this.animatableComponents != null) {
            this.loopAnimations(this.animatableComponents, null);
        }
        if (this.internalAnimatableComponents != null) {
            this.loopAnimations(this.internalAnimatableComponents, this.animatableComponents);
        }
        if (this.animMananger != null) {
            this.animMananger.updateAnimations();
        }
    }

    @Override
    public int getSideGap() {
        if (this.getParent() == null) {
            return 0;
        }
        return super.getSideGap();
    }

    @Override
    protected void paintScrollbars(Graphics g) {
        if (this.getParent() != null) {
            super.paintScrollbars(g);
        }
    }

    private void loopAnimations(ArrayList<Animation> v, ArrayList<Animation> notIn) {
        for (int iter = 0; iter < v.size(); ++iter) {
            Animation c = v.get(iter);
            if (c == null || notIn != null && notIn.contains(c) || !c.animate()) continue;
            if (c instanceof Component) {
                Rectangle rect = ((Component)c).getDirtyRegion();
                if (rect != null) {
                    Dimension d = rect.getSize();
                    if (d == null) continue;
                    ((Component)c).repaint(rect.getX(), rect.getY(), d.getWidth(), d.getHeight());
                    continue;
                }
                ((Component)c).repaint();
                continue;
            }
            Display.getInstance().repaint(c);
        }
    }

    boolean hasAnimations() {
        return this.animatableComponents != null && this.animatableComponents.size() > 0 || this.internalAnimatableComponents != null && this.internalAnimatableComponents.size() > 0 || this.animMananger != null && this.animMananger.isAnimating();
    }

    @Override
    public void refreshTheme(boolean merge) {
        if (this.menuBar != null) {
            this.menuBar.refreshTheme(merge);
        }
        if (this.titleArea != null) {
            this.titleArea.refreshTheme(merge);
        }
        if (this.toolbar != null) {
            this.toolbar.refreshTheme(merge);
        }
        super.refreshTheme(merge);
        if (this.toolbar == null) {
            int iter;
            this.hideMenu();
            this.restoreMenu();
            Command[] cmds = new Command[this.getCommandCount()];
            for (iter = 0; iter < cmds.length; ++iter) {
                cmds[iter] = this.getCommand(iter);
            }
            this.removeAllCommands();
            for (iter = 0; iter < cmds.length; ++iter) {
                this.addCommand(cmds[iter], this.getCommandCount());
            }
            if (this.getBackCommand() != null) {
                this.setBackCommand(this.getBackCommand());
            }
        }
        this.revalidateWithAnimationSafety();
    }

    @Override
    public void paintBackground(Graphics g) {
        super.paintBackground(g);
    }

    public Transition getTransitionInAnimator() {
        return this.transitionInAnimator;
    }

    public void setTransitionInAnimator(Transition transitionInAnimator) {
        this.transitionInAnimator = transitionInAnimator;
    }

    public Transition getTransitionOutAnimator() {
        return this.transitionOutAnimator;
    }

    public void setTransitionOutAnimator(Transition transitionOutAnimator) {
        this.transitionOutAnimator = transitionOutAnimator;
    }

    public void addCommandListener(ActionListener l) {
        if (this.commandListener == null) {
            this.commandListener = new EventDispatcher();
        }
        this.commandListener.addListener(l);
    }

    public void removeCommandListener(ActionListener l) {
        this.commandListener.removeListener(l);
    }

    protected void actionCommand(Command cmd) {
    }

    public void dispatchCommand(Command cmd, ActionEvent ev) {
        cmd.actionPerformed(ev);
        if (!ev.isConsumed()) {
            this.actionCommandImpl(cmd, ev);
        }
    }

    void actionCommandImpl(Command cmd) {
        this.actionCommandImpl(cmd, new ActionEvent((Object)cmd, ActionEvent.Type.Command));
    }

    void actionCommandImpl(Command cmd, ActionEvent ev) {
        if (cmd == null) {
            return;
        }
        if (comboLock) {
            if (cmd == this.menuBar.getCancelMenuItem()) {
                this.actionCommand(cmd);
                return;
            }
            Component c = this.getFocused();
            if (c != null) {
                c.fireClicked();
            }
            return;
        }
        if (cmd != this.menuBar.getSelectCommand()) {
            if (this.commandListener != null) {
                this.commandListener.fireActionEvent(ev);
                if (ev.isConsumed()) {
                    return;
                }
            }
            this.actionCommand(cmd);
        } else {
            Component c = this.getFocused();
            if (c != null) {
                c.fireClicked();
            }
        }
    }

    void actionCommandImplNoRecurseComponent(Command cmd, ActionEvent ev) {
        if (cmd == null) {
            return;
        }
        if (comboLock) {
            if (cmd == this.menuBar.getCancelMenuItem()) {
                this.actionCommand(cmd);
                return;
            }
            return;
        }
        if (cmd != this.menuBar.getSelectCommand()) {
            if (this.commandListener != null) {
                this.commandListener.fireActionEvent(ev);
                if (ev.isConsumed()) {
                    return;
                }
            }
            this.actionCommand(cmd);
        }
    }

    void initFocused() {
        if (this.focused == null) {
            Component focusable;
            Component component = focusable = this.formLayeredPane != null ? this.formLayeredPane.findFirstFocusable() : null;
            if (focusable == null) {
                focusable = this.getActualPane().findFirstFocusable();
            }
            this.setFocused(focusable);
            if (!Display.getInstance().shouldRenderSelection()) {
                return;
            }
            this.layoutContainer();
        }
    }

    public void show() {
        Display.impl.onShow(this);
        this.show(false);
    }

    public void showBack() {
        this.show(true);
    }

    private void show(boolean reverse) {
        if (this.transitionOutAnimator == null && this.transitionInAnimator == null) {
            this.initLaf(this.getUIManager());
        }
        this.initFocused();
        this.onShow();
        this.tint = false;
        if (this.getParent() == null) {
            Display.getInstance().setCurrent(this, reverse);
        } else {
            this.revalidateWithAnimationSafety();
        }
    }

    @Override
    void deinitializeImpl() {
        Form f;
        if (!comboLock) {
            try {
                this.setCurrentInputDevice(null);
            }
            catch (Exception ex) {
                Log.e(ex);
            }
        }
        if (this.getParent() != null && (f = this.getParent().getComponentForm()) != null) {
            f.deregisterAnimated(this);
        }
        super.deinitializeImpl();
        this.animMananger.flush();
        this.componentsAwaitingRelease = null;
        this.dragged = null;
    }

    @Override
    void initComponentImpl() {
        Form f;
        super.initComponentImpl();
        this.dragged = null;
        if (Display.getInstance().isNativeCommands()) {
            Display.impl.setNativeCommands(this.menuBar.getCommands());
        }
        if (this.getParent() != null && (f = this.getParent().getComponentForm()) != null) {
            f.registerAnimated(this);
            if (this.pointerPressedListeners != null) {
                for (ActionListener l : this.pointerPressedListeners.getListenerCollection()) {
                    f.addPointerPressedListener(l);
                }
                this.pointerPressedListeners = null;
            }
            if (this.pointerDraggedListeners != null) {
                for (ActionListener l : this.pointerDraggedListeners.getListenerCollection()) {
                    f.addPointerDraggedListener(l);
                }
                this.pointerDraggedListeners = null;
            }
            if (this.pointerReleasedListeners != null) {
                for (ActionListener l : this.pointerReleasedListeners.getListenerCollection()) {
                    f.addPointerReleasedListener(l);
                }
                this.pointerReleasedListeners = null;
            }
            if (this.longPressListeners != null) {
                for (ActionListener l : this.longPressListeners.getListenerCollection()) {
                    f.addLongPressListener(l);
                }
                this.longPressListeners = null;
            }
        }
    }

    @Override
    public void setSmoothScrolling(boolean smoothScrolling) {
        if (this.contentPane != null) {
            this.contentPane.setSmoothScrolling(smoothScrolling);
        }
    }

    @Override
    public boolean isSmoothScrolling() {
        return this.contentPane.isSmoothScrolling();
    }

    @Override
    public int getScrollAnimationSpeed() {
        return this.contentPane.getScrollAnimationSpeed();
    }

    @Override
    public void setScrollAnimationSpeed(int animationSpeed) {
        this.contentPane.setScrollAnimationSpeed(animationSpeed);
    }

    protected void onShow() {
    }

    protected void onShowCompleted() {
    }

    void onShowCompletedImpl() {
        this.setLightweightMode(false);
        this.onShowCompleted();
        if (this.showListener != null) {
            this.showListener.fireActionEvent(new ActionEvent((Object)this, ActionEvent.Type.Show));
        }
        if (this.editOnShow != null) {
            this.editOnShow.startEditingAsync();
        }
    }

    void showModal(int top, int bottom, int left, int right, boolean includeTitle, boolean modal, boolean reverse) {
        Display.getInstance().flushEdt();
        if (this.previousForm == null) {
            Dialog previousDialog;
            this.previousForm = Display.getInstance().getCurrent();
            if (this.previousForm == null) {
                this.previousForm = new Form();
                this.previousForm.show();
            } else if (this.previousForm instanceof Dialog && (previousDialog = (Dialog)this.previousForm).isDisposed()) {
                this.previousForm = Display.getInstance().getCurrentUpcoming();
            }
        }
        this.previousForm.tint = true;
        Painter p = this.getStyle().getBgPainter();
        if (top > 0 || bottom > 0 || left > 0 || right > 0) {
            if (!this.title.isVisible()) {
                includeTitle = false;
            }
            Style titleStyle = this.title.getStyle();
            titleStyle.removeListeners();
            Style contentStyle = this.contentPane.getUnselectedStyle();
            contentStyle.removeListeners();
            if (includeTitle) {
                titleStyle.setMargin(0, top, false);
                titleStyle.setMargin(2, 0, false);
                titleStyle.setMargin(1, left, false);
                titleStyle.setMargin(3, right, false);
                contentStyle.setMargin(0, 0, false);
                contentStyle.setMargin(2, bottom, false);
                contentStyle.setMargin(1, left, false);
                contentStyle.setMargin(3, right, false);
            } else {
                titleStyle.setMargin(0, 0, false);
                titleStyle.setMargin(2, 0, false);
                titleStyle.setMargin(1, 0, false);
                titleStyle.setMargin(3, 0, false);
                contentStyle.setMargin(0, top, false);
                contentStyle.setMargin(2, bottom, false);
                contentStyle.setMargin(1, left, false);
                contentStyle.setMargin(3, right, false);
            }
            titleStyle.setMarginUnit(null);
            contentStyle.setMarginUnit(null);
            this.initDialogBgPainter(p, this.previousForm);
            this.revalidate();
        } else {
            this.initDialogBgPainter(p, this.previousForm);
        }
        this.initFocused();
        if (this.getTransitionOutAnimator() == null && this.getTransitionInAnimator() == null) {
            this.initLaf(this.getUIManager());
        }
        this.initComponentImpl();
        Display.getInstance().setCurrent(this, reverse);
        this.onShow();
        if (modal) {
            Display.getInstance().invokeAndBlock(new RunnableWrapper(this, p, reverse));
            Display.getInstance().setShowVirtualKeyboard(false);
        }
    }

    void initDialogBgPainter(Painter p, Form previousForm) {
        if (p instanceof Component.BGPainter && ((Component.BGPainter)p).getPreviousForm() != null) {
            ((Component.BGPainter)p).setPreviousForm(previousForm);
        } else {
            Component.BGPainter b = new Component.BGPainter((Component)this, this, p);
            this.getStyle().setBgPainter(b);
            b.setPreviousForm(previousForm);
        }
    }

    void showModal(boolean reverse) {
        this.showDialog(true, reverse);
    }

    void showDialog(boolean modal, boolean reverse) {
        int h = Display.getInstance().getDisplayHeight() - this.menuBar.getPreferredH() - this.title.getPreferredH();
        int w = Display.getInstance().getDisplayWidth();
        int topSpace = h / 100 * 20;
        int bottomSpace = h / 100 * 10;
        int sideSpace = w / 100 * 20;
        this.showModal(topSpace, bottomSpace, sideSpace, sideSpace, true, modal, reverse);
    }

    void dispose() {
        this.disposeImpl();
    }

    boolean isDisposed() {
        return false;
    }

    void disposeImpl() {
        if (this.previousForm != null) {
            boolean clearPrevious;
            boolean bl = clearPrevious = Display.getInstance().getCurrent() == this;
            if (!clearPrevious) {
                Form f = Display.getInstance().getCurrent();
                while (f != null) {
                    if (f.previousForm == this) {
                        f.previousForm = this.previousForm;
                        this.previousForm = null;
                        return;
                    }
                    f = f.previousForm;
                }
            }
            this.previousForm.tint = false;
            if (this.previousForm instanceof Dialog) {
                if (!((Dialog)this.previousForm).isDisposed()) {
                    Display.getInstance().setCurrent(this.previousForm, false);
                }
            } else {
                Display.getInstance().setCurrent(this.previousForm, false);
            }
            if (clearPrevious) {
                this.previousForm = null;
            }
        }
    }

    boolean isMenu() {
        return false;
    }

    @Override
    void repaint(Component cmp) {
        if (this.getParent() != null) {
            super.repaint(cmp);
            return;
        }
        if (this.isVisible() && CN.getCurrentForm() == this) {
            Display.getInstance().repaint(cmp);
        }
    }

    @Override
    public final Form getComponentForm() {
        if (this.getParent() != null) {
            return super.getComponentForm();
        }
        return this;
    }

    void hideMenu() {
        this.menuBar.unInstallMenuBar();
    }

    void restoreMenu() {
        this.menuBar.installMenuBar();
    }

    void setFocusedInternal(Component focused) {
        this.focused = focused;
    }

    public void setFocused(Component focused) {
        if (this.focused == focused && focused != null) {
            this.focused.repaint();
            return;
        }
        Component oldFocus = this.focused;
        this.focused = focused;
        boolean triggerRevalidate = false;
        if (oldFocus != null && !(triggerRevalidate = this.changeFocusState(oldFocus, false)) && oldFocus.getParent() != null) {
            oldFocus.repaint();
        }
        if (focused != null && this.focused == focused) {
            boolean bl = triggerRevalidate = this.changeFocusState(focused, true) || triggerRevalidate;
            if (!triggerRevalidate) {
                focused.repaint();
            }
        }
        if (triggerRevalidate) {
            this.revalidateLater();
        }
    }

    private boolean changeFocusState(Component cmp, boolean gained) {
        Dimension d;
        boolean trigger = false;
        Style selected = cmp.getSelectedStyle();
        Style unselected = cmp.getUnselectedStyle();
        if (!selected.getFont().equals(unselected.getFont()) || selected.getPaddingTop() != unselected.getPaddingTop() || selected.getPaddingBottom() != unselected.getPaddingBottom() || selected.getPaddingRight(this.isRTL()) != unselected.getPaddingRight(this.isRTL()) || selected.getPaddingLeft(this.isRTL()) != unselected.getPaddingLeft(this.isRTL()) || selected.getMarginTop() != unselected.getMarginTop() || selected.getMarginBottom() != unselected.getMarginBottom() || selected.getMarginRight(this.isRTL()) != unselected.getMarginRight(this.isRTL()) || selected.getMarginLeft(this.isRTL()) != unselected.getMarginLeft(this.isRTL())) {
            trigger = true;
        }
        int prefW = 0;
        int prefH = 0;
        if (trigger) {
            d = cmp.getPreferredSize();
            prefW = d.getWidth();
            prefH = d.getHeight();
        }
        if (gained) {
            cmp.setFocus(true);
            cmp.fireFocusGained();
            this.fireFocusGained(cmp);
        } else {
            cmp.setFocus(false);
            cmp.fireFocusLost();
            this.fireFocusLost(cmp);
        }
        if (trigger) {
            cmp.setShouldCalcPreferredSize(true);
            d = cmp.getPreferredSize();
            if (prefW != d.getWidth() || prefH != d.getHeight()) {
                cmp.setShouldCalcPreferredSize(false);
                trigger = false;
            }
        }
        return trigger;
    }

    public Component getFocused() {
        return this.focused;
    }

    @Override
    protected void longKeyPress(int keyCode) {
        if (this.focused != null && this.focused.getComponentForm() == this) {
            this.focused.longKeyPress(keyCode);
        }
    }

    @Override
    public void longPointerPress(int x, int y) {
        if (this.longPressListeners != null && this.longPressListeners.hasListeners()) {
            ActionEvent ev = new ActionEvent((Object)this, ActionEvent.Type.LongPointerPress, x, y);
            this.longPressListeners.fireActionEvent(ev);
            if (ev.isConsumed()) {
                return;
            }
        }
        if (this.focused != null && this.focused.contains(x, y) && this.focused.getComponentForm() == this) {
            LeadUtil.longPointerPress(this.focused, x, y);
        }
    }

    protected boolean shouldSendPointerReleaseToOtherForm() {
        return false;
    }

    public Component getNextComponent(Component current) {
        return this.getTabIterator(current).getNext();
    }

    public Component getPreviousComponent(Component current) {
        return this.getTabIterator(current).getPrevious();
    }

    public TabIterator getTabIterator(Component start) {
        this.updateTabIndices(0);
        ArrayList<Component> out = new ArrayList<Component>();
        out.addAll(ComponentSelector.select("*", this).filter(new ComponentSelector.Filter(){

            public boolean filter(Component c) {
                return c.getTabIndex() >= 0 && c.isVisible() && c.isFocusable() && c.isEnabled();
            }
        }));
        Collections.sort(out, new Comparator<Component>(){

            @Override
            public int compare(Component o1, Component o2) {
                return o1.getTabIndex() < o2.getTabIndex() ? -1 : (o2.getTabIndex() < o1.getTabIndex() ? 1 : 0);
            }
        });
        return new TabIterator(out, start);
    }

    @Override
    public void keyPressed(int keyCode) {
        int game = Display.getInstance().getGameAction(keyCode);
        if (this.menuBar.handlesKeycode(keyCode)) {
            this.menuBar.keyPressed(keyCode);
            return;
        }
        if (this.focused != null) {
            if (this.focused.isEnabled()) {
                this.focused.keyPressed(keyCode);
            }
            if (this.focused == null) {
                this.initFocused();
                return;
            }
            if (this.focused.handlesInput()) {
                return;
            }
            if (this.focused.getComponentForm() == this) {
                this.updateFocus(game);
            } else {
                this.initFocused();
            }
        } else {
            this.initFocused();
            if (this.focused == null) {
                this.getContentPane().moveScrollTowards(game, null);
                return;
            }
        }
    }

    @Override
    public Layout getLayout() {
        return this.contentPane.getLayout();
    }

    public boolean isMinimizeOnBack() {
        return this.menuBar.isMinimizeOnBack();
    }

    public void setMinimizeOnBack(boolean minimizeOnBack) {
        this.menuBar.setMinimizeOnBack(minimizeOnBack);
    }

    @Override
    public void keyReleased(int keyCode) {
        Command defaultCmd;
        int game = Display.getInstance().getGameAction(keyCode);
        if (this.menuBar.handlesKeycode(keyCode)) {
            this.menuBar.keyReleased(keyCode);
            return;
        }
        if (this.focused != null && this.focused.getComponentForm() == this && this.focused.isEnabled()) {
            this.focused.keyReleased(keyCode);
        }
        if (game == 8 && (defaultCmd = this.getDefaultCommand()) != null) {
            defaultCmd.actionPerformed(new ActionEvent((Object)defaultCmd, keyCode));
            this.actionCommandImpl(defaultCmd);
        }
        this.fireKeyEvent(this.keyListeners, keyCode);
        this.fireKeyEvent(this.gameKeyListeners, game);
    }

    private void fireKeyEvent(HashMap<Integer, ArrayList<ActionListener>> keyListeners, int keyCode) {
        ArrayList<ActionListener> listeners;
        if (keyListeners != null && (listeners = keyListeners.get(new Integer(keyCode))) != null) {
            ActionEvent evt = new ActionEvent((Object)this, keyCode);
            for (int iter = 0; iter < listeners.size(); ++iter) {
                listeners.get(iter).actionPerformed(evt);
                if (!evt.isConsumed()) continue;
                return;
            }
        }
    }

    @Override
    public void keyRepeated(int keyCode) {
        if (this.focused != null) {
            if (this.focused.isEnabled()) {
                this.focused.keyRepeated(keyCode);
            }
            int game = Display.getInstance().getGameAction(keyCode);
            if (!(this.focused == null || this.focused.handlesInput() || game != 6 && game != 1 && game != 2 && game != 5)) {
                this.keyPressed(keyCode);
                this.keyReleased(keyCode);
            }
        } else {
            this.keyPressed(keyCode);
            this.keyReleased(keyCode);
        }
    }

    private void initRippleEffect(int x, int y, Component cmp) {
        if (cmp.isRippleEffect()) {
            rippleMotion = Motion.createEaseInMotion(0, 1000, 800);
            rippleMotion.start();
            rippleComponent = cmp;
            rippleX = x;
            rippleY = y;
        }
    }

    private void tactileTouchVibe(int x, int y, Component cmp) {
        if (this.tactileTouchDuration > 0 && cmp.isTactileTouch(x, y)) {
            Display.getInstance().vibrate(this.tactileTouchDuration);
        }
    }

    private void cancelScrolling(Component cmp) {
        for (Container parent = cmp.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.draggedMotionX == null && parent.draggedMotionY == null) continue;
            parent.draggedMotionX = null;
            parent.draggedMotionY = null;
        }
    }

    protected boolean resumeDragAfterScrolling(int x, int y) {
        Component cmp;
        for (cmp = this.getComponentAt(x, y); cmp != null && cmp.isIgnorePointerEvents(); cmp = cmp.getParent()) {
        }
        if (cmp != null && this.isCurrentlyScrolling(cmp = LeadUtil.leadParentImpl(cmp))) {
            this.cancelScrolling(cmp);
            cmp.initDragAndDrop(x, y);
            Display.getInstance().pointerDragged(new int[]{x}, new int[]{y});
            return true;
        }
        return false;
    }

    private void setPressedCmp(Component cmp) {
        this.pressedCmp = cmp = LeadUtil.leadParentImpl(cmp);
        if (cmp == null) {
            this.pressedCmpAbsBounds.setBounds(0, 0, 0, 0);
        } else {
            this.pressedCmpAbsBounds.setBounds(cmp.getAbsoluteX(), cmp.getAbsoluteY(), cmp.getWidth(), cmp.getHeight());
        }
    }

    Object getCurrentPointerPress() {
        return this.currentPointerPress;
    }

    @Override
    public void pointerPressed(int x, int y) {
        Container actual;
        this.currentPointerPress = new Object();
        if (this.resumeDragAfterScrolling(x, y)) {
            return;
        }
        this.setPressedCmp(null);
        this.stickyDrag = null;
        this.dragStopFlag = false;
        this.dragged = null;
        boolean isScrollWheeling = Display.impl.isScrollWheeling();
        if (this.pointerPressedListeners != null && this.pointerPressedListeners.hasListeners()) {
            ActionEvent e = new ActionEvent((Object)this, ActionEvent.Type.PointerPressed, x, y);
            this.pointerPressedListeners.fireActionEvent(e);
            if (e.isConsumed()) {
                return;
            }
        }
        if (y >= (actual = this.getActualPane(this.formLayeredPane, x, y)).getY() && x >= actual.getX()) {
            Component cmp;
            for (cmp = actual.getComponentAt(x, y); cmp != null && cmp.isIgnorePointerEvents(); cmp = cmp.getParent()) {
            }
            if (cmp != null) {
                cmp = LeadUtil.leadParentImpl(cmp);
                cmp.initDragAndDrop(x, y);
                if (!cmp.isDragAndDropInitialized()) {
                    Container draggableCnt;
                    for (draggableCnt = cmp.getParent(); draggableCnt != null && !draggableCnt.isDraggable(); draggableCnt = draggableCnt.getParent()) {
                    }
                    if (draggableCnt != null && draggableCnt.isDraggable() && !(draggableCnt instanceof Form)) {
                        draggableCnt.initDragAndDrop(x, y);
                    }
                }
                if (this.isCurrentlyScrolling(cmp)) {
                    this.dragStopFlag = true;
                    cmp.clearDrag();
                    return;
                }
                if (cmp.isEnabled()) {
                    if (!isScrollWheeling && cmp.isFocusable()) {
                        this.setFocused(cmp);
                    }
                    this.setPressedCmp(cmp);
                    LeadUtil.pointerPressed(cmp, x, y);
                    this.tactileTouchVibe(x, y, cmp);
                    this.initRippleEffect(x, y, cmp);
                }
            }
        } else if (y < actual.getY()) {
            Component cmp;
            for (cmp = this.getTitleArea().getComponentAt(x, y); cmp != null && cmp.isIgnorePointerEvents(); cmp = cmp.getParent()) {
            }
            if (cmp != null) {
                cmp = LeadUtil.leadParentImpl(cmp);
                this.setPressedCmp(cmp);
                LeadUtil.pointerPressed(cmp, x, y);
                this.tactileTouchVibe(x, y, cmp);
                this.initRippleEffect(x, y, cmp);
            }
        } else {
            Component cmp = ((BorderLayout)super.getLayout()).getWest();
            if (cmp != null) {
                for (cmp = ((Container)cmp).getComponentAt(x, y); cmp != null && cmp.isIgnorePointerEvents(); cmp = cmp.getParent()) {
                }
                if (cmp != null) {
                    cmp = LeadUtil.leadParentImpl(cmp);
                    cmp.initDragAndDrop(x, y);
                    this.setPressedCmp(cmp);
                    LeadUtil.pointerPressed(cmp, x, y);
                    this.tactileTouchVibe(x, y, cmp);
                    this.initRippleEffect(x, y, cmp);
                }
            }
        }
        this.initialPressX = x;
        this.initialPressY = y;
    }

    private boolean isCurrentlyScrolling(Component cmp) {
        for (Container parent = cmp.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.draggedMotionX == null && parent.draggedMotionY == null) continue;
            return true;
        }
        return false;
    }

    public <C extends Component> void addComponentAwaitingRelease(C c) {
        if (this.componentsAwaitingRelease == null) {
            this.componentsAwaitingRelease = new ArrayList();
        }
        this.componentsAwaitingRelease.add(c);
    }

    public <C extends Component> void removeComponentAwaitingRelease(C c) {
        if (this.componentsAwaitingRelease != null) {
            this.componentsAwaitingRelease.remove(c);
        }
    }

    public void clearComponentsAwaitingRelease() {
        if (this.componentsAwaitingRelease != null) {
            this.componentsAwaitingRelease.clear();
        }
    }

    private void autoRelease(int x, int y) {
        if (this.componentsAwaitingRelease != null && this.componentsAwaitingRelease.size() == 1) {
            Component pendingC;
            Component atXY = this.getComponentAt(x, y);
            if (atXY != null) {
                atXY = LeadUtil.leadParentImpl(atXY);
            }
            if ((pendingC = this.componentsAwaitingRelease.get(0)) != null) {
                pendingC = LeadUtil.leadParentImpl(pendingC);
            }
            Component pendingCLead = LeadUtil.leadComponentImpl(pendingC);
            if (atXY != pendingC) {
                if (pendingCLead instanceof ReleasableComponent) {
                    ReleasableComponent rc = (ReleasableComponent)((Object)pendingCLead);
                    int relRadius = rc.getReleaseRadius();
                    if (relRadius > 0) {
                        Rectangle r = new Rectangle(pendingC.getAbsoluteX() - relRadius, pendingC.getAbsoluteY() - relRadius, pendingC.getWidth() + relRadius * 2, pendingC.getHeight() + relRadius * 2);
                        if (!r.contains(x, y)) {
                            this.componentsAwaitingRelease = null;
                            LeadUtil.dragInitiated(pendingC);
                        }
                        return;
                    }
                    this.componentsAwaitingRelease = null;
                    LeadUtil.dragInitiated(pendingC);
                }
            } else if (pendingCLead instanceof ReleasableComponent && ((ReleasableComponent)((Object)pendingCLead)).isAutoRelease()) {
                this.componentsAwaitingRelease = null;
                LeadUtil.dragInitiated(pendingC);
            }
        }
    }

    @Override
    public void pointerDragged(int x, int y) {
        Component cmp;
        boolean isScrollWheeling = Display.impl.isScrollWheeling();
        if (this.dragStopFlag) {
            this.pointerPressed(x, y);
        }
        this.autoRelease(x, y);
        if (this.pointerDraggedListeners != null) {
            ActionEvent av = new ActionEvent((Object)this, ActionEvent.Type.PointerDrag, x, y);
            this.pointerDraggedListeners.fireActionEvent(av);
            if (av.isConsumed()) {
                return;
            }
        }
        rippleMotion = null;
        if (this.dragged != null) {
            LeadUtil.pointerDragged(this.dragged, x, y);
            return;
        }
        if (this.pressedCmp != null && this.pressedCmp.isStickyDrag()) {
            this.stickyDrag = this.pressedCmp;
        }
        if (this.stickyDrag != null) {
            LeadUtil.pointerDragged(this.stickyDrag, x, y);
            this.repaint();
            return;
        }
        Container actual = this.getActualPane(this.formLayeredPane, x, y);
        if (x < actual.getX()) {
            Component cmp2 = ((BorderLayout)super.getLayout()).getWest();
            if (cmp2 != null) {
                for (cmp2 = ((Container)cmp2).getComponentAt(x, y); cmp2 != null && cmp2.isIgnorePointerEvents(); cmp2 = cmp2.getParent()) {
                }
                if (cmp2 != null && cmp2.isEnabled()) {
                    cmp2.pointerDragged(x, y);
                    cmp2.repaint();
                    if (cmp2 == this.pressedCmp && cmp2.isStickyDrag()) {
                        this.stickyDrag = cmp2;
                    }
                }
            }
            return;
        }
        for (cmp = actual.getComponentAt(x, y); cmp != null && cmp.isIgnorePointerEvents(); cmp = cmp.getParent()) {
        }
        if (cmp != null) {
            if (!isScrollWheeling && cmp.isFocusable() && cmp.isEnabled()) {
                this.setFocused(cmp);
            }
            cmp = LeadUtil.leadParentImpl(cmp);
            LeadUtil.pointerDragged(cmp, x, y);
            if (cmp == this.pressedCmp && cmp.isStickyDrag()) {
                this.stickyDrag = cmp;
            }
        }
    }

    @Override
    public void pointerDragged(int[] x, int[] y) {
        Component cmp;
        boolean isScrollWheeling = Display.impl.isScrollWheeling();
        if (this.dragStopFlag) {
            this.pointerPressed(x, y);
        }
        this.autoRelease(x[0], y[0]);
        if (this.pointerDraggedListeners != null && this.pointerDraggedListeners.hasListeners()) {
            ActionEvent av = new ActionEvent((Object)this, ActionEvent.Type.PointerDrag, x[0], y[0]);
            this.pointerDraggedListeners.fireActionEvent(av);
            if (av.isConsumed()) {
                return;
            }
        }
        rippleMotion = null;
        if (this.dragged != null) {
            LeadUtil.pointerDragged(this.dragged, x, y);
            return;
        }
        if (this.pressedCmp != null && this.pressedCmp.isStickyDrag()) {
            this.stickyDrag = this.pressedCmp;
        }
        if (this.stickyDrag != null) {
            LeadUtil.pointerDragged(this.stickyDrag, x, y);
            this.repaint();
            return;
        }
        Container actual = this.getActualPane(this.formLayeredPane, x[0], y[0]);
        if (x[0] < actual.getX()) {
            Component cmp2 = ((BorderLayout)super.getLayout()).getWest();
            if (cmp2 != null) {
                for (cmp2 = ((Container)cmp2).getComponentAt(x[0], y[0]); cmp2 != null && cmp2.isIgnorePointerEvents(); cmp2 = cmp2.getParent()) {
                }
                if (cmp2 != null && cmp2.isEnabled()) {
                    cmp2.pointerDragged(x, y);
                    cmp2.repaint();
                    if (cmp2 == this.pressedCmp && cmp2.isStickyDrag()) {
                        this.stickyDrag = cmp2;
                    }
                }
            }
            return;
        }
        for (cmp = actual.getComponentAt(x[0], y[0]); cmp != null && cmp.isIgnorePointerEvents(); cmp = cmp.getParent()) {
        }
        if (cmp != null) {
            cmp = LeadUtil.leadParentImpl(cmp);
            if (!isScrollWheeling && cmp.isFocusable() && cmp.isEnabled()) {
                this.setFocused(cmp);
            }
            LeadUtil.pointerDragged(cmp, x, y);
            if (cmp == this.pressedCmp && cmp.isStickyDrag()) {
                this.stickyDrag = cmp;
            }
        }
    }

    @Override
    public void pointerHoverReleased(int[] x, int[] y) {
        Component cmp;
        if (this.dragged != null) {
            LeadUtil.pointerHoverReleased(this.dragged, x, y);
            this.dragged = null;
            return;
        }
        Container actual = this.getActualPane(this.formLayeredPane, x[0], y[0]);
        for (cmp = actual.getComponentAt(x[0], y[0]); cmp != null && cmp.isIgnorePointerEvents(); cmp = cmp.getParent()) {
        }
        if (cmp != null) {
            cmp = LeadUtil.leadParentImpl(cmp);
            LeadUtil.pointerHoverReleased(cmp, x, y);
        }
    }

    @Override
    public void pointerHoverPressed(int[] x, int[] y) {
        Component cmp;
        boolean isScrollWheeling = Display.impl.isScrollWheeling();
        Container actual = this.getActualPane(this.formLayeredPane, x[0], y[0]);
        for (cmp = actual.getComponentAt(x[0], y[0]); cmp != null && cmp.isIgnorePointerEvents(); cmp = cmp.getParent()) {
        }
        if (cmp != null) {
            cmp = LeadUtil.leadParentImpl(cmp);
            if (!isScrollWheeling && cmp.isFocusable() && cmp.isEnabled() && !Display.getInstance().isDesktop()) {
                this.setFocused(cmp);
            }
            LeadUtil.pointerHoverPressed(cmp, x, y);
        }
    }

    @Override
    public void pointerHover(int[] x, int[] y) {
        boolean isScrollWheeling = Display.impl.isScrollWheeling();
        if (this.dragged != null) {
            LeadUtil.pointerHover(this.dragged, x, y);
            return;
        }
        Container actual = this.getActualPane(this.formLayeredPane, x[0], y[0]);
        if (actual != null) {
            Component cmp;
            for (cmp = actual.getComponentAt(x[0], y[0]); cmp != null && cmp.isIgnorePointerEvents(); cmp = cmp.getParent()) {
            }
            if (cmp != null) {
                cmp = LeadUtil.leadParentImpl(cmp);
                if (!isScrollWheeling && cmp.isFocusable() && cmp.isEnabled() && !Display.getInstance().isDesktop()) {
                    this.setFocused(cmp);
                }
                LeadUtil.pointerHover(cmp, x, y);
            }
            if (TooltipManager.getInstance() != null) {
                String tip = cmp.getTooltip();
                if (tip != null && tip.length() > 0) {
                    TooltipManager.getInstance().prepareTooltip(tip, cmp);
                } else {
                    TooltipManager.getInstance().clearTooltip();
                }
            }
        }
    }

    public boolean isSingleFocusMode() {
        if (this.formLayeredPane != null) {
            return this.countFocusables(this.formLayeredPane) + this.countFocusables(this.getActualPane()) < 2;
        }
        return this.isSingleFocusMode(0, this.getActualPane()) == 1;
    }

    private int countFocusables(Container c) {
        int count = 0;
        int t = c.getComponentCount();
        for (int iter = 0; iter < t; ++iter) {
            Component cmp = c.getComponentAt(iter);
            if (cmp.isFocusable()) {
                ++count;
            }
            if (!(cmp instanceof Container)) continue;
            count += this.countFocusables((Container)cmp);
        }
        return count;
    }

    private int isSingleFocusMode(int b, Container c) {
        int t = c.getComponentCount();
        for (int iter = 0; iter < t; ++iter) {
            Component cmp = c.getComponentAt(iter);
            if (cmp.isFocusable()) {
                if (b > 0) {
                    return 2;
                }
                b = 1;
            }
            if (!(cmp instanceof Container) || (b = this.isSingleFocusMode(b, (Container)cmp)) <= 1) continue;
            return b;
        }
        return b;
    }

    private boolean fireReleaseListeners(int x, int y) {
        if (this.pointerReleasedListeners != null && this.pointerReleasedListeners.hasListeners()) {
            ActionEvent ev = new ActionEvent((Object)this, ActionEvent.Type.PointerReleased, x, y);
            this.pointerReleasedListeners.fireActionEvent(ev);
            if (ev.isConsumed()) {
                if (this.dragged != null) {
                    if (this.dragged.isDragAndDropInitialized()) {
                        LeadUtil.dragFinished(this.dragged, x, y);
                    }
                    this.dragged = null;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pointerReleased(int x, int y) {
        try {
            ReleasableComponent rc;
            Component origPressedCmp = this.pressedCmp;
            boolean inOrigPressedCmpBounds = this.pressedCmpAbsBounds.contains(x, y);
            rippleMotion = null;
            this.setPressedCmp(null);
            boolean isScrollWheeling = Display.impl.isScrollWheeling();
            Container actual = this.getActualPane(this.formLayeredPane, x, y);
            if (this.componentsAwaitingRelease != null && this.componentsAwaitingRelease.size() == 1) {
                Rectangle r;
                int relRadius;
                Component pendingC;
                Component atXY = actual.getComponentAt(x, y);
                if (atXY != null) {
                    atXY = LeadUtil.leadParentImpl(atXY);
                }
                if ((pendingC = this.componentsAwaitingRelease.get(0)) != null) {
                    pendingC = LeadUtil.leadParentImpl(pendingC);
                }
                if (atXY == pendingC) {
                    this.componentsAwaitingRelease = null;
                    if (this.dragged == pendingC) {
                        if (pendingC.isDragAndDropInitialized()) {
                            LeadUtil.dragFinished(pendingC, x, y);
                        } else {
                            LeadUtil.pointerReleased(pendingC, x, y);
                        }
                        this.dragged = null;
                    } else {
                        LeadUtil.pointerReleased(pendingC, x, y);
                        if (this.dragged != null) {
                            if (this.dragged.isDragAndDropInitialized()) {
                                LeadUtil.dragFinished(this.dragged, x, y);
                                this.dragged = null;
                            } else {
                                LeadUtil.pointerReleased(this.dragged, x, y);
                                this.dragged = null;
                            }
                        }
                    }
                    this.fireReleaseListeners(x, y);
                    return;
                }
                if (LeadUtil.leadComponentImpl(pendingC) instanceof ReleasableComponent && ((relRadius = (rc = (ReleasableComponent)((Object)LeadUtil.leadComponentImpl(pendingC))).getReleaseRadius()) > 0 || pendingC.contains(x, y)) && (r = new Rectangle(pendingC.getAbsoluteX() - relRadius, pendingC.getAbsoluteY() - relRadius, pendingC.getWidth() + relRadius * 2, pendingC.getHeight() + relRadius * 2)).contains(x, y)) {
                    this.componentsAwaitingRelease = null;
                    if (!pendingC.contains(x, y)) {
                        this.pointerReleased(pendingC.getAbsoluteX() + 1, pendingC.getAbsoluteY() + 1);
                        return;
                    }
                }
            }
            if (this.fireReleaseListeners(x, y)) {
                return;
            }
            if (this.dragStopFlag) {
                if (this.dragged != null) {
                    if (this.dragged.isDragAndDropInitialized()) {
                        LeadUtil.dragFinished(this.dragged, x, y);
                    }
                    this.dragged = null;
                }
                this.dragStopFlag = false;
                return;
            }
            if (this.dragged == null) {
                Component cmp;
                if (origPressedCmp != null) {
                    if (origPressedCmp.isEnabled()) {
                        LeadUtil.pointerReleased(origPressedCmp, x, y);
                    }
                    return;
                }
                if (this.menuBar.contains(x, y)) {
                    for (cmp = this.menuBar.getComponentAt(x, y); cmp != null && cmp.isIgnorePointerEvents(); cmp = cmp.getParent()) {
                    }
                    if ((cmp = LeadUtil.leadParentImpl(cmp)).isEnabled()) {
                        if (!isScrollWheeling && cmp.isFocusable()) {
                            this.setFocused(cmp);
                        }
                        LeadUtil.pointerReleased(cmp, x, y);
                    }
                    return;
                }
                if (this.stickyDrag != null) {
                    if (this.stickyDrag.isDragAndDropInitialized()) {
                        LeadUtil.dragFinished(this.stickyDrag, x, y);
                    } else {
                        LeadUtil.pointerReleased(this.stickyDrag, x, y);
                    }
                    this.repaint();
                } else if (y >= actual.getY() && x >= actual.getX()) {
                    for (cmp = actual.getComponentAt(x, y); cmp != null && cmp.isIgnorePointerEvents(); cmp = cmp.getParent()) {
                    }
                    if (cmp != null && cmp.isEnabled() && (cmp = LeadUtil.leadParentImpl(cmp)).isEnabled()) {
                        if (!isScrollWheeling && cmp.isFocusable()) {
                            this.setFocused(cmp);
                        }
                        LeadUtil.pointerReleased(cmp, x, y);
                    }
                } else if (y < actual.getY()) {
                    for (cmp = this.getTitleArea().getComponentAt(x, y); cmp != null && cmp.isIgnorePointerEvents(); cmp = cmp.getParent()) {
                    }
                    if (cmp != null) {
                        if ((cmp = LeadUtil.leadParentImpl(cmp)).isEnabled() && !isScrollWheeling && cmp.isFocusable()) {
                            this.setFocused(cmp);
                        }
                        LeadUtil.pointerReleased(cmp, x, y);
                    }
                } else {
                    cmp = ((BorderLayout)super.getLayout()).getWest();
                    if (cmp != null) {
                        for (cmp = ((Container)cmp).getComponentAt(x, y); cmp != null && cmp.isIgnorePointerEvents(); cmp = cmp.getParent()) {
                        }
                        if (cmp != null) {
                            cmp = LeadUtil.leadParentImpl(cmp);
                            if (!isScrollWheeling && cmp.isEnabled() && cmp.isFocusable()) {
                                this.setFocused(cmp);
                            }
                            LeadUtil.pointerReleased(cmp, x, y);
                        }
                    }
                }
            } else if (this.dragged.isDragAndDropInitialized()) {
                LeadUtil.dragFinished(this.dragged, x, y);
                this.dragged = null;
            } else {
                LeadUtil.pointerReleased(this.dragged, x, y);
                this.dragged = null;
            }
            this.stickyDrag = null;
            if (this.componentsAwaitingRelease != null && !Display.getInstance().isRecursivePointerRelease()) {
                for (int iter = 0; iter < this.componentsAwaitingRelease.size(); ++iter) {
                    Component c = this.componentsAwaitingRelease.get(iter);
                    if (!(LeadUtil.leadComponentImpl(c) instanceof ReleasableComponent)) continue;
                    rc = (ReleasableComponent)((Object)LeadUtil.leadComponentImpl(c));
                    rc.setReleased();
                }
                this.componentsAwaitingRelease = null;
            }
        }
        finally {
            this.currentPointerPress = null;
        }
    }

    @Override
    public void setScrollableY(boolean scrollableY) {
        this.getContentPane().setScrollableY(scrollableY);
    }

    @Override
    public void setScrollableX(boolean scrollableX) {
        this.getContentPane().setScrollableX(scrollableX);
    }

    @Override
    public void setScrollVisible(boolean isScrollVisible) {
        this.getContentPane().setScrollVisible(isScrollVisible);
    }

    @Override
    public boolean isScrollVisible() {
        return this.getContentPane().isScrollVisible();
    }

    @Override
    public int getComponentIndex(Component cmp) {
        return this.getContentPane().getComponentIndex(cmp);
    }

    public void addCommand(Command cmd, int offset) {
        this.menuBar.addCommand(cmd, offset);
    }

    public int getCommandCount() {
        return this.menuBar.getCommandCount();
    }

    public Command getCommand(int index) {
        return this.menuBar.getCommand(index);
    }

    public void addCommand(Command cmd) {
        this.addCommand(cmd, 0);
    }

    public void removeCommand(Command cmd) {
        this.menuBar.removeCommand(cmd);
    }

    public void setCyclicFocus(boolean cyclicFocus) {
        this.cyclicFocus = cyclicFocus;
    }

    private Component findNextFocusHorizontal(Component focused, Component bestCandidate, Container root, boolean right) {
        int count = root.getComponentCount();
        for (int iter = 0; iter < count; ++iter) {
            Component current = root.getComponentAt(iter);
            if (current.isFocusable() && this.isInSameRow(focused, current)) {
                int currentX = current.getAbsoluteX();
                int focusedX = focused.getAbsoluteX();
                if (right) {
                    if (focusedX < currentX) {
                        if (bestCandidate != null && bestCandidate.getAbsoluteX() < currentX) continue;
                        bestCandidate = current;
                    }
                } else if (focusedX > currentX) {
                    if (bestCandidate != null && bestCandidate.getAbsoluteX() > currentX) continue;
                    bestCandidate = current;
                }
            }
            if (!(current instanceof Container) || ((Container)current).isBlockFocus()) continue;
            bestCandidate = this.findNextFocusHorizontal(focused, bestCandidate, (Container)current, right);
        }
        return bestCandidate;
    }

    private Component findNextFocusVertical(Component focused, Component bestCandidate, Container root, boolean down) {
        int count = root.getComponentCount();
        for (int iter = 0; iter < count; ++iter) {
            Component current = root.getComponentAt(iter);
            if (current.isFocusable()) {
                boolean exitingInSame;
                int currentY = current.getAbsoluteY();
                int focusedY = 0;
                if (focused != null) {
                    focusedY = focused.getAbsoluteY();
                }
                if (down) {
                    if (focusedY < currentY) {
                        if (bestCandidate != null) {
                            exitingInSame = this.isInSameColumn(focused, bestCandidate);
                            if (bestCandidate.getAbsoluteY() < currentY && (exitingInSame || this.isInSameRow(current, bestCandidate) && !this.isInSameColumn(focused, current)) || exitingInSame && this.isInSameRow(current, bestCandidate)) continue;
                        }
                        bestCandidate = current;
                    }
                } else if (focusedY > currentY) {
                    if (bestCandidate != null) {
                        exitingInSame = this.isInSameColumn(focused, bestCandidate);
                        if (bestCandidate.getAbsoluteY() > currentY && (exitingInSame || this.isInSameRow(current, bestCandidate) && !this.isInSameColumn(focused, current)) || exitingInSame && this.isInSameRow(current, bestCandidate)) continue;
                    }
                    bestCandidate = current;
                }
            }
            if (!(current instanceof Container) || ((Container)current).isBlockFocus()) continue;
            bestCandidate = this.findNextFocusVertical(focused, bestCandidate, (Container)current, down);
        }
        return bestCandidate;
    }

    public Component findNextFocusVertical(boolean down) {
        Component c = null;
        if (this.formLayeredPane != null && (c = this.findNextFocusVertical(this.focused, null, this.formLayeredPane, down)) != null) {
            return c;
        }
        Container actual = this.getActualPane();
        c = this.findNextFocusVertical(this.focused, null, actual, down);
        if (c != null) {
            return c;
        }
        if (this.cyclicFocus && (c = this.findNextFocusVertical(this.focused, null, actual, !down)) != null) {
            Component current = this.findNextFocusVertical(c, null, actual, !down);
            while (current != null) {
                c = current;
                current = this.findNextFocusVertical(c, null, actual, !down);
            }
            return c;
        }
        return null;
    }

    public Component findNextFocusHorizontal(boolean right) {
        Component c = null;
        if (this.formLayeredPane != null && (c = this.findNextFocusHorizontal(this.focused, null, this.formLayeredPane, right)) != null) {
            return c;
        }
        Container actual = this.getActualPane();
        c = this.findNextFocusHorizontal(this.focused, null, actual, right);
        if (c != null) {
            return c;
        }
        if (this.cyclicFocus && (c = this.findNextFocusHorizontal(this.focused, null, actual, !right)) != null) {
            Component current = this.findNextFocusHorizontal(c, null, actual, !right);
            while (current != null) {
                c = current;
                current = this.findNextFocusHorizontal(c, null, actual, !right);
            }
            return c;
        }
        return null;
    }

    Component findNextFocusDown() {
        if (this.focused != null) {
            if (this.focused.getNextFocusDown() != null) {
                return this.focused.getNextFocusDown();
            }
            return this.findNextFocusVertical(true);
        }
        return null;
    }

    Component findNextFocusUp() {
        if (this.focused != null) {
            if (this.focused.getNextFocusUp() != null) {
                return this.focused.getNextFocusUp();
            }
            return this.findNextFocusVertical(false);
        }
        return null;
    }

    Component findNextFocusRight() {
        if (this.focused != null) {
            if (this.focused.getNextFocusRight() != null) {
                return this.focused.getNextFocusRight();
            }
            return this.findNextFocusHorizontal(true);
        }
        return null;
    }

    Component findNextFocusLeft() {
        if (this.focused != null) {
            if (this.focused.getNextFocusLeft() != null) {
                return this.focused.getNextFocusLeft();
            }
            return this.findNextFocusHorizontal(false);
        }
        return null;
    }

    public boolean isCyclicFocus() {
        return this.cyclicFocus;
    }

    private void updateFocus(int gameAction) {
        Component focused = this.getFocused();
        switch (gameAction) {
            case 6: {
                Component down = this.findNextFocusDown();
                if (down == null) break;
                focused = down;
                break;
            }
            case 1: {
                Component up = this.findNextFocusUp();
                if (up == null) break;
                focused = up;
                break;
            }
            case 5: {
                Component right = this.findNextFocusRight();
                if (right == null) break;
                focused = right;
                break;
            }
            case 2: {
                Component left = this.findNextFocusLeft();
                if (left == null) break;
                focused = left;
                break;
            }
            default: {
                return;
            }
        }
        if (this.isFocusScrolling()) {
            this.setFocused(focused);
            if (focused != null) {
                this.scrollComponentToVisible(focused);
            }
        } else if (this.moveScrollTowards(gameAction, focused)) {
            this.setFocused(focused);
            this.scrollComponentToVisible(focused);
        }
    }

    @Override
    boolean moveScrollTowards(int direction, Component c) {
        Component current = this.getFocused();
        if (current != null) {
            for (Container parent = current instanceof Container ? (Container)current : current.getParent(); parent != null; parent = parent.getParent()) {
                if (parent == this) {
                    if (!this.getContentPane().isScrollable()) continue;
                    this.getContentPane().moveScrollTowards(direction, c);
                    continue;
                }
                if (!parent.isScrollable()) continue;
                return parent.moveScrollTowards(direction, c);
            }
        }
        return true;
    }

    void fixNegativeScrolls() {
        Set<Component> negativeScrolls = this.getContentPane().findNegativeScrolls(new HashSet<Component>());
        for (Component cmp : negativeScrolls) {
            int x = cmp.getAbsoluteX() + cmp.getWidth() / 2;
            int y = cmp.getAbsoluteY() + cmp.getHeight() / 2;
            cmp.pointerPressed(x, y);
            cmp.pointerDragged(x, y);
            cmp.pointerReleased(x, y);
        }
    }

    @Override
    public void scrollComponentToVisible(Component c) {
        this.initFocused();
        for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isScrollable()) continue;
            if (parent == this) {
                if (this.getContentPane().isScrollable()) {
                    this.getContentPane().scrollComponentToVisible(c);
                }
            } else {
                parent.scrollComponentToVisible(c);
            }
            return;
        }
    }

    public void setMenuCellRenderer(ListCellRenderer menuCellRenderer) {
        this.menuBar.setMenuCellRenderer(menuCellRenderer);
    }

    public void removeAllCommands() {
        this.menuBar.removeAllCommands();
    }

    void requestFocus(Component cmp) {
        if (cmp.isFocusable() && this.contains(cmp)) {
            this.scrollComponentToVisible(cmp);
            this.setFocused(cmp);
        }
    }

    @Override
    public void setRTL(boolean r) {
        super.setRTL(r);
        this.contentPane.setRTL(r);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.inInternalPaint) {
            this.paintComponentBackground(g);
        }
        super.paint(g);
        if (this.tint) {
            g.setColor(this.tintColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight(), (byte)(this.tintColor >> 24 & 0xFF));
        }
    }

    @Override
    void internalPaintImpl(Graphics g, boolean paintIntersects) {
        this.inInternalPaint = true;
        super.internalPaintImpl(g, paintIntersects);
        this.inInternalPaint = false;
    }

    @Override
    public void setScrollable(boolean scrollable) {
        this.getContentPane().setScrollable(scrollable);
    }

    @Override
    public boolean isScrollable() {
        return this.getContentPane().isScrollable();
    }

    @Override
    public boolean isScrollableX() {
        return this.getContentPane().isScrollableX();
    }

    @Override
    public boolean isScrollableY() {
        return this.getContentPane().isScrollableY();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.mediaComponents != null) {
            int size = this.mediaComponents.size();
            for (int i = 0; i < size; ++i) {
                Component mediaCmp = this.mediaComponents.get(i);
                mediaCmp.setVisible(visible);
            }
        }
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public void setTintColor(int tintColor) {
        this.tintColor = tintColor;
    }

    public void setMenuTransitions(Transition transitionIn, Transition transitionOut) {
        this.menuBar.setTransitions(transitionIn, transitionOut);
    }

    @Override
    protected String paramString() {
        return super.paramString() + ", title = " + this.title + ", visible = " + this.isVisible();
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBar(MenuBar menuBar) {
        this.menuBar = menuBar;
        menuBar.initMenuBar(this);
    }

    public void setToolBar(Toolbar toolbar) {
        this.toolbar = toolbar;
        this.setMenuBar(toolbar.getMenuBar());
    }

    public void setToolbar(Toolbar toolbar) {
        this.toolbar = toolbar;
        this.setMenuBar(toolbar.getMenuBar());
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public boolean isFocusScrolling() {
        return this.focusScrolling;
    }

    public void setFocusScrolling(boolean focusScrolling) {
        this.focusScrolling = focusScrolling;
    }

    @Override
    public String[] getPropertyNames() {
        return new String[]{"titleUIID", "titleAreaUIID"};
    }

    @Override
    public Class[] getPropertyTypes() {
        return new Class[]{String.class, String.class};
    }

    @Override
    public String[] getPropertyTypeNames() {
        return new String[]{"String", "String"};
    }

    @Override
    public Object getPropertyValue(String name) {
        if (name.equals("titleUIID") && this.getTitleComponent() != null) {
            return this.getTitleComponent().getUIID();
        }
        if (name.equals("titleAreaUIID") && this.getTitleArea() != null) {
            return this.getTitleArea().getUIID();
        }
        return null;
    }

    @Override
    public String setPropertyValue(String name, Object value) {
        if (name.equals("titleUIID")) {
            if (this.getTitleComponent() != null) {
                this.getTitleComponent().setUIID((String)value);
            }
            return null;
        }
        if (name.equals("titleAreaUIID")) {
            if (this.getTitleArea() != null) {
                this.getTitleArea().setUIID((String)value);
            }
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public TextArea getEditOnShow() {
        return this.editOnShow;
    }

    public void setEditOnShow(TextArea editOnShow) {
        this.editOnShow = editOnShow;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TabIterator
    implements ListIterator<Component> {
        private List<Component> components;
        private int currPos;
        private Component current;

        private TabIterator(List<Component> components, Component current) {
            this.components = components;
            this.setCurrent(current);
        }

        public Component getCurrent() {
            return this.current;
        }

        public Component getNext() {
            Component next;
            Component current = this.getCurrent();
            if (current == null && this.components.isEmpty()) {
                return null;
            }
            Component component = next = current != null ? current.getNextFocusRight() : null;
            if (next != null && next.isFocusable() && next.isVisible() && next.isEnabled()) {
                return next;
            }
            Component component2 = next = current != null ? current.getNextFocusDown() : null;
            if (next != null && next.isFocusable() && next.isVisible() && next.isEnabled()) {
                return next;
            }
            if (this.currPos < 0 && !this.components.isEmpty()) {
                return this.components.get(0);
            }
            if (this.currPos < this.components.size() - 1) {
                return this.components.get(this.currPos + 1);
            }
            return null;
        }

        public Component getPrevious() {
            Component prev;
            Component current = this.getCurrent();
            if (current == null && this.components.isEmpty()) {
                return null;
            }
            Component component = prev = current != null ? current.getNextFocusLeft() : null;
            if (prev != null && prev.isFocusable() && prev.isVisible() && prev.isEnabled()) {
                return prev;
            }
            Component component2 = prev = current != null ? current.getNextFocusUp() : null;
            if (prev != null && prev.isFocusable() && prev.isVisible() && prev.isEnabled()) {
                return prev;
            }
            if (this.currPos < 0 && !this.components.isEmpty()) {
                return this.components.get(this.components.size() - 1);
            }
            if (this.currPos > 0 && this.currPos <= this.components.size()) {
                return this.components.get(this.currPos - 1);
            }
            return null;
        }

        public void setCurrent(Component cmp) {
            this.current = cmp;
            this.currPos = cmp != null ? this.components.indexOf(cmp) : -1;
        }

        @Override
        public boolean hasNext() {
            return this.getNext() != null;
        }

        @Override
        public Component next() {
            Component next = this.getNext();
            this.setCurrent(next);
            return next;
        }

        @Override
        public boolean hasPrevious() {
            return this.getPrevious() != null;
        }

        @Override
        public Component previous() {
            Component prev = this.getPrevious();
            this.setCurrent(prev);
            return prev;
        }

        @Override
        public int nextIndex() {
            Component next = this.getNext();
            if (next == null) {
                return -1;
            }
            return this.components.indexOf(next);
        }

        @Override
        public int previousIndex() {
            Component prev = this.getPrevious();
            if (prev == null) {
                return -1;
            }
            return this.components.indexOf(prev);
        }

        @Override
        public void remove() {
            Component newCurr = this.getPrevious();
            if (newCurr == null) {
                newCurr = this.getNext();
            }
            if (this.current != null) {
                this.components.remove(this.current);
                this.setCurrent(newCurr);
            }
        }

        @Override
        public void set(Component e) {
            if (this.currPos >= 0 && this.currPos < this.components.size() - 1) {
                this.components.set(this.currPos, e);
                this.setCurrent(e);
            }
        }

        @Override
        public void add(Component e) {
            this.components.add(e);
        }
    }
}

