/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.plaf;

import com.codename1.compat.java.util.Objects;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.Image;
import com.codename1.ui.Painter;
import com.codename1.ui.events.StyleListener;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;

public class Style {
    private boolean suppressChangeEvents;
    private Style[] proxyTo;
    public static final String BG_COLOR = "bgColor";
    public static final String FG_COLOR = "fgColor";
    public static final String BG_IMAGE = "bgImage";
    public static final String BACKGROUND_TYPE = "bgType";
    public static final String BACKGROUND_ALIGNMENT = "bgAlign";
    public static final String BACKGROUND_GRADIENT = "bgGradient";
    public static final String FONT = "font";
    public static final String TRANSPARENCY = "transparency";
    public static final String OPACITY = "opacity";
    public static final String MARGIN = "margin";
    public static final String BORDER = "border";
    public static final String PADDING = "padding";
    public static final String PAINTER = "painter";
    public static final String ALIGNMENT = "align";
    public static final String TEXT_DECORATION = "textDecoration";
    public static final String PADDING_UNIT = "padUnit";
    public static final String MARGIN_UNIT = "marUnit";
    public static final byte BACKGROUND_NONE = 0;
    public static final byte BACKGROUND_IMAGE_SCALED = 1;
    public static final byte BACKGROUND_IMAGE_TILE_BOTH = 2;
    public static final byte BACKGROUND_IMAGE_TILE_VERTICAL = 3;
    public static final byte BACKGROUND_IMAGE_TILE_HORIZONTAL = 4;
    private static final byte BACKGROUND_IMAGE_ALIGNED = 5;
    public static final byte BACKGROUND_IMAGE_ALIGNED_TOP = 20;
    public static final byte BACKGROUND_IMAGE_ALIGNED_BOTTOM = 21;
    public static final byte BACKGROUND_IMAGE_ALIGNED_LEFT = 22;
    public static final byte BACKGROUND_IMAGE_ALIGNED_RIGHT = 23;
    public static final byte BACKGROUND_IMAGE_ALIGNED_CENTER = 24;
    public static final byte BACKGROUND_IMAGE_ALIGNED_TOP_LEFT = 25;
    public static final byte BACKGROUND_IMAGE_ALIGNED_TOP_RIGHT = 26;
    public static final byte BACKGROUND_IMAGE_ALIGNED_BOTTOM_LEFT = 27;
    public static final byte BACKGROUND_IMAGE_ALIGNED_BOTTOM_RIGHT = 28;
    public static final byte BACKGROUND_IMAGE_TILE_HORIZONTAL_ALIGN_TOP = 4;
    public static final byte BACKGROUND_IMAGE_TILE_HORIZONTAL_ALIGN_CENTER = 29;
    public static final byte BACKGROUND_IMAGE_TILE_HORIZONTAL_ALIGN_BOTTOM = 30;
    public static final byte BACKGROUND_IMAGE_TILE_VERTICAL_ALIGN_LEFT = 3;
    public static final byte BACKGROUND_IMAGE_TILE_VERTICAL_ALIGN_CENTER = 31;
    public static final byte BACKGROUND_IMAGE_TILE_VERTICAL_ALIGN_RIGHT = 32;
    public static final byte BACKGROUND_IMAGE_SCALED_FILL = 33;
    public static final byte BACKGROUND_IMAGE_SCALED_FIT = 34;
    public static final byte BACKGROUND_GRADIENT_LINEAR_VERTICAL = 6;
    public static final byte BACKGROUND_GRADIENT_LINEAR_HORIZONTAL = 7;
    public static final byte BACKGROUND_GRADIENT_RADIAL = 8;
    private static final byte BACKGROUND_IMAGE_ALIGN_TOP = -95;
    private static final byte BACKGROUND_IMAGE_ALIGN_BOTTOM = -94;
    private static final byte BACKGROUND_IMAGE_ALIGN_LEFT = -93;
    private static final byte BACKGROUND_IMAGE_ALIGN_RIGHT = -92;
    private static final byte BACKGROUND_IMAGE_ALIGN_CENTER = -91;
    public static final byte TEXT_DECORATION_NONE = 0;
    public static final byte TEXT_DECORATION_UNDERLINE = 1;
    public static final byte TEXT_DECORATION_STRIKETHRU = 2;
    public static final byte TEXT_DECORATION_OVERLINE = 4;
    public static final byte TEXT_DECORATION_3D = 8;
    public static final byte TEXT_DECORATION_3D_LOWERED = 16;
    public static final byte TEXT_DECORATION_3D_SHADOW_NORTH = 32;
    public static final byte UNIT_TYPE_PIXELS = 0;
    public static final byte UNIT_TYPE_SCREEN_PERCENTAGE = 1;
    public static final byte UNIT_TYPE_DIPS = 2;
    private int fgColor = 0;
    private int bgColor = 0xFFFFFF;
    private Font font = Font.getDefaultFont();
    private Image bgImage;
    float[] padding = new float[4];
    float[] margin = new float[4];
    private float[] cached_margin = null;
    byte[] paddingUnit;
    byte[] marginUnit;
    private byte transparency = (byte)-1;
    private byte opacity = (byte)-1;
    private Painter bgPainter;
    private byte backgroundType = 1;
    private byte backgroundAlignment = (byte)-95;
    private Object[] backgroundGradient;
    private Border border = null;
    private int align = 1;
    private int textDecoration;
    private int modifiedFlag;
    private static final int FG_COLOR_MODIFIED = 1;
    private static final int BG_COLOR_MODIFIED = 2;
    private static final int FONT_MODIFIED = 16;
    private static final int BG_IMAGE_MODIFIED = 32;
    private static final int TRANSPARENCY_MODIFIED = 128;
    private static final int PADDING_MODIFIED = 256;
    private static final int MARGIN_MODIFIED = 512;
    private static final int BORDER_MODIFIED = 1024;
    private static final int BACKGROUND_TYPE_MODIFIED = 2048;
    private static final int BACKGROUND_ALIGNMENT_MODIFIED = 4096;
    private static final int BACKGROUND_GRADIENT_MODIFIED = 8192;
    private static final int ALIGNMENT_MODIFIED = 16384;
    private static final int OPACITY_MODIFIED = 32768;
    private static final int TEXT_DECORATION_MODIFIED = 64;
    private EventDispatcher listeners;
    Object roundRectCache;
    Object nativeOSCache;
    boolean renderer;

    public Style() {
        this.setPadding(3, 3, 3, 3);
        this.setMargin(2, 2, 2, 2);
        this.modifiedFlag = 0;
    }

    public void markAsRendererStyle() {
        this.renderer = true;
    }

    public static Style createProxyStyle(Style ... styles) {
        Style s = new Style();
        s.proxyTo = styles;
        return s;
    }

    public Style(Style style) {
        this(style.getFgColor(), style.getBgColor(), style.getFont(), style.getBgTransparency(), style.getBgImage());
        this.setPadding(style.padding[0], style.padding[2], style.padding[1], style.padding[3]);
        this.setMargin(style.margin[0], style.margin[2], style.margin[1], style.margin[3]);
        this.setPaddingUnit(style.paddingUnit);
        this.setMarginUnit(style.marginUnit);
        this.setBorder(style.getBorder());
        this.opacity = style.opacity;
        this.modifiedFlag = 0;
        this.align = style.align;
        this.backgroundType = style.backgroundType;
        this.backgroundAlignment = style.backgroundAlignment;
        this.textDecoration = style.textDecoration;
        if (style.backgroundGradient != null) {
            this.backgroundGradient = new Object[style.backgroundGradient.length];
            System.arraycopy(style.backgroundGradient, 0, this.backgroundGradient, 0, this.backgroundGradient.length);
        }
    }

    public Style(int fgColor, int bgColor, Font f, byte transparency) {
        this(fgColor, bgColor, f, transparency, null, 1);
    }

    private Style(int fgColor, int bgColor, Font f, byte transparency, Image im) {
        this();
        this.fgColor = fgColor;
        this.bgColor = bgColor;
        this.font = f;
        this.transparency = transparency;
        this.bgImage = im;
    }

    public Style(int fgColor, int bgColor, Font f, byte transparency, Image im, byte backgroundType) {
        this();
        this.fgColor = fgColor;
        this.bgColor = bgColor;
        this.font = f;
        this.transparency = transparency;
        this.backgroundType = backgroundType;
        this.bgImage = im;
    }

    public void merge(Style style) {
        int tmp = this.modifiedFlag;
        if ((this.modifiedFlag & 1) == 0) {
            this.setFgColor(style.getFgColor());
        }
        if ((this.modifiedFlag & 2) == 0) {
            this.setBgColor(style.getBgColor());
        }
        if ((this.modifiedFlag & 0x20) == 0) {
            this.setBgImage(style.getBgImage());
        }
        if ((this.modifiedFlag & 0x800) == 0) {
            this.setBackgroundType(style.getBackgroundType());
        }
        if ((this.modifiedFlag & 0x1000) == 0) {
            this.setBackgroundAlignment(style.getBackgroundAlignment());
        }
        if ((this.modifiedFlag & 0x2000) == 0) {
            this.setBackgroundGradientStartColor(style.getBackgroundGradientStartColor());
            this.setBackgroundGradientEndColor(style.getBackgroundGradientEndColor());
            this.setBackgroundGradientRelativeX(style.getBackgroundGradientRelativeX());
            this.setBackgroundGradientRelativeY(style.getBackgroundGradientRelativeY());
            this.setBackgroundGradientRelativeSize(style.getBackgroundGradientRelativeSize());
        }
        if ((this.modifiedFlag & 0x10) == 0) {
            this.setFont(style.getFont());
        }
        if ((this.modifiedFlag & 0x80) == 0) {
            this.setBgTransparency(style.getBgTransparency());
        }
        if ((this.modifiedFlag & 0x8000) == 0) {
            this.setOpacity(style.getOpacity());
        }
        if ((this.modifiedFlag & 0x100) == 0) {
            this.setPadding(style.padding[0], style.padding[2], style.padding[1], style.padding[3]);
            this.setPaddingUnit(this.paddingUnit);
        }
        if ((this.modifiedFlag & 0x200) == 0) {
            this.setMargin(style.margin[0], style.margin[2], style.margin[1], style.margin[3]);
            this.setMarginUnit(style.marginUnit);
        }
        if ((this.modifiedFlag & 0x400) == 0) {
            this.setBorder(style.getBorder());
        }
        if ((this.modifiedFlag & 0x40) == 0) {
            this.setTextDecoration(style.getTextDecoration());
        }
        if ((this.modifiedFlag & 0x4000) == 0) {
            this.setAlignment(style.getAlignment());
        }
        this.bgPainter = style.bgPainter;
        this.modifiedFlag = tmp;
    }

    public boolean isModified() {
        return this.modifiedFlag != 0;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public Image getBgImage() {
        return this.bgImage;
    }

    public byte getBackgroundType() {
        return this.backgroundType;
    }

    private byte getBackgroundAlignment() {
        return this.backgroundAlignment;
    }

    public int getBackgroundGradientStartColor() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 1) {
            return (Integer)this.backgroundGradient[0];
        }
        return 0xFFFFFF;
    }

    public int getBackgroundGradientEndColor() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 1) {
            return (Integer)this.backgroundGradient[1];
        }
        return 0;
    }

    public float getBackgroundGradientRelativeX() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 2) {
            return ((Float)this.backgroundGradient[2]).floatValue();
        }
        return 0.5f;
    }

    public float getBackgroundGradientRelativeY() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 3) {
            return ((Float)this.backgroundGradient[3]).floatValue();
        }
        return 0.5f;
    }

    public float getBackgroundGradientRelativeSize() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 4) {
            return ((Float)this.backgroundGradient[4]).floatValue();
        }
        return 1.0f;
    }

    public int getFgColor() {
        return this.fgColor;
    }

    public Font getFont() {
        return this.font;
    }

    public void setBgColor(int bgColor) {
        this.setBgColor(bgColor, false);
    }

    public void setAlignment(int align) {
        this.setAlignment(align, false);
    }

    public void setAlignment(int align, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setAlignment(align, override);
            }
            return;
        }
        if (this.align != align) {
            this.align = align;
            if (!override) {
                this.modifiedFlag |= 0x4000;
            }
            this.firePropertyChanged(ALIGNMENT);
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setBgImage(Image bgImage) {
        this.setBgImage(bgImage, false);
    }

    public void setBackgroundType(byte backgroundType) {
        this.setBackgroundType(backgroundType, false);
    }

    private void setBackgroundAlignment(byte backgroundAlignment) {
        this.setBackgroundAlignment(backgroundAlignment, false);
    }

    public void setBackgroundGradientStartColor(int backgroundGradientStartColor) {
        this.setBackgroundGradientStartColor(backgroundGradientStartColor, false);
    }

    public void setBackgroundGradientEndColor(int backgroundGradientEndColor) {
        this.setBackgroundGradientEndColor(backgroundGradientEndColor, false);
    }

    public void setBackgroundGradientRelativeX(float backgroundGradientRelativeX) {
        this.setBackgroundGradientRelativeX(backgroundGradientRelativeX, false);
    }

    public void setBackgroundGradientRelativeY(float backgroundGradientRelativeY) {
        this.setBackgroundGradientRelativeY(backgroundGradientRelativeY, false);
    }

    public void setBackgroundGradientRelativeSize(float backgroundGradientRelativeSize) {
        this.setBackgroundGradientRelativeSize(backgroundGradientRelativeSize, false);
    }

    public void setFgColor(int fgColor) {
        this.setFgColor(fgColor, false);
    }

    public void setFont(Font font) {
        this.setFont(font, false);
    }

    public void setUnderline(boolean underline) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setUnderline(underline);
            }
            return;
        }
        if (underline != this.isUnderline()) {
            this.textDecoration = underline ? (this.textDecoration |= 1) : --this.textDecoration;
        }
    }

    public boolean isUnderline() {
        return (this.textDecoration & 1) != 0;
    }

    public void set3DText(boolean t, boolean raised) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.set3DText(t, raised);
            }
            return;
        }
        if (raised) {
            if (t != this.isRaised3DText()) {
                this.textDecoration &= 0xFFFFFFEF;
                this.textDecoration = t ? (this.textDecoration |= 8) : (this.textDecoration -= 8);
            }
        } else if (t != this.isLowered3DText()) {
            this.textDecoration &= 0xFFFFFFF7;
            this.textDecoration = t ? (this.textDecoration |= 0x10) : (this.textDecoration -= 16);
        }
    }

    public void set3DTextNorth(boolean north) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.set3DTextNorth(north);
            }
            return;
        }
        this.textDecoration = 32;
    }

    public boolean is3DTextNorth() {
        return (this.textDecoration & 0x20) == 32;
    }

    public boolean isRaised3DText() {
        return (this.textDecoration & 8) != 0;
    }

    public boolean isLowered3DText() {
        return (this.textDecoration & 0x10) != 0;
    }

    public void setOverline(boolean overline) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setOverline(overline);
            }
            return;
        }
        if (overline != this.isOverline()) {
            this.textDecoration = overline ? (this.textDecoration |= 4) : (this.textDecoration -= 4);
        }
    }

    public boolean isOverline() {
        return (this.textDecoration & 4) != 0;
    }

    public void setStrikeThru(boolean strikethru) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setStrikeThru(strikethru);
            }
            return;
        }
        if (strikethru != this.isStrikeThru()) {
            this.textDecoration = strikethru ? (this.textDecoration |= 2) : (this.textDecoration -= 2);
        }
    }

    public boolean isStrikeThru() {
        return (this.textDecoration & 2) != 0;
    }

    public int getTextDecoration() {
        return this.textDecoration;
    }

    public void setTextDecoration(int textDecoration) {
        this.setTextDecoration(textDecoration, false);
    }

    public void setTextDecoration(int textDecoration, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setTextDecoration(textDecoration, override);
            }
            return;
        }
        this.textDecoration = textDecoration;
        if (this.textDecoration != textDecoration) {
            this.textDecoration = textDecoration;
            if (!override) {
                this.modifiedFlag |= 0x40;
            }
            this.firePropertyChanged(TEXT_DECORATION);
        }
    }

    public byte getBgTransparency() {
        if (this.bgImage != null && this.backgroundType <= 2 && this.backgroundType != 0 && (this.bgImage.isAnimation() || this.bgImage.isOpaque())) {
            return -1;
        }
        return this.transparency;
    }

    public void setBgTransparency(byte transparency) {
        this.setBgTransparency(transparency & 0xFF, false);
    }

    public int getOpacity() {
        return this.opacity & 0xFF;
    }

    public void setOpacity(int opacity) {
        this.setOpacity(opacity, false);
    }

    public void setOpacity(int opacity, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setOpacity(opacity, override);
            }
            return;
        }
        if (opacity < 0 || opacity > 255) {
            throw new IllegalArgumentException("valid values are between 0-255: " + opacity);
        }
        if (this.opacity != (byte)opacity) {
            this.opacity = (byte)opacity;
            if (!override) {
                this.modifiedFlag |= 0x8000;
            }
            this.firePropertyChanged(OPACITY);
        }
    }

    public void setBgTransparency(int transparency) {
        this.setBgTransparency(transparency, false);
    }

    public void stripMarginAndPadding() {
        this.setPadding(0, 0, 0, 0);
        this.setMargin(0, 0, 0, 0);
        this.setBorder(Border.createEmpty());
    }

    public void setPadding(int top, int bottom, int left, int right) {
        this.setPadding((float)top, (float)bottom, (float)left, (float)right);
    }

    public void setPadding(float top, float bottom, float left, float right) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setPadding(top, bottom, left, right);
            }
            return;
        }
        if (top < 0.0f || left < 0.0f || right < 0.0f || bottom < 0.0f) {
            throw new IllegalArgumentException("padding cannot be negative");
        }
        if (this.padding[0] != top || this.padding[2] != bottom || this.padding[1] != left || this.padding[3] != right) {
            this.padding[0] = top;
            this.padding[2] = bottom;
            this.padding[1] = left;
            this.padding[3] = right;
            this.modifiedFlag |= 0x100;
            this.firePropertyChanged(PADDING);
        }
    }

    public void setPadding(int orientation, int gap) {
        this.setPadding(orientation, gap, false);
    }

    public void setPadding(int orientation, float gap) {
        this.setPadding(orientation, gap, false);
    }

    public void setMargin(int top, int bottom, int left, int right) {
        this.setMargin((float)top, (float)bottom, (float)left, (float)right);
    }

    public void setMargin(float top, float bottom, float left, float right) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setMargin(top, bottom, left, right);
            }
            return;
        }
        if (top < 0.0f || left < 0.0f || right < 0.0f || bottom < 0.0f) {
            throw new IllegalArgumentException("margin cannot be negative");
        }
        if (this.margin[0] != top || this.margin[2] != bottom || this.margin[1] != left || this.margin[3] != right) {
            this.margin[0] = top;
            this.margin[2] = bottom;
            this.margin[1] = left;
            this.margin[3] = right;
            this.modifiedFlag |= 0x200;
            this.firePropertyChanged(MARGIN);
        }
    }

    public void cacheMargins(boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.cacheMargins(override);
            }
            return;
        }
        if (override || this.cached_margin == null) {
            this.cached_margin = new float[4];
            System.arraycopy(this.margin, 0, this.cached_margin, 0, this.margin.length);
        }
    }

    public void restoreCachedMargins() {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.restoreCachedMargins();
            }
            return;
        }
        if (this.cached_margin != null) {
            this.setMargin(this.cached_margin[0], this.cached_margin[1], this.cached_margin[2], this.cached_margin[3]);
            this.cached_margin = null;
        }
    }

    public void flushMarginsCache() {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.flushMarginsCache();
            }
            return;
        }
        this.cached_margin = null;
    }

    public void setMargin(int orientation, int gap) {
        this.setMargin(orientation, gap, false);
    }

    public void setMargin(int orientation, float gap) {
        this.setMargin(orientation, gap, false);
    }

    public int getPaddingValue(boolean rtl, int orientation) {
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("wrong orientation " + orientation);
        }
        if (rtl) {
            switch (orientation) {
                case 1: {
                    orientation = 3;
                    break;
                }
                case 3: {
                    orientation = 1;
                }
            }
        }
        return (int)this.padding[orientation];
    }

    public int getPaddingLeft(boolean rtl) {
        if (rtl) {
            return this.convertUnit(this.paddingUnit, this.padding[3], 3);
        }
        return this.convertUnit(this.paddingUnit, this.padding[1], 1);
    }

    private void initPaddingUnits() {
        if (this.paddingUnit == null) {
            this.paddingUnit = new byte[]{0, 0, 0, 0};
        }
    }

    public void setPaddingUnitLeft(byte unit) {
        this.initPaddingUnits();
        this.paddingUnit[1] = unit;
    }

    public void setPaddingUnitRight(byte unit) {
        this.initPaddingUnits();
        this.paddingUnit[3] = unit;
    }

    public void setPaddingUnitTop(byte unit) {
        this.initPaddingUnits();
        this.paddingUnit[0] = unit;
    }

    public void setPaddingUnitBottom(byte unit) {
        this.initPaddingUnits();
        this.paddingUnit[2] = unit;
    }

    public int getPaddingRight(boolean rtl) {
        if (rtl) {
            return this.convertUnit(this.paddingUnit, this.padding[1], 1);
        }
        return this.convertUnit(this.paddingUnit, this.padding[3], 3);
    }

    public int getPaddingTop() {
        return this.convertUnit(this.paddingUnit, this.padding[0], 0);
    }

    public void setPaddingTop(int gap) {
        this.setPaddingTop((float)gap);
    }

    public void setPaddingTop(float gap) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setPaddingTop(gap);
            }
            return;
        }
        if (gap < 0.0f) {
            throw new IllegalArgumentException("padding cannot be negative");
        }
        if (this.padding[0] != gap) {
            this.padding[0] = gap;
            this.modifiedFlag |= 0x100;
            this.firePropertyChanged(PADDING);
        }
    }

    public void setPaddingBottom(int gap) {
        this.setPaddingBottom((float)gap);
    }

    public void setPaddingBottom(float gap) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setPaddingBottom(gap);
            }
            return;
        }
        if (gap < 0.0f) {
            throw new IllegalArgumentException("padding cannot be negative");
        }
        if (this.padding[2] != gap) {
            this.padding[2] = gap;
            this.modifiedFlag |= 0x100;
            this.firePropertyChanged(PADDING);
        }
    }

    public void setPaddingLeft(int gap) {
        this.setPaddingLeft((float)gap);
    }

    public void setPaddingLeft(float gap) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setPaddingLeft(gap);
            }
            return;
        }
        if (gap < 0.0f) {
            throw new IllegalArgumentException("padding cannot be negative");
        }
        if (this.padding[1] != gap) {
            this.padding[1] = gap;
            this.modifiedFlag |= 0x100;
            this.firePropertyChanged(PADDING);
        }
    }

    public void setPaddingRight(int gap) {
        this.setPaddingRight((float)gap);
    }

    public void setPaddingRight(float gap) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setPaddingRight(gap);
            }
            return;
        }
        if (gap < 0.0f) {
            throw new IllegalArgumentException("padding cannot be negative");
        }
        if (this.padding[3] != gap) {
            this.padding[3] = gap;
            this.modifiedFlag |= 0x100;
            this.firePropertyChanged(PADDING);
        }
    }

    public void setMarginTop(int gap) {
        this.setMarginTop((float)gap);
    }

    public void setMarginTop(float gap) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setMarginTop(gap);
            }
            return;
        }
        if (gap < 0.0f) {
            throw new IllegalArgumentException("Margin cannot be negative");
        }
        if (this.margin[0] != gap) {
            this.margin[0] = gap;
            this.modifiedFlag |= 0x200;
            this.firePropertyChanged(MARGIN);
        }
    }

    public void setMarginBottom(int gap) {
        this.setMarginBottom((float)gap);
    }

    public void setMarginBottom(float gap) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setMarginBottom(gap);
            }
            return;
        }
        if (gap < 0.0f) {
            throw new IllegalArgumentException("Margin cannot be negative");
        }
        if (this.margin[2] != gap) {
            this.margin[2] = gap;
            this.modifiedFlag |= 0x200;
            this.firePropertyChanged(MARGIN);
        }
    }

    public void setMarginLeft(int gap) {
        this.setMarginLeft((float)gap);
    }

    public void setMarginLeft(float gap) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setMarginLeft(gap);
            }
            return;
        }
        if (gap < 0.0f) {
            throw new IllegalArgumentException("Margin cannot be negative");
        }
        if (this.margin[1] != gap) {
            this.margin[1] = gap;
            this.modifiedFlag |= 0x200;
            this.firePropertyChanged(MARGIN);
        }
    }

    public void setMarginRight(int gap) {
        this.setMarginRight((float)gap);
    }

    public void setMarginRight(float gap) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setMarginRight(gap);
            }
            return;
        }
        if (gap < 0.0f) {
            throw new IllegalArgumentException("Margin cannot be negative");
        }
        if (this.margin[3] != gap) {
            this.margin[3] = gap;
            this.modifiedFlag |= 0x200;
            this.firePropertyChanged(MARGIN);
        }
    }

    public int getPaddingBottom() {
        return this.convertUnit(this.paddingUnit, this.padding[2], 2);
    }

    public int getHorizontalMargins() {
        return this.convertUnit(this.marginUnit, this.margin[3], 3) + this.convertUnit(this.marginUnit, this.margin[1], 1);
    }

    public int getVerticalMargins() {
        return this.convertUnit(this.marginUnit, this.margin[0], 0) + this.convertUnit(this.marginUnit, this.margin[2], 2);
    }

    public int getHorizontalPadding() {
        return this.convertUnit(this.paddingUnit, this.padding[3], 3) + this.convertUnit(this.paddingUnit, this.padding[1], 1);
    }

    public int getVerticalPadding() {
        return this.convertUnit(this.paddingUnit, this.padding[0], 0) + this.convertUnit(this.paddingUnit, this.padding[2], 2);
    }

    public int getMarginRightNoRTL() {
        return this.convertUnit(this.marginUnit, this.margin[3], 3);
    }

    public int getMarginLeftNoRTL() {
        return this.convertUnit(this.marginUnit, this.margin[1], 1);
    }

    public int getPaddingRightNoRTL() {
        return this.convertUnit(this.paddingUnit, this.padding[3], 3);
    }

    public int getPaddingLeftNoRTL() {
        return this.convertUnit(this.paddingUnit, this.padding[1], 1);
    }

    public int getMarginRight(boolean rtl) {
        if (rtl) {
            return this.convertUnit(this.marginUnit, this.margin[1], 1);
        }
        return this.convertUnit(this.marginUnit, this.margin[3], 3);
    }

    public int getMarginLeft(boolean rtl) {
        if (rtl) {
            return this.convertUnit(this.marginUnit, this.margin[3], 3);
        }
        return this.convertUnit(this.marginUnit, this.margin[1], 1);
    }

    public int getMarginTop() {
        return this.convertUnit(this.marginUnit, this.margin[0], 0);
    }

    public int getMarginBottom() {
        return this.convertUnit(this.marginUnit, this.margin[2], 2);
    }

    public int getPadding(boolean rtl, int orientation) {
        int v = this.getPaddingValue(rtl, orientation);
        return this.convertUnit(this.paddingUnit, v, orientation);
    }

    private int convertUnit(byte[] unitType, float v, int orientation) {
        if (unitType != null) {
            switch (unitType[orientation]) {
                case 2: {
                    return Display.getInstance().convertToPixels(v);
                }
                case 1: {
                    if (orientation == 0 || orientation == 2) {
                        float h = Display.getInstance().getDisplayHeight();
                        h = h / 100.0f * v;
                        return (int)h;
                    }
                    float w = Display.getInstance().getDisplayWidth();
                    w = w / 100.0f * v;
                    return (int)w;
                }
            }
            return (int)v;
        }
        return (int)v;
    }

    public int getPadding(int orientation) {
        return this.getPadding(UIManager.getInstance().getLookAndFeel().isRTL(), orientation);
    }

    public int getMargin(int orientation) {
        return this.getMargin(UIManager.getInstance().getLookAndFeel().isRTL(), orientation);
    }

    public int getMargin(boolean rtl, int orientation) {
        int v = this.getMarginValue(rtl, orientation);
        return this.convertUnit(this.marginUnit, v, orientation);
    }

    public int getMarginValue(boolean rtl, int orientation) {
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("wrong orientation " + orientation);
        }
        if (rtl) {
            switch (orientation) {
                case 1: {
                    orientation = 3;
                    break;
                }
                case 3: {
                    orientation = 1;
                }
            }
        }
        return (int)this.margin[orientation];
    }

    public void setBgColor(int bgColor, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setBgColor(bgColor, override);
            }
            return;
        }
        if (this.bgColor != bgColor) {
            this.bgColor = bgColor;
            if (!override) {
                this.modifiedFlag |= 2;
            }
            this.firePropertyChanged(BG_COLOR);
        }
    }

    public void setBgImage(Image bgImage, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setBgImage(bgImage, override);
            }
            return;
        }
        if (this.bgImage != bgImage) {
            this.bgImage = bgImage;
            if (!override) {
                this.modifiedFlag |= 0x20;
            }
            this.firePropertyChanged(BG_IMAGE);
        }
    }

    public void setBackgroundType(byte backgroundType, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setBackgroundType(backgroundType, override);
            }
            return;
        }
        if (this.backgroundType != backgroundType) {
            this.backgroundType = backgroundType;
            if (!override) {
                this.modifiedFlag |= 0x800;
            }
            this.firePropertyChanged(BACKGROUND_TYPE);
        }
    }

    private void setBackgroundAlignment(byte backgroundAlignment, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setBackgroundAlignment(backgroundAlignment, override);
            }
            return;
        }
        if (this.backgroundAlignment != backgroundAlignment) {
            this.backgroundAlignment = backgroundAlignment;
            if (!override) {
                this.modifiedFlag |= 0x1000;
            }
            this.firePropertyChanged(BACKGROUND_ALIGNMENT);
        }
    }

    Object[] getBackgroundGradient() {
        if (this.backgroundGradient == null) {
            Float c = new Float(0.5f);
            this.backgroundGradient = new Object[]{new Integer(0xFFFFFF), new Integer(0), c, c, new Float(1.0f)};
        }
        return this.backgroundGradient;
    }

    void setBackgroundGradient(Object[] backgroundGradient) {
        this.backgroundGradient = backgroundGradient;
    }

    public void setBackgroundGradientStartColor(int backgroundGradientStartColor, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setBackgroundGradientStartColor(backgroundGradientStartColor, override);
            }
            return;
        }
        if ((Integer)this.getBackgroundGradient()[0] != backgroundGradientStartColor) {
            this.getBackgroundGradient()[0] = new Integer(backgroundGradientStartColor);
            if (!override) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setBackgroundGradientEndColor(int backgroundGradientEndColor, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setBackgroundGradientEndColor(backgroundGradientEndColor, override);
            }
            return;
        }
        if ((Integer)this.getBackgroundGradient()[1] != backgroundGradientEndColor) {
            this.getBackgroundGradient()[1] = new Integer(backgroundGradientEndColor);
            if (!override) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setBackgroundGradientRelativeX(float backgroundGradientRelativeX, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setBackgroundGradientRelativeX(backgroundGradientRelativeX, override);
            }
            return;
        }
        if (((Float)this.getBackgroundGradient()[2]).floatValue() != backgroundGradientRelativeX) {
            this.getBackgroundGradient()[2] = new Float(backgroundGradientRelativeX);
            if (!override) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setBackgroundGradientRelativeY(float backgroundGradientRelativeY, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setBackgroundGradientRelativeY(backgroundGradientRelativeY, override);
            }
            return;
        }
        if (((Float)this.getBackgroundGradient()[3]).floatValue() != backgroundGradientRelativeY) {
            this.getBackgroundGradient()[3] = new Float(backgroundGradientRelativeY);
            if (!override) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setBackgroundGradientRelativeSize(float backgroundGradientRelativeSize, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setBackgroundGradientRelativeSize(backgroundGradientRelativeSize, override);
            }
            return;
        }
        if (((Float)this.getBackgroundGradient()[4]).floatValue() != backgroundGradientRelativeSize) {
            this.getBackgroundGradient()[4] = new Float(backgroundGradientRelativeSize);
            if (!override) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setFgColor(int fgColor, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setFgColor(fgColor, override);
            }
            return;
        }
        if (this.fgColor != fgColor) {
            this.fgColor = fgColor;
            if (!override) {
                this.modifiedFlag |= 1;
            }
            this.firePropertyChanged(FG_COLOR);
        }
    }

    public void setFont(Font font, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setFont(font, override);
            }
            return;
        }
        if (this.font == null && font != null || this.font != null && !this.font.equals(font)) {
            this.font = font;
            if (!override) {
                this.modifiedFlag |= 0x10;
            }
            this.firePropertyChanged(FONT);
        }
    }

    public void setBgTransparency(int transparency, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setBgTransparency(transparency, override);
            }
            return;
        }
        if (transparency < 0 || transparency > 255) {
            throw new IllegalArgumentException("valid values are between 0-255");
        }
        if (this.transparency != (byte)transparency) {
            this.transparency = (byte)transparency;
            if (!override) {
                this.modifiedFlag |= 0x80;
            }
            this.firePropertyChanged(TRANSPARENCY);
        }
    }

    public void setPadding(int orientation, int gap, boolean override) {
        this.setPadding(orientation, (float)gap, override);
    }

    public void setPadding(int orientation, float gap, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setPadding(orientation, gap, override);
            }
            return;
        }
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("wrong orientation " + orientation);
        }
        if (gap < 0.0f) {
            throw new IllegalArgumentException("padding cannot be negative");
        }
        if (this.padding[orientation] != gap) {
            this.padding[orientation] = gap;
            if (!override) {
                this.modifiedFlag |= 0x100;
            }
            this.firePropertyChanged(PADDING);
        }
    }

    public void setMargin(int orientation, int gap, boolean override) {
        this.setMargin(orientation, (float)gap, override);
    }

    public void setMargin(int orientation, float gap, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setMargin(orientation, gap, override);
            }
            return;
        }
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("wrong orientation " + orientation);
        }
        if (gap < 0.0f) {
            throw new IllegalArgumentException("margin cannot be negative");
        }
        if (this.margin[orientation] != gap) {
            this.margin[orientation] = gap;
            if (!override) {
                this.modifiedFlag |= 0x200;
            }
            this.firePropertyChanged(MARGIN);
        }
    }

    public boolean isSuppressChangeEvents() {
        return this.suppressChangeEvents;
    }

    public void setSuppressChangeEvents(boolean suppress) {
        this.suppressChangeEvents = suppress;
    }

    private void firePropertyChanged(String propertName) {
        this.roundRectCache = null;
        this.nativeOSCache = null;
        if (this.listeners == null || this.suppressChangeEvents) {
            return;
        }
        this.listeners.fireStyleChangeEvent(propertName, this);
    }

    public void addStyleListener(StyleListener l) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.addStyleListener(l);
            }
            return;
        }
        if (this.listeners == null) {
            this.listeners = new EventDispatcher();
        }
        this.listeners.addListener(l);
    }

    public void removeStyleListener(StyleListener l) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.removeStyleListener(l);
            }
            return;
        }
        if (this.listeners != null) {
            this.listeners.removeListener(l);
        }
    }

    public void removeListeners() {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.removeListeners();
            }
            return;
        }
        if (this.listeners != null) {
            this.listeners = null;
        }
    }

    void resetModifiedFlag() {
        this.modifiedFlag = 0;
    }

    public void setBorder(Border border) {
        this.setBorder(border, false);
    }

    public void setBorder(Border border, boolean override) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setBorder(border, override);
            }
            return;
        }
        if (this.border == null && border != null || this.border != null && !this.border.equals(border)) {
            this.border = border;
            if (!override) {
                this.modifiedFlag |= 0x400;
            }
            this.firePropertyChanged(BORDER);
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public Painter getBgPainter() {
        return this.bgPainter;
    }

    public void setBgPainter(Painter bgPainter) {
        if (this.proxyTo != null) {
            for (Style s : this.proxyTo) {
                s.setBgPainter(bgPainter);
            }
            return;
        }
        this.bgPainter = bgPainter;
        this.firePropertyChanged(PAINTER);
    }

    public byte[] getPaddingUnit() {
        return this.paddingUnit;
    }

    public void setPaddingUnit(byte ... paddingUnit) {
        if (this.proxyTo != null) {
            if (paddingUnit != null && paddingUnit.length < 4) {
                paddingUnit = new byte[]{paddingUnit[0], paddingUnit[0], paddingUnit[0], paddingUnit[0]};
            }
            for (Style s : this.proxyTo) {
                s.setPaddingUnit(paddingUnit);
            }
            return;
        }
        if (paddingUnit != null && paddingUnit.length < 4) {
            this.paddingUnit = new byte[]{paddingUnit[0], paddingUnit[0], paddingUnit[0], paddingUnit[0]};
        } else if (paddingUnit == null) {
            this.paddingUnit = null;
        } else {
            if (this.paddingUnit == null) {
                this.paddingUnit = new byte[4];
            }
            System.arraycopy(paddingUnit, 0, this.paddingUnit, 0, 4);
        }
    }

    public byte[] getMarginUnit() {
        return this.marginUnit;
    }

    public void setMarginUnit(byte ... marginUnit) {
        if (this.proxyTo != null) {
            if (marginUnit != null && marginUnit.length < 4) {
                marginUnit = new byte[]{marginUnit[0], marginUnit[0], marginUnit[0], marginUnit[0]};
            }
            for (Style s : this.proxyTo) {
                s.setMarginUnit(marginUnit);
            }
            return;
        }
        if (marginUnit != null && marginUnit.length < 4) {
            this.marginUnit = new byte[]{marginUnit[0], marginUnit[0], marginUnit[0], marginUnit[0]};
        } else if (marginUnit == null) {
            this.marginUnit = null;
        } else {
            if (this.marginUnit == null) {
                this.marginUnit = new byte[4];
            }
            System.arraycopy(marginUnit, 0, this.marginUnit, 0, 4);
        }
    }

    private void initMarginUnits() {
        if (this.marginUnit == null) {
            this.marginUnit = new byte[]{0, 0, 0, 0};
        }
    }

    public void setMarginUnitLeft(byte unit) {
        this.initMarginUnits();
        this.marginUnit[1] = unit;
    }

    public void setMarginUnitRight(byte unit) {
        this.initMarginUnits();
        this.marginUnit[3] = unit;
    }

    public void setMarginUnitTop(byte unit) {
        this.initMarginUnits();
        this.marginUnit[0] = unit;
    }

    public void setMarginUnitBottom(byte unit) {
        this.initMarginUnits();
        this.marginUnit[2] = unit;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Style other = (Style)obj;
        if (this.fgColor != other.fgColor) {
            return false;
        }
        if (this.bgColor != other.bgColor) {
            return false;
        }
        if (!(this.font == other.font || this.font != null && this.font.equals(other.font))) {
            return false;
        }
        if (!(this.bgImage == other.bgImage || this.bgImage != null && this.bgImage.equals(other.bgImage))) {
            return false;
        }
        if (!Objects.deepEquals(this.padding, other.padding)) {
            return false;
        }
        if (!Objects.deepEquals(this.margin, other.margin)) {
            return false;
        }
        if (!Objects.deepEquals(this.paddingUnit, other.paddingUnit)) {
            return false;
        }
        if (!Objects.deepEquals(this.marginUnit, other.marginUnit)) {
            return false;
        }
        if (this.transparency != other.transparency) {
            return false;
        }
        if (this.opacity != other.opacity) {
            return false;
        }
        if (this.backgroundType != other.backgroundType) {
            return false;
        }
        if (this.backgroundAlignment != other.backgroundAlignment) {
            return false;
        }
        if (!Objects.deepEquals(this.backgroundGradient, other.backgroundGradient)) {
            return false;
        }
        if (!(this.border == other.border || this.border != null && this.border.equals(other.border))) {
            return false;
        }
        if (this.align != other.align) {
            return false;
        }
        return this.textDecoration == other.textDecoration;
    }

    private static boolean equals(float[] a, float[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }
}

