/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.processing;

import com.codename1.processing.AttributeEvaluator;
import com.codename1.processing.ContainsEvaluator;
import com.codename1.processing.Evaluator;
import com.codename1.processing.IndexEvaluator;
import com.codename1.processing.TextEvaluator;

class EvaluatorFactory {
    EvaluatorFactory() {
    }

    public static Evaluator createEvaluator(String text) {
        if (EvaluatorFactory.isNumeric(text)) {
            return new IndexEvaluator(text);
        }
        if (text.startsWith("@")) {
            return new AttributeEvaluator(text);
        }
        if (text.indexOf(IndexEvaluator.FUNC_LAST) != -1) {
            return new IndexEvaluator(text);
        }
        if (text.indexOf("text()") != -1) {
            return new TextEvaluator(text);
        }
        if (text.indexOf(IndexEvaluator.FUNC_POSITION) != -1) {
            return new IndexEvaluator(text);
        }
        if (text.startsWith("@")) {
            return new AttributeEvaluator(text);
        }
        if (text.indexOf(37) != -1) {
            return new ContainsEvaluator(text);
        }
        if (text.indexOf(61) != -1) {
            return new TextEvaluator(text);
        }
        throw new IllegalStateException("Could not create a comparator for value: " + text);
    }

    private static boolean isNumeric(String text) {
        text = text.trim();
        int tlen = text.length();
        for (int i = 0; i < tlen; ++i) {
            if (Character.isDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

