/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.compat.java.util.Objects;
import com.codename1.impl.CodenameOneThread;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.FileSystemStorage;
import com.codename1.io.MultipartRequest;
import com.codename1.io.NetworkManager;
import com.codename1.io.Preferences;
import com.codename1.io.Storage;
import com.codename1.io.Util;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.TextArea;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.layouts.BorderLayout;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class Log {
    private static boolean crashBound;
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    private int level = 1;
    private static Log instance;
    private long zeroTime = System.currentTimeMillis();
    private Writer output;
    private boolean fileWriteEnabled = false;
    private String fileURL = null;
    private boolean logDirty;
    public static int REPORTING_NONE;
    public static int REPORTING_DEBUG;
    public static int REPORTING_PRODUCTION;
    private int reporting = REPORTING_NONE;
    private static boolean initialized;

    public static void setReportingLevel(int level) {
        Log.instance.reporting = level;
    }

    public static int getReportingLevel() {
        return Log.instance.reporting;
    }

    protected Log() {
    }

    public static long getUniqueDeviceId() {
        return -1L;
    }

    public static String getUniqueDeviceKey() {
        String devId = Preferences.get("DeviceKey__$", null);
        if (devId != null) {
            return devId;
        }
        devId = Preferences.get("UDeviceKey__$", null);
        if (devId != null) {
            return devId;
        }
        String buildKey = Display.getInstance().getProperty("build_key", null);
        if (buildKey == null) {
            buildKey = "";
        }
        ConnectionRequest r = new ConnectionRequest(){

            protected void readResponse(InputStream input) throws IOException {
                Preferences.set("UDeviceKey__$", Util.readToString(input));
            }

            protected void handleErrorResponseCode(int code, String message) {
                System.out.print("Error in sending log to server: " + code + " " + message);
            }

            protected void handleException(Exception err) {
                err.printStackTrace();
            }
        };
        r.setPost(true);
        r.setUrl(Display.getInstance().getProperty("cloudServerURL", "https://cloud.codenameone.com/register/device"));
        r.addArgument("appName", Display.getInstance().getProperty("AppName", ""));
        r.addArgument("buildKey", buildKey);
        r.addArgument("builtByUser", Display.getInstance().getProperty("built_by_user", ""));
        r.addArgument("packageName", Display.getInstance().getProperty("package_name", ""));
        r.addArgument("appVersion", Display.getInstance().getProperty("AppVersion", "0.1"));
        r.addArgument("platformName", Display.getInstance().getPlatformName());
        NetworkManager.getInstance().addToQueueAndWait(r);
        return Preferences.get("UDeviceKey__$", null);
    }

    public static void sendLog() {
        Log.sendLogImpl(true);
    }

    public static void sendLogAsync() {
        Log.sendLogImpl(true);
    }

    private static void sendLogImpl(boolean sync) {
        try {
            if (!Display.isInitialized()) {
                return;
            }
            if (!Log.instance.logDirty) {
                return;
            }
            Log.instance.logDirty = false;
            String devId = Log.getUniqueDeviceKey();
            if (devId == null) {
                if (Display.getInstance().isSimulator()) {
                    Dialog.show("Send Log Error", "Device Not Registered: Sending a log from an unregistered device is impossible", "OK", null);
                } else {
                    Log.p("Device Not Registered: Sending a log from an unregistered device is impossible");
                }
                return;
            }
            ConnectionRequest r = new ConnectionRequest();
            r.setPost(false);
            MultipartRequest m = new MultipartRequest();
            m.setUrl("https://crashreport.codenameone.com/CrashReporterEmail/sendCrashReport");
            byte[] read = Util.readInputStream(Storage.getInstance().createInputStream("CN1Log__$"));
            m.addArgument("i", "" + devId);
            m.addArgument("u", Display.getInstance().getProperty("built_by_user", ""));
            m.addArgument("p", Display.getInstance().getProperty("package_name", ""));
            m.addArgument("v", Display.getInstance().getProperty("AppVersion", "0.1"));
            m.addData("log", read, "text/plain");
            m.setFailSilently(true);
            if (sync) {
                NetworkManager.getInstance().addToQueueAndWait(m);
            } else {
                NetworkManager.getInstance().addToQueue(m);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static void sendLogLegacy() {
        try {
            if (!Display.isInitialized()) {
                return;
            }
            if (!Log.instance.logDirty) {
                return;
            }
            Log.instance.logDirty = false;
            long devId = Log.getUniqueDeviceId();
            if (devId < 0L) {
                Dialog.show("Send Log Error", "Device Not Registered: Sending a log from an unregistered device is impossible", "OK", null);
                return;
            }
            ConnectionRequest r = new ConnectionRequest();
            r.setPost(false);
            r.setUrl(Display.getInstance().getProperty("cloudServerURL", "https://codename-one.appspot.com/") + "uploadLogRequest");
            r.setFailSilently(true);
            NetworkManager.getInstance().addToQueueAndWait(r);
            String url = new String(r.getResponseData());
            MultipartRequest m = new MultipartRequest();
            m.setUrl(url);
            byte[] read = Util.readInputStream(Storage.getInstance().createInputStream("CN1Log__$"));
            m.addArgument("i", "" + devId);
            m.addArgument("by", Display.getInstance().getProperty("built_by_user", ""));
            m.addArgument("p", Display.getInstance().getProperty("package_name", ""));
            m.addArgument("v", Display.getInstance().getProperty("AppVersion", "0.1"));
            m.addData("log", read, "text/plain");
            m.setFailSilently(true);
            NetworkManager.getInstance().addToQueueAndWait(m);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void install(Log newInstance) {
        instance = newInstance;
    }

    public static void p(String text) {
        Log.p(text, 1);
    }

    public static void p(String text, int level) {
        instance.print(text, level);
    }

    public static void e(Throwable t) {
        instance.logThrowable(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logThrowable(Throwable t) {
        if (t == null) {
            Log.p("Exception logging invoked with null exception...");
            return;
        }
        this.print("Exception: " + t.getClass().getName() + " - " + t.getMessage(), 4);
        Thread thr = Thread.currentThread();
        if (thr instanceof CodenameOneThread && ((CodenameOneThread)thr).hasStackFrame()) {
            this.print(((CodenameOneThread)thr).getStack(t), 4);
        }
        t.printStackTrace();
        try {
            Log log = this;
            synchronized (log) {
                Writer w = this.getWriter();
                Util.getImplementation().printStackTraceToStream(t, w);
                w.flush();
            }
        }
        catch (IOException err) {
            err.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print(String text, int level) {
        if (!initialized) {
            initialized = true;
            try {
                InputStream is = Display.getInstance().getResourceAsStream(this.getClass(), "/cn1-version-numbers");
                if (is != null) {
                    this.print("Codename One revisions: " + Util.readToString(is), 2);
                }
            }
            catch (IOException err) {
                err.printStackTrace();
            }
        }
        if (this.level > level) {
            return;
        }
        this.logDirty = true;
        text = this.getThreadAndTimeStamp() + " - " + text;
        Util.getImplementation().systemOut(text);
        try {
            Log err = this;
            synchronized (err) {
                Writer w = this.getWriter();
                w.write(text + "\n");
                w.flush();
            }
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }

    protected Writer createWriter() throws IOException {
        try {
            if (this.getFileURL() == null) {
                return new OutputStreamWriter(Storage.getInstance().createOutputStream("CN1Log__$"));
            }
            if (FileSystemStorage.getInstance().exists(this.getFileURL())) {
                return new OutputStreamWriter(FileSystemStorage.getInstance().openOutputStream(this.getFileURL(), (int)FileSystemStorage.getInstance().getLength(this.getFileURL())));
            }
            return new OutputStreamWriter(FileSystemStorage.getInstance().openOutputStream(this.getFileURL()));
        }
        catch (Exception err) {
            this.setFileWriteEnabled(false);
            return new OutputStreamWriter(new ByteArrayOutputStream());
        }
    }

    public static void deleteLog() {
        if (Log.instance.output != null) {
            Util.cleanup(Log.instance.output);
            Log.instance.output = null;
        }
        if (instance.getFileURL() == null) {
            Storage.getInstance().deleteStorageFile("CN1Log__$");
        } else if (FileSystemStorage.getInstance().exists(instance.getFileURL())) {
            FileSystemStorage.getInstance().delete(instance.getFileURL());
        }
    }

    private Writer getWriter() throws IOException {
        if (this.output == null) {
            this.output = this.createWriter();
        }
        return this.output;
    }

    protected String getThreadAndTimeStamp() {
        long time = System.currentTimeMillis() - this.zeroTime;
        long milli = time % 1000L;
        long sec = (time /= 1000L) % 60L;
        long min = (time /= 60L) % 60L;
        long hour = (time /= 60L) % 60L;
        return "[" + Thread.currentThread().getName() + "] " + hour + ":" + min + ":" + sec + "," + milli;
    }

    public static void setLevel(int level) {
        Log.instance.level = level;
    }

    public static int getLevel() {
        return Log.instance.level;
    }

    public static String getLogContent() {
        try {
            String text = "";
            if (instance.isFileWriteEnabled()) {
                if (instance.getFileURL() == null) {
                    instance.setFileURL("file:///" + FileSystemStorage.getInstance().getRoots()[0] + "/codenameOne.log");
                }
                InputStreamReader r = new InputStreamReader(FileSystemStorage.getInstance().openInputStream(instance.getFileURL()));
                char[] buffer = new char[1024];
                int size = r.read(buffer);
                while (size > -1) {
                    text = text + new String(buffer, 0, size);
                    size = r.read(buffer);
                }
                ((Reader)r).close();
            }
            return text;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static void showLog() {
        try {
            String text = Log.getLogContent();
            TextArea area = new TextArea(text, 5, 20);
            Form f = new Form("Log");
            f.setScrollable(false);
            final Form current = Display.getInstance().getCurrent();
            Command back = new Command("Back"){

                public void actionPerformed(ActionEvent ev) {
                    current.show();
                }
            };
            f.addCommand(back);
            f.setBackCommand(back);
            f.setLayout(new BorderLayout());
            f.addComponent("Center", (Component)area);
            f.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Log getInstance() {
        return instance;
    }

    public boolean isFileWriteEnabled() {
        return this.fileWriteEnabled;
    }

    public void setFileWriteEnabled(boolean fileWriteEnabled) {
        this.fileWriteEnabled = fileWriteEnabled;
    }

    public String getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(String fileURL) {
        if (!Objects.equals(this.fileURL, fileURL)) {
            try {
                this.fileURL = fileURL;
                this.output = this.createWriter();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void trackFileSystem() {
        Util.getImplementation().setLogListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String s = (String)evt.getSource();
                if (Log.this.output != null) {
                    Log.p(s);
                }
            }
        });
    }

    public static void bindCrashProtection(final boolean consumeError) {
        if (Display.getInstance().isSimulator()) {
            return;
        }
        Display.getInstance().addEdtErrorHandler(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (consumeError) {
                    evt.consume();
                }
                Log.p("Exception in " + Display.getInstance().getProperty("AppName", "app") + " version " + Display.getInstance().getProperty("AppVersion", "Unknown"));
                Log.p("OS " + Display.getInstance().getPlatformName());
                Log.p("Error " + evt.getSource());
                if (Display.getInstance().getCurrent() != null) {
                    Log.p("Current Form " + Display.getInstance().getCurrent().getName());
                } else {
                    Log.p("Before the first form!");
                }
                Log.e((Throwable)evt.getSource());
                if (Log.getUniqueDeviceKey() != null) {
                    Log.sendLog();
                }
            }
        });
        crashBound = true;
    }

    public static boolean isCrashBound() {
        return crashBound;
    }

    static {
        instance = new Log();
        REPORTING_NONE = 0;
        REPORTING_DEBUG = 1;
        REPORTING_PRODUCTION = 3;
    }
}

