/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.messaging;

import com.codename1.io.ConnectionRequest;
import com.codename1.io.NetworkManager;
import com.codename1.ui.Display;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message {
    private String content = "";
    private String fileUri = "";
    private String mimeType = "text/plain";
    private String attachmentMimeType = "image/jpeg";
    private HashMap<String, String> attachments;
    private boolean cloudMessageFailSilently = false;
    public static final String MIME_TEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_IMAGE_JPG = "image/jpeg";
    public static final String MIME_IMAGE_PNG = "image/png";

    public Message(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public void setAttachment(String fileUri) {
        this.fileUri = fileUri;
    }

    public Map<String, String> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new HashMap();
        }
        if (this.fileUri != null && this.attachmentMimeType != null && this.fileUri.length() > 0 && this.attachmentMimeType.length() > 0 && !this.attachments.containsKey(this.fileUri)) {
            this.attachments.put(this.fileUri, this.attachmentMimeType);
        }
        return this.attachments;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setAttachmentMimeType(String mimeType) {
        this.attachmentMimeType = mimeType;
    }

    public String getAttachmentMimeType() {
        return this.attachmentMimeType;
    }

    public String getAttachment() {
        return this.fileUri;
    }

    public static void sendMessage(String[] recipients, String subject, Message msg) {
        Display.getInstance().sendMessage(recipients, subject, msg);
    }

    public void sendMessageViaCloud(String sender, String recipient, String recipientName, String subject, String plainTextBody) {
        NetworkManager.getInstance().addToQueue(this.createMessage(sender, recipient, recipientName, subject, plainTextBody));
    }

    public boolean sendMessageViaCloudSync(String sender, String recipient, String recipientName, String subject, String plainTextBody) {
        ConnectionRequest r = this.createMessage(sender, recipient, recipientName, subject, plainTextBody);
        r.setFailSilently(true);
        NetworkManager.getInstance().addToQueueAndWait(r);
        return r.getResposeCode() == 200;
    }

    private ConnectionRequest createMessage(String sender, String recipient, String recipientName, String subject, String plainTextBody) {
        ConnectionRequest cr = new ConnectionRequest();
        cr.setUrl(Display.getInstance().getProperty("cloudServerURL", "https://codename-one.appspot.com/") + "sendEmailServlet");
        cr.setFailSilently(this.cloudMessageFailSilently);
        cr.setPost(true);
        cr.addArgument("d", Display.getInstance().getProperty("built_by_user", ""));
        cr.addArgument("from", sender);
        cr.addArgument("to", recipient);
        cr.addArgument("re", recipientName);
        cr.addArgument("subject", subject);
        if (this.mimeType.equals(MIME_TEXT)) {
            cr.addArgument("body", this.content);
        } else {
            cr.addArgument("body", plainTextBody);
            cr.addArgument("html", this.content);
        }
        return cr;
    }

    public boolean isCloudMessageFailSilently() {
        return this.cloudMessageFailSilently;
    }

    public void setCloudMessageFailSilently(boolean cloudMessageFailSilently) {
        this.cloudMessageFailSilently = cloudMessageFailSilently;
    }
}

