/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.cloud.BindTarget;
import com.codename1.io.Log;
import com.codename1.ui.Component;
import com.codename1.ui.CustomFont;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.FontImage;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.IconHolder;
import com.codename1.ui.Image;
import com.codename1.ui.TextHolder;
import com.codename1.ui.TextSelection;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.plaf.DefaultLookAndFeel;
import com.codename1.ui.plaf.LookAndFeel;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;

public class Label
extends Component
implements IconHolder,
TextHolder {
    private final ActionListener iconChangeListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (Label.this.isInitialized() && evt.getSource() == Label.this.getIcon()) {
                Label.this.repaint();
            }
        }
    };
    private boolean iconChangeListenerInstalled;
    private boolean legacyRenderer;
    private String text = "";
    private TextSelection.TextSelectionSupport textSelectionSupport;
    private boolean textSelectionEnabled;
    private Image icon;
    private Image maskedIcon;
    private Component iconStyleComponent;
    private int valign = 2;
    private int textPosition = 3;
    private static int defaultGap = 2;
    private int gap = defaultGap;
    private int shiftText = 0;
    private boolean tickerRunning = false;
    private static boolean defaultTickerEnabled = true;
    private boolean tickerEnabled = defaultTickerEnabled;
    private long tickerStartTime;
    private long tickerDelay;
    private boolean rightToLeft;
    private boolean endsWith3Points = true;
    private Object mask;
    private String maskName;
    private EventDispatcher textBindListeners = null;
    private boolean shouldLocalize = true;
    private boolean showEvenIfBlank = false;
    private float shiftMillimeters = 0.25f;
    private int stringWidthUnselected = -1;
    private boolean autoSizeMode;
    private float maxAutoSize = -1.0f;
    private float minAutoSize = -1.0f;
    private Font originalFont;
    private int widthAtLastCheck = -1;
    private char materialIcon;
    private float materialIconSize = -1.0f;
    private Font font;
    private char fontIcon;
    private float fontIconSize = -1.0f;
    private String badgeText;
    private Component badgeStyleComponent;
    private boolean autoSizeLaidOutLock;
    private TextSelection.Span span;

    public Label(String text) {
        this.noBind = true;
        this.setUIID("Label");
        this.text = text;
        this.localize();
        this.setFocusable(false);
        int iconGap = this.getStyle().getIconGap();
        if (iconGap >= 0) {
            this.setGap(iconGap);
        }
        this.endsWith3Points = UIManager.getInstance().getLookAndFeel().isDefaultEndsWith3Points();
    }

    public Label(String text, String uiid) {
        this.noBind = true;
        this.text = text;
        this.localize();
        this.setFocusable(false);
        this.setUIID(uiid);
        int iconGap = this.getStyle().getIconGap();
        if (iconGap >= 0) {
            this.setGap(iconGap);
        }
        this.endsWith3Points = UIManager.getInstance().getLookAndFeel().isDefaultEndsWith3Points();
    }

    protected void laidOut() {
        if (this.autoSizeLaidOutLock) {
            return;
        }
        this.autoSizeLaidOutLock = true;
        super.laidOut();
        if (this.autoSizeMode) {
            this.initAutoResize();
        }
        this.autoSizeLaidOutLock = false;
    }

    public Label() {
        this("");
        this.endsWith3Points = UIManager.getInstance().getLookAndFeel().isDefaultEndsWith3Points();
    }

    public Label(Image icon) {
        this("");
        this.icon = icon;
        if (icon != null && icon.requiresDrawImage()) {
            this.legacyRenderer = true;
        }
        this.endsWith3Points = UIManager.getInstance().getLookAndFeel().isDefaultEndsWith3Points();
    }

    public Label(Image icon, String uiid) {
        this("", uiid);
        this.icon = icon;
        if (icon != null && icon.requiresDrawImage()) {
            this.legacyRenderer = true;
        }
        this.endsWith3Points = UIManager.getInstance().getLookAndFeel().isDefaultEndsWith3Points();
    }

    public Label(String text, Image icon, String uiid) {
        this(text, uiid);
        this.icon = icon;
        if (icon != null && icon.requiresDrawImage()) {
            this.legacyRenderer = true;
        }
        this.endsWith3Points = UIManager.getInstance().getLookAndFeel().isDefaultEndsWith3Points();
    }

    public Label(String text, Image icon) {
        this(text);
        this.icon = icon;
        if (icon != null && icon.requiresDrawImage()) {
            this.legacyRenderer = true;
        }
        this.endsWith3Points = UIManager.getInstance().getLookAndFeel().isDefaultEndsWith3Points();
    }

    public void setBadgeText(String badgeText) {
        this.badgeText = badgeText;
    }

    public String getBadgeText() {
        return this.badgeText;
    }

    public void setBadgeUIID(String badgeUIID) {
        if (this.badgeStyleComponent == null) {
            this.badgeStyleComponent = new Label();
        }
        this.badgeStyleComponent.setUIID(badgeUIID);
    }

    public Component getBadgeStyleComponent() {
        return this.badgeStyleComponent;
    }

    public void setIconUIID(String uiid) {
        if (this.iconStyleComponent == null || !uiid.equals(this.iconStyleComponent.getUIID())) {
            this.iconStyleComponent = new Component(){};
            this.iconStyleComponent.setUIID(uiid);
        }
    }

    public Component getIconStyleComponent() {
        if (this.iconStyleComponent != null) {
            return this.iconStyleComponent;
        }
        return this;
    }

    public void setMaterialIcon(char c) {
        FontImage.setMaterialIcon(this, c);
        this.materialIconSize = -1.0f;
        this.materialIcon = c;
    }

    public void setFontIcon(Font font, char c) {
        FontImage.setFontIcon(this, font, c);
        this.fontIconSize = -1.0f;
        this.font = font;
        this.fontIcon = c;
    }

    public void setFontIcon(char c) {
        Component iconStyle = this.getIconStyleComponent();
        if (this.font == null) {
            if (iconStyle == null) {
                throw new IllegalStateException("Cannot set FontIcon without an IconStyleComponent set first.");
            }
            Font font = iconStyle.getStyle().getFont();
            if (font == null) {
                throw new IllegalStateException("Cannot set FontIcon without an IconStyleComponent with a fond set first.");
            }
            this.font = font;
        }
        this.setFontIcon(this.font, c);
    }

    public void setMaterialIcon(char c, float size) {
        FontImage.setMaterialIcon(this, c, size);
        this.materialIconSize = size;
        this.materialIcon = c;
    }

    public void setFontIcon(Font font, char c, float size) {
        FontImage.setFontIcon(this, font, c, size);
        this.fontIconSize = size;
        this.font = font;
        this.fontIcon = c;
    }

    public char getMaterialIcon() {
        return this.materialIcon;
    }

    public char getFontIcon() {
        return this.fontIcon;
    }

    public float getMaterialIconSize() {
        return this.materialIconSize;
    }

    public float getFontIconSize() {
        return this.fontIconSize;
    }

    public Font getIconFont() {
        return this.font;
    }

    public int getBaselineResizeBehavior() {
        switch (this.valign) {
            case 0: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return 4;
    }

    public int getBaseline(int width, int height) {
        Style s = this.getStyle();
        Font f = s.getFont();
        int innerHeight = height - s.getVerticalPadding();
        return s.getPaddingTop() + (innerHeight - f.getHeight()) / 2 + f.getAscent();
    }

    public void setUIID(String id) {
        super.setUIID(id);
        String iconUIID = this.getUIManager().getIconUIIDFor(id);
        if (iconUIID != null) {
            this.setIconUIID(iconUIID);
        }
        if (this.materialIcon != '\u0000') {
            FontImage.setMaterialIcon(this, this.materialIcon, this.materialIconSize);
        } else if (this.fontIcon != '\u0000') {
            FontImage.setFontIcon(this, this.font, this.fontIcon, this.fontIconSize);
        }
    }

    public void refreshTheme(boolean merge) {
        super.refreshTheme(merge);
        if (this.materialIcon != '\u0000') {
            FontImage.setMaterialIcon(this, this.materialIcon, this.materialIconSize);
        } else if (this.fontIcon != '\u0000') {
            FontImage.setFontIcon(this, this.font, this.fontIcon, this.fontIconSize);
        }
    }

    public void setText(String text) {
        this.widthAtLastCheck = -1;
        this.text = text;
        this.localize();
        this.stringWidthUnselected = -1;
        this.setShouldCalcPreferredSize(true);
        this.repaint();
    }

    private void localize() {
        if (this.shouldLocalize) {
            this.text = this.getUIManager().localize(this.text, this.text);
        }
    }

    protected void initLaf(UIManager uim) {
        String iconUiid;
        super.initLaf(uim);
        String uiid = this.getUIID();
        if (uiid != null && uiid.length() > 0 && (iconUiid = uim.getIconUIIDFor(uiid)) != null) {
            this.setIconUIID(iconUiid);
            if (this.materialIcon != '\u0000') {
                FontImage.setMaterialIcon(this, this.materialIcon, this.materialIconSize);
            } else if (this.fontIcon != '\u0000') {
                FontImage.setFontIcon(this, this.font, this.fontIcon, this.fontIconSize);
            }
        }
    }

    void initComponentImpl() {
        super.initComponentImpl();
        UIManager manager = this.getUIManager();
        LookAndFeel lf = manager.getLookAndFeel();
        if (this.hasFocus() && lf instanceof DefaultLookAndFeel) {
            ((DefaultLookAndFeel)lf).focusGained(this);
        }
        if (this.isTickerEnabled() && this.isTickerRunning() && !this.isCellRenderer()) {
            this.getComponentForm().registerAnimatedInternal(this);
        }
        this.checkAnimation();
        if (this.maskName != null && this.mask == null) {
            this.setMask(UIManager.getInstance().getThemeMaskConstant(this.maskName));
        }
        if (this.getIcon() != null) {
            if (!this.iconChangeListenerInstalled) {
                this.getIcon().addActionListener(this.iconChangeListener);
                this.iconChangeListenerInstalled = true;
            }
            this.getIcon().lock();
        }
    }

    void deinitializeImpl() {
        super.deinitializeImpl();
        Form f = this.getComponentForm();
        if (f != null) {
            f.deregisterAnimated(this);
        }
        if (this.getIcon() != null) {
            this.getIcon().removeActionListener(this.iconChangeListener);
            this.getIcon().unlock();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setIcon(Image icon) {
        if (this.icon == icon) {
            return;
        }
        if (this.icon != null) {
            this.icon.removeActionListener(this.iconChangeListener);
            this.iconChangeListenerInstalled = false;
        }
        this.widthAtLastCheck = -1;
        if (icon != null) {
            if (icon.requiresDrawImage()) {
                this.legacyRenderer = true;
            }
            if (this.mask != null) {
                this.maskedIcon = icon.applyMaskAutoScale(this.mask);
            }
        }
        this.icon = icon;
        if (this.icon != null && this.isInitialized()) {
            this.icon.addActionListener(this.iconChangeListener);
            this.iconChangeListenerInstalled = true;
        }
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    void checkAnimation() {
        Form parent;
        super.checkAnimation();
        if (this.icon != null && this.icon.isAnimation() && (parent = this.getComponentForm()) != null) {
            parent.registerAnimated(this);
        }
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setAlignment(int align) {
        this.getSelectedStyle().setAlignment(align);
        this.getUnselectedStyle().setAlignment(align);
    }

    public void setVerticalAlignment(int valign) {
        if (valign != 4 && valign != 0 && valign != 2 && valign != 5) {
            throw new IllegalArgumentException("Alignment can't be set to " + valign);
        }
        this.valign = valign;
    }

    public int getVerticalAlignment() {
        return this.valign;
    }

    public int getAlignment() {
        return this.getStyle().getAlignment();
    }

    public void setTextPosition(int textPosition) {
        if (textPosition != 1 && textPosition != 3 && textPosition != 2 && textPosition != 0) {
            throw new IllegalArgumentException("Text position can't be set to " + textPosition);
        }
        this.textPosition = textPosition;
    }

    public int getTextPosition() {
        return this.textPosition;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    public static void setDefaultGap(int gap) {
        defaultGap = gap;
    }

    public static int getDefaultGap() {
        return defaultGap;
    }

    protected String paramString() {
        return super.paramString() + ", text = " + this.getText() + ", gap = " + this.gap;
    }

    public void paint(Graphics g) {
        if (this.legacyRenderer || this.badgeText != null && this.badgeText.length() > 0) {
            this.initAutoResize();
            this.getUIManager().getLookAndFeel().drawLabel(g, this);
            return;
        }
        this.paintImpl(g);
    }

    void paintImpl(Graphics g) {
        this.initAutoResize();
        Object icn = null;
        Image i = this.getIconFromState();
        if (i != null) {
            icn = i.getImage();
        } else if (this.text == null || this.text.equals("") || this.text.equals(" ")) {
            return;
        }
        int cmpX = this.getX() + g.getTranslateX();
        int cmpY = this.getY() + g.getTranslateY();
        int cmpHeight = this.getHeight();
        int cmpWidth = this.getWidth();
        Style s = this.getStyle();
        Font f = s.getFont();
        String t = this.text;
        if (this.text == null) {
            t = "";
        }
        Display.impl.drawLabelComponent(g.getGraphics(), cmpX, cmpY, cmpHeight, cmpWidth, s, t, icn, null, 0, this.gap, this.isRTL(), false, this.textPosition, this.getStringWidth(f), this.tickerRunning, this.shiftText, this.endsWith3Points, this.valign);
    }

    public void setMaxAutoSize(float maxSize) {
        this.maxAutoSize = maxSize;
    }

    public float getMaxAutoSize() {
        return this.maxAutoSize;
    }

    public void setMinAutoSize(float minSize) {
        this.minAutoSize = minSize;
    }

    public float getMinAutoSize() {
        return this.minAutoSize;
    }

    void initAutoResize() {
        if (this.autoSizeMode) {
            Style s = this.getUnselectedStyle();
            int p = s.getHorizontalPadding();
            int w = this.getWidth();
            if (w > p + 10) {
                if (this.originalFont == null) {
                    this.originalFont = s.getFont();
                } else if (w == this.widthAtLastCheck) {
                    return;
                }
                Font currentFont = this.getUnselectedStyle().getFont();
                float fontSize = currentFont.getPixelSize();
                if (fontSize < 1.0f) {
                    Log.p("Autosize disabled probably because component wasn't using native fonts for UIID: " + this.getUIID());
                    this.autoSizeMode = false;
                    return;
                }
                this.widthAtLastCheck = w;
                this.autoSizeMode = false;
                int currentWidth = this.calcPreferredSize().getWidth();
                int maxSizePixel = Display.getInstance().convertToPixels(this.maxAutoSize);
                while (currentWidth < w) {
                    if ((fontSize += 1.0f) >= (float)maxSizePixel) {
                        fontSize = maxSizePixel;
                        currentFont = currentFont.derive(maxSizePixel, currentFont.getStyle());
                        this.getAllStyles().setFont(currentFont);
                        currentWidth = this.calcPreferredSize().getWidth();
                        break;
                    }
                    currentFont = currentFont.derive(fontSize, currentFont.getStyle());
                    this.getAllStyles().setFont(currentFont);
                    currentWidth = this.calcPreferredSize().getWidth();
                }
                int minSizePixel = Display.getInstance().convertToPixels(this.minAutoSize);
                while (currentWidth > w) {
                    if ((fontSize -= 1.0f) <= (float)minSizePixel) {
                        fontSize = minSizePixel;
                        currentFont = currentFont.derive(minSizePixel, currentFont.getStyle());
                        this.getAllStyles().setFont(currentFont);
                        currentWidth = this.calcPreferredSize().getWidth();
                        break;
                    }
                    currentFont = currentFont.derive(fontSize, currentFont.getStyle());
                    this.getAllStyles().setFont(currentFont);
                    currentWidth = this.calcPreferredSize().getWidth();
                }
                this.autoSizeMode = true;
            }
        }
    }

    protected Dimension calcPreferredSize() {
        return this.getUIManager().getLookAndFeel().getLabelPreferredSize(this);
    }

    public int getShiftText() {
        return this.shiftText;
    }

    public void setShiftText(int shiftText) {
        this.shiftText = shiftText;
    }

    public boolean shouldTickerStart() {
        int textSpaceW;
        if (!this.tickerEnabled) {
            return false;
        }
        Style style = this.getStyle();
        int txtW = style.getFont().stringWidth(this.getText());
        return txtW > (textSpaceW = this.getAvaliableSpaceForText()) && textSpaceW > 0;
    }

    Image getIconFromState() {
        return this.getMaskedIcon();
    }

    int getAvaliableSpaceForText() {
        Style style = this.getStyle();
        int textSpaceW = this.getWidth() - style.getHorizontalPadding();
        Image icon = this.getIconFromState();
        if (icon != null && (this.getTextPosition() == 3 || this.getTextPosition() == 1)) {
            textSpaceW -= icon.getWidth();
        }
        return textSpaceW;
    }

    public void startTicker() {
        this.startTicker(this.getUIManager().getLookAndFeel().getTickerSpeed(), true);
    }

    public void startTicker(long delay, boolean rightToLeft) {
        Form parent;
        if (!this.tickerEnabled) {
            return;
        }
        if (!this.isCellRenderer() && (parent = this.getComponentForm()) != null) {
            parent.registerAnimatedInternal(this);
        }
        this.tickerStartTime = System.currentTimeMillis();
        this.tickerDelay = delay;
        this.tickerRunning = true;
        this.rightToLeft = rightToLeft;
        if (this.isRTL()) {
            this.rightToLeft = !this.rightToLeft;
        }
    }

    public void stopTicker() {
        this.tickerRunning = false;
        this.setShiftText(0);
        this.deregisterAnimatedInternal();
    }

    void tryDeregisterAnimated() {
        if (this.tickerEnabled || this.tickerRunning) {
            return;
        }
        super.tryDeregisterAnimated();
    }

    public boolean isTickerRunning() {
        return this.tickerRunning;
    }

    public void setTickerEnabled(boolean tickerEnabled) {
        this.tickerEnabled = tickerEnabled;
    }

    public boolean isTickerEnabled() {
        return this.tickerEnabled;
    }

    public void setEndsWith3Points(boolean endsWith3Points) {
        this.endsWith3Points = endsWith3Points;
    }

    public boolean isEndsWith3Points() {
        return this.endsWith3Points;
    }

    public boolean animate() {
        if (!this.isVisibleOnForm()) {
            return false;
        }
        boolean animateTicker = false;
        if (this.tickerRunning && this.tickerStartTime + this.tickerDelay < System.currentTimeMillis()) {
            this.tickerStartTime = System.currentTimeMillis();
            if (this.rightToLeft) {
                this.shiftText -= Display.getInstance().convertToPixels(this.shiftMillimeters);
                if (this.shiftText + this.getStringWidth(this.getStyle().getFont()) < 0) {
                    this.shiftText = this.getStringWidth(this.getStyle().getFont());
                }
            } else {
                this.shiftText += Display.getInstance().convertToPixels(this.shiftMillimeters);
                if (this.getStringWidth(this.getStyle().getFont()) - this.shiftText < 0) {
                    this.shiftText = -this.getStringWidth(this.getStyle().getFont());
                }
            }
            animateTicker = true;
        }
        boolean val = this.icon != null && this.icon.isAnimation() && this.icon.animate();
        boolean parent = super.animate();
        return val || parent || animateTicker;
    }

    public static boolean isDefaultTickerEnabled() {
        return defaultTickerEnabled;
    }

    public static void setDefaultTickerEnabled(boolean aDefaultTickerEnabled) {
        defaultTickerEnabled = aDefaultTickerEnabled;
    }

    public void setMask(Object mask) {
        this.mask = mask;
    }

    public Object getMask() {
        return this.mask;
    }

    public String getMaskName() {
        return this.maskName;
    }

    public void setMaskName(String maskName) {
        this.maskName = maskName;
        this.setMask(UIManager.getInstance().getThemeMaskConstant(maskName));
        this.repaint();
    }

    public String[] getPropertyNames() {
        return new String[]{"maskName"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{String.class};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"String"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("maskName")) {
            return this.getMaskName();
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("maskName")) {
            this.setMaskName((String)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public Image getMaskedIcon() {
        if (this.maskedIcon != null) {
            return this.maskedIcon;
        }
        if (this.mask != null && this.icon != null) {
            this.maskedIcon = this.icon.applyMaskAutoScale(this.mask);
            return this.maskedIcon;
        }
        return this.icon;
    }

    public String[] getBindablePropertyNames() {
        return new String[]{"text"};
    }

    public Class[] getBindablePropertyTypes() {
        return new Class[]{String.class};
    }

    public void bindProperty(String prop, BindTarget target) {
        if (prop.equals("text")) {
            if (this.textBindListeners == null) {
                this.textBindListeners = new EventDispatcher();
            }
            this.textBindListeners.addListener(target);
            return;
        }
        super.bindProperty(prop, target);
    }

    public void unbindProperty(String prop, BindTarget target) {
        if (prop.equals("text")) {
            if (this.textBindListeners == null) {
                return;
            }
            this.textBindListeners.removeListener(target);
            if (!this.textBindListeners.hasListeners()) {
                this.textBindListeners = null;
            }
            return;
        }
        super.unbindProperty(prop, target);
    }

    public Object getBoundPropertyValue(String prop) {
        if (prop.equals("text")) {
            return this.getText();
        }
        return super.getBoundPropertyValue(prop);
    }

    public void setBoundPropertyValue(String prop, Object value) {
        if (prop.equals("text")) {
            this.setText((String)value);
            return;
        }
        super.setBoundPropertyValue(prop, value);
    }

    public boolean isShouldLocalize() {
        return this.shouldLocalize;
    }

    public void setShouldLocalize(boolean shouldLocalize) {
        this.shouldLocalize = shouldLocalize;
    }

    public int getShiftMillimeters() {
        return Math.round(this.shiftMillimeters);
    }

    public float getShiftMillimetersF() {
        return this.shiftMillimeters;
    }

    public void setShiftMillimeters(int shiftMillimeters) {
        this.shiftMillimeters = shiftMillimeters;
    }

    public void setShiftMillimeters(float shiftMillimeters) {
        this.shiftMillimeters = shiftMillimeters;
    }

    public boolean isShowEvenIfBlank() {
        return this.showEvenIfBlank;
    }

    public void setShowEvenIfBlank(boolean showEvenIfBlank) {
        this.showEvenIfBlank = showEvenIfBlank;
    }

    public int getStringWidth(Font fnt) {
        if (this.isUnselectedStyle) {
            if (this.stringWidthUnselected < 0) {
                this.stringWidthUnselected = fnt.stringWidth(this.text);
            }
            return this.stringWidthUnselected;
        }
        return fnt.stringWidth(this.text);
    }

    public boolean isLegacyRenderer() {
        return this.legacyRenderer;
    }

    public void setLegacyRenderer(boolean legacyRenderer) {
        this.legacyRenderer = legacyRenderer;
    }

    public void styleChanged(String propertyName, Style source) {
        super.styleChanged(propertyName, source);
        if ("font".equals(propertyName) && source.getFont() instanceof CustomFont) {
            this.setLegacyRenderer(true);
        }
        if ("iconGap".equals(propertyName) && source.getIconGap() > 0) {
            this.setGap(source.getIconGap());
        }
    }

    protected void initUnselectedStyle(Style unselectedStyle) {
        super.initUnselectedStyle(unselectedStyle);
        if (unselectedStyle.getIconGap() > 0) {
            this.setGap(unselectedStyle.getIconGap());
        }
    }

    public boolean isAutoSizeMode() {
        return this.autoSizeMode;
    }

    public void setAutoSizeMode(boolean autoSizeMode) {
        this.autoSizeMode = autoSizeMode;
    }

    public void setTextSelectionEnabled(boolean enabled) {
        this.textSelectionEnabled = enabled;
        if (enabled) {
            this.setCursor(2);
        }
    }

    public boolean isTextSelectionEnabled() {
        return this.textSelectionEnabled;
    }

    public TextSelection.TextSelectionSupport getTextSelectionSupport() {
        if (this.textSelectionSupport == null) {
            this.textSelectionSupport = new TextSelection.TextSelectionSupport(){

                public TextSelection.Spans getTextSelectionForBounds(TextSelection sel, Rectangle bounds) {
                    Label.this.span = Label.this.getUIManager().getLookAndFeel().calculateLabelSpan(sel, Label.this);
                    if (Label.this.span == null) {
                        return sel.newSpans();
                    }
                    TextSelection.Span result = Label.this.span.getIntersection(bounds, true);
                    if (bounds.getY() < Label.this.getY()) {
                        // empty if block
                    }
                    TextSelection.Spans out = sel.newSpans();
                    out.add(result);
                    return out;
                }

                public boolean isTextSelectionEnabled(TextSelection sel) {
                    return Label.this.textSelectionEnabled;
                }

                public boolean isTextSelectionTriggerEnabled(TextSelection sel) {
                    return Label.this.textSelectionEnabled;
                }

                public TextSelection.Span triggerSelectionAt(TextSelection sel, int x, int y) {
                    int startPos;
                    Label.this.span = Label.this.getUIManager().getLookAndFeel().calculateLabelSpan(sel, Label.this);
                    if (Label.this.span.size() == 0) {
                        return null;
                    }
                    TextSelection.Char charAtPoint = Label.this.span.charAt(x, y);
                    if (charAtPoint == null) {
                        return null;
                    }
                    int endPos = charAtPoint.getPosition() + 1;
                    String dividers = " \t\r\n-.;";
                    for (startPos = charAtPoint.getPosition(); startPos > Label.this.span.first().getPosition(); --startPos) {
                        if (dividers.indexOf(Label.this.getText().substring(startPos, startPos + 1)) < 0) {
                            continue;
                        }
                        if (startPos >= Label.this.span.last().getPosition()) break;
                        ++startPos;
                        break;
                    }
                    while (endPos < Label.this.span.last().getPosition() + 1) {
                        if (dividers.indexOf(Label.this.getText().substring(endPos - 1, endPos)) < 0) {
                            ++endPos;
                            continue;
                        }
                        if (endPos <= Label.this.span.first().getPosition()) break;
                        --endPos;
                        break;
                    }
                    System.out.println("Text is [" + Label.this.getText().substring(startPos, endPos) + "]");
                    return Label.this.span.subspan(startPos, endPos);
                }

                public String getTextForSpan(TextSelection sel, TextSelection.Span span) {
                    int offset = span.getStartPos();
                    offset = Math.max(0, offset);
                    offset = Math.min(Label.this.getText().length() - 1, offset);
                    int end = span.getEndPos();
                    end = Math.min(Label.this.getText().length(), end);
                    return Label.this.getText().substring(offset, end);
                }
            };
        }
        return this.textSelectionSupport;
    }

    public String getIconUIID() {
        if (this.iconStyleComponent != null) {
            return this.iconStyleComponent.getUIID();
        }
        return this.getUIID();
    }
}

