/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ads;

import com.codename1.ads.InnerActive;
import com.codename1.components.Ads;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.NetworkManager;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.html.HTMLComponent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AdsService
extends ConnectionRequest {
    private String currentAd;
    private boolean initialized = false;
    private static Class service = InnerActive.class;

    protected AdsService() {
    }

    public void initialize(Ads adsComponent) {
        if (!this.initialized) {
            this.initService(adsComponent);
            this.initialized = true;
        }
    }

    public abstract void initService(Ads var1);

    public static AdsService createAdsService() {
        try {
            AdsService adsService = (AdsService)service.newInstance();
            return adsService;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void setAdsProvider(Class provider) {
        service = provider;
    }

    public String getCurrentAd() {
        return this.currentAd;
    }

    public void requestAd() {
        NetworkManager.getInstance().addToQueue(this);
    }

    protected void readResponse(InputStream input) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        while ((len = input.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        int size = out.toByteArray().length;
        if (size > 0) {
            String s;
            this.currentAd = s = new String(out.toByteArray(), 0, size, "UTF-8");
            this.fireResponseListener(new ActionEvent((Object)this.currentAd, ActionEvent.Type.Response));
        }
    }

    public void onAdDisplay(HTMLComponent cmp) {
    }

    protected void handleErrorResponseCode(int code, String message) {
        System.err.println("error=" + code + " " + message);
    }

    protected void handleRuntimeException(RuntimeException err) {
        err.printStackTrace();
    }

    protected void handleException(Exception err) {
        err.printStackTrace();
    }
}

