/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.Button;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.Font;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.SelectableIconHolder;
import com.codename1.ui.TextArea;
import com.codename1.ui.TextHolder;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.ActionSource;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;

public class SpanButton
extends Container
implements ActionSource,
SelectableIconHolder,
TextHolder {
    private int gap = Label.getDefaultGap();
    private Button actualButton;
    private TextArea text;
    private boolean shouldLocalize = true;

    public SpanButton() {
        this("");
    }

    public SpanButton(String txt, String textUiid) {
        this(txt);
        this.text.setUIID(textUiid);
    }

    public SpanButton(String txt) {
        this.setUIID("Button");
        this.setLayout(new BorderLayout());
        this.text = new TextArea(this.getUIManager().localize(txt, txt));
        this.text.setColumns(100);
        this.text.setUIID("Button");
        this.text.setGrowByContent(true);
        this.text.setEditable(false);
        this.text.setFocusable(false);
        this.text.setActAsLabel(true);
        this.setFocusable(true);
        this.removeBackground(this.text.getUnselectedStyle());
        this.removeBackground(this.text.getSelectedStyle());
        this.removeBackground(this.text.getPressedStyle());
        this.removeBackground(this.text.getDisabledStyle());
        this.actualButton = new Button();
        this.actualButton.setUIID("icon");
        this.addComponent("West", (Component)this.actualButton);
        Container center = BoxLayout.encloseYCenter(this.text);
        center.getStyle().setMargin(0, 0, 0, 0);
        center.getStyle().setPadding(0, 0, 0, 0);
        this.addComponent("Center", (Component)center);
        this.setLeadComponent(this.actualButton);
        this.updateGap();
    }

    public void styleChanged(String propertyName, Style source) {
        int gap;
        super.styleChanged(propertyName, source);
        if ("iconGap".equals(propertyName) && (gap = source.getIconGap()) >= 0 && gap != this.getGap()) {
            this.setGap(gap);
            this.updateGap();
        }
    }

    protected void initUnselectedStyle(Style unselectedStyle) {
        int gap;
        super.initUnselectedStyle(unselectedStyle);
        if (unselectedStyle.getIconGap() > 0 && (gap = unselectedStyle.getIconGap()) != this.getGap()) {
            this.setGap(unselectedStyle.getIconGap());
            this.updateGap();
        }
    }

    private void updateGap() {
        if (this.getIcon() == null) {
            ComponentSelector.$(this.actualButton).setMargin(0);
        } else if ("North".equals(this.getIconPosition())) {
            ComponentSelector.$(this.actualButton).selectAllStyles().setMargin(0, 0, this.gap, 0);
        } else if ("South".equals(this.getIconPosition())) {
            ComponentSelector.$(this.actualButton).selectAllStyles().setMargin(this.gap, 0, 0, 0);
        } else if ("East".equals(this.getIconPosition())) {
            ComponentSelector.$(this.actualButton).selectAllStyles().setMargin(0, 0, 0, this.gap);
        } else if ("West".equals(this.getIconPosition())) {
            ComponentSelector.$(this.actualButton).selectAllStyles().setMargin(0, this.gap, 0, 0);
        }
    }

    public TextArea getTextComponent() {
        return this.text;
    }

    public void setTextUIID(String uiid) {
        this.text.setUIID(uiid);
    }

    public String getTextUIID() {
        return this.text.getUIID();
    }

    public void setUIID(String id) {
        String iconUIID;
        super.setUIID(id);
        if (id != null && id.length() > 0 && (iconUIID = this.getUIManager().getIconUIIDFor(id)) != null) {
            this.setIconUIID(iconUIID);
        }
    }

    protected void initLaf(UIManager uim) {
        String iconUiid;
        if (uim == this.getUIManager() && this.isInitialized()) {
            return;
        }
        super.initLaf(uim);
        String uiid = this.getUIID();
        if (uiid != null && uiid.length() > 0 && (iconUiid = uim.getIconUIIDFor(uiid)) != null) {
            this.setIconUIID(iconUiid);
        }
    }

    public Component getIconStyleComponent() {
        return this.actualButton.getIconStyleComponent();
    }

    public Style getTextAllStyles() {
        return this.text.getAllStyles();
    }

    public Style getTextStyle() {
        return this.text.getStyle();
    }

    public void setIconUIID(String uiid) {
        this.actualButton.setUIID(uiid);
        this.updateGap();
    }

    public String getIconUIID() {
        return this.actualButton.getUIID();
    }

    private void removeBackground(Style s) {
        s.setBackgroundType((byte)0);
        s.setBgImage(null);
        s.setBorder(null);
        s.setBgTransparency(0);
    }

    public void setText(String t) {
        if (this.shouldLocalize) {
            this.text.setText(this.getUIManager().localize(t, t));
        } else {
            this.text.setText(t);
        }
    }

    public void setIcon(Image i) {
        this.actualButton.setIcon(i);
        this.updateGap();
    }

    public String getText() {
        return this.text.getText();
    }

    public Image getIcon() {
        return this.actualButton.getIcon();
    }

    public void addLongPressListener(ActionListener l) {
        this.actualButton.addLongPressListener(l);
    }

    public void removeLongPressListener(ActionListener l) {
        this.actualButton.removeLongPressListener(l);
    }

    public void addActionListener(ActionListener l) {
        this.actualButton.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actualButton.removeActionListener(l);
    }

    public void setIconPosition(String t) {
        this.removeComponent(this.actualButton);
        this.addComponent(t, (Component)this.actualButton);
        this.updateGap();
        this.revalidateLater();
    }

    public String getIconPosition() {
        return (String)this.getLayout().getComponentConstraint(this.actualButton);
    }

    public void setCommand(Command cmd) {
        this.actualButton.setCommand(cmd);
    }

    public Command getCommand() {
        return this.actualButton.getCommand();
    }

    public String[] getPropertyNames() {
        return new String[]{"text", "icon", "iconPosition", "textUiid", "iconUiid"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{String.class, Image.class, String.class, String.class, String.class};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"String", "Image", "String", "String", "String"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("text")) {
            return this.getText();
        }
        if (name.equals("icon")) {
            return this.getIcon();
        }
        if (name.equals("iconPosition")) {
            return this.getIconPosition();
        }
        if (name.equals("textUiid")) {
            return this.getTextUIID();
        }
        if (name.equals("iconUiid")) {
            return this.getIconUIID();
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("text")) {
            this.setText((String)value);
            return null;
        }
        if (name.equals("icon")) {
            this.setIcon((Image)value);
            return null;
        }
        if (name.equals("iconPosition")) {
            this.setIconPosition((String)value);
            return null;
        }
        if (name.equals("textUiid")) {
            this.setTextUIID((String)value);
            return null;
        }
        if (name.equals("iconUiid")) {
            this.setIconUIID((String)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public boolean isShouldLocalize() {
        return this.shouldLocalize;
    }

    public void setShouldLocalize(boolean shouldLocalize) {
        this.shouldLocalize = shouldLocalize;
    }

    public void setPressedIcon(Image i) {
        this.actualButton.setPressedIcon(i);
    }

    public Image getPressedIcon() {
        return this.actualButton.getPressedIcon();
    }

    public void setRolloverIcon(Image i) {
        this.actualButton.setRolloverIcon(i);
    }

    public Image getRolloverIcon() {
        return this.actualButton.getRolloverIcon();
    }

    public void setDisabledIcon(Image i) {
        this.actualButton.setDisabledIcon(i);
    }

    public Image getDisabledIcon() {
        return this.actualButton.getDisabledIcon();
    }

    public boolean isAutoRelease() {
        return this.actualButton.isAutoRelease();
    }

    public void setAutoRelease(boolean autoRelease) {
        this.actualButton.setAutoRelease(autoRelease);
    }

    public void setWidth(int width) {
        int w = this.getWidth();
        if (w != width) {
            int newTextW = width;
            String iconPos = this.getIconPosition();
            if (this.getIcon() != null && "East".equals(iconPos) || "West".equals(iconPos)) {
                newTextW -= this.actualButton.getOuterWidth();
            }
            newTextW -= this.getStyle().getHorizontalPadding();
            this.text.setWidth(newTextW -= this.text.getStyle().getHorizontalMargins());
            super.setWidth(width);
            this.setShouldCalcPreferredSize(true);
        }
    }

    public void setGap(int gap) {
        if (gap != this.gap) {
            this.gap = gap;
            this.updateGap();
        }
    }

    public int getGap() {
        return this.gap;
    }

    public void setTextPosition(int textPosition) {
        switch (textPosition) {
            case 0: {
                this.setIconPosition("South");
                break;
            }
            case 2: {
                this.setIconPosition("North");
                break;
            }
            case 1: {
                this.setIconPosition("East");
                break;
            }
            case 3: {
                this.setIconPosition("West");
                break;
            }
            default: {
                this.setIconPosition("East");
            }
        }
    }

    public int getTextPosition() {
        String iconPosition = this.getIconPosition();
        if ("North".equals(iconPosition)) {
            return 2;
        }
        if ("South".equals(iconPosition)) {
            return 0;
        }
        if ("East".equals(iconPosition)) {
            return 1;
        }
        if ("West".equals(iconPosition)) {
            return 3;
        }
        return 1;
    }

    public void setRolloverPressedIcon(Image arg0) {
        this.actualButton.setRolloverPressedIcon(arg0);
    }

    public Image getRolloverPressedIcon() {
        return this.actualButton.getRolloverIcon();
    }

    public Image getIconFromState() {
        return this.actualButton.getIconFromState();
    }

    public void setMaterialIcon(char c) {
        this.actualButton.setMaterialIcon(c);
    }

    public void setFontIcon(Font font, char c) {
        this.actualButton.setFontIcon(font, c);
    }

    public void setMaterialIcon(char c, float size) {
        this.actualButton.setMaterialIcon(c, size);
    }

    public void setFontIcon(Font font, char c, float size) {
        this.actualButton.setFontIcon(font, c, size);
    }

    public char getMaterialIcon() {
        return this.actualButton.getMaterialIcon();
    }

    public char getFontIcon() {
        return this.actualButton.getFontIcon();
    }

    public float getMaterialIconSize() {
        return this.actualButton.getMaterialIconSize();
    }

    public float getFontIconSize() {
        return this.actualButton.getFontIconSize();
    }

    public Font getIconFont() {
        return this.actualButton.getIconFont();
    }
}

