/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.validation;

import com.codename1.ui.validation.Constraint;
import com.codename1.util.regex.RE;

public class RegexConstraint
implements Constraint {
    private static final String validEmailRegex = "^([a-zA-Z0-9.!#$%&'*+/=?^`{|}~]|-|_)+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
    private static final String validURLRegex = "^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    private RE regex;
    private String errorMessage;

    public RegexConstraint(String regex, String errorMessage) {
        this.regex = new RE(regex);
        this.errorMessage = errorMessage;
    }

    public static Constraint validEmail(String errorMessage) {
        return new RegexConstraint(validEmailRegex, errorMessage);
    }

    public static Constraint validEmail() {
        return new RegexConstraint(validEmailRegex, "Invalid Email Address");
    }

    public static Constraint validURL(String errorMessage) {
        return new RegexConstraint(validURLRegex, errorMessage);
    }

    public static Constraint validURL() {
        return new RegexConstraint(validURLRegex, "Invalid URL");
    }

    public boolean isValid(Object value) {
        return value != null && this.regex.match(value.toString());
    }

    public String getDefaultFailMessage() {
        return this.errorMessage;
    }
}

