/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maps.providers;

import com.codename1.maps.BoundingBox;
import com.codename1.maps.Coord;
import com.codename1.maps.Projection;
import com.codename1.maps.Tile;
import com.codename1.ui.geom.Dimension;

public abstract class MapProvider {
    private Projection _projection;
    private Dimension _tileSize;

    protected MapProvider(Projection p, Dimension tileSize) {
        this._projection = p;
        this._tileSize = tileSize;
    }

    public void tileSize(Dimension size) {
    }

    public abstract BoundingBox bboxFor(Coord var1, int var2);

    public abstract Tile tileFor(BoundingBox var1);

    public abstract int maxZoomLevel();

    public int minZoomLevel() {
        return 0;
    }

    public abstract Coord scale(int var1);

    public Coord translate(Coord position, int zoomLevel, int pixelsX, int pixelsY) {
        Coord scale = this.scale(zoomLevel);
        return position.translate((double)pixelsY * scale.getLatitude(), (double)pixelsX * scale.getLongitude());
    }

    public Projection projection() {
        return this._projection;
    }

    public Dimension tileSize() {
        return this._tileSize;
    }

    public abstract String attribution();

    public int maxZoomFor(Tile tile) {
        Coord scale;
        int zoom;
        int height = tile.dimension().getHeight();
        int width = tile.dimension().getWidth();
        double latitude = tile.getBoundingBox().latitudeDifference();
        double longitude = tile.getBoundingBox().longitudeDifference();
        for (zoom = this.maxZoomLevel(); !(zoom <= 0 || (scale = this.scale(zoom)).getLatitude() * (double)height > latitude && scale.getLongitude() * (double)width > longitude); --zoom) {
        }
        return zoom;
    }
}

